/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.dbobj.faulttree.egli;

import com.dassault.cecilia.db.DBFolder;
import com.dassault.cecilia.db.DBGlobEvent;
import com.dassault.cecilia.dbobj.faulttree.egli.FTGlobEventAbstract;
import com.dassault.cecilia.dbobj.faulttree.obj.FTEvent;
import com.dassault.cecilia.dbobj.general.DBObjectXmlUtility;
import com.dassault.cecilia.dbobj.general.attrib.DBAttrib;
import com.dassault.cecilia.dbobj.general.attrib.io.DBAttributesHandlerXml;
import com.dassault.cecilia.dbobj.general.law.Law;
import com.dassault.cecilia.dbobj.general.law.Param;
import java.io.IOException;
import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.Logger;

public class FTGlobEvent
extends FTGlobEventAbstract {
    private static Logger _LOG = Logger.getLogger(FTGlobEvent.class.getPackage().getName());
    String _commentShort;
    DBGlobEvent.Type _type;
    DBGlobEvent.Link _link;
    String _commentLong;
    String _definition;
    FTEvent.State _state;
    FTEvent.Style _style;
    Param _inspected;
    Param _inflight_tested;
    Law _distrib;
    Collection<DBAttrib.Value> _attributes;
    DBFolder _dbCCF;
    DBFolder _dbSubTree;
    DBFolder _dbModelLaw = null;
    boolean _genericFlag;
    String _genericSuffix;
    String _eventModelFmeaName = "";
    String _dataXML = null;

    public FTGlobEvent(DBFolder dbFolder, String name) {
        super(dbFolder, name);
    }

    private String constructXML() {
        StringBuilder buffer = new StringBuilder(2048);
        try {
            this.toXML(buffer, "", false);
        }
        catch (IOException e) {
            _LOG.log(Level.SEVERE, "Internal error during write XML code for GlobEvent : " + this._name + " [" + this._dbFolder.getRefPath() + "]", e);
        }
        return buffer.toString();
    }

    public void toXML(Appendable out, String indent, boolean header) throws IOException {
        out.append(indent).append("<").append("cec.gevt");
        if (header) {
            DBObjectXmlUtility.appendXML(out.append(" ").append("name").append("='"), this._name).append("'");
            DBObjectXmlUtility.writeDBFolder(out, this._dbFolder, null);
            DBObjectXmlUtility.appendXML(out.append(" ").append("type").append("='"), this._type.toString().toLowerCase()).append("'");
            DBObjectXmlUtility.appendXML(out.append(" ").append("link").append("='"), this._link.toString().toLowerCase()).append("'");
        }
        if (this.getGenericFlag()) {
            out.append(" ").append("isGeneric").append("='true'");
        }
        out.append(">\n");
        if (this._commentLong.length() > 0) {
            out.append(indent).append("  <").append("label").append(">");
            DBObjectXmlUtility.appendXML(out, this._commentLong);
            out.append("</").append("label").append(">\n");
        }
        if (this._type == DBGlobEvent.Type.BASIC) {
            String indent1 = indent + "  ";
            String indent2 = indent1 + "  ";
            out.append(indent1).append("<").append("ft.state");
            out.append(" ").append("value").append("='").append(this._state.getXMLCode()).append("'");
            out.append("/>\n");
            out.append(indent1).append("<").append("ft.style");
            out.append(" ").append("value").append("='").append(this._style.getXMLCode()).append("'");
            out.append("/>\n");
            if (this._dbModelLaw != null) {
                out.append(indent1);
                DBObjectXmlUtility.writeDBFolder(out, this._dbModelLaw, "frb");
            }
            if (this._distrib != null) {
                this._distrib.toXML("law", out, indent1, true);
            }
            if (this._inspected != null) {
                out.append(indent1).append("<").append("inspected").append(">\n");
                this._inspected.toXML(out, indent2, true);
                out.append(indent1).append("</").append("inspected").append(">\n");
            }
            if (this._inflight_tested != null) {
                out.append(indent1).append("<").append("inflight").append(">\n");
                this._inflight_tested.toXML(out, indent2, true);
                out.append(indent1).append("</").append("inflight").append(">\n");
            }
            if (!this._attributes.isEmpty()) {
                DBAttributesHandlerXml.writeAttributes(out, this._attributes, indent1);
            }
            if (this._dbCCF != null) {
                out.append(indent1);
                DBObjectXmlUtility.writeDBFolder(out, this._dbCCF, "ft.ccf");
            }
        } else if (this._definition != null && this._definition.length() > 0) {
            out.append(indent).append("  <").append("ft.define").append(">");
            DBObjectXmlUtility.appendXML(out, this._definition);
            out.append("</").append("ft.define").append(">\n");
        }
        if (this._dbSubTree != null) {
            out.append(indent).append("  <").append("ft.link");
            DBObjectXmlUtility.writeDBFolder(out, this._dbSubTree, null);
            if (this._genericSuffix != null && !this._genericSuffix.isEmpty()) {
                DBObjectXmlUtility.appendXML(out.append(" ").append("addIfGeneric").append("='"), this._genericSuffix).append("'");
            }
            out.append("/>\n");
        }
        out.append(indent).append("</").append("cec.gevt").append(">\n");
    }

    String getDataXML() {
        if (this._dataXML == null) {
            this._dataXML = this.constructXML();
        }
        return this._dataXML;
    }

    @Override
    public String getProject() {
        return this._dbFolder.getParent().getParent().getParent().getName();
    }

    @Override
    public String getSystem() {
        return this._dbFolder.getParent().getParent().getName();
    }

    @Override
    public String getTree() {
        return this._dbFolder.getParent().getName();
    }

    @Override
    public String getVersion() {
        return this._dbFolder.getName();
    }

    @Override
    public String getName() {
        return this._name;
    }

    @Override
    public String getComment() {
        return this._commentShort;
    }

    @Override
    public DBGlobEvent.Type getType() {
        return this._type;
    }

    @Override
    public DBGlobEvent.Link getLink() {
        return this._link;
    }

    @Override
    public String getCommentLong() {
        return this._commentLong;
    }

    @Override
    public String getDefinition() {
        return this._definition;
    }

    @Override
    public FTEvent.State getState() {
        return this._state;
    }

    @Override
    public FTEvent.Style getStyle() {
        return this._style;
    }

    @Override
    public Param getInspected() {
        return this._inspected;
    }

    @Override
    public Param getInflightTested() {
        return this._inflight_tested;
    }

    @Override
    public Law getLaw() {
        return this._distrib;
    }

    @Override
    public Collection<DBAttrib.Value> getAttributes() {
        return this._attributes;
    }

    @Override
    public DBFolder getCCF() {
        return this._dbCCF;
    }

    @Override
    public DBFolder getSubTree() {
        return this._dbSubTree;
    }

    @Override
    public DBFolder getModelLaw() {
        return this._dbModelLaw;
    }

    @Override
    public boolean getGenericFlag() {
        return this._genericFlag;
    }

    @Override
    public String getGenericSuffix() {
        return this._genericSuffix;
    }
}

