/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.dbobj.faulttree.egli;

import com.dassault.cecilia.core.cecilia.ResMsgCore;
import com.dassault.cecilia.db.DBFolder;
import com.dassault.cecilia.db.DBGlobEvent;
import com.dassault.cecilia.dbobj.CECFactory;
import com.dassault.cecilia.dbobj.faulttree.egli.FTGlobEvent;
import com.dassault.cecilia.dbobj.faulttree.egli.io.EGHandlerXml;
import com.dassault.cecilia.dbobj.faulttree.obj.FTEvent;
import com.dassault.cecilia.dbobj.general.attrib.DBAttrib;
import com.dassault.cecilia.dbobj.general.law.Law;
import com.dassault.cecilia.dbobj.general.law.Param;
import com.dassault.cecilia.dbobj.general.log.DBLogs;
import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Locator;
import org.xml.sax.helpers.DefaultHandler;

public class FTGlobEventExtract
extends FTGlobEvent {
    private static Logger _LOG = Logger.getLogger(FTGlobEventExtract.class.getPackage().getName());
    DBGlobEvent _dbGlobEvent;

    public FTGlobEventExtract(DBGlobEvent dbGlobEvent) {
        super(dbGlobEvent.getFolder(), dbGlobEvent.getName());
        this._dbGlobEvent = dbGlobEvent;
        this._type = this._dbGlobEvent.getType();
        this._link = this._dbGlobEvent.getLink();
        this._commentShort = this._dbGlobEvent.getComment();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean extract(CECFactory daoFactory) {
        DBLogs dbLogs = new DBLogs();
        DBLogs.DefaultManager logMng = new DBLogs.DefaultManager("extract", dbLogs);
        EGHandlerXml handler = new EGHandlerXml(logMng, null, daoFactory);
        try {
            SAXParserFactory fabrique = SAXParserFactory.newInstance();
            SAXParser parseur = fabrique.newSAXParser();
            parseur.parse(this._dbGlobEvent.getLObStream(), (DefaultHandler)((Object)handler));
            if (dbLogs.withLogs(DBLogs.DBLevel.WARNING)) {
                _LOG.severe("Probleme d'extraction de l'EGL pour " + this.getName() + ", " + this.getFolder().getRefPath());
                dbLogs.traceLogs(_LOG, DBLogs.DBLevel.INFO);
                boolean bl = false;
                return bl;
            }
            handler.configureEvent(this);
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            StringBuffer sb = new StringBuffer();
            sb.append(ResMsgCore.getString("MSG_ERR_DBMOD_XML_GENERIC")).append("\n");
            Locator loc = handler.getLocator();
            if (loc != null) {
                sb.append("in [line = ");
                sb.append(loc.getLineNumber());
                sb.append("] [col = ");
                sb.append(loc.getColumnNumber());
                sb.append("]\n");
            }
            sb.append(e.getMessage());
            _LOG.log(Level.INFO, sb.toString(), e);
        }
        finally {
            this._dbGlobEvent = null;
        }
        return false;
    }

    public void setComment(String label) {
        this._commentLong = label;
    }

    public void setLaw(Law law) {
        this._distrib = law;
    }

    public void setInspected(Param inspected) {
        this._inspected = inspected;
    }

    public void setInflightTested(Param inflight_tested) {
        this._inflight_tested = inflight_tested;
    }

    public void setAttributes(Collection<DBAttrib.Value> attributes) {
        this._attributes = attributes;
    }

    public void setState(FTEvent.State state) {
        this._state = state;
    }

    public void setStyle(FTEvent.Style style) {
        this._style = style;
    }

    public void setSubTree(DBFolder dbSubTree) {
        this._dbSubTree = dbSubTree;
    }

    public void setModelLaw(DBFolder dbModelLaw) {
        this._dbModelLaw = dbModelLaw;
    }

    public void setCCF(DBFolder dbCCF) {
        this._dbCCF = dbCCF;
    }

    public void setGenericFlag(boolean flag) {
        this._genericFlag = flag;
    }

    public void setGenericSuffix(String generic) {
        this._genericSuffix = generic;
    }

    public void setDefinition(String definition) {
        this._definition = definition;
    }
}

