/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.dbobj.faulttree.egli.gui;

import com.dassault.cecilia.core.ResMsgVoc;
import com.dassault.cecilia.core.cecilia.export.DBKOutput;
import com.dassault.cecilia.core.cecilia.pref.PrefFieldBoolean;
import com.dassault.cecilia.core.cecilia.print.SrbInputStream;
import com.dassault.cecilia.core.swing.JOptionCecilia;
import com.dassault.cecilia.db.DBFolder;
import com.dassault.cecilia.db.DBGlobEvent;
import com.dassault.cecilia.dbobj.ResMsgObj;
import com.dassault.cecilia.dbobj.faulttree.ResMsgArbor;
import com.dassault.cecilia.dbobj.faulttree.egli.FTGlobEventAbstract;
import com.dassault.cecilia.dbobj.faulttree.egli.FTGlobEventUtility;
import com.dassault.cecilia.dbobj.faulttree.egli.gui.EventGlobalListTable;
import com.dassault.cecilia.dbobj.faulttree.ft.gui.filter.Filter;
import com.dassault.cecilia.dbobj.faulttree.ft.gui.filter.FilterAbstract;
import com.dassault.cecilia.dbobj.faulttree.ft.gui.filter.FilterAttribute;
import com.dassault.cecilia.dbobj.faulttree.ft.gui.filter.FilterDlgExtended;
import com.dassault.cecilia.dbobj.faulttree.ft.gui.filter.FilterLaw;
import com.dassault.cecilia.dbobj.faulttree.ft.gui.filter.FilterLawAralia;
import com.dassault.cecilia.dbobj.faulttree.ft.gui.filter.FilterString;
import com.dassault.cecilia.dbobj.faulttree.ft.gui.filter.TypeFilter;
import com.dassault.cecilia.dbobj.faulttree.gui.ItemAbstractColumnsModel;
import com.dassault.cecilia.dbobj.faulttree.gui.ItemAbstractTableModel;
import com.dassault.cecilia.dbobj.faulttree.obj.FTEvent;
import com.dassault.cecilia.dbobj.general.attrib.Attr;
import com.dassault.cecilia.dbobj.general.attrib.DBAttrib;
import com.dassault.cecilia.dbobj.general.law.FctParamSelect;
import com.dassault.cecilia.dbobj.general.law.Law;
import com.dassault.cecilia.dbobj.general.law.LawFormat;
import com.dassault.cecilia.dbobj.general.law.Param;
import com.dassault.cecilia.dbobj.general.law.ParamFMEA;
import java.awt.Window;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.SwingUtilities;

public class EventGlobalListModel
extends ItemAbstractTableModel<FTGlobEventAbstract> {
    public static final String EGL_FIELD_NAME = "nom";
    public static final String EGL_FIELD_PROJECT = "projets";
    public static final String EGL_FIELD_SYSTEM = "systemes";
    public static final String EGL_FIELD_TREE = "arbres";
    public static final String EGL_FIELD_COMMENT = "commentaire";
    public static final String EGL_FIELD_DEFINITION = "definition";
    public static final String EGL_FIELD_LAW = "loi";
    public static final String EGL_FIELD_STATE = "etat";
    public static final String EGL_FIELD_STYLE = "style";
    public static final String EGL_FIELD_GENERIC = "generique";
    public static final String EGL_FIELD_EXTENTION = "extension";
    public static final String EGL_FIELD_SUBTREE = "sous_arbre";
    public static final String EGL_FIELD_DSF = "dsf";
    public static final String EGL_FIELD_TREENAME = "nom_arbre";
    public static final String EGL_FIELD_BTP = "BTP";
    public static final String EGL_FIELD_FMEA = "Amdec";
    public static final String EGL_FIELD_INSPECTED = "inspecte";
    public static final String EGL_FIELD_TESTED = "test_vol";
    public static final String EGL_FIELD_ATTRIBS = "attribute";
    public static final String EGL_FIELD_CCF = "DCC";
    public static final int EGL_IDX_NAME = 1;
    public static final int EGL_IDX_PROJECT = 2;
    public static final int EGL_IDX_SYSTEM = 3;
    public static final int EGL_IDX_TREE = 4;
    public static final int EGL_IDX_COMMENT = 100;
    public static final int EGL_IDX_DEFINITION = 101;
    public static final int EGL_IDX_LAW = 102;
    public static final int EGL_IDX_STATE = 103;
    public static final int EGL_IDX_STYLE = 115;
    public static final int EGL_IDX_GENERIC = 104;
    public static final int EGL_IDX_EXTENTION = 105;
    public static final int EGL_IDX_SUBTREE = 106;
    public static final int EGL_IDX_DSF = 107;
    public static final int EGL_IDX_TREENAME = 108;
    public static final int EGL_IDX_BTP = 109;
    public static final int EGL_IDX_FMEA = 110;
    public static final int EGL_IDX_INSPECTED = 111;
    public static final int EGL_IDX_TESTED = 112;
    public static final int EGL_IDX_ATTRIBS = 113;
    public static final int EGL_IDX_CCF = 114;
    private List<FTGlobEventAbstract> _listItem;
    private List<FTGlobEventAbstract> _listSynItem;
    private int[] _visibleIndexes = new int[0];
    Filter<FTGlobEventAbstract> _filter;
    boolean _isSynthesis;

    public static List<PrefFieldBoolean> createFields() {
        ArrayList<PrefFieldBoolean> fields = new ArrayList<PrefFieldBoolean>();
        fields.add(new PrefFieldBoolean(ResMsgVoc.getString("VOC_COMMENTS"), EGL_FIELD_COMMENT, 100, 15, "L"));
        fields.add(new PrefFieldBoolean(ResMsgVoc.getString("VOC_DEFINITION"), EGL_FIELD_DEFINITION, 101, 15, "L"));
        fields.add(new PrefFieldBoolean(ResMsgObj.getString("LAW_FIELD"), EGL_FIELD_LAW, 102, 15, "L"));
        fields.add(new PrefFieldBoolean(ResMsgVoc.getString("VOC_STATE"), EGL_FIELD_STATE, 103, 10, "L"));
        fields.add(new PrefFieldBoolean(ResMsgVoc.getString("VOC_STYLE"), EGL_FIELD_STYLE, 115, 10, "L"));
        fields.add(new PrefFieldBoolean(ResMsgVoc.getString("VOC_GENERIC"), EGL_FIELD_GENERIC, 104, 4, "C"));
        fields.add(new PrefFieldBoolean(ResMsgArbor.getString("EVENT_FIELD_GENERIC_EXTENTION"), EGL_FIELD_EXTENTION, 105, 10, "L"));
        fields.add(new PrefFieldBoolean(ResMsgVoc.getString("VOC_SUBTREE"), EGL_FIELD_SUBTREE, 106, 4, "C"));
        fields.add(new PrefFieldBoolean(ResMsgVoc.getString("VOC_DSF"), EGL_FIELD_DSF, 107, 4, "C"));
        fields.add(new PrefFieldBoolean(ResMsgArbor.getString("EVENT_FIELD_LINK"), EGL_FIELD_TREENAME, 108, 10, "L"));
        fields.add(new PrefFieldBoolean(ResMsgVoc.getString("VOC_FRB"), EGL_FIELD_BTP, 109, 10, "L"));
        fields.add(new PrefFieldBoolean(ResMsgVoc.getString("VOC_FMEA"), EGL_FIELD_FMEA, 110, 10, "L"));
        fields.add(new PrefFieldBoolean(ResMsgVoc.getString("VOC_INSPECTED"), EGL_FIELD_INSPECTED, 111, 6, "R"));
        fields.add(new PrefFieldBoolean(ResMsgVoc.getString("VOC_INFLIGHT_TESTED"), EGL_FIELD_TESTED, 112, 6, "R"));
        fields.add(new PrefFieldBoolean(ResMsgVoc.getString("VOC_ATTRIBUTES"), EGL_FIELD_ATTRIBS, 113, 10, "L"));
        fields.add(new PrefFieldBoolean(ResMsgArbor.getString("VOC_CCF"), EGL_FIELD_CCF, 114, 10, "L"));
        int len = fields.size();
        block3: for (int i = 0; i < len; ++i) {
            PrefFieldBoolean item = fields.get(i);
            item.setOptionnal(true);
            switch (item.getIdxCode()) {
                case 100: 
                case 101: 
                case 102: 
                case 103: 
                case 108: 
                case 109: 
                case 111: 
                case 113: {
                    item.setSelected(true);
                    continue block3;
                }
                default: {
                    item.setSelected(false);
                }
            }
        }
        return fields;
    }

    @Override
    public EGLColumnsModel getColumnModel() {
        return (EGLColumnsModel)super.getColumnModel();
    }

    public EventGlobalListModel(List<FTGlobEventAbstract> data, boolean synthesis) {
        super(new EGLColumnsModel(synthesis));
        this._listItem = data;
        this._isSynthesis = synthesis;
        this._filter = FilterEGLFactory.createItem(TypeFilter.ALL);
        this.computeVisibleRows();
    }

    @Override
    public void refresh(boolean rowsChanged, boolean columnsChanged) {
        if (rowsChanged) {
            this.computeVisibleRows();
        }
        super.refresh(rowsChanged, columnsChanged);
    }

    public boolean isSynthesis() {
        return this._isSynthesis;
    }

    public void setSynthesis(boolean synthesis) {
        if (synthesis == this._isSynthesis) {
            return;
        }
        this._isSynthesis = synthesis;
        this.getColumnModel().setSynthesis(synthesis);
        this.refresh(true, true);
    }

    public void setFilter(Filter filter) {
        if (this._filter == filter) {
            return;
        }
        this._filter = filter;
        this.refresh(true, false);
    }

    private void computeVisibleRows() {
        if (this._isSynthesis) {
            this._listSynItem = FTGlobEventUtility.computeSynthesis(this._listItem, this._filter);
        } else {
            int i;
            ArrayList<Integer> lst = new ArrayList<Integer>();
            for (i = 0; i < this._listItem.size(); ++i) {
                if (!this._filter.filter(this._listItem.get(i))) continue;
                lst.add(i);
            }
            this._visibleIndexes = new int[lst.size()];
            for (i = 0; i < lst.size(); ++i) {
                this._visibleIndexes[i] = (Integer)lst.get(i);
            }
        }
    }

    public Filter<FTGlobEventAbstract> getFilter() {
        return this._filter;
    }

    public List<FTGlobEventAbstract> getAllGlobEvent() {
        return this._listItem;
    }

    @Override
    public int getFullRowCount() {
        return this._listItem.size();
    }

    @Override
    public int getRowCount() {
        if (this._isSynthesis) {
            return this._listSynItem.size();
        }
        return this._visibleIndexes.length;
    }

    @Override
    public FTGlobEventAbstract getItem(int row) {
        return this._isSynthesis ? this._listSynItem.get(row) : this._listItem.get(this._visibleIndexes[row]);
    }

    @Override
    public Object getValueAt(FTGlobEventAbstract item, int col) {
        int idxCol = this.getColumnModel().getColumnField(col).getIdxCode();
        switch (idxCol) {
            case 1: {
                return item.getName();
            }
            case 2: {
                return item.getProject();
            }
            case 3: {
                return item.getSystem();
            }
            case 4: {
                if (item.getTree().isEmpty()) {
                    return item.getVersion();
                }
                return item.getTree() + ";" + item.getVersion();
            }
            case 100: {
                return item.getComment();
            }
            case 101: {
                return item.getDefinition();
            }
            case 102: {
                return item.getLaw();
            }
            case 103: {
                return item.getState();
            }
            case 115: {
                return item.getStyle();
            }
            case 104: {
                return item.getGenericFlag();
            }
            case 105: {
                return item.getGenericSuffix();
            }
            case 106: {
                return item.getLink() == DBGlobEvent.Link.TREE;
            }
            case 107: {
                return item.getLink() == DBGlobEvent.Link.DSF;
            }
            case 108: {
                return item.getSubTree();
            }
            case 109: {
                return item.getModelLaw();
            }
            case 110: {
                Set<Param> params = item.recupParams(new LinkedHashSet<Param>(), new FctParamSelect.FctParamFMEA());
                return ParamFMEA.transcodeCollections(params);
            }
            case 111: {
                return item.getInspected();
            }
            case 112: {
                return item.getInflightTested();
            }
            case 113: {
                return item.getAttributes();
            }
            case 114: {
                return item.getCCF();
            }
        }
        return "";
    }

    @Override
    public Class getColumnClass(int col) {
        int idxCol = this.getColumnModel().getColumnField(col).getIdxCode();
        switch (idxCol) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 100: 
            case 101: 
            case 105: {
                return String.class;
            }
            case 103: {
                return FTEvent.State.class;
            }
            case 115: {
                return FTEvent.Style.class;
            }
            case 104: 
            case 106: 
            case 107: {
                return Boolean.class;
            }
            case 102: {
                return Law.class;
            }
            case 111: 
            case 112: {
                return Param.class;
            }
            case 108: 
            case 109: 
            case 114: {
                return DBFolder.class;
            }
            case 110: {
                return String.class;
            }
            case 113: {
                return Collection.class;
            }
        }
        return String.class;
    }

    @Override
    public void exportToScribeFile(SrbInputStream outScribe, JTable table) throws IOException {
        outScribe.concat("<GDOC SEC=''>\n");
        outScribe.concat("<TITLE>" + ResMsgArbor.getString("KEY_1144") + "\n");
        outScribe.concat("<DOCNUM>\n");
        outScribe.concat("<DATE>" + this.getCurrentDateAsDDMMYYYY() + "\n");
        outScribe.concat(".ti @\n");
        outScribe.concat(".tp 5 7 18 20 30 35 40 50 60\n");
        outScribe.concat("<BODY>\n");
        outScribe.concat("<H1>" + ResMsgArbor.getString("KEY_1145") + "\n");
        StringBuffer b = new StringBuffer();
        b.append("<TABLEAU>\n");
        b.append("<TABTIT>" + ResMsgArbor.getString("KEY_1144") + "\n");
        this.exportTableToScribeFile(b, table);
        b.append("<ETABLEAU>\n");
        outScribe.concat(b.toString());
        outScribe.concat("<EGDOC>0\n");
    }

    @Override
    protected int getExportNbrSubCell(int row, int col, JTable table) {
        int colDoc = this.getColumnModel().getColumnField(col).getIdxCode();
        switch (colDoc) {
            case 113: {
                Collection attributes = (Collection)this.getValueAt(this.getItem(row), col);
                if (attributes == null || attributes.isEmpty()) break;
                return attributes.size();
            }
            case 100: {
                String comment = (String)this.getValueAt(this.getItem(row), col);
                if (comment == null || comment.isEmpty()) break;
                return comment.split("\n").length;
            }
        }
        return 1;
    }

    @Override
    protected String getExportValueAt(int row, int col, int idx, JTable table) {
        if (idx > 0 && this.getExportNbrSubCell(row, col, table) == 1) {
            return "";
        }
        Object value = this.getValueAt(this.getItem(row), col);
        if (value == null) {
            return "";
        }
        switch (this.getColumnModel().getColumnField(col).getIdxCode()) {
            case 113: {
                Collection attributes = (Collection)value;
                if (!attributes.isEmpty()) {
                    if (idx >= 0) {
                        int nbr = 0;
                        Iterator iterator = attributes.iterator();
                        while (iterator.hasNext()) {
                            if (nbr == idx) {
                                return ((DBAttrib.Value)iterator.next()).toDisplay();
                            }
                            ++nbr;
                            iterator.next();
                        }
                        return "";
                    }
                    StringBuilder buffer = new StringBuilder();
                    Iterator iterator = attributes.iterator();
                    while (iterator.hasNext()) {
                        buffer.append(((DBAttrib.Value)iterator.next()).toDisplay());
                        if (!iterator.hasNext()) continue;
                        buffer.append(" ; ");
                    }
                    return buffer.toString();
                }
                return "-";
            }
            case 100: {
                if (idx < 0) {
                    return value.toString().replaceAll("\n", " ");
                }
                String[] lines = value.toString().split("\n");
                if (lines.length > 0 && idx < lines.length) {
                    return lines[idx];
                }
                return "";
            }
            case 111: 
            case 112: {
                if (value instanceof Param) {
                    EventGlobalListTable eglTable = (EventGlobalListTable)table;
                    return LawFormat.DEFAULT.format((Param)value, eglTable._format);
                }
                return "-";
            }
            case 102: {
                if (value instanceof Law) {
                    EventGlobalListTable eglTable = (EventGlobalListTable)table;
                    return LawFormat.DEFAULT.format((Law)value, eglTable._format);
                }
                return "-";
            }
            case 108: 
            case 109: 
            case 114: {
                if (value instanceof DBFolder) {
                    return ((DBFolder)value).getRefPath();
                }
                return "-";
            }
            case 103: {
                if (value instanceof FTEvent.State) {
                    return ((FTEvent.State)((Object)value)).getLabel();
                }
                return "-";
            }
            case 115: {
                if (value instanceof FTEvent.Style) {
                    return ((FTEvent.Style)((Object)value)).getLabel();
                }
                return "-";
            }
            case 104: 
            case 106: 
            case 107: {
                if (value instanceof Boolean) {
                    return ResMsgVoc.getString((Boolean)value != false ? "VOC_TRUE" : "VOC_FALSE");
                }
                return "-";
            }
        }
        return value.toString();
    }

    @Override
    public void exportToXMLDocBook(DBKOutput xmlWriter) throws IOException {
    }

    protected static class EGLColumnsModel
    extends ItemAbstractColumnsModel {
        PrefFieldBoolean _itemName = new PrefFieldBoolean(ResMsgVoc.getString("VOC_NAME"), "nom", 1, 12, "L");
        PrefFieldBoolean _itemProjects = new PrefFieldBoolean(ResMsgVoc.getString("VOC_PROJECT"), "projets", 2, 12, "L");
        PrefFieldBoolean _itemSystems = new PrefFieldBoolean(ResMsgVoc.getString("VOC_SYSTEM"), "systemes", 3, 12, "L");
        PrefFieldBoolean _itemTrees = new PrefFieldBoolean(ResMsgVoc.getString("VOC_TREE"), "arbres", 4, 12, "L");
        boolean _isSynthesis;

        public EGLColumnsModel(boolean synthesis) {
            this.init();
        }

        @Override
        public List<PrefFieldBoolean> createOptionnalFields() {
            return EventGlobalListModel.createFields();
        }

        @Override
        public void setOptionnalFields(List<PrefFieldBoolean> optionnalFields) {
            this._optionnalFields = optionnalFields;
            this.setSynthesis(this._isSynthesis);
        }

        public void setSynthesis(boolean synthesis) {
            this._isSynthesis = synthesis;
            this._items.clear();
            if (!synthesis) {
                this._items.add(this._itemProjects);
                this._items.add(this._itemSystems);
                this._items.add(this._itemTrees);
            }
            this._items.add(this._itemName);
            for (PrefFieldBoolean item : this._optionnalFields) {
                this._items.add(item);
            }
            if (synthesis) {
                this._items.add(this._itemTrees);
                this._items.add(this._itemSystems);
                this._items.add(this._itemProjects);
            }
            this.resetFilterIndexes();
        }
    }

    protected static class FilterEGLFactory {
        protected FilterEGLFactory() {
        }

        static Filter<FTGlobEventAbstract> createItem(TypeFilter type) {
            switch (type) {
                case ALL: {
                    return new FilterAbstract<FTGlobEventAbstract>(type.getLabel()){

                        @Override
                        public boolean filter(FTGlobEventAbstract row) {
                            return true;
                        }
                    };
                }
                case ROOTS: {
                    return new FilterAbstract<FTGlobEventAbstract>(type.getLabel()){

                        @Override
                        public boolean filter(FTGlobEventAbstract row) {
                            return row.getType() == DBGlobEvent.Type.ROOT;
                        }
                    };
                }
                case GATES: {
                    return new FilterAbstract<FTGlobEventAbstract>(type.getLabel()){

                        @Override
                        public boolean filter(FTGlobEventAbstract row) {
                            return row.getType() == DBGlobEvent.Type.GATE;
                        }
                    };
                }
                case LEAVES: {
                    return new FilterAbstract<FTGlobEventAbstract>(type.getLabel()){

                        @Override
                        public boolean filter(FTGlobEventAbstract row) {
                            return row.getType() == DBGlobEvent.Type.BASIC;
                        }
                    };
                }
                case SUBTREE: {
                    return new FilterAbstract<FTGlobEventAbstract>(type.getLabel()){

                        @Override
                        public boolean filter(FTGlobEventAbstract row) {
                            return row.getLink() == DBGlobEvent.Link.TREE;
                        }
                    };
                }
                case DSF: {
                    return new FilterAbstract<FTGlobEventAbstract>(type.getLabel()){

                        @Override
                        public boolean filter(FTGlobEventAbstract row) {
                            return row.getLink() == DBGlobEvent.Link.DSF;
                        }
                    };
                }
                case INSPECTED: {
                    return new FilterAbstract<FTGlobEventAbstract>(type.getLabel()){

                        @Override
                        public boolean filter(FTGlobEventAbstract row) {
                            return row.getInspected() != null;
                        }
                    };
                }
                case INFLYTESTED: {
                    return new FilterAbstract<FTGlobEventAbstract>(type.getLabel()){

                        @Override
                        public boolean filter(FTGlobEventAbstract row) {
                            return row.getInflightTested() != null;
                        }
                    };
                }
                case FILTERED: {
                    return new FilterEGLExtended();
                }
            }
            return null;
        }
    }

    protected static class FilterEGLExtended
    extends FilterAbstract<FTGlobEventAbstract> {
        FilterString<FTGlobEventAbstract> _project = new FilterString<FTGlobEventAbstract>(ResMsgVoc.getString("VOC_PROJECT")){

            @Override
            public String getString(FTGlobEventAbstract row) {
                return row.getProject();
            }
        };
        FilterString<FTGlobEventAbstract> _system = new FilterString<FTGlobEventAbstract>(ResMsgVoc.getString("VOC_SYSTEM")){

            @Override
            public String getString(FTGlobEventAbstract row) {
                return row.getSystem();
            }
        };
        FilterString<FTGlobEventAbstract> _tree = new FilterString<FTGlobEventAbstract>(ResMsgVoc.getString("VOC_TREE")){

            @Override
            public String getString(FTGlobEventAbstract row) {
                return row.getTree() + ";" + row.getVersion();
            }
        };
        boolean _eventSelect;
        boolean _evtTypeGate;
        boolean _evtTypeLeaf;
        boolean _evtTypeSubTree;
        boolean _evtTypeRoot;
        boolean _evtTypeDSF;
        boolean _evtTypeInspected;
        boolean _evtTypeTested;
        FilterString<FTGlobEventAbstract> _evtName = new FilterString<FTGlobEventAbstract>(ResMsgVoc.getString("VOC_NAME")){

            @Override
            public String getString(FTGlobEventAbstract row) {
                return row.getName();
            }
        };
        FilterString<FTGlobEventAbstract> _evtRemark = new FilterString<FTGlobEventAbstract>(ResMsgVoc.getString("VOC_COMMENT")){

            @Override
            public String getString(FTGlobEventAbstract row) {
                return row.getComment();
            }
        };
        FilterLaw<FTGlobEventAbstract> _evtLaw = new FilterLawAralia<FTGlobEventAbstract>(){

            @Override
            public Law getLaw(FTGlobEventAbstract row) {
                return row.getLaw();
            }
        };
        FilterAttribute<FTGlobEventAbstract> _evtAttr = new FilterAttribute<FTGlobEventAbstract>(){

            @Override
            public Collection<? extends Attr> getAttributes(FTGlobEventAbstract row) {
                return row.getAttributes();
            }
        };

        public FilterEGLExtended() {
            super(ResMsgVoc.getString("VOC_FILTER"));
        }

        @Override
        public boolean filter(FTGlobEventAbstract row) {
            if (!this._project.filter(row)) {
                return false;
            }
            if (!this._system.filter(row)) {
                return false;
            }
            if (!this._tree.filter(row)) {
                return false;
            }
            if (this._eventSelect) {
                boolean isTerminal = false;
                if (this._evtTypeLeaf && row.getType() == DBGlobEvent.Type.BASIC) {
                    isTerminal = true;
                } else if (this._evtTypeDSF && row.getLink() == DBGlobEvent.Link.DSF) {
                    isTerminal = true;
                } else if (this._evtTypeInspected && row.getInspected() != null) {
                    isTerminal = true;
                } else if (this._evtTypeTested && row.getInflightTested() != null) {
                    isTerminal = true;
                } else if (!(this._evtTypeGate && row.getType() == DBGlobEvent.Type.GATE || this._evtTypeRoot && row.getType() == DBGlobEvent.Type.ROOT || this._evtTypeSubTree && row.getLink() == DBGlobEvent.Link.TREE)) {
                    return false;
                }
                if (!this._evtName.filter(row)) {
                    return false;
                }
                if (!this._evtRemark.filter(row)) {
                    return false;
                }
                if (isTerminal) {
                    if (!this._evtLaw.filter(row)) {
                        return false;
                    }
                    if (!this._evtAttr.filter(row)) {
                        return false;
                    }
                }
            }
            return true;
        }

        @Override
        public boolean withDialog() {
            return true;
        }

        @Override
        public boolean selectFilter(JComponent owner) {
            if (!(this._project.isSelected() || this._system.isSelected() || this._tree.isSelected() || this._eventSelect && (this._evtName.isSelected() || this._evtRemark.isSelected() || this._evtLaw.isSelected() || this._evtAttr.isSelected() || this._evtTypeGate || this._evtTypeLeaf || this._evtTypeSubTree || this._evtTypeRoot || this._evtTypeDSF || this._evtTypeInspected || this._evtTypeTested))) {
                return this.displayDialog(owner);
            }
            return true;
        }

        @Override
        public boolean displayDialog(JComponent owner) {
            Window win = SwingUtilities.getWindowAncestor(owner);
            FilterDlgExtended dlg = new FilterDlgExtended(win){

                @Override
                protected Map<DBAttrib, Set<String>> createAttributes() {
                    return null;
                }
            };
            dlg.create();
            dlg.copyToCtrl(this._project, dlg.getProjectCheck(), dlg.getProjectText());
            dlg.copyToCtrl(this._system, dlg.getSystemCheck(), dlg.getSystemText());
            dlg.copyToCtrl(this._tree, dlg.getTreeCheck(), dlg.getTreeText());
            dlg.getEventSelectCheck().setSelected(true);
            dlg.getEvtTypeGateCheck().setSelected(this._evtTypeGate);
            dlg.getEvtTypeRootCheck().setSelected(this._evtTypeRoot);
            dlg.getEvtTypeLeafCheck().setSelected(this._evtTypeLeaf);
            dlg.getEvtTypeSubTreeCheck().setSelected(this._evtTypeSubTree);
            dlg.getEvtTypeDSFCheck().setSelected(this._evtTypeDSF);
            dlg.getEvtTypeInspectedCheck().setSelected(this._evtTypeInspected);
            dlg.getEvtTypeTestedCheck().setSelected(this._evtTypeTested);
            dlg.copyToCtrl(this._evtName, dlg.getEvtNameCheck(), dlg.getEvtNameText());
            dlg.copyToCtrl(this._evtRemark, dlg.getEvtRemarkCheck(), dlg.getEvtRemarkText());
            dlg.getEvtLawCheck().setSelected(this._evtLaw.isSelected());
            dlg.setEvtLawType(this._evtLaw.getType());
            dlg.setEvtLawOp(this._evtLaw.getOp());
            dlg.setEvtLawValue(this._evtLaw.getLimit());
            dlg.getEvtAttrCheck().setSelected(this._evtAttr.isSelected());
            if (this._evtAttr.isSelected()) {
                dlg.setEvtAttrSelect(this._evtAttr.getAttribute());
            }
            dlg.updateCtrls();
            dlg.setLocationRelativeTo(JOptionCecilia.getTopContainerOf(owner));
            dlg.setVisible(true);
            if (!dlg.getResult()) {
                return false;
            }
            dlg.copyFromCtrl(this._project, dlg.getProjectCheck(), dlg.getProjectText());
            dlg.copyFromCtrl(this._system, dlg.getSystemCheck(), dlg.getSystemText());
            dlg.copyFromCtrl(this._tree, dlg.getTreeCheck(), dlg.getTreeText());
            this._eventSelect = dlg.getEventSelectCheck().isSelected();
            if (this._eventSelect) {
                this._evtTypeGate = dlg.getEvtTypeGateCheck().isSelected();
                this._evtTypeRoot = dlg.getEvtTypeRootCheck().isSelected();
                this._evtTypeLeaf = dlg.getEvtTypeLeafCheck().isSelected();
                this._evtTypeSubTree = dlg.getEvtTypeSubTreeCheck().isSelected();
                this._evtTypeDSF = dlg.getEvtTypeDSFCheck().isSelected();
                this._evtTypeInspected = dlg.getEvtTypeInspectedCheck().isSelected();
                this._evtTypeTested = dlg.getEvtTypeTestedCheck().isSelected();
                dlg.copyFromCtrl(this._evtName, dlg.getEvtNameCheck(), dlg.getEvtNameText());
                dlg.copyFromCtrl(this._evtRemark, dlg.getEvtRemarkCheck(), dlg.getEvtRemarkText());
                this._evtLaw.setSelected(dlg.getEvtLawCheck().isSelected());
                if (this._evtLaw.isSelected()) {
                    this._evtLaw.setType(dlg.getEvtLawType());
                    this._evtLaw.setOp(dlg.getEvtLawOp());
                    this._evtLaw.setLimit(dlg.getEvtLawValue());
                }
                this._evtAttr.setSelected(dlg.getEvtAttrCheck().isSelected());
                if (this._evtAttr.isSelected()) {
                    this._evtAttr.configure(dlg.getEvtAttrSelect());
                }
            }
            return true;
        }
    }
}

