/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.dbobj.faulttree.ft;

import com.dassault.cecilia.core.ResMsgVoc;
import com.dassault.cecilia.dbobj.ResMsgObj;
import com.dassault.cecilia.dbobj.faulttree.ResMsgArbor;
import com.dassault.cecilia.dbobj.faulttree.ft.TypeProbability;
import com.dassault.cecilia.dbobj.general.DBObjectXmlUtility;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.logging.Logger;
import javax.swing.AbstractAction;

public class FTComputeParameters {
    private static Logger _LOG = Logger.getLogger(FTComputeParameters.class.getPackage().getName());
    String _ftConfigName = null;
    TypeProbability _type = TypeProbability.BDD;
    FTOneHourAction _bOneHourAction = new FTOneHourAction();
    double _missionTime = 3600.0;
    double _averageFlightDuration = Double.NaN;
    String _averageAttribute = null;
    String _lastCRCDag = null;
    String _lastCRCXml = null;
    private static final String KEY_CONFIG = "Config";
    private static final String KEY_TYPE = "Type";
    private static final String KEY_ONE_HOUR = "OneHour";
    private static final String KEY_MISSION_TIME = "MissionTime";
    private static final String KEY_FLIGHT_DURATION = "AverageFlightDuration";
    private static final String KEY_ATTRIBUTE = "AverageAttribute";
    private static final String KEY_CRC = "LastCRC";
    private static final String KEY_CRC_XML = "LastCRCXml";
    private static final String VAL_TRUE = "true";
    private static final String VAL_FALSE = "true";

    public String getConfigName() {
        return this._ftConfigName;
    }

    public TypeProbability getType() {
        return this._type;
    }

    public boolean isOneHourOption() {
        return this._bOneHourAction.isSelected();
    }

    public FTOneHourAction getOneHourAction() {
        return this._bOneHourAction;
    }

    public double getTime() {
        return this._missionTime;
    }

    public double getFlightDuration() {
        return this._averageFlightDuration;
    }

    public String getAverageAttribute() {
        return this._averageAttribute;
    }

    public String getLastCRC() {
        return this._lastCRCDag;
    }

    public String getLastCRCXml() {
        return this._lastCRCXml;
    }

    public FTComputeParameters setConfigName(String name) {
        this._ftConfigName = name;
        return this;
    }

    public FTComputeParameters setType(TypeProbability value) {
        this._type = value;
        return this;
    }

    public FTComputeParameters setTime(double value) {
        this._missionTime = value;
        return this;
    }

    public FTComputeParameters setFlightDuration(double value) {
        this._averageFlightDuration = value;
        return this;
    }

    public FTComputeParameters setAverageAttribute(String value) {
        this._averageAttribute = value;
        return this;
    }

    public FTComputeParameters setOneHourOption(boolean value) {
        this._bOneHourAction.setSelected(value);
        return this;
    }

    public FTComputeParameters setLastCRC(String value) {
        this._lastCRCDag = value;
        return this;
    }

    public FTComputeParameters setLastCRCXml(String value) {
        this._lastCRCXml = value;
        return this;
    }

    public FTComputeParameters getCopy() {
        FTComputeParameters result = new FTComputeParameters();
        result._ftConfigName = this._ftConfigName;
        result._type = this._type;
        result.setOneHourOption(this.isOneHourOption());
        result._missionTime = this._missionTime;
        result._averageFlightDuration = this._averageFlightDuration;
        result._averageAttribute = this._averageAttribute;
        result._lastCRCDag = this._lastCRCDag;
        result._lastCRCXml = this._lastCRCXml;
        return result;
    }

    private void paramToXML(Appendable out, String type, String value) throws IOException {
        out.append("  <").append("ft.cpt.param");
        out.append(" ").append("type").append("='").append(type).append("'");
        out.append(" ").append("value").append("='");
        DBObjectXmlUtility.appendXML(out, value).append("'");
        out.append("/>\n");
    }

    public void toXML(Appendable out, String indent) throws IOException {
        out.append(indent).append("<").append("ft.compute").append(">\n");
        if (this._ftConfigName != null) {
            this.paramToXML(out.append(indent), KEY_CONFIG, this._ftConfigName);
        }
        this.paramToXML(out.append(indent), KEY_TYPE, this._type.toString().toLowerCase());
        if (this.isOneHourOption()) {
            this.paramToXML(out.append(indent), KEY_ONE_HOUR, "true");
        }
        this.paramToXML(out.append(indent), KEY_MISSION_TIME, Double.toString(this._missionTime));
        if (!Double.isNaN(this._averageFlightDuration)) {
            this.paramToXML(out.append(indent), KEY_FLIGHT_DURATION, Double.toString(this._averageFlightDuration));
        }
        if (this._averageAttribute != null) {
            this.paramToXML(out.append(indent), KEY_ATTRIBUTE, this._averageAttribute);
        }
        if (this._lastCRCDag != null) {
            this.paramToXML(out.append(indent), KEY_CRC, this._lastCRCDag);
        }
        if (this._lastCRCXml != null) {
            this.paramToXML(out.append(indent), KEY_CRC_XML, this._lastCRCXml);
        }
        out.append(indent).append("</").append("ft.compute").append(">\n");
    }

    public void setParameters(Map<String, String> parameters) {
        for (Map.Entry<String, String> param : parameters.entrySet()) {
            String key = param.getKey();
            String value = param.getValue();
            if (KEY_CONFIG.equals(key)) {
                if (value.length() <= 0) continue;
                this.setConfigName(value);
                continue;
            }
            if (KEY_TYPE.equals(key)) {
                TypeProbability type = TypeProbability.valueOf(value.toUpperCase());
                if (type == null) {
                    _LOG.info("FTCompute avec un Type inconnu : " + value);
                    continue;
                }
                this.setType(type);
                continue;
            }
            if (KEY_MISSION_TIME.equals(key)) {
                try {
                    double time = Double.parseDouble(value);
                    if (time < 0.0) {
                        _LOG.info("FTCompute avec un temps de mission impossible : " + value);
                        continue;
                    }
                    this.setTime(time);
                }
                catch (NumberFormatException e) {
                    _LOG.info("FTCompute avec un temps de mission exceptionnel : " + value);
                }
                continue;
            }
            if (KEY_FLIGHT_DURATION.equals(key)) {
                try {
                    double time = Double.parseDouble(value);
                    if (time < 0.0) {
                        _LOG.info("FTCompute avec une dur\u00e9e de vol impossible : " + value);
                        continue;
                    }
                    this.setFlightDuration(time);
                }
                catch (NumberFormatException e) {
                    _LOG.info("FTCompute avec une dur\u00e9e de vol exceptionnel : " + value);
                }
                continue;
            }
            if (KEY_ONE_HOUR.equals(key)) {
                if ("true".equalsIgnoreCase(value)) {
                    this.setOneHourOption(true);
                    continue;
                }
                if ("true".equalsIgnoreCase(value)) {
                    this.setOneHourOption(false);
                    continue;
                }
                _LOG.info("FTCompute avec une valeur de OneHour impossible : " + value);
                continue;
            }
            if (KEY_ATTRIBUTE.equals(key)) {
                if (value.length() <= 0) continue;
                this.setAverageAttribute(value);
                continue;
            }
            if (KEY_CRC.equals(key)) {
                if (value.length() <= 0) continue;
                this.setLastCRC(value);
                continue;
            }
            if (KEY_CRC_XML.equals(key)) {
                if (value.length() <= 0) continue;
                this.setLastCRCXml(value);
                continue;
            }
            _LOG.info("FTCompute avec un param\u00e8tre inconnu : Key=" + key + ", Value=" + value);
        }
    }

    public String getAbstract() {
        StringBuilder sb = new StringBuilder();
        BiFunction<String, String, String> func = (x, y) -> {
            StringBuilder tmp = new StringBuilder();
            tmp.append((String)x).append(" : ").append((String)y).append('\n');
            return tmp.toString();
        };
        if (this._ftConfigName != null) {
            sb.append(func.apply(ResMsgVoc.getString("VOC_CONFIGURATION"), this._ftConfigName));
        }
        if (this._type != null) {
            sb.append(func.apply(ResMsgVoc.getString("VOC_TYPE"), this._type.getLabel()));
            if (this._averageAttribute != null) {
                sb.setLength(sb.length() - 1);
                sb.append('(').append(this._averageAttribute).append(')').append('\n');
            }
        }
        sb.append(func.apply(ResMsgVoc.getString("VOC_DURATION"), String.valueOf(this._missionTime)));
        if (!Double.isNaN(this._averageFlightDuration)) {
            sb.append(func.apply(ResMsgObj.getString("DLG_AVERAGEFLIGHT_LABEL"), String.valueOf(this._averageFlightDuration)));
        }
        return sb.toString();
    }

    public class FTOneHourAction
    extends AbstractAction {
        List<ActionListener> _listeners;

        public FTOneHourAction() {
            super(ResMsgArbor.getString("PFH_LABEL"));
            this._listeners = new ArrayList<ActionListener>();
            this.putValue("SwingSelectedKey", Boolean.FALSE);
        }

        boolean isSelected() {
            return (Boolean)this.getValue("SwingSelectedKey");
        }

        void setSelected(boolean value) {
            this.putValue("SwingSelectedKey", value);
            this.actionPerformed(new ActionEvent(FTComputeParameters.this, 0, "Modele"));
        }

        public void addActionListener(ActionListener listener) {
            if (this._listeners.contains(listener)) {
                return;
            }
            this._listeners.add(listener);
        }

        public void removeActionListener(ActionListener listener) {
            this._listeners.remove(listener);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            for (ActionListener actionListener : this._listeners) {
                actionListener.actionPerformed(e);
            }
        }
    }
}

