/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.dbobj.faulttree.ft;

import com.dassault.cecilia.core.cecilia.ResMsgCore;
import com.dassault.cecilia.db.DBAccess;
import com.dassault.cecilia.db.DBFolder;
import com.dassault.cecilia.db.DBObjModel;
import com.dassault.cecilia.db.DBObject;
import com.dassault.cecilia.db.DBRelation;
import com.dassault.cecilia.db.DBUser;
import com.dassault.cecilia.dbobj.CECFactory;
import com.dassault.cecilia.dbobj.faulttree.ResMsgArbor;
import com.dassault.cecilia.dbobj.faulttree.ft.FTVariable;
import com.dassault.cecilia.dbobj.faulttree.ft.io.FTEquationHandlerXml;
import com.dassault.cecilia.dbobj.faulttree.obj.FTDefinition;
import com.dassault.cecilia.dbobj.faulttree.obj.FTEquationAbstract;
import com.dassault.cecilia.dbobj.faulttree.obj.FTEvent;
import com.dassault.cecilia.dbobj.faulttree.obj.FTLink;
import com.dassault.cecilia.dbobj.faulttree.obj.FTVariableAbstract;
import com.dassault.cecilia.dbobj.faulttree.obj.FTVariableExtern;
import com.dassault.cecilia.dbobj.general.attrib.DBAttrib;
import com.dassault.cecilia.dbobj.general.log.DBLogs;
import com.dassault.cecilia.dbobj.general.log.DBLogsWrap;
import com.dassault.cecilia.lib.util.CopyUtility;
import com.dassault.cecilia.main.cecilia.CeciliaAppl;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;

public class FTEquationBasic
extends FTEquationAbstract {
    private static Logger _LOG = Logger.getLogger(FTEquationBasic.class.getPackage().getName());
    FTVariable _ftTopEvent = null;
    int _seqID = 0;
    List<FTVariable> _listVarsInternal = new ArrayList<FTVariable>();
    List<FTVariableAbstract> _listVarsGlobal = new ArrayList<FTVariableAbstract>();
    Map<String, FTVariableAbstract> _mapDictionary = new LinkedHashMap<String, FTVariableAbstract>();
    boolean _bManuelInstanciate = false;
    public static final String PROP_AUTOCORRECT_GENERIC = "cecilia.ft.GenericAutoCorrect";
    DBLogs _logsInstanciate = null;

    @Override
    protected Logger getJavaLog() {
        return _LOG;
    }

    public boolean getManuelInstanciate() {
        return this._bManuelInstanciate;
    }

    public FTEquationBasic setManuelInstanciate(boolean value) {
        this._bManuelInstanciate = value;
        return this;
    }

    @Override
    public List<FTVariableAbstract> getAllVariables() {
        return this._listVarsGlobal;
    }

    @Override
    public FTVariableAbstract getVariable(String name) {
        return this._mapDictionary.get(name);
    }

    public FTVariable getTopEvent() {
        return this._ftTopEvent;
    }

    public FTEquationBasic(DBFolder folder) {
        super(folder);
    }

    @Override
    public void configureModels(DBObject dbObj) {
        if (this._ftTopEvent == null) {
            this._ftTopEvent = new FTVariable().setName(this.getDBFolder().getParent().getName());
            this._ftTopEvent.setEvent(new FTEvent());
            this._ftTopEvent.setRoot(true);
            this._ftTopEvent.setInternalID(this._seqID++);
            this._listVarsInternal.add(this._ftTopEvent);
            this._listVarsGlobal.add(this._ftTopEvent);
            this._mapDictionary.put(this._ftTopEvent.getName(), this._ftTopEvent);
        }
        super.configureModels(dbObj);
    }

    @Override
    public FTEquationBasic getCopy() {
        FTEquationBasic dest = new FTEquationBasic(this._dbFolder);
        dest.copy(this);
        return dest;
    }

    @Override
    protected void copy(DBLogsWrap src) {
        super.copy(src);
        if (!(src instanceof FTEquationBasic)) {
            return;
        }
        FTEquationBasic ftEquSrc = (FTEquationBasic)src;
        this._mapDictionary.clear();
        this._listVarsInternal.clear();
        this._ftTopEvent = null;
        CopyUtility.Default helper = new CopyUtility.Default();
        for (FTVariable ftVarSrc : ftEquSrc._listVarsInternal) {
            FTVariable ftVar = ftVarSrc.getCopy((CopyUtility)helper);
            if (ftVarSrc == ftEquSrc._ftTopEvent) {
                this._ftTopEvent = ftVar;
            }
            this._listVarsInternal.add(ftVar);
            this._listVarsGlobal.add(ftVar);
            this._mapDictionary.put(ftVar.getName(), ftVar);
        }
        this._seqID = ftEquSrc._seqID;
    }

    @Override
    public String getAbstract() {
        StringBuilder sb = new StringBuilder();
        sb.append("[").append(ResMsgArbor.getString("CFG_DLG_DSF_SUBTREE")).append("] ");
        sb.append(ResMsgArbor.getString("VOC_ROOT")).append(": ").append(this._ftTopEvent.getName());
        return sb.toString();
    }

    @Override
    public boolean isBigTree() {
        return false;
    }

    public Map<DBAttrib, Set<String>> getAttributesOfVariables() {
        HashMap<DBAttrib, Set<String>> results = new HashMap<DBAttrib, Set<String>>();
        for (int i = this._listVarsGlobal.size() - 1; i >= 0; --i) {
            FTEvent ftEvt = this._listVarsGlobal.get(i).getEvent();
            if (ftEvt == null) continue;
            for (DBAttrib.Value valAttr : ftEvt.getAttributes()) {
                HashSet<String> values = (HashSet<String>)results.get(valAttr.getKey());
                if (values == null) {
                    values = new HashSet<String>();
                    results.put(valAttr.getKey(), values);
                }
                values.add(valAttr.getValue().toString());
            }
        }
        return results;
    }

    public void setVariables(Collection<FTVariable> vars, DBLogs.DBLogsManager logMng, boolean verifyGeneric) {
        int size = vars.size();
        this._listVarsInternal = new ArrayList<FTVariable>(size + 1);
        this._listVarsGlobal = new ArrayList<FTVariableAbstract>(2 * size + 1);
        this._mapDictionary = new LinkedHashMap<String, FTVariableAbstract>();
        if (verifyGeneric) {
            this.verifyGenericVariables(vars, logMng);
        }
        this._ftTopEvent = null;
        for (FTVariable var : vars) {
            if (var.isRoot()) {
                if (this._ftTopEvent == null) {
                    this._ftTopEvent = var;
                } else {
                    logMng.addLog(DBLogs.DBLevel.ERROR, "Multiroot equation: " + this._ftTopEvent.getName() + ", " + var.getName());
                }
            }
            this._listVarsInternal.add(var);
            this._listVarsGlobal.add(var);
            this._mapDictionary.put(var.getName(), var);
        }
        if (this._ftTopEvent == null) {
            logMng.addLog(DBLogs.DBLevel.ERROR, "No root equation");
        }
        Collections.sort(this._listVarsInternal, FTVariableAbstract.getComparatorName());
        Collections.sort(this._listVarsGlobal, FTVariableAbstract.getComparatorName());
        for (FTVariable var : this._listVarsInternal) {
            var.setInternalID(this._seqID++);
        }
    }

    public boolean withLoopDefinition() {
        for (FTVariable var : this._listVarsInternal) {
            var.setFlags(0);
        }
        for (FTVariable var : this._listVarsInternal) {
            if (!this.withLoopDefinition_rec(var)) continue;
            return true;
        }
        for (FTVariable var : this._listVarsInternal) {
            var.setFlags(0);
        }
        return false;
    }

    private boolean withLoopDefinition_rec(FTVariableAbstract var) {
        if (var.getFlags() == 1) {
            return false;
        }
        if (var.getFlags() == 2) {
            return true;
        }
        var.setFlags(2);
        if (var.getDefinition() != null) {
            for (FTVariableAbstract child : var.getDefinition().getArgs()) {
                if (!this.withLoopDefinition_rec(child)) continue;
                return true;
            }
        }
        var.setFlags(1);
        return false;
    }

    private void verifyGenericVariables(Collection<FTVariable> vars, DBLogs.DBLogsManager logMng) {
        boolean withGeneric = false;
        for (FTVariable var : vars) {
            if (var.isGeneric()) {
                withGeneric = true;
            }
            var.setFlags(0);
        }
        if (!withGeneric) {
            return;
        }
        ArrayList<FTVariable> errorVars = new ArrayList<FTVariable>(Math.max(16, vars.size() / 4));
        for (FTVariable var : vars) {
            FTDefinition ftDef;
            if (var.isRoot() || (ftDef = var.getDefinition()) == null) continue;
            boolean withGeneric2 = false;
            for (FTVariableAbstract arg : ftDef.getArgs()) {
                if (!arg.isGeneric() || arg.getLink() != null) continue;
                withGeneric2 = true;
                break;
            }
            if (!withGeneric2 || var.isGeneric()) continue;
            errorVars.add(var);
        }
        if (errorVars.isEmpty()) {
            return;
        }
        StringBuilder sbMsg = new StringBuilder();
        sbMsg.append(ResMsgArbor.getString("MSG_ERR_GENERIC_FLAG")).append("\n");
        for (int i = 0; i < errorVars.size(); ++i) {
            if (i > 0) {
                sbMsg.append(", ");
                if (i % 10 == 0) {
                    sbMsg.append("\n");
                }
            }
            sbMsg.append(((FTVariable)errorVars.get(i)).getName());
        }
        boolean correctionOfErrors = true;
        if (correctionOfErrors) {
            for (int i = errorVars.size() - 1; i >= 0; --i) {
                this.propageFlag((FTVariableAbstract)errorVars.get(i), 1);
            }
            for (FTVariable var : vars) {
                if (var.getFlags() == 0) continue;
                var.setGeneric(false);
            }
        }
        if (Boolean.getBoolean(PROP_AUTOCORRECT_GENERIC)) {
            logMng.addLog(DBLogs.DBLevel.INFO, sbMsg.toString());
        } else {
            logMng.addLog(DBLogs.DBLevel.WARNING, sbMsg.toString());
        }
    }

    public void rename(FTVariable ftVar, String newName) {
        if (this.getVariable(newName) != null) {
            _LOG.info("Tentative de renommage d'une variable avec un nom deja utilise : " + newName);
        } else {
            FTVariableAbstract verifyItem = this.getVariable(ftVar.getName());
            if (verifyItem == null || !verifyItem.equals(ftVar)) {
                _LOG.info("Tentative de renommage d'une variable qui n'existe pas dans l'equation courante : " + ftVar.getName());
            } else {
                this._mapDictionary.remove(ftVar.getName());
                ftVar.setName(newName);
                this._mapDictionary.put(newName, ftVar);
            }
        }
    }

    public void defineLockedVariables() {
        for (FTVariable var : this._listVarsInternal) {
            var.setLocked(false);
        }
        if (this._listVarsInternal.size() == this._listVarsGlobal.size()) {
            return;
        }
        this.setFlags(0);
        for (FTVariable var : this._listVarsInternal) {
            if (var.getLink() == null) continue;
            this.defineLockedVariables_rec(var, false);
        }
    }

    private void defineLockedVariables_rec(FTVariableAbstract ftCurrent, boolean locked) {
        if (locked && ftCurrent.isIntern()) {
            if (ftCurrent instanceof FTVariable) {
                ((FTVariable)ftCurrent).setLocked(true);
            } else {
                _LOG.warning("Une variable interne qui n'est pas FTVariable ? : " + ftCurrent.getExportName());
            }
        }
        if (ftCurrent.getFlags() > 0) {
            return;
        }
        ftCurrent.setFlags(1);
        if (ftCurrent.getDefinition() != null) {
            locked = locked || !ftCurrent.isIntern() || ftCurrent.getLink() != null;
            for (FTVariableAbstract ftChild : ftCurrent.getDefinition().getArgs()) {
                this.defineLockedVariables_rec(ftChild, locked);
            }
        }
    }

    public void changeDefinitionOf(FTVariable ftVar, FTDefinition ftDefine) {
        this.setFlags(1);
        ftVar.setDefinition(ftDefine);
        this._ftTopEvent.resetFlagDescendant(0, false);
        ArrayList<FTVariable> newVars = new ArrayList<FTVariable>(this._listVarsInternal.size() + 10);
        for (int i = 0; i < this._listVarsInternal.size(); ++i) {
            FTVariableAbstract ftArg = this._listVarsInternal.get(i);
            if (ftArg.getFlags() == 0) {
                ftArg.setFlags(2);
                newVars.add((FTVariable)ftArg);
                if (((FTVariable)ftArg).getInternalID() != -1L) continue;
                ((FTVariable)ftArg).setInternalID(this._seqID++);
                continue;
            }
            ((FTVariable)ftArg).setInternalID(-1L);
        }
        this._listVarsInternal = newVars;
        if (ftDefine != null) {
            boolean bAddVar = false;
            for (FTVariableAbstract ftArg : ftDefine.getArgs()) {
                bAddVar |= this.changeDefinitionOf_addNewVar(ftArg);
            }
            if (bAddVar) {
                Collections.sort(this._listVarsInternal, FTVariableAbstract.getComparatorName());
            }
        }
    }

    private boolean changeDefinitionOf_addNewVar(FTVariableAbstract ftVar) {
        if (ftVar.getFlags() != 0) {
            return false;
        }
        ftVar.setFlags(2);
        if (ftVar instanceof FTVariable) {
            this._listVarsInternal.add((FTVariable)ftVar);
            if (ftVar.getInternalID() == -1L) {
                ((FTVariable)ftVar).setInternalID(this._seqID++);
            }
        }
        this._listVarsGlobal.add(ftVar);
        FTDefinition ftDef = ftVar.getDefinition();
        if (ftDef != null) {
            for (FTVariableAbstract ftArg : ftDef.getArgs()) {
                this.changeDefinitionOf_addNewVar(ftArg);
            }
        }
        return true;
    }

    public boolean instanciateAfterChangeDefinition(DBUser dbUser) {
        this._mapDictionary.clear();
        this._listVarsGlobal.clear();
        for (int i = 0; i < this._listVarsInternal.size(); ++i) {
            FTVariable ftArg = this._listVarsInternal.get(i);
            this._listVarsGlobal.add(ftArg);
            this._mapDictionary.put(ftArg.getName(), ftArg);
        }
        if (!this.instanciate(true, dbUser)) {
            this.getInstanciateLogs().traceLogs(_LOG, DBLogs.DBLevel.INFO);
            return false;
        }
        return true;
    }

    private void changeLinkOf(FTVariable ftVar, FTLink ftLink, DBUser dbUser) {
        this.setFlags(1);
        ftVar.setDefinition(null);
        ftVar.setLink(ftLink);
        this._ftTopEvent.resetFlagDescendant(0, false);
        ArrayList<FTVariable> newVars = new ArrayList<FTVariable>(this._listVarsInternal.size() + 10);
        for (int i = 0; i < this._listVarsInternal.size(); ++i) {
            FTVariable ftArg = this._listVarsInternal.get(i);
            if (ftArg.getFlags() == 0) {
                ftArg.setFlags(2);
                newVars.add(ftArg);
                if (ftArg.getInternalID() != -1L) continue;
                ftArg.setInternalID(this._seqID++);
                continue;
            }
            ftArg.setInternalID(-1L);
        }
        this._listVarsInternal = newVars;
        this.instanciateAfterChangeDefinition(dbUser);
        this.defineLockedVariables();
        this.setModified(true);
    }

    @Override
    public DBLogs getInstanciateLogs() {
        return this._logsInstanciate;
    }

    @Override
    public boolean instanciate(boolean force, DBUser dbUser) {
        if (!force && this._logsInstanciate != null) {
            return !this._logsInstanciate.withLogs(DBLogs.DBLevel.WARNING);
        }
        this._logsInstanciate = new DBLogs();
        ArrayList<FTVariable> linkedVars = new ArrayList<FTVariable>();
        for (FTVariable var : this._listVarsInternal) {
            if (!var.isLinked()) continue;
            linkedVars.add(var);
            FTEquationAbstract subEqu = var.getLink().getSubTree();
            if (subEqu.getDBFolder().getAccessRight(dbUser) == DBAccess.Right.INTEGRATE) {
                this.addInstanciateLog(this._logsInstanciate, subEqu.getDBFolder(), DBLogs.DBLevel.WARNING, ResMsgArbor.msgFormat("_MSG_INSTANCE_SUBTREE_INTEGRATE", subEqu.getRefPath(), var.getExportName(), this.getRefPath()));
                continue;
            }
            if (!subEqu.instanciate(false, dbUser)) {
                this.addInstanciateLog(this._logsInstanciate, subEqu.getDBFolder(), DBLogs.DBLevel.WARNING, ResMsgArbor.msgFormat("_MSG_INSTANCE_SUBTREE", var.getExportName(), subEqu.getRefPath()));
                continue;
            }
            if (!subEqu.getInstanciateLogs().withLogs(DBLogs.DBLevel.INFO)) continue;
            for (DBLogs.Log dbLog : subEqu.getInstanciateLogs().getLogs(DBLogs.DBLevel.INFO)) {
                this._logsInstanciate.addLog(dbLog);
            }
        }
        if (!linkedVars.isEmpty() && !this._logsInstanciate.withLogs(DBLogs.DBLevel.WARNING)) {
            while (!linkedVars.isEmpty()) {
                FTVariable varLink = null;
                for (int i = linkedVars.size() - 1; i >= 0 && varLink == null; --i) {
                    FTVariable iVarLink = (FTVariable)linkedVars.get(i);
                    boolean find = false;
                    for (int j = linkedVars.size() - 1; !find && j >= 0; --j) {
                        if (i == j) continue;
                        FTVariable jVarLink = (FTVariable)linkedVars.get(j);
                        FTVariableAbstract tVar = iVarLink.getLink().getSubTree().getVariable(jVarLink.getName());
                        if (tVar == null || tVar.isRoot()) continue;
                        find = true;
                    }
                    if (find) continue;
                    varLink = (FTVariable)linkedVars.remove(i);
                }
                if (varLink == null) {
                    this.addInstanciateLog(this._logsInstanciate, this.getDBFolder(), DBLogs.DBLevel.ERROR, "Internal error: Impossibilit\u00e9 de choisir le prochain sous-arbre a instancier");
                    return false;
                }
                FTEquationAbstract subEqu = varLink.getLink().getSubTree();
                String append = varLink.getLink().getGeneric();
                List<FTVariableExtern> subVars = subEqu.instanciateVariables(append);
                for (FTVariableExtern subVar : subVars) {
                    subVar.setFlags(0);
                }
                for (FTVariableExtern subVar : subVars) {
                    if (subVar.getFlags() != 0) continue;
                    if (subVar.isRoot()) {
                        varLink.setDefinition(subVar.getDefinition());
                        continue;
                    }
                    String msgErr = this.appendInternalVar(subVar, false);
                    if (msgErr == null) continue;
                    FTVariableAbstract firstVar = this._mapDictionary.get(subVar.getName());
                    String msg = ResMsgArbor.msgFormat("_MSG_EQUI_HEADER", subVar.getName(), msgErr, varLink.getName(), firstVar.toStringOrigins(this), subVar.toStringOrigins(this));
                    this.addInstanciateLog(this._logsInstanciate, subEqu.getDBFolder(), DBLogs.DBLevel.WARNING, msg);
                }
            }
            if (!this._logsInstanciate.withLogs(DBLogs.DBLevel.WARNING)) {
                Collections.sort(this._listVarsGlobal, FTVariableAbstract.getComparatorName());
                this.deleteRemovedVars();
            }
        }
        if (this._logsInstanciate.withLogs(DBLogs.DBLevel.WARNING)) {
            this._mapDictionary.clear();
            this._listVarsGlobal.clear();
            for (int i = 0; i < this._listVarsInternal.size(); ++i) {
                FTVariable ftArg = this._listVarsInternal.get(i);
                this._listVarsGlobal.add(ftArg);
                this._mapDictionary.put(ftArg.getName(), ftArg);
                if (ftArg.isLinked()) {
                    ftArg.setDefinition(null);
                }
                ftArg.setProbability(Double.NaN);
            }
        }
        return !this._logsInstanciate.withLogs(DBLogs.DBLevel.WARNING);
    }

    private void deleteRemovedVars() {
        for (FTVariableAbstract ftVar : this._listVarsGlobal) {
            FTDefinition ftDef = ftVar.getDefinition();
            if (ftDef == null) continue;
            boolean bWithRemoved = false;
            ArrayList<FTVariableAbstract> ftNewArgs = new ArrayList<FTVariableAbstract>();
            for (FTVariableAbstract ftArg : ftDef.getArgs()) {
                if (ftArg.getFlags() == 3) {
                    FTVariableAbstract ftChg = this._mapDictionary.get(ftArg.getName());
                    if (ftChg == null) {
                        _LOG.info("Variable '" + ftArg.getName() + "' FLAG_REMOVED (r\u00e9f. inconnu) : " + this.getRefPath());
                        ftNewArgs.add(ftArg);
                        continue;
                    }
                    if (ftChg == ftArg) {
                        _LOG.info("La variable '" + ftArg.getName() + "' FLAG_REMOVED (r\u00e9f. courante) : " + this.getRefPath());
                        ftNewArgs.add(ftArg);
                        continue;
                    }
                    ftNewArgs.add(ftChg);
                    bWithRemoved = true;
                    continue;
                }
                ftNewArgs.add(ftArg);
            }
            if (!bWithRemoved) continue;
            ftDef.setArgs(ftNewArgs);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String appendInternalVar(FTVariableAbstract subVar, boolean subVarIsGoofRef) {
        FTVariableAbstract otherVar = this._mapDictionary.get(subVar.getName());
        if (otherVar != null) {
            StringBuilder sb = new StringBuilder(64);
            if (!otherVar.isEquivalentTo(subVar, sb)) return sb.toString();
            if (subVarIsGoofRef) {
                otherVar.setFlags(3);
                if (otherVar.isRoot()) {
                    subVar.setRoot(true);
                    if (otherVar == this._ftTopEvent && subVar instanceof FTVariable) {
                        this._ftTopEvent = (FTVariable)subVar;
                    } else assert (false);
                }
                this._mapDictionary.put(subVar.getName(), subVar);
                this._listVarsGlobal.remove(otherVar);
                this._listVarsGlobal.add(subVar);
                if (otherVar instanceof FTVariable) {
                    this._listVarsInternal.remove(otherVar);
                }
                if (!(subVar instanceof FTVariable)) return null;
                this._listVarsInternal.add((FTVariable)subVar);
                return null;
            } else {
                subVar.setFlags(3);
            }
            return null;
        } else {
            subVar.setFlags(1);
            this._mapDictionary.put(subVar.getName(), subVar);
            this._listVarsGlobal.add(subVar);
            if (!(subVar instanceof FTVariable)) return null;
            this._listVarsInternal.add((FTVariable)subVar);
        }
        return null;
    }

    @Override
    public List<FTVariableExtern> instanciateVariables(String append) {
        return this.instanciateVariables(this._listVarsGlobal, append);
    }

    public boolean update(CeciliaAppl appl, DBLogs.DBLogsManager logMng) {
        CECFactory cecFactory = appl.getDAOFactory();
        this.clearResults();
        this._mapDictionary.clear();
        this._listVarsGlobal.clear();
        for (int i = 0; i < this._listVarsInternal.size(); ++i) {
            FTVariable ftArg = this._listVarsInternal.get(i);
            this._listVarsGlobal.add(ftArg);
            this._mapDictionary.put(ftArg.getName(), ftArg);
            if (ftArg.isLinked()) {
                FTLink ftLink = ftArg.getLink();
                if (ftLink.update(cecFactory, logMng)) continue;
                ftArg.setLink(null);
                ftArg.setEvent(new FTEvent());
                ftArg.getEvent().initialise(appl);
                continue;
            }
            if (!ftArg.isLeaf() || ftArg.getEvent() == null) continue;
            FTEvent ftEvent = ftArg.getEvent();
            ftEvent.update(cecFactory, logMng, ftArg.getName());
        }
        this._logsInstanciate = null;
        boolean result = this.instanciate(false, appl.getDBUser());
        this.prepareDependTimeUpdt(cecFactory, this.getWorkingRelations());
        return result;
    }

    @Override
    public short getFamilyFlag() {
        return 2;
    }

    @Override
    protected String getNature() {
        return "tree.def";
    }

    @Override
    public void toXML(Appendable out, String indent) throws IOException {
        out.append(indent).append("<").append("cec.faulttree");
        if (this.isBigTree()) {
            out.append(" ").append("isBigTree").append("='true'");
        }
        out.append(">\n");
        String subindent = indent + "    ";
        out.append(indent).append("  <").append("ft.variables").append(">\n");
        for (FTVariable ftVar : this._listVarsInternal) {
            ftVar.toXMLDictionary(out, subindent);
        }
        out.append(indent).append("  </").append("ft.variables").append(">\n");
        if (this.isBigTree()) {
            out.append(indent).append("  <").append("ft.equations").append(">\n");
            out.append(indent).append("  </").append("ft.equations").append(">\n");
        } else {
            out.append(indent).append("  <").append("ft.equations").append(">\n");
            for (FTVariable ftVar : this._listVarsInternal) {
                ftVar.toXMLEquation(out, subindent);
            }
            out.append(indent).append("  </").append("ft.equations").append(">\n");
        }
        this.toXML_others(out, indent + "  ");
        out.append(indent).append("</").append("cec.faulttree").append(">\n");
    }

    protected void toXML_others(Appendable out, String indent) throws IOException {
    }

    public Set<DBRelation> getUseRelations() {
        HashSet<DBRelation> relations = new HashSet<DBRelation>();
        for (FTVariable ftVariable : this._listVarsInternal) {
            ftVariable.addRelation(this._dbFolder, "TREE_V", relations);
        }
        return relations;
    }

    public Set<DBRelation> getWorkingRelations() {
        HashSet<DBRelation> relations = new HashSet<DBRelation>();
        for (FTVariable ftVariable : this._listVarsInternal) {
            ftVariable.addRelation(this._dbFolder, "WORKING", relations);
        }
        return relations;
    }

    @Override
    protected boolean readFromDBObjModel(DBObjModel model, CECFactory cecFactory, DBLogs.DBLogsManager logMng) {
        String format = model.getFormat();
        if ("ZML".equals(format) || "XML".equals(format)) {
            InputStream istream = this.getBinaryStream(model, cecFactory, logMng);
            if (istream == null) {
                return false;
            }
            if ("ZML".equals(format)) {
                istream = new InflaterInputStream(istream, new Inflater());
            }
            return this.readXml(istream, cecFactory, logMng);
        }
        logMng.addLog(DBLogs.DBLevel.ERROR, ResMsgCore.msgFormat("MSG_ERR_DBMOD_FORMAT", this.getNature(), format));
        return false;
    }

    protected boolean readXml(InputStream input, CECFactory cecFactory, DBLogs.DBLogsManager logMng) {
        boolean result = false;
        FTEquationHandlerXml saxHanlder = new FTEquationHandlerXml(logMng, null, cecFactory);
        try {
            this.readXml(input, saxHanlder);
            this.setVariables(saxHanlder.getVariables(), logMng, true);
            if (this.withLoopDefinition()) {
                this.getJavaLog().severe("Looped equation !!");
            } else {
                result = true;
            }
        }
        catch (IOException e) {
            logMng.addLog(DBLogs.DBLevel.ERROR, ResMsgCore.getString("MSG_ERR_DBMOD_XML_GENERIC"));
        }
        return result;
    }

    public void writeEqu(Appendable out) throws IOException {
        for (FTVariableAbstract var : this._listVarsGlobal) {
            if (var.getFlags() == 0) continue;
            var.writeEqu(out);
        }
    }

    public List<List<FTVariableAbstract>> findPaths(FTVariableAbstract ftTop, FTVariableAbstract ftChild, boolean checkByName) {
        this.setFlags(0);
        ArrayList<List<FTVariableAbstract>> result = new ArrayList<List<FTVariableAbstract>>(4);
        LinkedList<FTVariableAbstract> path = new LinkedList<FTVariableAbstract>();
        if (ftTop == null) {
            ftTop = this._ftTopEvent;
        }
        this.findPaths_rec(ftTop, ftChild, path, result, checkByName);
        return result;
    }

    private void findPaths_rec(FTVariableAbstract ftCur, FTVariableAbstract ftStop, LinkedList<FTVariableAbstract> path, List<List<FTVariableAbstract>> result, boolean checkByName) {
        if (checkByName ? ftCur.getExportName().equals(ftStop.getExportName()) : ftCur == ftStop) {
            result.add(new ArrayList<FTVariableAbstract>(path));
        } else if (ftCur.getFlags() == 0) {
            FTDefinition ftDef = ftCur.getDefinition();
            if (ftDef != null) {
                path.addLast(ftCur);
                for (FTVariableAbstract ftArg : ftDef.getArgs()) {
                    this.findPaths_rec(ftArg, ftStop, path, result, checkByName);
                }
                path.removeLast();
            }
            ftCur.setFlags(1);
        }
    }

    public boolean addVariables(Collection<FTVariable> vars, DBLogs.DBLogsManager logMng) {
        this.setFlags(0);
        for (FTVariable ftVar : vars) {
            ftVar.setFlags(0);
            ftVar.setInternalID(this._seqID++);
        }
        for (FTVariable subVar : vars) {
            String msgErr = this.appendInternalVar(subVar, true);
            if (msgErr == null) continue;
            String msg = ResMsgArbor.msgFormat("_MSG_EQUI_HEADER_APPEND", subVar.getName(), msgErr, subVar.getName());
            logMng.addLog(DBLogs.DBLevel.WARNING, msg);
        }
        if (!logMng.withLogs(DBLogs.DBLevel.WARNING)) {
            Collections.sort(this._listVarsGlobal, FTVariableAbstract.getComparatorName());
            Collections.sort(this._listVarsInternal, FTVariableAbstract.getComparatorName());
            this.deleteRemovedVars();
            return true;
        }
        return false;
    }
}

