/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.dbobj.faulttree.ft.export;

import com.dassault.cecilia.core.ResMsgVoc;
import com.dassault.cecilia.core.cecilia.ResMsgCore;
import com.dassault.cecilia.core.cecilia.export.DBKOutput;
import com.dassault.cecilia.core.cecilia.export.ExpGeneral;
import com.dassault.cecilia.core.cecilia.export.ExpSection;
import com.dassault.cecilia.core.cecilia.print.SrbInputStream;
import com.dassault.cecilia.core.swing.DlgPanelTime;
import com.dassault.cecilia.db.DBFolder;
import com.dassault.cecilia.db.DBObjProperty;
import com.dassault.cecilia.dbobj.ResMsgObj;
import com.dassault.cecilia.dbobj.faulttree.ResMsgArbor;
import com.dassault.cecilia.dbobj.faulttree.ft.FTEquation;
import com.dassault.cecilia.dbobj.faulttree.ft.TypeProbability;
import com.dassault.cecilia.dbobj.faulttree.ft.export.ExpFTCriticityResult;
import com.dassault.cecilia.lib.util.format.DoubleFormat;
import java.io.IOException;

public class ExpFTAnalysis
extends ExpSection {
    FTEquation _ftEqu;

    public ExpFTAnalysis(FTEquation ftEqu, DoubleFormat formatter) {
        this._ftEqu = ftEqu;
        this.add(new SectReference());
        if (this._ftEqu.withMBSAExportFields()) {
            this.add(new SectMBSA());
        }
        this.add(new SectDate());
        this.add(new SectRoot());
        this.add(new SectFlyPhase());
        if (this._ftEqu.getComputeParameters().isOneHourOption()) {
            this.add(new SectAverageFly());
        }
        if (this._ftEqu.getCriticityLevel() != null) {
            this.add(new ExpFTCriticityResult.ExpFTCriticityResultSection(this._ftEqu, formatter));
        }
    }

    @Override
    public String getTitle() {
        return ResMsgArbor.getString("KEY_0408");
    }

    class SectReference
    extends ExpGeneral {
        public SectReference() {
            super(ExpFTAnalysis.this._ftEqu.getDBFolder());
        }

        @Override
        public String getTitle() {
            return ResMsgArbor.getString("KEY_0496");
        }

        @Override
        protected void writeContentDocbook(DBKOutput output) throws IOException {
            DBFolder dbFolder = ExpFTAnalysis.this._ftEqu.getDBFolder();
            this.writeDBKSimpleParamKey(output, ResMsgVoc.getString("VOC_PROJECT"), dbFolder.getParent().getParent().getParent().getName());
            this.writeDBKSimpleParamKey(output, ResMsgVoc.getString("VOC_SYSTEM"), dbFolder.getParent().getParent().getName());
            this.writeDBKSimpleParamKey(output, ResMsgVoc.getString("VOC_TREE"), dbFolder.getParent().getName() + "(" + dbFolder.getName() + ")");
            this.writeDBKComments(output);
        }

        @Override
        protected void writeContentScribe(SrbInputStream scribe) throws IOException {
            scribe.concat("<UL>\n");
            DBFolder dbFolder = ExpFTAnalysis.this._ftEqu.getDBFolder();
            this.writeSRBSimpleParamKey(scribe, ResMsgVoc.getString("VOC_PROJECT"), dbFolder.getParent().getParent().getParent().getName());
            this.writeSRBSimpleParamKey(scribe, ResMsgVoc.getString("VOC_SYSTEM"), dbFolder.getParent().getParent().getName());
            this.writeSRBSimpleParamKey(scribe, ResMsgVoc.getString("VOC_TREE"), dbFolder.getParent().getName() + "(" + dbFolder.getName() + ")");
            this.writeScribeComments(scribe);
        }
    }

    class SectMBSA
    extends ExpSection {
        @Override
        public String getTitle() {
            return ResMsgArbor.getString("MSG_DLG_MBSA_CONF");
        }

        @Override
        protected void writeContentDocbook(DBKOutput output) throws IOException {
            if (ExpFTAnalysis.this._ftEqu.getModelePathMBSA() != null) {
                this.writeDBKSimpleParamKey(output, ResMsgArbor.getString("MSG_DLG_MBSA_MODEL"), ExpFTAnalysis.this._ftEqu.getModelePathMBSA());
            }
            if (ExpFTAnalysis.this._ftEqu.getInitialConfMBSA() != null) {
                this.writeDBKSimpleParamKey(output, ResMsgArbor.getString("MSG_DLG_MBSA_INITIAL_CONF"), ExpFTAnalysis.this._ftEqu.getInitialConfMBSA());
            }
            if (ExpFTAnalysis.this._ftEqu.getTargetMBSA() != null) {
                this.writeDBKSimpleParamKey(output, ResMsgArbor.getString("MSG_DLG_MBSA_TARGET"), ExpFTAnalysis.this._ftEqu.getTargetMBSA());
            }
        }

        @Override
        protected void writeContentScribe(SrbInputStream scribe) throws IOException {
            if (ExpFTAnalysis.this._ftEqu.getModelePathMBSA() != null) {
                this.writeSRBSimpleParamKey(scribe, ResMsgArbor.getString("MSG_DLG_MBSA_MODEL"), ExpFTAnalysis.this._ftEqu.getModelePathMBSA());
            }
            if (ExpFTAnalysis.this._ftEqu.getInitialConfMBSA() != null) {
                scribe.concat(ResMsgArbor.getString("MSG_DLG_MBSA_INITIAL_CONF"));
                scribe.concat(":<HP2>");
                scribe.concat(ExpFTAnalysis.this._ftEqu.getInitialConfMBSA());
                scribe.concat("<EHP2>\n");
                scribe.concat(".br \n");
            }
            if (ExpFTAnalysis.this._ftEqu.getTargetMBSA() != null) {
                this.writeSRBSimpleParamKey(scribe, ResMsgArbor.getString("MSG_DLG_MBSA_TARGET"), ExpFTAnalysis.this._ftEqu.getTargetMBSA());
            }
        }
    }

    class SectDate
    extends ExpSection {
        @Override
        public String getTitle() {
            return ResMsgVoc.getString("VOC_DATES");
        }

        @Override
        protected void writeContentDocbook(DBKOutput output) throws IOException {
            DBFolder _dbFolder = ExpFTAnalysis.this._ftEqu.getDBFolder();
            DBObjProperty dbObjProp = null;
            if (_dbFolder.isVersion() && _dbFolder.getObject() != null) {
                dbObjProp = _dbFolder.getObject().getProperty("object.creator");
            }
            if (dbObjProp != null) {
                this.writeDBKSimpleParamKey(output, ResMsgVoc.getString("VOC_CREATION"), ResMsgCore.msgFormat("MSG_DATE_BY_USER", this.dateToString(_dbFolder.getDateCreate()), dbObjProp.getValue()));
            } else {
                this.writeDBKSimpleParamKey(output, ResMsgVoc.getString("VOC_CREATION"), this.dateToString(_dbFolder.getDateCreate()));
            }
            StringBuilder sb = new StringBuilder();
            sb.append(ResMsgCore.msgFormat("MSG_DATE_BY_USER", this.dateToString(_dbFolder.getDateModify()), _dbFolder.getUserModify().getLogin()));
            if (_dbFolder.isFreeze()) {
                sb.append(" [").append(ResMsgVoc.getString("VOC_FREEZE")).append("]");
            }
            this.writeDBKSimpleParamKey(output, ResMsgVoc.getString("VOC_MODIFICATION"), sb.toString());
        }

        @Override
        protected void writeContentScribe(SrbInputStream scribe) throws IOException {
            DBFolder _dbFolder = ExpFTAnalysis.this._ftEqu.getDBFolder();
            DBObjProperty dbObjProp = null;
            if (_dbFolder.isVersion() && _dbFolder.getObject() != null) {
                dbObjProp = _dbFolder.getObject().getProperty("object.creator");
            }
            if (dbObjProp != null) {
                this.writeSRBSimpleParamKey(scribe, ResMsgVoc.getString("VOC_CREATION"), ResMsgCore.msgFormat("MSG_DATE_BY_USER", this.dateToString(_dbFolder.getDateCreate()), dbObjProp.getValue()));
            } else {
                this.writeSRBSimpleParamKey(scribe, ResMsgVoc.getString("VOC_CREATION"), this.dateToString(_dbFolder.getDateCreate()));
            }
            StringBuilder sb = new StringBuilder();
            sb.append(ResMsgCore.msgFormat("MSG_DATE_BY_USER", this.dateToString(_dbFolder.getDateModify()), _dbFolder.getUserModify().getLogin()));
            if (_dbFolder.isFreeze()) {
                sb.append(" [").append(ResMsgVoc.getString("VOC_FREEZE")).append("]");
            }
            this.writeSRBSimpleParamKey(scribe, ResMsgVoc.getString("VOC_MODIFICATION"), sb.toString());
        }
    }

    class SectRoot
    extends ExpSection {
        @Override
        public String getTitle() {
            return ResMsgArbor.getString("KEY_0409");
        }

        @Override
        protected void writeContentDocbook(DBKOutput output) throws IOException {
            this.writeDBKSimpleParamKey(output, ResMsgVoc.getString("VOC_NAME"), ExpFTAnalysis.this._ftEqu.getTopEvent().getName());
            String comment = ExpFTAnalysis.this._ftEqu.getTopEvent().getLabel();
            if (comment != null && !comment.isEmpty()) {
                this.writeDBKSimpleParamKey(output, ResMsgVoc.getString("VOC_COMMENT"), comment);
            }
            this.writeDBKSimpleParamKey(output, ResMsgVoc.getString("VOC_PROBABILITY"), this.getStringProbability(this.getTopProbability()));
        }

        @Override
        protected void writeContentScribe(SrbInputStream scribe) throws IOException {
            this.writeSRBSimpleParamKey(scribe, ResMsgVoc.getString("VOC_NAME"), ExpFTAnalysis.this._ftEqu.getTopEvent().getName());
            String comment = ExpFTAnalysis.this._ftEqu.getTopEvent().getLabel();
            if (comment != null && !comment.isEmpty()) {
                scribe.concat("@@");
                this.exportScribeComment(scribe, comment, "\n.br \n@@");
                scribe.concat("\n");
                scribe.concat(".br \n");
            }
            this.writeSRBSimpleParamKey(scribe, ResMsgVoc.getString("VOC_PROBABILITY"), this.getStringProbability(this.getTopProbability()));
        }

        protected String getStringProbability(double prb) {
            if (Double.isNaN(prb) || prb == -1.0) {
                return "-";
            }
            StringBuilder buffer = new StringBuilder();
            buffer.append(this.dtos(prb));
            TypeProbability typePr = ExpFTAnalysis.this._ftEqu.getComputeParameters().getType();
            switch (typePr) {
                case NONE: {
                    break;
                }
                case ARP1: 
                case ARP2: {
                    buffer.append(" (").append(typePr.getLabel());
                    if (ExpFTAnalysis.this._ftEqu.getComputeParameters().getAverageAttribute() != null) {
                        buffer.append(" (").append(ExpFTAnalysis.this._ftEqu.getComputeParameters().getAverageAttribute()).append(")");
                    }
                    buffer.append(")");
                    break;
                }
                default: {
                    buffer.append(" (").append(typePr.getLabel()).append(")");
                }
            }
            return buffer.toString();
        }

        protected double getTopProbability() {
            double result = ExpFTAnalysis.this._ftEqu.getTopEvent().getProbability();
            if (Double.isNaN(result)) {
                return result;
            }
            if (result < 0.0) {
                return result;
            }
            if (ExpFTAnalysis.this._ftEqu.getComputeParameters().isOneHourOption()) {
                double time = ExpFTAnalysis.this._ftEqu.getComputeParameters().getFlightDuration();
                if (Double.isNaN(time)) {
                    time = ExpFTAnalysis.this._ftEqu.getComputeParameters().getTime();
                }
                if (!Double.isNaN(time)) {
                    return result / time * 3600.0;
                }
            }
            return result;
        }
    }

    class SectFlyPhase
    extends ExpSection {
        @Override
        public String getTitle() {
            return ResMsgVoc.getString("VOC_FLIGHT_PHASE");
        }

        @Override
        protected void writeContentDocbook(DBKOutput output) throws IOException {
            StringBuilder buffer = new StringBuilder();
            buffer.append(DlgPanelTime.formatMissionTime(ExpFTAnalysis.this._ftEqu.getComputeParameters().getTime()));
            if (ExpFTAnalysis.this._ftEqu.getComputeParameters().isOneHourOption()) {
                buffer.append(ResMsgArbor.getString("KEY_0837"));
            }
            this.writeDBKSimpleParamKey(output, ResMsgVoc.getString("VOC_DURATION"), buffer.toString());
            this.writeDBKSimpleParamKey(output, ResMsgArbor.getString("KEY_0413"), "");
        }

        @Override
        protected void writeContentScribe(SrbInputStream scribe) throws IOException {
            StringBuilder buffer = new StringBuilder();
            buffer.append(DlgPanelTime.formatMissionTime(ExpFTAnalysis.this._ftEqu.getComputeParameters().getTime()));
            if (ExpFTAnalysis.this._ftEqu.getComputeParameters().isOneHourOption()) {
                buffer.append(ResMsgArbor.getString("KEY_0837"));
            }
            this.writeSRBSimpleParamKey(scribe, ResMsgVoc.getString("VOC_DURATION"), buffer.toString());
            this.writeSRBSimpleParamKey(scribe, ResMsgArbor.getString("KEY_0413"), "");
        }
    }

    class SectAverageFly
    extends ExpSection {
        @Override
        public String getTitle() {
            return ResMsgObj.getString("DLG_AVERAGEFLIGHT_EXPORT");
        }

        @Override
        protected void writeContentDocbook(DBKOutput output) throws IOException {
            this.writeDBKSimpleParamKey(output, ResMsgVoc.getString("VOC_DURATION"), DlgPanelTime.formatMissionTime(ExpFTAnalysis.this._ftEqu.getComputeParameters().getFlightDuration()));
        }

        @Override
        protected void writeContentScribe(SrbInputStream scribe) throws IOException {
            this.writeSRBSimpleParamKey(scribe, ResMsgVoc.getString("VOC_DURATION"), DlgPanelTime.formatMissionTime(ExpFTAnalysis.this._ftEqu.getComputeParameters().getFlightDuration()));
        }
    }
}

