/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.dbobj.faulttree.ft.export;

import com.dassault.cecilia.core.ResMsgVoc;
import com.dassault.cecilia.core.cecilia.export.DBKOutput;
import com.dassault.cecilia.core.cecilia.export.ExpSection;
import com.dassault.cecilia.core.cecilia.print.SrbInputStream;
import com.dassault.cecilia.dbobj.ResMsgObj;
import com.dassault.cecilia.dbobj.faulttree.ResMsgArbor;
import com.dassault.cecilia.dbobj.faulttree.ft.FTComputeParameters;
import com.dassault.cecilia.dbobj.faulttree.ft.FTEquation;
import java.io.IOException;

public class ExpFTComputeParameters
extends ExpSection {
    FTEquation _ftEqu;

    public ExpFTComputeParameters(FTEquation ftEqu) {
        this._ftEqu = ftEqu;
    }

    @Override
    public String getTitle() {
        return ResMsgVoc.getString("VOC_PARAMETERS");
    }

    @Override
    protected void writeContentDocbook(DBKOutput output) throws IOException {
        FTComputeParameters params = this._ftEqu.getComputeParameters();
        this.writeDBKSimpleParamKey(output, ResMsgVoc.getString("VOC_FLIGHT_PHASE"), " ");
        this.writeDBKSimpleParamKey(output, ResMsgArbor.getString("KEY_0413"), " ");
        this.writeDBKSimpleParamKey(output, ResMsgVoc.getString("VOC_TIME"), ResMsgArbor.formatHMS(params.getTime()) + (params.isOneHourOption() ? ResMsgArbor.getString("KEY_0837") : ""));
        this.writeDBKSimpleParamKey(output, ResMsgVoc.getString("VOC_TYPE"), params.getType().getLabel() + (String)(params.getAverageAttribute() != null ? " (" + params.getAverageAttribute() + ")" : ""));
        double averageDuration = params.getFlightDuration();
        if (!Double.isNaN(averageDuration)) {
            this.writeDBKSimpleParamKey(output, ResMsgObj.getString("DLG_AVERAGEFLIGHT_LABEL"), " ");
            this.writeDBKSimpleParamKey(output, ResMsgVoc.getString("VOC_DURATION"), ResMsgArbor.formatHMS(averageDuration));
        }
    }

    @Override
    protected void writeContentScribe(SrbInputStream scribe) throws IOException {
        FTComputeParameters params = this._ftEqu.getComputeParameters();
        this.writeSRBSimpleParamKey(scribe, ResMsgVoc.getString("VOC_FLIGHT_PHASE"), " ");
        this.writeSRBSimpleParamKey(scribe, ResMsgArbor.getString("KEY_0413"), " ");
        this.writeSRBSimpleParamKey(scribe, ResMsgVoc.getString("VOC_TIME"), ResMsgArbor.formatHMS(params.getTime()) + (params.isOneHourOption() ? ResMsgArbor.getString("KEY_0837") : ""));
        this.writeSRBSimpleParamKey(scribe, ResMsgVoc.getString("VOC_TYPE"), params.getType().getLabel() + (String)(params.getAverageAttribute() != null ? " (" + params.getAverageAttribute() + ")" : ""));
        double averageDuration = params.getFlightDuration();
        if (!Double.isNaN(averageDuration)) {
            this.writeSRBSimpleParamKey(scribe, ResMsgObj.getString("DLG_AVERAGEFLIGHT_LABEL"), " ");
            this.writeSRBSimpleParamKey(scribe, ResMsgVoc.getString("VOC_DURATION"), ResMsgArbor.formatHMS(averageDuration));
        }
    }
}

