/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.dbobj.faulttree.ft.export;

import com.dassault.cecilia.core.cecilia.export.ExpBook;
import com.dassault.cecilia.core.cecilia.export.ExpContainer;
import com.dassault.cecilia.core.cecilia.export.ExpDBFolderHeader;
import com.dassault.cecilia.core.cecilia.export.ExpObjectInfo;
import com.dassault.cecilia.core.cecilia.export.XPortCfgDependencies;
import com.dassault.cecilia.core.cecilia.export.XPortConfig;
import com.dassault.cecilia.dbobj.faulttree.ft.FTEquation;
import com.dassault.cecilia.dbobj.faulttree.ft.export.ExpFTComputeParameters;
import com.dassault.cecilia.dbobj.faulttree.ft.export.ExpFTConfigs;
import com.dassault.cecilia.dbobj.faulttree.ft.export.ExpFTGeneral;
import com.dassault.cecilia.dbobj.faulttree.ft.export.ExpFTGraphicTree;
import com.dassault.cecilia.dbobj.faulttree.ft.export.ExpFTListVariables;
import com.dassault.cecilia.dbobj.faulttree.ft.export.ExpFTListVariables51;
import com.dassault.cecilia.dbobj.faulttree.ft.export.ExpFTListVariablesRecap;
import com.dassault.cecilia.dbobj.faulttree.pref.FTVariableListPrintPreferencies;

public class XPortCfgTree
extends XPortCfgDependencies
implements XPortConfig<FTEquation> {
    private TypeExport _typeExport = TypeExport.ALL_INFOS;
    private int _levelGSR = -1;

    public void setTypeExport(TypeExport typeExport) {
        this._typeExport = typeExport;
    }

    public void configLevelGSR(int levelGSR) {
        this._levelGSR = levelGSR;
    }

    @Override
    public void configBook(ExpBook expBook, FTEquation item) {
        switch (this._typeExport) {
            case ONLY_LIST_EVENTS: {
                expBook.setInfo(new ExpObjectInfo(item.getDBFolder()));
                expBook.add(new ExpFTListVariables51(expBook, item));
                break;
            }
            case ONLY_TREE_VIEW: {
                if (item.isBigTree()) break;
                expBook.setInfo(new ExpObjectInfo(item.getDBFolder()));
                expBook.add(new ExpFTGraphicTree(item).configLevelGSR(this._levelGSR));
                break;
            }
            case ALL_INFOS: {
                expBook.setInfo(new ExpObjectInfo(item.getDBFolder()));
                boolean onlyInternal = false;
                if (expBook.getPreferencies() != null) {
                    FTVariableListPrintPreferencies pref = (FTVariableListPrintPreferencies)expBook.getPreferencies().getOptions(FTVariableListPrintPreferencies.PREF_KEY);
                    onlyInternal = pref.getPref("Events.OnlyIntern").isSelected();
                }
                this.addInternal(expBook, item, true, onlyInternal);
            }
        }
    }

    @Override
    public void addInto(ExpContainer expContainer, FTEquation item) {
        ExpDBFolderHeader header = new ExpDBFolderHeader(item.getDBFolder());
        this.addInternal(header, item, false, false);
        expContainer.add(header);
    }

    private void addInternal(ExpContainer expContainer, FTEquation item, boolean topTree, boolean onlyInternal) {
        expContainer.add(new ExpFTGeneral(item));
        expContainer.add(new ExpFTConfigs(item.getConfigs()));
        if (topTree) {
            expContainer.add(new ExpFTListVariablesRecap(item, onlyInternal));
            expContainer.add(new ExpFTComputeParameters(item));
        }
        if (!item.isBigTree()) {
            expContainer.add(new ExpFTGraphicTree(item));
        }
        expContainer.add(new ExpFTListVariables((ExpBook)expContainer, item));
    }

    public static enum TypeExport {
        ONLY_TREE_VIEW,
        ONLY_LIST_EVENTS,
        ALL_INFOS;

    }
}

