/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.dbobj.faulttree.ft.grf;

import com.dassault.cecilia.dbobj.faulttree.ft.FTEquation;
import com.dassault.cecilia.dbobj.faulttree.ft.grf.FGContext;
import com.dassault.cecilia.dbobj.faulttree.ft.grf.FGIterator;
import com.dassault.cecilia.dbobj.faulttree.ft.grf.FGScissor;
import com.dassault.cecilia.dbobj.faulttree.ft.grf.FGScissorDepth;
import com.dassault.cecilia.dbobj.faulttree.ft.grf.FGVariable;
import com.dassault.cecilia.dbobj.faulttree.obj.FTDefinition;
import com.dassault.cecilia.dbobj.faulttree.obj.FTVariableAbstract;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.geom.AffineTransform;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class FGContent {
    FTEquation _ftEquation;
    FGScissor _fgScissor;
    int _width;
    int _height;
    FGVariable _fgTop;
    public static final String PROP_CONTENT_TRACE = "cecilia.ft.gui.GraphicContentTrace";
    boolean _bTrace = Boolean.getBoolean("cecilia.ft.gui.GraphicContentTrace");

    public FGContent(FTEquation ftEquation) {
        this(ftEquation, new FGScissorDepth(3));
    }

    public FGContent(FTEquation ftEquation, FGScissor fgScissor) {
        this._ftEquation = ftEquation;
        this._fgScissor = fgScissor;
        this.browse(this._ftEquation.getTopEvent());
    }

    public FTEquation getEquation() {
        return this._ftEquation;
    }

    public FGVariable getTop() {
        return this._fgTop;
    }

    public FGScissor getScissor() {
        return this._fgScissor;
    }

    public boolean setScissor(FGScissor fgScissor) {
        if (this._fgScissor.equals(fgScissor)) {
            return false;
        }
        this._fgScissor = fgScissor;
        this.browse(this._fgTop.getVar());
        return true;
    }

    private FGVariable createFGVar_rec(FTVariableAbstract ftVar, boolean linkException) {
        FTDefinition ftDef;
        FGVariable fgVar = new FGVariable(ftVar);
        if (!this._fgScissor.cut(ftVar) && (linkException || ftVar.getLink() == null) && (ftDef = ftVar.getDefinition()) != null) {
            this._fgScissor.incDepth();
            ArrayList<FGVariable> fgChildren = new ArrayList<FGVariable>(ftDef.getArgs().size());
            for (FTVariableAbstract ftChild : ftDef.getArgs()) {
                FGVariable fgChild = this.createFGVar_rec(ftChild, false);
                fgChild.setParent(fgVar);
                fgChildren.add(fgChild);
            }
            fgVar.setChildren(fgChildren);
            this._fgScissor.decDepth();
        }
        return fgVar;
    }

    public void browse(FTVariableAbstract ftPivot) {
        this._fgTop = this.createFGVar_rec(ftPivot, true);
    }

    public int getWidth() {
        return this._width;
    }

    public int getHeight() {
        return this._height;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void computeSize(Graphics2D g, FGContext context) {
        if (g == null) {
            return;
        }
        AffineTransform saveAT = g.getTransform();
        try {
            g.scale(context.getZoom(), context.getZoom());
            g.setFont(context.getFont());
            context.getArranger().arrange(this._fgTop, g, context);
        }
        finally {
            g.setTransform(saveAT);
        }
        this._width = this._fgTop.getWAll();
        this._height = this._fgTop.getHAll();
    }

    protected void trace_rec(FGVariable fgVar, String indent) {
        StringBuilder line = new StringBuilder();
        line.append(indent).append(fgVar.getVar().getName());
        line.append(": ").append(fgVar.getW()).append(",").append(fgVar.getH());
        line.append(" ; ").append(fgVar.getDX()).append(",").append(fgVar.getDY());
        line.append(" ; ").append(fgVar.getWAll()).append(",").append(fgVar.getHAll());
        line.append(" ; ").append(fgVar.getXPad());
        System.out.println(line.toString());
        List<FGVariable> children = fgVar.getChildren();
        if (children != null && !children.isEmpty()) {
            String indent1 = indent + "  ";
            for (int i = 0; i < children.size(); ++i) {
                this.trace_rec(children.get(i), indent1);
            }
        }
    }

    public void paint(Graphics2D g, FGContext context) {
        if (this._bTrace) {
            this.trace_rec(this._fgTop, "");
        }
        g.scale(context.getZoom(), context.getZoom());
        g.setColor(context.getForeColor(null));
        g.setStroke(context.getStroke(2, -1, -1, false));
        g.setFont(context.getFont());
        if (context.isDisplay()) {
            String msg = null;
            switch (this._ftEquation.getComputeParameters().getType()) {
                case ARP1: 
                case ARP2: 
                case ARP3: {
                    msg = this._ftEquation.getComputeParameters().getType().getLabel();
                }
            }
            if (msg != null) {
                g.drawString(msg, 5, 10);
            }
        }
        this._fgTop.paint(g, context);
    }

    private FGVariable getGraphAtPoint_rec(FGVariable fg, int x, int y) {
        if (x > fg.getDX() && x - fg.getDX() < fg.getW() && y > 0 && y < fg.getH()) {
            return fg;
        }
        if ((y -= fg.getDY()) > 0) {
            List<FGVariable> children = fg.getChildren();
            if (children == null) {
                return null;
            }
            for (int i = 0; i < children.size(); ++i) {
                FGVariable child = children.get(i);
                if (y >= child.getHAll() || x <= child.getXPad() || x - child.getXPad() >= child.getWAll() || (child = this.getGraphAtPoint_rec(child, x - child.getXPad(), y)) == null) continue;
                return child;
            }
        }
        return null;
    }

    public FGVariable getGraphAtPoint(int x, int y) {
        return this.getGraphAtPoint_rec(this._fgTop, x, y);
    }

    public Iterator<FGVariable> iterator() {
        return new FGIterator(this._fgTop);
    }

    private Point getPointForVariable_rec(FTVariableAbstract var, FGVariable fg, int x, int y) {
        if (var.equals(fg.getVar())) {
            return new Point(x + fg._dx + fg._w / 2, y + fg._h / 2);
        }
        y += fg.getDY();
        List<FGVariable> children = fg.getChildren();
        if (children != null) {
            Point result = null;
            for (int i = 0; i < children.size(); ++i) {
                FGVariable child = children.get(i);
                result = this.getPointForVariable_rec(var, child, x + child.getXPad(), y);
                if (result == null) continue;
                return result;
            }
        }
        return null;
    }

    private Point getPointForFGVariable_rec(FGVariable var, FGVariable fg, int x, int y) {
        if (var.equals(fg)) {
            return new Point(x + fg._dx + fg._w / 2, y + fg._h / 2);
        }
        y += fg.getDY();
        List<FGVariable> children = fg.getChildren();
        if (children != null) {
            Point result = null;
            for (int i = 0; i < children.size(); ++i) {
                FGVariable child = children.get(i);
                result = this.getPointForFGVariable_rec(var, child, x + child.getXPad(), y);
                if (result == null) continue;
                return result;
            }
        }
        return null;
    }

    public Point getPointForFGVariable(FGVariable var) {
        return this.getPointForFGVariable_rec(var, this._fgTop, 0, 0);
    }

    public Point getPointForVariable(FTVariableAbstract var) {
        return this.getPointForVariable_rec(var, this._fgTop, 0, 0);
    }
}

