/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.dbobj.faulttree.ft.grf;

import com.dassault.cecilia.core.cecilia.pref.GeneralTextPreferencies;
import com.dassault.cecilia.core.cecilia.pref.Preferencies;
import com.dassault.cecilia.core.plugin.PluginWithOptions;
import com.dassault.cecilia.dbobj.CLawManager;
import com.dassault.cecilia.dbobj.faulttree.ft.FTEquation;
import com.dassault.cecilia.dbobj.faulttree.ft.grf.FGArranger;
import com.dassault.cecilia.dbobj.faulttree.ft.grf.FGFormatter;
import com.dassault.cecilia.dbobj.faulttree.ft.grf.FGFormatterFactory;
import com.dassault.cecilia.dbobj.faulttree.ft.grf.FGVariable;
import com.dassault.cecilia.dbobj.faulttree.obj.FTEvent;
import com.dassault.cecilia.dbobj.faulttree.obj.FTVariableAbstract;
import com.dassault.cecilia.dbobj.faulttree.pref.FTEquationViewDisplayPreferencies;
import com.dassault.cecilia.dbobj.faulttree.pref.FTEquationViewPrintPreferencies;
import com.dassault.cecilia.dbobj.faulttree.pref.FTVariableColorPreferencies;
import com.dassault.cecilia.dbobj.general.law.Param;
import com.dassault.cecilia.dbobj.general.law.ParamValue;
import com.dassault.cecilia.lib.util.FontType;
import com.dassault.cecilia.lib.util.format.DoubleFormat;
import com.dassault.cecilia.lib.util.format.DoubleFormatJava;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.util.HashMap;
import java.util.Map;

public class FGContext {
    FTEquation _ftEquation;
    CLawManager _lawManager;
    Rectangle _viewRect = new Rectangle(0, 0, 100, 50);
    double _zoom = 1.0;
    boolean _bPrinting = false;
    int _nbrPages = 1;
    public static final String PROP_CONTEXT_DEBUG = "cecilia.ft.gui.GraphicContextDebug";
    boolean _bDebug = Boolean.getBoolean("cecilia.ft.gui.GraphicContextDebug");
    Color _clrBackNormal = FTVariableColorPreferencies.COLOR_BACK_NORMAL;
    Color _clrBackSelected = FTVariableColorPreferencies.COLOR_BACK_SELECTED;
    Color _clrBackLast = FTVariableColorPreferencies.COLOR_BACK_LAST;
    Color _clrForeNormal = FTVariableColorPreferencies.COLOR_FORE_NORMAL;
    Color _clrForeLock = FTVariableColorPreferencies.COLOR_FORE_LOCKED;
    Color _clrForeExtern = FTVariableColorPreferencies.COLOR_FORE_EXTERN;
    Color _clrForeTrue = FTVariableColorPreferencies.COLOR_FORE_TRUE;
    Color _clrForeFalse = FTVariableColorPreferencies.COLOR_FORE_FALSE;
    FGArranger _fgArranger = FGArranger.createArranger(FGArranger.Type.DEFAULT);
    FGFormatterFactory _fgFormatterFactory = FGFormatterFactory.createDefault();
    Map<FormatterOption, Boolean> _mapOptions = new HashMap<FormatterOption, Boolean>();
    DoubleFormat _format = new DoubleFormatJava();
    FontType _fontType = FontType.Monospaced;
    int _fontSize = 11;
    boolean _fontBold = false;
    Map<FontDefine, Font> _mapFonts = new HashMap<FontDefine, Font>();
    Map<StrokeDefine, Stroke> _mapStrokes = new HashMap<StrokeDefine, Stroke>();

    public FGContext(FTEquation ftEquation) {
        this._ftEquation = ftEquation;
    }

    public FTEquation getEquation() {
        return this._ftEquation;
    }

    public void setLawManager(CLawManager lawM) {
        this._lawManager = lawM;
    }

    public Rectangle getRectView() {
        return this._viewRect;
    }

    public void setRectView(Rectangle rect) {
        this._viewRect = rect;
    }

    public double getZoom() {
        return this._zoom;
    }

    public void setZoom(double zoom) {
        this._zoom = zoom;
    }

    public boolean isPrinting() {
        return this._bPrinting;
    }

    public void setPrinting(boolean b) {
        this._bPrinting = b;
    }

    public int getNbrPages() {
        return this._nbrPages;
    }

    public void setNbrPages(int nbr) {
        this._nbrPages = nbr;
    }

    public boolean isDisplay() {
        return !this._bPrinting;
    }

    public boolean isDebug() {
        return this._bDebug;
    }

    public Color getForeColor(FGVariable fgVar) {
        if (fgVar == null) {
            return this._clrForeNormal;
        }
        FTVariableAbstract ftVar = fgVar.getVar();
        FTEvent.State state = FTEvent.State.DEFAULT;
        if (ftVar.getEvent() != null) {
            state = ftVar.getEvent().getState();
        }
        switch (state) {
            case TRUE: {
                return this._clrForeTrue;
            }
            case FALSE: {
                return this._clrForeFalse;
            }
        }
        if (ftVar.isLocked()) {
            return this._clrForeLock;
        }
        if (!ftVar.isIntern()) {
            return this._clrForeExtern;
        }
        return this._clrForeNormal;
    }

    public Color getBackColor(FGVariable fgVar) {
        if (fgVar == null) {
            return this._clrBackNormal;
        }
        FTVariableAbstract ftVar = fgVar.getVar();
        if (ftVar.isSelected() && this.isDisplay()) {
            if (fgVar.isPivot()) {
                return this._clrBackLast;
            }
            return this._clrBackSelected;
        }
        return this._clrBackNormal;
    }

    public FGArranger getArranger() {
        return this._fgArranger;
    }

    public FGFormatter getFormatter(FGVariable fgVar) {
        return this._fgFormatterFactory.getFormater(fgVar);
    }

    public boolean withOption(FormatterOption opt) {
        Boolean value = this._mapOptions.get((Object)opt);
        if (value != null) {
            return value;
        }
        return true;
    }

    public String formatDouble(double number) {
        if (Double.isNaN(number)) {
            return "-";
        }
        return this._format.format(number);
    }

    public double evaluate(Param param) {
        if (this._lawManager != null) {
            return this._lawManager.evaluate(param);
        }
        if (param instanceof ParamValue) {
            return ((ParamValue)param).getValue();
        }
        return Double.NaN;
    }

    public Font getFont(String fontName, int fontType, int fontSize) {
        FontDefine def = new FontDefine(fontName, fontType, fontSize);
        Font font = this._mapFonts.get(def);
        if (font == null) {
            font = new Font(def._name, def._type, def._size);
            this._mapFonts.put(def, font);
        }
        return font;
    }

    public Font getFont() {
        return this.getFont(null, -1, -1);
    }

    public Stroke getStroke(int size, int cap, int join, boolean dash) {
        StrokeDefine def = new StrokeDefine(size, cap, join, dash);
        Stroke stroke = this._mapStrokes.get(def);
        if (stroke == null) {
            if (dash) {
                float[] dashPattern = new float[]{10.0f, 10.0f, 10.0f, 10.0f, 30.0f, 10.0f, 30.0f, 10.0f, 30.0f, 10.0f, 10.0f, 10.0f, 10.0f, 10.0f, 10.0f, 30.0f};
                stroke = new BasicStroke(def._size, def._cap, def._join, 10.0f, dashPattern, 0.0f);
            } else {
                stroke = new BasicStroke(def._size, def._cap, def._join);
            }
            this._mapStrokes.put(def, stroke);
        }
        return stroke;
    }

    public void updateFromPreferencies(Preferencies prefs) {
        PluginWithOptions opts = prefs.getOptions(FTVariableColorPreferencies.PREF_KEY);
        if (opts != null && opts instanceof FTVariableColorPreferencies) {
            FTVariableColorPreferencies colors = (FTVariableColorPreferencies)opts;
            this._clrBackNormal = colors.getPref("EvtNormal").getColor();
            this._clrBackSelected = colors.getPref("EvtSelected").getColor();
            this._clrBackLast = colors.getPref("EvtSelectedLast").getColor();
            this._clrForeNormal = colors.getPref("EvtForeNormal").getColor();
            this._clrForeLock = colors.getPref("EvtLocked").getColor();
            this._clrForeExtern = colors.getPref("EvtForeExtern").getColor();
            this._clrForeTrue = colors.getPref("EvtTrue").getColor();
            this._clrForeFalse = colors.getPref("EvtFalse").getColor();
        }
        if (this._bPrinting) {
            opts = prefs.getOptions(FTEquationViewDisplayPreferencies.PREF_KEY);
            if (opts != null && opts instanceof FTEquationViewDisplayPreferencies) {
                options = (FTEquationViewDisplayPreferencies)opts;
                this._fgArranger = FGArranger.createArranger(((FTEquationViewDisplayPreferencies)options).getArrangerType());
            }
            if ((opts = prefs.getOptions(FTEquationViewPrintPreferencies.PREF_KEY)) != null && opts instanceof FTEquationViewPrintPreferencies) {
                options = (FTEquationViewPrintPreferencies)opts;
                this._mapOptions.put(FormatterOption.LABEL, options.getPref("Fields.Comment").isSelected());
                this._mapOptions.put(FormatterOption.DORMANT, options.getPref("Fields.Periodicity").isSelected());
                this._mapOptions.put(FormatterOption.GSR, false);
                this._mapOptions.put(FormatterOption.PROBA, options.getPref("Fields.Occurence").isSelected());
            }
        } else {
            opts = prefs.getOptions(FTEquationViewDisplayPreferencies.PREF_KEY);
            if (opts != null && opts instanceof FTEquationViewDisplayPreferencies) {
                options = (FTEquationViewDisplayPreferencies)opts;
                this._mapOptions.put(FormatterOption.LABEL, options.getPref("Fields.Comment").isSelected());
                this._mapOptions.put(FormatterOption.DORMANT, options.getPref("Fields.Periodicity").isSelected());
                this._mapOptions.put(FormatterOption.GSR, options.getPref("Fields.GSR").isSelected());
                this._mapOptions.put(FormatterOption.PROBA, options.getPref("Fields.Occurence").isSelected());
                this._fgArranger = FGArranger.createArranger(((FTEquationViewDisplayPreferencies)options).getArrangerType());
            }
        }
        opts = prefs.getOptions(GeneralTextPreferencies.PREF_KEY);
        if (opts != null && opts instanceof GeneralTextPreferencies) {
            GeneralTextPreferencies gpref = (GeneralTextPreferencies)opts;
            this._format = gpref.getDoubleFormat();
            this._fontType = gpref.getFontType();
            this._fontSize = gpref.getFontSize();
            this._fontBold = gpref.getFontBold();
        }
    }

    private class FontDefine {
        String _name;
        int _type;
        int _size;

        FontDefine(String name, int type, int size) {
            if (name == null || name.isEmpty()) {
                name = FGContext.this._fontType.toString();
            }
            if (type < 0) {
                int n = type = FGContext.this._fontBold ? 1 : 0;
            }
            if (size < 0) {
                size = FGContext.this._fontSize;
            }
            this._name = name;
            this._type = type;
            this._size = size;
        }

        public int hashCode() {
            return (this._name.hashCode() * 7 + this._type) * 5 + this._size;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof FontDefine)) {
                return false;
            }
            FontDefine other = (FontDefine)obj;
            if (!other._name.equals(this._name)) {
                return false;
            }
            if (other._type != this._type) {
                return false;
            }
            return other._size == this._size;
        }
    }

    private static class StrokeDefine {
        int _size;
        int _cap;
        int _join;
        boolean _dash;

        StrokeDefine(int size, int cap, int join, boolean dash) {
            if (size < 0) {
                size = 1;
            }
            if (cap < 0) {
                cap = 0;
            }
            if (join < 0) {
                join = 2;
            }
            this._size = size;
            this._cap = cap;
            this._join = join;
            this._dash = dash;
        }

        public int hashCode() {
            return ((this._size * 7 + this._cap) * 5 + this._join) * 3 + (this._dash ? 1 : 0);
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof StrokeDefine)) {
                return false;
            }
            StrokeDefine other = (StrokeDefine)obj;
            if (other._size != this._size) {
                return false;
            }
            if (other._cap != this._cap) {
                return false;
            }
            if (other._join != this._join) {
                return false;
            }
            return other._dash == this._dash;
        }
    }

    public static enum FormatterOption {
        LABEL,
        GSR,
        PROBA,
        LAW,
        DORMANT;

    }
}

