/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.dbobj.faulttree.ft.grf;

import com.dassault.cecilia.dbobj.faulttree.ft.grf.FGContext;
import com.dassault.cecilia.dbobj.faulttree.obj.FTVariableAbstract;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class FGVariable {
    boolean _bIsPivot = false;
    FTVariableAbstract _ftSource;
    FGVariable _fgParent;
    List<FGVariable> _fgChildren;
    String _strMark = null;
    int _linkPgIdx = -1;
    Map<FTVariableAbstract, Integer> _summary = null;
    int _dx;
    int _dy;
    int _w;
    int _h;
    int _xpad;
    int _wAll;
    int _hAll;

    public FGVariable(FTVariableAbstract src) {
        this._ftSource = src;
    }

    public boolean isPivot() {
        return this._bIsPivot;
    }

    public FGVariable setPivot(boolean src) {
        this._bIsPivot = src;
        return this;
    }

    public FTVariableAbstract getVar() {
        return this._ftSource;
    }

    public FGVariable setVar(FTVariableAbstract src) {
        this._ftSource = src;
        return this;
    }

    public FGVariable getParent() {
        return this._fgParent;
    }

    public FGVariable setParent(FGVariable parent) {
        this._fgParent = parent;
        return this;
    }

    public List<FGVariable> getChildren() {
        return this._fgChildren;
    }

    public FGVariable setChildren(List<FGVariable> children) {
        this._fgChildren = children;
        return this;
    }

    public String getMark() {
        return this._strMark;
    }

    public FGVariable setMark(String value) {
        this._strMark = value;
        return this;
    }

    public int getLinkPageIdx() {
        return this._linkPgIdx;
    }

    public FGVariable setLinkPageIdx(int value) {
        this._linkPgIdx = value;
        return this;
    }

    public Map<FTVariableAbstract, Integer> getSummary() {
        return this._summary;
    }

    public void clearSummary() {
        this._summary = null;
    }

    public void addSummary(FTVariableAbstract ftVar, int idxPage) {
        if (this._summary == null) {
            this._summary = new LinkedHashMap<FTVariableAbstract, Integer>();
        }
        this._summary.put(ftVar, idxPage);
    }

    public int getDX() {
        return this._dx;
    }

    public FGVariable setDX(int dx) {
        this._dx = dx;
        return this;
    }

    public int getDY() {
        return this._dy;
    }

    public FGVariable setDY(int dy) {
        this._dy = dy;
        return this;
    }

    public int getW() {
        return this._w;
    }

    public FGVariable setW(int w) {
        this._w = w;
        return this;
    }

    public int getH() {
        return this._h;
    }

    public FGVariable setH(int h) {
        this._h = h;
        return this;
    }

    public int getXPad() {
        return this._xpad;
    }

    public FGVariable setXPad(int xpad) {
        this._xpad = xpad;
        return this;
    }

    public int getWAll() {
        return this._wAll;
    }

    public FGVariable setWAll(int wAll) {
        this._wAll = wAll;
        return this;
    }

    public int getHAll() {
        return this._hAll;
    }

    public FGVariable setHAll(int hAll) {
        this._hAll = hAll;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paint(Graphics2D g, FGContext context) {
        AffineTransform oldTransform = g.getTransform();
        if (g.getClip() == null || g.getClip().intersects(this._dx, 0.0, this._w, this._h)) {
            g.translate(this._dx, 0);
            context.getFormatter(this).paint(this, g, context);
            g.setTransform(oldTransform);
        }
        if (g.getClip() == null || g.getClip().intersects(0.0, 0.0, this._wAll, this._hAll)) {
            if (context.isDebug()) {
                Stroke oldStroke = g.getStroke();
                Color oldcolor = g.getColor();
                g.setStroke(context.getStroke(1, -1, -1, true));
                g.setColor(Color.lightGray);
                g.drawRect(0, 0, this._wAll, this._hAll);
                g.drawRect(this._dx, 0, this._w, this._h);
                g.setColor(oldcolor);
                g.setStroke(oldStroke);
            }
            if (this._fgChildren != null && !this._fgChildren.isEmpty()) {
                Color oldcolor = g.getColor();
                try {
                    int xDst = this._dx + this._w / 2;
                    int yDst = this._h;
                    int ySrc = this._dy;
                    g.setColor(context.getForeColor(this));
                    for (int i = 0; i < this._fgChildren.size(); ++i) {
                        FGVariable child = this._fgChildren.get(i);
                        int xSrc = child.getXPad() + child.getDX() + child.getW() / 2;
                        g.drawLine(xSrc, ySrc, xSrc, yDst);
                        g.drawLine(xSrc, yDst, xDst, yDst);
                    }
                }
                finally {
                    g.setColor(oldcolor);
                }
                g.translate(0, this._dy);
                for (int i = 0; i < this._fgChildren.size(); ++i) {
                    FGVariable child = this._fgChildren.get(i);
                    g.translate(child.getXPad(), 0);
                    child.paint(g, context);
                    g.translate(-child.getXPad(), 0);
                }
            }
        }
        g.setTransform(oldTransform);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getVar().getName());
        sb.append(" [dx=").append(this._dx);
        sb.append(", dy=").append(this._dy);
        sb.append(", w=").append(this._w);
        sb.append(", h=").append(this._h);
        sb.append(", wA=").append(this._wAll);
        sb.append(", hA=").append(this._hAll);
        sb.append(", xp=").append(this._xpad);
        sb.append("]");
        return sb.toString();
    }
}

