/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.dbobj.faulttree.ft.grf.arranger;

import com.dassault.cecilia.dbobj.faulttree.ft.grf.FGArranger;
import com.dassault.cecilia.dbobj.faulttree.ft.grf.FGContext;
import com.dassault.cecilia.dbobj.faulttree.ft.grf.FGVariable;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.util.List;

public class FGArrangerBasic
extends FGArranger {
    protected static final int _wpadDefault = 30;
    protected static final int _hpadDefault = 30;

    @Override
    public void arrange(FGVariable fgTop, Graphics2D g, FGContext context) {
        this.arrange_rec(fgTop, g, context);
    }

    private void arrange_rec(FGVariable fgVar, Graphics2D g, FGContext context) {
        Dimension size = context.getFormatter(fgVar).computeSizeDisplay(fgVar, g, context);
        fgVar.setW(size.width).setH(size.height);
        int wpad = 30;
        int hpad = 30;
        int wAll = 0;
        int hAll = 0;
        List<FGVariable> children = fgVar.getChildren();
        if (children != null && !children.isEmpty()) {
            for (int i = 0; i < children.size(); ++i) {
                FGVariable child = children.get(i);
                this.arrange_rec(child, g, context);
                child.setXPad(wAll);
                wAll += child.getWAll();
                wAll += wpad;
                if (hAll >= child.getHAll()) continue;
                hAll = child.getHAll();
            }
            wAll -= wpad;
        }
        if (wAll <= size.width) {
            fgVar.setDX(0);
            if (wAll > 0 && children != null && !children.isEmpty()) {
                int dXPad = (size.width - wAll) / 2;
                for (int i = 0; i < children.size(); ++i) {
                    FGVariable child = children.get(i);
                    child.setXPad(child.getXPad() + dXPad);
                }
            }
            wAll = size.width;
        } else {
            fgVar.setDX((wAll - size.width) / 2);
        }
        fgVar.setDY(size.height + hpad);
        hAll = hAll == 0 ? size.height : size.height + hpad + hAll;
        fgVar.setWAll(wAll).setHAll(hAll);
    }
}

