/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.dbobj.faulttree.ft.grf.formater;

import com.dassault.cecilia.dbobj.faulttree.ft.grf.FGContext;
import com.dassault.cecilia.dbobj.faulttree.ft.grf.FGVariable;
import com.dassault.cecilia.dbobj.faulttree.ft.grf.formater.FGFormatterClassicAbstract;
import com.dassault.cecilia.dbobj.faulttree.obj.FTEvent;
import com.dassault.cecilia.dbobj.general.law.Param;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;

public class FGFormatterClassicEvent
extends FGFormatterClassicAbstract {
    private static final int MARGE_DORMANT = 4;
    private static GeneralPath BASIC_SHAPE = new GeneralPath();
    private static GeneralPath BASIC_SHAPE_DORMANT;
    private static GeneralPath UNDEVELOPED_SHAPE;
    private static GeneralPath UNDEVELOPED_SHAPE_DORMANT;
    private static GeneralPath HOUSE_SHAPE;
    private static GeneralPath HOUSE_SHAPE_DORMANT;
    private static Shape CONDITION_SHAPE;
    private static Shape CONDITION_SHAPE_DORMANT;

    private boolean isInted(FGVariable var) {
        FTEvent ftEvent = var.getVar().getEvent();
        if (ftEvent == null) {
            return false;
        }
        if (ftEvent.isInspected()) {
            return true;
        }
        return ftEvent.isInflightTested();
    }

    private boolean isInspected(FGVariable var) {
        FTEvent ftEvent = var.getVar().getEvent();
        if (ftEvent == null) {
            return false;
        }
        return ftEvent.isInspected();
    }

    private boolean isInflightTested(FGVariable var) {
        FTEvent ftEvent = var.getVar().getEvent();
        if (ftEvent == null) {
            return false;
        }
        return ftEvent.isInflightTested();
    }

    private Param getParamInted(FGVariable var) {
        FTEvent ftEvent = var.getVar().getEvent();
        if (ftEvent == null) {
            return null;
        }
        if (ftEvent.isInspected()) {
            return ftEvent.getInspected();
        }
        if (ftEvent.isInflightTested()) {
            return ftEvent.getInflightTested();
        }
        return null;
    }

    private Shape getShape(FGVariable var) {
        FTEvent ftEvent = var.getVar().getEvent();
        if (ftEvent == null) {
            return BASIC_SHAPE;
        }
        switch (ftEvent.getStyle()) {
            case CONDITIONNING: {
                return CONDITION_SHAPE;
            }
            case UNDEVELOPED: {
                return UNDEVELOPED_SHAPE;
            }
            case EXTERNAL: {
                return HOUSE_SHAPE;
            }
        }
        return BASIC_SHAPE;
    }

    private Shape getShapeDormant(FGVariable var) {
        FTEvent ftEvent = var.getVar().getEvent();
        if (ftEvent == null) {
            return BASIC_SHAPE_DORMANT;
        }
        switch (ftEvent.getStyle()) {
            case CONDITIONNING: {
                return CONDITION_SHAPE_DORMANT;
            }
            case UNDEVELOPED: {
                return UNDEVELOPED_SHAPE_DORMANT;
            }
            case EXTERNAL: {
                return HOUSE_SHAPE_DORMANT;
            }
        }
        return BASIC_SHAPE_DORMANT;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paint(FGVariable var, Graphics2D g, FGContext context) {
        AffineTransform oldTransform = g.getTransform();
        Color oldColor = g.getColor();
        Stroke oldStroke = g.getStroke();
        try {
            Font f = g.getFont();
            FontMetrics fmetrics = g.getFontMetrics(f);
            int htext = fmetrics.getHeight();
            g.translate(var.getW() / 2, 0);
            if (var.getParent() == null && var.getVar().getLink() != null) {
                g.setColor(context.getForeColor(var));
                g.translate(0, SYM_BOT);
                g.draw(SHAPE_UP);
            }
            g.translate(0, __HEIGHT / 2);
            g.setColor(context.getBackColor(var));
            Shape symbol = this.getShape(var);
            g.fill(symbol);
            g.setColor(context.getForeColor(var));
            if (this.isInflightTested(var)) {
                g.setStroke(context.getStroke(4, -1, -1, false));
            }
            g.draw(symbol);
            if (this.isInspected(var)) {
                g.draw(this.getShapeDormant(var));
            }
            String name = var.getVar().getName();
            int wtext = fmetrics.stringWidth(name);
            g.drawString(name, -wtext / 2, htext / 2);
            if (this.isInted(var) && context.withOption(FGContext.FormatterOption.DORMANT)) {
                double dormant = Double.NaN;
                Param param = this.getParamInted(var);
                if (param != null) {
                    dormant = context.evaluate(param);
                }
                String append = context.formatDouble(dormant);
                g.drawString(append, -__WIDTH / 2, __HEIGHT / 2 + htext);
            }
            if (context.withOption(FGContext.FormatterOption.PROBA)) {
                double proba = var.getVar().getProbability();
                String append = context.formatDouble(proba);
                int wtext2 = fmetrics.stringWidth(append);
                g.drawString(append, __WIDTH / 2 - wtext2, __HEIGHT / 2 + htext);
            }
            if (context.withOption(FGContext.FormatterOption.LABEL)) {
                this.paintLabel(var, g, context, __HEIGHT / 2 + htext * 2);
            }
        }
        finally {
            g.setColor(oldColor);
            g.setStroke(oldStroke);
            g.setTransform(oldTransform);
        }
    }

    @Override
    public Dimension computeSizeDisplay(FGVariable var, Graphics2D g, FGContext context) {
        int width = this.computeWidthForName(var, g);
        if (width < __WIDTH) {
            width = __WIDTH;
        }
        int height = g.getFontMetrics().getHeight() * 7 / 2 + __HEIGHT;
        if (var.getParent() == null && var.getVar().getLink() != null) {
            height += SYM_BOT;
        }
        return new Dimension(width, height);
    }

    static {
        BASIC_SHAPE.moveTo(0.0f, -__HEIGHT / 2);
        BASIC_SHAPE.lineTo(__WIDTH / 2, 0.0f);
        BASIC_SHAPE.lineTo(0.0f, __HEIGHT / 2);
        BASIC_SHAPE.lineTo(-__WIDTH / 2, 0.0f);
        BASIC_SHAPE.closePath();
        BASIC_SHAPE_DORMANT = new GeneralPath();
        BASIC_SHAPE_DORMANT.moveTo(0.0f, -__HEIGHT / 2 + 4);
        BASIC_SHAPE_DORMANT.lineTo(__WIDTH / 2 - 8, 0.0f);
        BASIC_SHAPE_DORMANT.lineTo(0.0f, __HEIGHT / 2 - 4);
        BASIC_SHAPE_DORMANT.lineTo(-__WIDTH / 2 + 8, 0.0f);
        BASIC_SHAPE_DORMANT.closePath();
        UNDEVELOPED_SHAPE = new GeneralPath();
        UNDEVELOPED_SHAPE.moveTo(0.0f, -__HEIGHT / 2);
        UNDEVELOPED_SHAPE.lineTo(__WIDTH / 2, 0.0f);
        UNDEVELOPED_SHAPE.lineTo(0.0f, __HEIGHT / 2);
        UNDEVELOPED_SHAPE.lineTo(-__WIDTH / 2, 0.0f);
        UNDEVELOPED_SHAPE.closePath();
        UNDEVELOPED_SHAPE.moveTo(0.0f, -__HEIGHT / 2);
        UNDEVELOPED_SHAPE.lineTo(__WIDTH / 2 - 16, 0.0f);
        UNDEVELOPED_SHAPE.lineTo(0.0f, __HEIGHT / 2);
        UNDEVELOPED_SHAPE.moveTo(0.0f, -__HEIGHT / 2);
        UNDEVELOPED_SHAPE.lineTo(-__WIDTH / 2 + 16, 0.0f);
        UNDEVELOPED_SHAPE.lineTo(0.0f, __HEIGHT / 2);
        UNDEVELOPED_SHAPE_DORMANT = new GeneralPath();
        UNDEVELOPED_SHAPE_DORMANT.moveTo(0.0f, -__HEIGHT / 2 + 4);
        UNDEVELOPED_SHAPE_DORMANT.lineTo(__WIDTH / 2 - 24, 0.0f);
        UNDEVELOPED_SHAPE_DORMANT.lineTo(0.0f, __HEIGHT / 2 - 4);
        UNDEVELOPED_SHAPE_DORMANT.lineTo(-__WIDTH / 2 + 24, 0.0f);
        UNDEVELOPED_SHAPE_DORMANT.closePath();
        HOUSE_SHAPE = new GeneralPath();
        HOUSE_SHAPE.moveTo(0.0f, -__HEIGHT / 2);
        HOUSE_SHAPE.lineTo(__WIDTH / 2, 0.0f);
        HOUSE_SHAPE.lineTo(__WIDTH / 2, __HEIGHT / 2);
        HOUSE_SHAPE.lineTo(-__WIDTH / 2, __HEIGHT / 2);
        HOUSE_SHAPE.lineTo(-__WIDTH / 2, 0.0f);
        HOUSE_SHAPE.closePath();
        HOUSE_SHAPE_DORMANT = new GeneralPath();
        HOUSE_SHAPE_DORMANT.moveTo(0.0f, -__HEIGHT / 2 + 8);
        HOUSE_SHAPE_DORMANT.lineTo(__WIDTH / 2 - 4, 4.0f);
        HOUSE_SHAPE_DORMANT.lineTo(__WIDTH / 2 - 4, __HEIGHT / 2 - 4);
        HOUSE_SHAPE_DORMANT.lineTo(-__WIDTH / 2 + 4, __HEIGHT / 2 - 4);
        HOUSE_SHAPE_DORMANT.lineTo(-__WIDTH / 2 + 4, 4.0f);
        HOUSE_SHAPE_DORMANT.closePath();
        CONDITION_SHAPE = new Ellipse2D.Double(-__WIDTH / 2, -__HEIGHT / 2, __WIDTH, __HEIGHT);
        CONDITION_SHAPE_DORMANT = new Ellipse2D.Double(-__WIDTH / 2 + 6, -__HEIGHT / 2 + 6, __WIDTH - 12, __HEIGHT - 12);
    }
}

