/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.dbobj.faulttree.ft.grf.formater;

import com.dassault.cecilia.dbobj.faulttree.ResMsgArbor;
import com.dassault.cecilia.dbobj.faulttree.ft.FTComputeParameters;
import com.dassault.cecilia.dbobj.faulttree.ft.grf.FGContext;
import com.dassault.cecilia.dbobj.faulttree.ft.grf.FGVariable;
import com.dassault.cecilia.dbobj.faulttree.ft.grf.formater.FGFormatterClassicAbstract;
import com.dassault.cecilia.dbobj.faulttree.obj.FTDefinition;
import com.dassault.cecilia.dbobj.faulttree.obj.FTVariableAbstract;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.util.Iterator;
import java.util.Map;

public class FGFormatterClassicGate
extends FGFormatterClassicAbstract {
    private static int MARGE_TOP_NAME = 4;
    private static int MARGE_TOP_LABEL = 4;
    private static int NEG_SIZE = 12;
    private static int SYM_TOP = 18;
    private static int SYM_HEIGHT = SYM_TOP + SYM_SIZE + SYM_BOT;
    private static int OR_ADD = 4;
    private static GeneralPath SHAPE_AND;
    private static GeneralPath SHAPE_OR;
    private static GeneralPath SHAPE_XOR;
    private static GeneralPath SHAPE_ITE;
    private static GeneralPath SHAPE_KOFN;
    private static GeneralPath SHAPE_NOT;
    private static Ellipse2D SHAPE_NEG;
    private static GeneralPath SHAPE_DOWN;
    protected static GeneralPath SHAPE_UP_PRINT;

    private void paintSummary(Graphics2D g, FGContext context, Map<FTVariableAbstract, Integer> summary) {
        if (summary == null || summary.isEmpty()) {
            return;
        }
        int nbrCharMax = 75;
        int nbrPages = context.getNbrPages();
        StringBuilder buffer = new StringBuilder(summary.size() * 20);
        StringBuilder currentLine = new StringBuilder(nbrCharMax);
        int nbrLine = 0;
        Iterator<Map.Entry<FTVariableAbstract, Integer>> iter = summary.entrySet().iterator();
        while (iter.hasNext() && nbrLine < 3) {
            Map.Entry<FTVariableAbstract, Integer> entry = iter.next();
            StringBuilder currentToken = new StringBuilder(nbrCharMax);
            currentToken.append(entry.getKey().getName());
            currentToken.append("(");
            currentToken.append(ResMsgArbor.msgFormat("IO_PRINT_PAGE_TRANSFERT", entry.getValue() + 1, nbrPages));
            currentToken.append(")");
            if (iter.hasNext()) {
                currentToken.append(", ");
            }
            if (currentLine.length() == 0) {
                currentLine.append(currentToken.toString());
                continue;
            }
            if (currentLine.length() + currentToken.length() < nbrCharMax) {
                currentLine.append(currentToken.toString());
                continue;
            }
            buffer.append(currentLine.toString()).append("\n");
            ++nbrLine;
            currentLine = new StringBuilder(nbrCharMax);
            currentLine.append(currentToken.toString());
        }
        if (nbrLine < 3 && currentLine.length() > 0) {
            buffer.append(currentLine.toString());
            ++nbrLine;
        } else {
            buffer.append("...");
        }
        int deltaY = 0;
        if (nbrLine > 1) {
            Font f = g.getFont();
            FontMetrics fmetrics = g.getFontMetrics(f);
            int htext = fmetrics.getHeight();
            deltaY = (nbrLine - 1) * htext;
        }
        g.drawString("<= ", SYM_BOT / 2, -SYM_BOT / 2);
        g.translate(SYM_BOT, -deltaY);
        this.paintMultilineText(buffer.toString(), g, -SYM_BOT / 2, 2000, true);
        g.translate(-SYM_BOT, deltaY);
    }

    @Override
    public void paint(FGVariable fgVar, Graphics2D g, FGContext context) {
        FTDefinition ftDef;
        AffineTransform oldTransform = g.getTransform();
        Color oldColor = g.getColor();
        Stroke oldStroke = g.getStroke();
        Font f = g.getFont();
        FontMetrics fmetrics = g.getFontMetrics(f);
        int htext = fmetrics.getHeight();
        FTVariableAbstract ftVar = fgVar.getVar();
        g.translate(fgVar.getW() / 2, 0);
        if (fgVar.getParent() == null && !ftVar.isRoot()) {
            g.setColor(context.getForeColor(fgVar));
            g.translate(0, SYM_BOT);
            if (context.isPrinting()) {
                g.draw(SHAPE_UP_PRINT);
                this.paintSummary(g, context, fgVar.getSummary());
            } else {
                g.draw(SHAPE_UP);
            }
        }
        g.translate(0, __HEIGHT / 2);
        g.setColor(context.getBackColor(fgVar));
        g.fillRect(-__WIDTH / 2, -__HEIGHT / 2, __WIDTH, __HEIGHT);
        g.setColor(context.getForeColor(fgVar));
        g.drawRect(-__WIDTH / 2, -__HEIGHT / 2, __WIDTH, __HEIGHT);
        int y = -__HEIGHT / 2 + htext + MARGE_TOP_NAME;
        String name = ftVar.getName();
        int wtext = fmetrics.stringWidth(name);
        g.drawString(name, -wtext / 2, y);
        if (context.withOption(FGContext.FormatterOption.LABEL)) {
            this.paintLabel(fgVar, g, context, y += htext + MARGE_TOP_LABEL);
        }
        if (context.withOption(FGContext.FormatterOption.GSR) && (ftDef = ftVar.getDefinition()) != null && ftDef.isGSR()) {
            String append = "GSR";
            wtext = fmetrics.stringWidth(append);
            g.drawString(append, __WIDTH / 2 - wtext, -__HEIGHT / 2 - htext / 3);
        }
        if (context.withOption(FGContext.FormatterOption.PROBA)) {
            FTComputeParameters ftParams;
            double proba = ftVar.getProbability();
            String append = context.formatDouble(proba);
            int wtext2 = fmetrics.stringWidth(append);
            g.drawString(append, fgVar.getW() / 2 - wtext2, __HEIGHT / 2 + htext);
            if (ftVar.isRoot() && (ftParams = context.getEquation().getComputeParameters()).isOneHourOption()) {
                double time = ftParams.getFlightDuration();
                if (Double.isNaN(time)) {
                    time = ftParams.getTime();
                }
                if (!Double.isNaN(time)) {
                    append = ResMsgArbor.msgFormat("PFH_COMPUTE", context.formatDouble(proba / time * 3600.0));
                    wtext2 = fmetrics.stringWidth(append);
                    g.drawString(append, fgVar.getW() / 2 - wtext2, __HEIGHT / 2 + htext * 2);
                }
            }
        }
        if (fgVar.getParent() != null && (ftVar.isLeaf() || ftVar.getLink() != null)) {
            int idxPage;
            g.draw(SHAPE_TRANSFERT);
            String type = "??";
            if (ftVar.getLink() != null) {
                type = fgVar.getMark() != null ? fgVar.getMark() : (ftVar.getLink().isDSF() ? "DSF" : "ST");
            }
            if (context.isPrinting() && (idxPage = fgVar.getLinkPageIdx()) >= 0) {
                StringBuilder sb = new StringBuilder(128);
                sb.append(type).append(" => ");
                sb.append(ResMsgArbor.msgFormat("IO_PRINT_PAGE_TRANSFERT", idxPage + 1, context.getNbrPages()));
                type = sb.toString();
            }
            g.drawString(type, -__WIDTH / 2 + __TRANSFER_UNIT * 5 / 2, __HEIGHT / 2 + __TRANSFER_UNIT * 3);
        } else {
            FTDefinition ftDef2 = ftVar.getDefinition();
            if (ftDef2 != null) {
                boolean breakGate;
                boolean bl = breakGate = fgVar.getChildren() == null;
                if (breakGate && context.isPrinting()) {
                    g.draw(SHAPE_TRANSFERT);
                    int idxPage = fgVar.getLinkPageIdx();
                    if (idxPage >= 0) {
                        StringBuilder sb = new StringBuilder(128);
                        sb.append("=> ");
                        sb.append(ResMsgArbor.msgFormat("IO_PRINT_PAGE_TRANSFERT", idxPage + 1, context.getNbrPages()));
                        g.drawString(sb.toString(), -__WIDTH / 2 + __TRANSFER_UNIT * 5 / 2, __HEIGHT / 2 + __TRANSFER_UNIT * 3);
                    }
                } else {
                    if (breakGate) {
                        g.setColor(Color.lightGray);
                        g.setStroke(context.getStroke(1, -1, -1, false));
                    }
                    this.paintSymbol(ftDef2, breakGate, g, context);
                    if (breakGate) {
                        g.setStroke(oldStroke);
                        g.setColor(context.getForeColor(fgVar));
                        g.draw(SHAPE_DOWN);
                    }
                }
            }
        }
        g.setStroke(oldStroke);
        g.setColor(oldColor);
        g.setTransform(oldTransform);
    }

    private void paintSymbol(FTDefinition ftDef, boolean breakGate, Graphics2D g, FGContext context) {
        int h = __HEIGHT / 2;
        switch (ftDef.getType()) {
            case AND: {
                g.drawLine(0, h + 1, 0, h + SYM_TOP);
                g.draw(SHAPE_AND);
                if (breakGate) break;
                g.drawLine(0, h += SYM_TOP + SYM_SIZE, 0, h + SYM_BOT);
                break;
            }
            case NAND: {
                g.drawLine(0, h + 1, 0, h + SYM_TOP - NEG_SIZE);
                g.draw(SHAPE_NEG);
                g.draw(SHAPE_AND);
                if (breakGate) break;
                g.drawLine(0, h += SYM_TOP + SYM_SIZE, 0, h + SYM_BOT);
                break;
            }
            case OR: {
                g.drawLine(0, h + 1, 0, h + SYM_TOP);
                g.draw(SHAPE_OR);
                if (breakGate) break;
                g.drawLine(0, (h += SYM_TOP + SYM_SIZE) - SYM_TOP / 3 - OR_ADD, 0, h + SYM_BOT);
                break;
            }
            case NOR: {
                g.drawLine(0, h + 1, 0, h + SYM_TOP - NEG_SIZE);
                g.draw(SHAPE_NEG);
                g.draw(SHAPE_OR);
                if (breakGate) break;
                g.drawLine(0, (h += SYM_TOP + SYM_SIZE) - SYM_TOP / 3 - OR_ADD, 0, h + SYM_BOT);
                break;
            }
            case XOR: {
                g.drawLine(0, h + 1, 0, h + SYM_TOP);
                g.draw(SHAPE_XOR);
                if (breakGate) break;
                g.drawLine(0, (h += SYM_TOP + SYM_SIZE) - SYM_TOP / 3, 0, h + SYM_BOT);
                break;
            }
            case NXOR: {
                g.drawLine(0, h + 1, 0, h + SYM_TOP - NEG_SIZE);
                g.draw(SHAPE_NEG);
                g.draw(SHAPE_XOR);
                if (breakGate) break;
                g.drawLine(0, (h += SYM_TOP + SYM_SIZE) - SYM_TOP / 3, 0, h + SYM_BOT);
                break;
            }
            case NOT: {
                g.drawLine(0, h + 1, 0, h + SYM_TOP - NEG_SIZE);
                g.draw(SHAPE_NEG);
                g.draw(SHAPE_NOT);
                if (breakGate) break;
                g.drawLine(0, h += SYM_TOP + SYM_SIZE, 0, h + SYM_BOT);
                break;
            }
            case ITE: {
                g.drawLine(0, h + 1, 0, h + SYM_TOP);
                g.draw(SHAPE_ITE);
                if (breakGate) break;
                g.drawLine(0, h += SYM_TOP + SYM_SIZE, 0, h + SYM_BOT);
                break;
            }
            case KOFN: {
                g.drawLine(0, h + 1, 0, h + SYM_TOP);
                g.draw(SHAPE_AND);
                if (!breakGate) {
                    g.drawLine(0, h += SYM_TOP + SYM_SIZE, 0, h + SYM_BOT);
                    g.setStroke(context.getStroke(1, -1, -1, false));
                }
                g.draw(SHAPE_KOFN);
                g.drawString(Integer.toString(ftDef.getAtLeast()), 2, __HEIGHT / 2 + SYM_TOP + SYM_SIZE * 3 / 4 + 2);
            }
        }
    }

    @Override
    public Dimension computeSizeDisplay(FGVariable var, Graphics2D g, FGContext context) {
        int width = this.computeWidthForName(var, g);
        if (width < __WIDTH) {
            width = __WIDTH;
        }
        if (context.withOption(FGContext.FormatterOption.PROBA)) {
            FTComputeParameters ftParams;
            double proba;
            String append;
            FontMetrics fmetrics = g.getFontMetrics();
            int wtext = fmetrics.stringWidth(append = context.formatDouble(proba = var.getVar().getProbability()));
            if (width < SYM_SIZE + 2 * wtext + 9) {
                width = SYM_SIZE + 2 * wtext + 9;
            }
            if (var.getVar().isRoot() && (ftParams = context.getEquation().getComputeParameters()).isOneHourOption() && !Double.isNaN(ftParams.getTime()) && width < SYM_SIZE + 2 * (wtext = fmetrics.stringWidth(append = ResMsgArbor.msgFormat("PFH_COMPUTE", context.formatDouble(proba / ftParams.getTime() * 3600.0)))) + 9) {
                width = SYM_SIZE + 2 * wtext + 9;
            }
        }
        int height = __HEIGHT + SYM_HEIGHT;
        if (var.getParent() == null && !var.getVar().isRoot()) {
            height += SYM_BOT;
        }
        return new Dimension(width, height);
    }

    static {
        int xOut = 0;
        int yOut = __HEIGHT / 2 + SYM_TOP;
        SHAPE_AND = new GeneralPath();
        SHAPE_AND.moveTo(xOut - SYM_SIZE / 2, yOut + SYM_SIZE);
        SHAPE_AND.lineTo(xOut + SYM_SIZE / 2, yOut + SYM_SIZE);
        SHAPE_AND.lineTo(xOut + SYM_SIZE / 2, yOut + SYM_SIZE / 3);
        SHAPE_AND.curveTo(xOut + SYM_SIZE / 2, yOut - SYM_SIZE / 9, xOut - SYM_SIZE / 2, yOut - SYM_SIZE / 9, xOut - SYM_SIZE / 2, yOut + SYM_SIZE / 3);
        SHAPE_AND.closePath();
        SHAPE_OR = new GeneralPath();
        SHAPE_OR.moveTo(xOut - SYM_SIZE / 2, yOut + SYM_SIZE + OR_ADD);
        SHAPE_OR.curveTo(xOut - SYM_SIZE / 2, yOut + (4 * SYM_SIZE / 9 + OR_ADD), xOut + SYM_SIZE / 2, yOut + (4 * SYM_SIZE / 9 + OR_ADD), xOut + SYM_SIZE / 2, yOut + SYM_SIZE + OR_ADD);
        SHAPE_OR.lineTo(xOut + SYM_SIZE / 2, yOut + SYM_SIZE);
        SHAPE_OR.lineTo(xOut + SYM_SIZE / 2, yOut + SYM_SIZE / 3);
        SHAPE_OR.curveTo(xOut + SYM_SIZE / 2, yOut - SYM_SIZE / 9, xOut - SYM_SIZE / 2, yOut - SYM_SIZE / 9, xOut - SYM_SIZE / 2, yOut + SYM_SIZE / 3);
        SHAPE_OR.closePath();
        SHAPE_XOR = new GeneralPath();
        SHAPE_XOR.moveTo(xOut - SYM_SIZE / 2, yOut + SYM_SIZE + OR_ADD);
        SHAPE_XOR.curveTo(xOut - SYM_SIZE / 2, yOut + (4 * SYM_SIZE / 9 + OR_ADD), xOut + SYM_SIZE / 2, yOut + (4 * SYM_SIZE / 9 + OR_ADD), xOut + SYM_SIZE / 2, yOut + SYM_SIZE + OR_ADD);
        SHAPE_XOR.lineTo(xOut + SYM_SIZE / 2, yOut + SYM_SIZE);
        SHAPE_XOR.lineTo(xOut + SYM_SIZE / 2, yOut + SYM_SIZE / 3);
        SHAPE_XOR.curveTo(xOut + SYM_SIZE / 2, yOut - SYM_SIZE / 9, xOut - SYM_SIZE / 2, yOut - SYM_SIZE / 9, xOut - SYM_SIZE / 2, yOut + SYM_SIZE / 3);
        SHAPE_XOR.closePath();
        SHAPE_XOR.lineTo(xOut - SYM_SIZE / 2, yOut + SYM_SIZE + OR_ADD * 2);
        SHAPE_XOR.curveTo(xOut - SYM_SIZE / 2, yOut + (4 * SYM_SIZE / 9 + OR_ADD * 2), xOut + SYM_SIZE / 2, yOut + (4 * SYM_SIZE / 9 + OR_ADD * 2), xOut + SYM_SIZE / 2, yOut + SYM_SIZE + OR_ADD * 2);
        SHAPE_XOR.lineTo(xOut + SYM_SIZE / 2, yOut + SYM_SIZE + OR_ADD);
        SHAPE_NOT = new GeneralPath();
        SHAPE_NOT.moveTo(xOut, yOut);
        SHAPE_NOT.lineTo(xOut - SYM_SIZE / 2, yOut + SYM_SIZE);
        SHAPE_NOT.lineTo(xOut + SYM_SIZE / 2, yOut + SYM_SIZE);
        SHAPE_NOT.closePath();
        SHAPE_ITE = new GeneralPath();
        SHAPE_ITE.moveTo(xOut, yOut);
        SHAPE_ITE.lineTo(xOut - SYM_SIZE / 2, yOut + SYM_SIZE / 4);
        SHAPE_ITE.lineTo(xOut - SYM_SIZE / 2, yOut + 3 * SYM_SIZE / 4);
        SHAPE_ITE.lineTo(xOut, yOut + SYM_SIZE);
        SHAPE_ITE.lineTo(xOut + SYM_SIZE / 2, yOut + 3 * SYM_SIZE / 4);
        SHAPE_ITE.lineTo(xOut + SYM_SIZE / 2, yOut + SYM_SIZE / 4);
        SHAPE_ITE.closePath();
        SHAPE_KOFN = new GeneralPath();
        SHAPE_KOFN.moveTo(xOut - SYM_SIZE / 3, yOut + SYM_SIZE / 2);
        SHAPE_KOFN.lineTo(xOut - 4, yOut + SYM_SIZE * 3 / 4);
        SHAPE_KOFN.lineTo(xOut - SYM_SIZE / 3, yOut + SYM_SIZE * 3 / 4);
        SHAPE_KOFN.moveTo(xOut - SYM_SIZE / 3, yOut + SYM_SIZE * 3 / 4 + 2);
        SHAPE_KOFN.lineTo(xOut - 4, yOut + SYM_SIZE * 3 / 4 + 2);
        SHAPE_NEG = new Ellipse2D.Double(-NEG_SIZE / 2, __HEIGHT / 2 + SYM_TOP - NEG_SIZE, NEG_SIZE, NEG_SIZE);
        xOut = 0;
        yOut = __HEIGHT / 2 + SYM_TOP + SYM_SIZE + 4;
        SHAPE_DOWN = new GeneralPath();
        int browseH = SYM_BOT - 4;
        SHAPE_DOWN.moveTo(xOut - SYM_SIZE / 5, yOut);
        SHAPE_DOWN.lineTo(xOut - SYM_SIZE / 5, yOut + browseH * 2 / 3);
        SHAPE_DOWN.moveTo(xOut + SYM_SIZE / 5, yOut);
        SHAPE_DOWN.lineTo(xOut + SYM_SIZE / 5, yOut + browseH * 2 / 3);
        SHAPE_DOWN.moveTo(xOut - SYM_SIZE / 2, yOut + browseH * 2 / 3);
        SHAPE_DOWN.lineTo(xOut, yOut + browseH);
        SHAPE_DOWN.lineTo(xOut + SYM_SIZE / 2, yOut + browseH * 2 / 3);
        xOut = 0;
        yOut = 0;
        SHAPE_UP_PRINT = new GeneralPath();
        browseH = SYM_BOT;
        SHAPE_UP_PRINT.moveTo(xOut, yOut - browseH + __TRANSFER_UNIT);
        SHAPE_UP_PRINT.lineTo(xOut + __TRANSFER_UNIT, yOut - browseH);
        SHAPE_UP_PRINT.lineTo(xOut - __TRANSFER_UNIT, yOut - browseH);
        SHAPE_UP_PRINT.lineTo(xOut, yOut - browseH + __TRANSFER_UNIT);
        SHAPE_UP_PRINT.lineTo(xOut, yOut);
    }
}

