/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.dbobj.faulttree.ft.gui;

import com.dassault.cecilia.core.ResIcoCore;
import com.dassault.cecilia.core.ResMsgVoc;
import com.dassault.cecilia.core.cecilia.ResMsgCore;
import com.dassault.cecilia.core.cecilia.export.ExpBook;
import com.dassault.cecilia.core.cecilia.export.ExpBookUtility;
import com.dassault.cecilia.core.cecilia.export.ExpObjectInfo;
import com.dassault.cecilia.core.cecilia.pref.PrefFieldsCategory;
import com.dassault.cecilia.core.cecilia.pref.Preferencies;
import com.dassault.cecilia.core.plugin.IModel;
import com.dassault.cecilia.core.plugin.PluginWithOptions;
import com.dassault.cecilia.core.swing.CeciliaAction;
import com.dassault.cecilia.core.swing.JOptionCecilia;
import com.dassault.cecilia.core.swing.PopupedListener;
import com.dassault.cecilia.db.DBFolder;
import com.dassault.cecilia.dbobj.faulttree.ResIcoArbor;
import com.dassault.cecilia.dbobj.faulttree.ResMsgArbor;
import com.dassault.cecilia.dbobj.faulttree.ft.FTEquation;
import com.dassault.cecilia.dbobj.faulttree.ft.FTVariable;
import com.dassault.cecilia.dbobj.faulttree.ft.SelectionPackage;
import com.dassault.cecilia.dbobj.faulttree.ft.export.ExpFTComputeParameters;
import com.dassault.cecilia.dbobj.faulttree.ft.export.ExpFTGeneral;
import com.dassault.cecilia.dbobj.faulttree.ft.export.ExpFTGraphicTree;
import com.dassault.cecilia.dbobj.faulttree.ft.grf.FGBook;
import com.dassault.cecilia.dbobj.faulttree.ft.grf.FGBookPrintable;
import com.dassault.cecilia.dbobj.faulttree.ft.grf.FGContent;
import com.dassault.cecilia.dbobj.faulttree.ft.grf.FGContext;
import com.dassault.cecilia.dbobj.faulttree.ft.grf.FGVariable;
import com.dassault.cecilia.dbobj.faulttree.ft.gui.FGContentFrame;
import com.dassault.cecilia.dbobj.faulttree.ft.gui.FGContentView;
import com.dassault.cecilia.dbobj.faulttree.ft.gui.FTContentPrintPreviewDlg;
import com.dassault.cecilia.dbobj.faulttree.ft.gui.FTEditPanel;
import com.dassault.cecilia.dbobj.faulttree.ft.gui.FTEquationFrame;
import com.dassault.cecilia.dbobj.faulttree.ft.gui.FTPluginAction;
import com.dassault.cecilia.dbobj.faulttree.ft.gui.actions.FTCmdDelete;
import com.dassault.cecilia.dbobj.faulttree.ft.gui.actions.FTCmdEventsEdit;
import com.dassault.cecilia.dbobj.faulttree.ft.gui.actions.FTCmdPaste;
import com.dassault.cecilia.dbobj.faulttree.ft.gui.actions.FTCmdSubTreeMove;
import com.dassault.cecilia.dbobj.faulttree.ft.gui.actions.FTCmdSubTreeRestore;
import com.dassault.cecilia.dbobj.faulttree.ft.gui.actions.FTCmdVarDuplicate;
import com.dassault.cecilia.dbobj.faulttree.ft.gui.actions.FTCmdVarEventEdit;
import com.dassault.cecilia.dbobj.faulttree.ft.gui.actions.FTCmdVarGateEdit;
import com.dassault.cecilia.dbobj.faulttree.ft.gui.actions.FTCmdVarLinkEdit;
import com.dassault.cecilia.dbobj.faulttree.ft.gui.actions.FTCmdVarRename;
import com.dassault.cecilia.dbobj.faulttree.obj.FTClipboard;
import com.dassault.cecilia.dbobj.faulttree.obj.FTClipboardTransferable;
import com.dassault.cecilia.dbobj.faulttree.obj.FTVariableAbstract;
import com.dassault.cecilia.dbobj.faulttree.pref.FTEquationViewDisplayPreferencies;
import com.dassault.cecilia.dbobj.faulttree.pref.FTEquationViewPrintPreferencies;
import com.dassault.cecilia.dbobj.folder.DBFolderTreeActivable;
import com.dassault.cecilia.dbobj.general.ihm.IPanelWithZoom;
import com.dassault.cecilia.dbobj.wrap.PageableThread;
import com.dassault.cecilia.main.cecilia.CeciliaGUI;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.print.PageFormat;
import java.awt.print.Pageable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;

public class FGContentPanel
extends FTEditPanel
implements IPanelWithZoom,
PopupedListener,
FTEquation.ChangeListener,
SelectionPackage.ChangeSelectionListener<FTVariableAbstract> {
    private static Logger _LOG = Logger.getLogger(FTEquationFrame.class.getPackage().getName());
    JPopupMenu _popupMenu;
    CeciliaAction _actionEdit;
    CeciliaAction _actionRename;
    CeciliaAction _actionDuplicate;
    CeciliaAction _actionConvertToGate;
    CeciliaAction _actionConvertToEvent;
    CeciliaAction _actionConvertToLink;
    CeciliaAction _actionSubTreeCreate;
    CeciliaAction _actionSubTreeMove;
    CeciliaAction _actionSubTreeRestore;
    CeciliaAction _actionSubTreeOpen;
    AbstractAction _actionNavUp;
    AbstractAction _actionNavDown;
    AbstractAction _actionNavDownOther;
    AbstractAction _actionDelete;
    AbstractAction _actionCut;
    AbstractAction _actionCopy;
    AbstractAction _actionPaste;
    CeciliaAction _actionNavTop;
    FTPluginAction _pluginMCS;
    FTPluginAction _pluginMEL;
    IPanelWithZoom.ZoomDecorator _zoomDecorator = new IPanelWithZoom.ZoomDecorator(this);
    protected FGContentView _contentView;
    private JScrollPane _scrollView;
    protected JCheckBox _ctrlForOneHour;
    protected JButton _ctrlNavUp;
    protected JButton _ctrlNavDown;
    protected JButton _ctrlNavTop;
    protected JComboBox _ctrlLevel;
    protected JTextField _searchEventJTF;
    protected JButton _searchEventBTN;
    protected List<FTVariableAbstract> _currentPath;
    boolean _bIAmActived = false;
    long _prefsCode = -1L;

    public FGContentPanel(FTEquationFrame frame) {
        super(frame);
    }

    protected boolean isReadOnly() {
        return false;
    }

    protected FGContext createContext() {
        FGContext context = new FGContext(this.getFrame().getDBWrap());
        context.setLawManager(this.getFrame().getApplication().getDAOFactory().getLawManager());
        context.setPrinting(false);
        context.updateFromPreferencies(this.getAppl().getPreferencies());
        return context;
    }

    public void setModified(boolean value) {
    }

    @Override
    public FGContentView getContentView() {
        return this._contentView;
    }

    protected FGContentView createContentView() {
        return new FGContentView(this.createContext());
    }

    public void make() {
        this.createActions();
        this._contentView = this.createContentView();
        FGContent fgContent = new FGContent(this._ftEquation);
        this._contentView.setInheritsPopupMenu(true);
        this._contentView.setContent(fgContent);
        this._contentView.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() != 2) {
                    return;
                }
                if (!SwingUtilities.isLeftMouseButton(e)) {
                    return;
                }
                Point pt = new Point(e.getX(), e.getY());
                pt = FGContentPanel.this._contentView.convertViewToLogical(pt);
                FGVariable fgVar = FGContentPanel.this._contentView.getContent().getGraphAtPoint(pt.x, pt.y);
                if (fgVar != null) {
                    if (e.isControlDown()) {
                        if (fgVar == FGContentPanel.this._contentView.getContent().getTop() && fgVar.getVar() != FGContentPanel.this._ftEquation.getTopEvent()) {
                            FGContentPanel.this._actionNavUp.actionPerformed(new ActionEvent(e.getSource(), 1001, ""));
                        } else if (fgVar.getChildren() == null && fgVar.getVar().getEvent() == null) {
                            FGContentPanel.this._actionNavDown.actionPerformed(new ActionEvent(e.getSource(), 1001, ""));
                        }
                    } else if (!e.isShiftDown()) {
                        FGContentPanel.this.doEdit();
                    }
                }
            }
        });
        this._scrollView = this._zoomDecorator.createScrollPane();
        this.setLayout(new GridBagLayout());
        this.add(this.createCtrlPanel(), new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 10, 5, 10), 0, 0));
        this.add((Component)this._scrollView, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 17, 1, new Insets(0, 10, 10, 10), 0, 0));
        PluginWithOptions opts = this.getAppl().getPreferencies().getOptions(FTEquationViewDisplayPreferencies.PREF_KEY);
        if (opts != null && opts instanceof FTEquationViewDisplayPreferencies) {
            int level = ((FTEquationViewDisplayPreferencies)opts).getPrefLevel();
            this._ctrlLevel.setSelectedItem(Integer.toString(level));
            this._contentView.changeLevel(level);
        }
        this.createPopupMenu();
        this._scrollView.setComponentPopupMenu(this._popupMenu);
        this._contentView.setZoom(1.0);
        this._contentView.setActionEdit(this._actionEdit);
    }

    private void createActions() {
        this._actionDelete = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Collection<FTVariable> initialVars = FGContentPanel.this.getSelectInterneVariables();
                if (!initialVars.isEmpty()) {
                    FTCmdDelete cmd = new FTCmdDelete(FGContentPanel.this.getAppl(), FGContentPanel.this.getFrame(), initialVars, FGContentPanel.this._contentView);
                    FGVariable pivot = FGContentPanel.this.getView().getPivot();
                    cmd.setPivot(pivot);
                    cmd.realiseDo();
                }
            }
        };
        this._actionCut = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FTVariable ftVar = FGContentPanel.this.getSelectSingleInterneVariable(true);
                if (ftVar != null) {
                    List<FTVariable> vars = ftVar.extractVariables();
                    FTClipboardTransferable transferable = new FTClipboardTransferable(new FTClipboard(vars));
                    FGContentPanel.this.getAppl().getLocalClipboard(false).setContents(transferable, null);
                    FTCmdDelete cmd = new FTCmdDelete(FGContentPanel.this.getAppl(), FGContentPanel.this.getFrame(), Collections.singleton(ftVar), FGContentPanel.this._contentView);
                    cmd.realiseDo();
                }
            }
        };
        this._actionCopy = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FTVariable ftVar = FGContentPanel.this.getSelectSingleInterneVariable(false);
                if (ftVar != null) {
                    List<FTVariable> vars = ftVar.extractVariables();
                    FTClipboardTransferable transferable = new FTClipboardTransferable(new FTClipboard(vars));
                    FGContentPanel.this.getAppl().getLocalClipboard(false).setContents(transferable, null);
                }
            }
        };
        this._actionPaste = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FTVariable ftVar = FGContentPanel.this.getSelectSingleInterneVariable(true);
                if (ftVar != null && ftVar.getLink() == null) {
                    FTCmdPaste cmd = new FTCmdPaste(FGContentPanel.this.getAppl(), FGContentPanel.this.getFrame(), ftVar, FGContentPanel.this._contentView);
                    cmd.realiseDo();
                }
            }
        };
        this._actionNavUp = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (FGContentPanel.this._contentView.browse(FGContentView.BrowseOrientation.UP)) {
                    FGVariable fgVar = FGContentPanel.this._contentView.getPivot();
                    FGContentPanel.this.refreshScroll((Collection<? extends FTVariableAbstract>)(fgVar != null ? Collections.singleton(fgVar.getVar()) : Collections.EMPTY_SET));
                    FGContentPanel.this.changeBrowseActions();
                }
            }
        };
        this._actionNavDown = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (FGContentPanel.this._contentView.browse(FGContentView.BrowseOrientation.DOWN)) {
                    FGVariable fgVar = FGContentPanel.this._contentView.getPivot();
                    FGContentPanel.this.refreshScroll((Collection<? extends FTVariableAbstract>)(fgVar != null ? Collections.singleton(fgVar.getVar()) : Collections.EMPTY_SET));
                    FGContentPanel.this.changeBrowseActions();
                }
            }
        };
        this._actionNavDownOther = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FTVariableAbstract ftVar = null;
                FGVariable fgVar = FGContentPanel.this._contentView.getPivot();
                if (fgVar != null && !fgVar.getVar().isRoot() && fgVar != FGContentPanel.this._contentView.getContent().getTop() && (ftVar = fgVar.getVar()).getLink() == null && ftVar.getDefinition() == null) {
                    ftVar = null;
                }
                if (ftVar != null) {
                    FGContentFrame iframe = new FGContentFrame(FGContentPanel.this.getFrame(), ftVar);
                    iframe.showView(FGContentPanel.this.getAppl().getTopWindow().getDesktop());
                }
            }
        };
        this._actionNavTop = new CeciliaAction(ResIcoArbor.getImageIcon("ROOT"), ResMsgArbor.getString("VOC_ROOT")){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (FGContentPanel.this._contentView.browse(FGContentView.BrowseOrientation.TOP)) {
                    FGContentPanel.this.refreshScroll(Collections.singleton(FGContentPanel.this._contentView.getPivot().getVar()));
                    FGContentPanel.this.changeBrowseActions();
                }
            }
        };
        this._actionEdit = new CeciliaAction(ResMsgVoc.getString("VOC_EDIT")){

            @Override
            public void actionPerformed(ActionEvent e) {
                FGContentPanel.this.doEdit();
            }
        };
        this._actionRename = new CeciliaAction(ResMsgVoc.getString("VOC_RENAME")){

            @Override
            public void actionPerformed(ActionEvent e) {
                FTVariable ftVar = FGContentPanel.this.getSelectSingleInterneVariable(true);
                if (ftVar != null) {
                    FTCmdVarRename cmd = new FTCmdVarRename(FGContentPanel.this.getAppl(), FGContentPanel.this.getFrame(), ftVar, null, FGContentPanel.this._contentView);
                    cmd.realiseDo();
                }
            }
        };
        this._actionDuplicate = new CeciliaAction(ResMsgVoc.getString("VOC_DUPLICATE")){

            @Override
            public void actionPerformed(ActionEvent e) {
                FTVariable ftVar = FGContentPanel.this.getSelectSingleInterneVariable(true);
                FGVariable fgVar = FGContentPanel.this._contentView.getPivot();
                FTVariableAbstract parent = fgVar.getParent().getVar();
                if (ftVar != null && parent != null && parent instanceof FTVariable) {
                    FTCmdVarDuplicate cmd = new FTCmdVarDuplicate(FGContentPanel.this.getAppl(), FGContentPanel.this.getFrame(), ftVar, (FTVariable)parent, null, FGContentPanel.this._contentView);
                    cmd.realiseDo();
                }
            }
        };
        this._actionConvertToEvent = new CeciliaAction(ResMsgArbor.getString("LBL_CONVERT_TO_EVENT")){

            @Override
            public void actionPerformed(ActionEvent e) {
                FTVariable ftVar = FGContentPanel.this.getSelectSingleInterneVariable(true);
                if (ftVar != null) {
                    FTCmdVarEventEdit cmd = new FTCmdVarEventEdit(FGContentPanel.this.getAppl(), FGContentPanel.this.getFrame(), ftVar, FGContentPanel.this._contentView);
                    cmd.realiseDo();
                }
            }
        };
        this._actionConvertToGate = new CeciliaAction(ResMsgArbor.getString("LBL_CONVERT_TO_GATE")){

            @Override
            public void actionPerformed(ActionEvent e) {
                FTVariable ftVar = FGContentPanel.this.getSelectSingleInterneVariable(true);
                if (ftVar != null && (ftVar.getLink() != null || ftVar.getEvent() != null)) {
                    FTCmdVarGateEdit cmd = new FTCmdVarGateEdit(FGContentPanel.this.getAppl(), FGContentPanel.this.getFrame(), ftVar, FGContentPanel.this._contentView);
                    cmd.realiseDo();
                }
            }
        };
        this._actionConvertToLink = new CeciliaAction(ResMsgArbor.getString("LBL_CONVERT_TO_LINK")){

            @Override
            public void actionPerformed(ActionEvent e) {
                FTVariable ftVar = FGContentPanel.this.getSelectSingleInterneVariable(true);
                if (ftVar != null && ftVar.getLink() == null) {
                    FTCmdVarLinkEdit cmd = new FTCmdVarLinkEdit(FGContentPanel.this.getAppl(), FGContentPanel.this.getFrame(), ftVar, FGContentPanel.this._contentView);
                    cmd.realiseDo();
                }
            }
        };
        this._actionSubTreeCreate = new CeciliaAction(ResMsgArbor.getString("LBL_SUBTREE_CREATE")){

            @Override
            public void actionPerformed(ActionEvent e) {
                FTVariable ftVar = FGContentPanel.this.getSelectSingleInterneVariable(true);
                if (ftVar != null && ftVar.getLink() == null && ftVar.getDefinition() != null) {
                    FTCmdSubTreeMove cmd = new FTCmdSubTreeMove(FGContentPanel.this.getAppl(), FGContentPanel.this.getFrame(), ftVar, FGContentPanel.this._contentView);
                    cmd.setMove(false).realiseDo();
                }
            }
        }.setDesc(ResMsgArbor.getString("TTP_SUBTREE_CREATE"));
        this._actionSubTreeMove = new CeciliaAction(ResMsgArbor.getString("LBL_SUBTREE_MOVE")){

            @Override
            public void actionPerformed(ActionEvent e) {
                FTVariable ftVar = FGContentPanel.this.getSelectSingleInterneVariable(true);
                if (ftVar != null && ftVar.getLink() == null && ftVar.getDefinition() != null) {
                    FTCmdSubTreeMove cmd = new FTCmdSubTreeMove(FGContentPanel.this.getAppl(), FGContentPanel.this.getFrame(), ftVar, FGContentPanel.this._contentView);
                    cmd.setMove(true).realiseDo();
                }
            }
        }.setDesc(ResMsgArbor.getString("TTP_SUBTREE_MOVE"));
        this._actionSubTreeRestore = new CeciliaAction(ResMsgArbor.getString("LBL_SUBTREE_RESTORE")){

            @Override
            public void actionPerformed(ActionEvent e) {
                FTVariable ftVar = FGContentPanel.this.getSelectSingleInterneVariable(true);
                if (ftVar != null && ftVar.getLink() != null && !ftVar.getLink().isDSF()) {
                    FTCmdSubTreeRestore cmd = new FTCmdSubTreeRestore(FGContentPanel.this.getAppl(), FGContentPanel.this.getFrame(), ftVar, FGContentPanel.this._contentView);
                    cmd.realiseDo();
                }
            }
        }.setDesc(ResMsgArbor.getString("TTP_SUBTREE_RESTORE"));
        this._actionSubTreeOpen = new CeciliaAction(ResMsgArbor.getString("LBL_SUBTREE_OPEN")){

            @Override
            public void actionPerformed(ActionEvent e) {
                FTVariable ftVar = FGContentPanel.this.getSelectSingleInterneVariable(true);
                if (ftVar != null && ftVar.getLink() != null) {
                    DBFolder dbFolder = ftVar.getLink().getSubTree().getDBFolder();
                    DBFolderTreeActivable tree = FGContentPanel.this.getAppl().getTopWindow().getFolders().getTree(dbFolder.getFamily());
                    if (tree != null) {
                        tree.edit(dbFolder, false);
                    }
                }
            }
        };
        this._pluginMCS = new FTPluginAction("com.dassault.cecilia.plugin.faulttree.compute.PluginCmdMCS", this.getFrame());
        this._pluginMEL = new FTPluginAction("com.dassault.cecilia.plugin.faulttree.compute.PluginCmdMEL", this.getFrame());
    }

    protected FTVariable getSelectSingleInterneVariable(boolean unlocked) {
        FTVariableAbstract firstSelect = null;
        Iterator<FGVariable> iterGrf = this._contentView.getContent().iterator();
        while (iterGrf.hasNext()) {
            FGVariable fgVar = iterGrf.next();
            if (!fgVar.getVar().isSelected()) continue;
            if (firstSelect != null) {
                if (firstSelect == fgVar.getVar()) continue;
                return null;
            }
            firstSelect = fgVar.getVar();
            if (!firstSelect.isIntern()) {
                return null;
            }
            if (!unlocked || !firstSelect.isLocked()) continue;
            return null;
        }
        return (FTVariable)firstSelect;
    }

    protected Collection<FTVariable> getSelectInterneVariables() {
        LinkedHashSet<FTVariable> result = new LinkedHashSet<FTVariable>();
        Iterator<FGVariable> iterGrf = this._contentView.getContent().iterator();
        while (iterGrf.hasNext()) {
            FTVariableAbstract ftVar = iterGrf.next().getVar();
            if (!ftVar.isSelected() || result.contains(ftVar) || !ftVar.isIntern()) continue;
            result.add((FTVariable)ftVar);
        }
        return result;
    }

    private void createPopupMenu() {
        this._popupMenu = new JPopupMenu();
        if (this.getFrame().isEditable()) {
            this._popupMenu.add(this.getAppl().getTopWindow().getAction("UNDO").createMenuItem());
            this._popupMenu.add(this.getAppl().getTopWindow().getAction("REDO").createMenuItem());
            this._popupMenu.addSeparator();
        }
        this._popupMenu.add(this._actionNavTop);
        this._popupMenu.add(this.getAppl().getTopWindow().getAction("OCAS_UP").createMenuItem());
        this._popupMenu.add(this.getAppl().getTopWindow().getAction("OCAS_DOWN").createMenuItem());
        this._popupMenu.add(this.getAppl().getTopWindow().getAction("OCAS_DOWN_OTHER").createMenuItem());
        this._popupMenu.addSeparator();
        if (this.getFrame().isEditable()) {
            this._popupMenu.add(this._actionRename);
            this._popupMenu.add(this._actionDuplicate);
        }
        this._popupMenu.add(this._actionEdit);
        if (this.getFrame().isEditable()) {
            this._popupMenu.add(this.getAppl().getTopWindow().getAction("DELETE").createMenuItem());
            this._popupMenu.addSeparator();
            this._popupMenu.add(this.getAppl().getTopWindow().getAction("CUT").createMenuItem());
            this._popupMenu.add(this.getAppl().getTopWindow().getAction("COPY").createMenuItem());
            this._popupMenu.add(this.getAppl().getTopWindow().getAction("PASTE").createMenuItem());
            this._popupMenu.addSeparator();
            this._popupMenu.add(this._actionConvertToEvent);
            this._popupMenu.add(this._actionConvertToGate);
            this._popupMenu.add(this._actionConvertToLink);
            this._popupMenu.addSeparator();
            this._popupMenu.add(this._actionSubTreeCreate);
            this._popupMenu.add(this._actionSubTreeMove);
            this._popupMenu.add(this._actionSubTreeRestore);
        }
        this._popupMenu.add(this._actionSubTreeOpen);
        this._popupMenu.addSeparator();
        this._popupMenu.add(this._pluginMCS);
        this._popupMenu.add(this._pluginMEL);
    }

    protected Component createCtrlPanel() {
        this._ctrlForOneHour = new JCheckBox(this._ftEquation.getComputeParameters().getOneHourAction());
        this._ftEquation.getComputeParameters().getOneHourAction().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FGContentPanel.this.refreshContent();
            }
        });
        this._searchEventJTF = new JTextField(12);
        this._searchEventJTF.setPreferredSize(new Dimension(0, 25));
        this._searchEventJTF.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FGContentPanel.this.doSelectEvent();
            }
        });
        this._searchEventJTF.setToolTipText(ResMsgCore.getString("FT_SEARCH_TABLE_REGEX_TOOLTIP"));
        this._searchEventBTN = new JButton(ResIcoCore.getImageIcon("BUT_SEARCH"));
        this._searchEventBTN.setPreferredSize(new Dimension(25, 25));
        this._searchEventBTN.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FGContentPanel.this.doSelectEvent();
            }
        });
        this._ctrlNavTop = new JButton(ResIcoArbor.getImageIcon("ROOT"));
        this._ctrlNavTop.addActionListener(this._actionNavTop);
        this._ctrlNavTop.setMargin(new Insets(1, 1, 1, 1));
        this._ctrlNavUp = new JButton(ResIcoCore.getImageIcon("BUT_DISPLAY_UP"));
        this._ctrlNavUp.addActionListener(this._actionNavUp);
        this._ctrlNavUp.setMargin(new Insets(1, 1, 1, 1));
        this._ctrlNavDown = new JButton(ResIcoCore.getImageIcon("BUT_DISPLAY_DOWN"));
        this._ctrlNavDown.addActionListener(this._actionNavDown);
        this._ctrlNavDown.setMargin(new Insets(1, 1, 1, 1));
        this._ctrlLevel = new JComboBox<Object>(new Object[]{"2", "3", "4", "5", "6", "7", "8", "9"});
        this._ctrlLevel.setSelectedItem("3");
        this._ctrlLevel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    String strLevel = FGContentPanel.this._ctrlLevel.getSelectedItem().toString();
                    if (FGContentPanel.this._contentView.changeLevel(Integer.parseInt(strLevel))) {
                        FGContentPanel.this.refreshScroll(null);
                        FGContentPanel.this.changeBrowseActions();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        JPanel topPanel = new JPanel();
        int idxX = 0;
        topPanel.setLayout(new GridBagLayout());
        topPanel.add((Component)this._ctrlForOneHour, new GridBagConstraints(idxX++, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 10), 0, 0));
        topPanel.add((Component)new JLabel(""), new GridBagConstraints(idxX++, 0, 1, 1, 0.3, 0.0, 10, 2, new Insets(0, 0, 0, 5), 0, 0));
        topPanel.add((Component)this._searchEventJTF, new GridBagConstraints(idxX++, 0, 1, 1, 0.1, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        topPanel.add((Component)this._searchEventBTN, new GridBagConstraints(idxX++, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        topPanel.add((Component)new JLabel(""), new GridBagConstraints(idxX++, 0, 1, 1, 0.3, 0.0, 10, 2, new Insets(0, 0, 0, 5), 0, 0));
        topPanel.add((Component)this._ctrlNavTop, new GridBagConstraints(idxX++, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 5), 0, 0));
        topPanel.add((Component)this._ctrlNavUp, new GridBagConstraints(idxX++, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 5), 0, 0));
        topPanel.add((Component)this._ctrlNavDown, new GridBagConstraints(idxX++, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 5), 0, 0));
        topPanel.add((Component)new JLabel(""), new GridBagConstraints(idxX++, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 5), 0, 0));
        topPanel.add((Component)new JLabel(ResMsgVoc.getString("VOC_LEVEL")), new GridBagConstraints(idxX++, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 5, 0, 5), 0, 0));
        topPanel.add((Component)this._ctrlLevel, new GridBagConstraints(idxX++, 0, 1, 1, 0.01, 0.0, 13, 2, new Insets(0, 0, 0, 0), 0, 0));
        return topPanel;
    }

    protected void refreshContent() {
        FGContent content = this._contentView.getContent();
        content.computeSize((Graphics2D)this.getGraphics(), this._contentView.getContext());
        this.repaint();
    }

    private final void doSelectEvent() {
        int indexCurrentPath;
        String eventName = this._searchEventJTF.getText();
        ArrayList<FTVariableAbstract> listSearchVar = new ArrayList<FTVariableAbstract>();
        try {
            Pattern p = Pattern.compile(eventName);
            for (FTVariableAbstract var : this._ftEquation.getAllVariables()) {
                if (!p.matcher(var.getName()).find()) continue;
                listSearchVar.add(var);
            }
        }
        catch (PatternSyntaxException error) {
            SelectionPackage.ChangeSelectionEvent<FTVariableAbstract> unselectAllEvents = new SelectionPackage.ChangeSelectionEvent<FTVariableAbstract>(this._ftEquation.getAllVariables().get(0), false, (Collection<FTVariableAbstract>)this._ftEquation.getAllVariables());
            for (FTVariableAbstract ftVar : this._ftEquation.getAllVariables()) {
                ftVar.setSelected(false);
            }
            this._ftEquation.fireChangeSelection(unselectAllEvents, this._contentView);
            JOptionPane.showMessageDialog(this, ResMsgArbor.getString("FT_SEARCH_REGEX_ERROR"), ResMsgVoc.getString("VOC_ERROR"), 0);
            return;
        }
        if (listSearchVar.isEmpty()) {
            SelectionPackage.ChangeSelectionEvent<FTVariableAbstract> unselectAllEvents = new SelectionPackage.ChangeSelectionEvent<FTVariableAbstract>(this._ftEquation.getAllVariables().get(0), false, (Collection<FTVariableAbstract>)this._ftEquation.getAllVariables());
            for (FTVariableAbstract ftVar : this._ftEquation.getAllVariables()) {
                ftVar.setSelected(false);
            }
            this._ftEquation.fireChangeSelection(unselectAllEvents, this._contentView);
            return;
        }
        FTVariableAbstract ftVarAbs = null;
        if (this._currentPath == null) {
            ftVarAbs = (FTVariableAbstract)listSearchVar.get(0);
        } else {
            List<List<FTVariableAbstract>> possiblePaths;
            FTVariableAbstract varPath = this._currentPath.get(this._currentPath.size() - 1);
            this._currentPath.remove(this._currentPath.size() - 1);
            ftVarAbs = listSearchVar.contains(varPath) ? ((possiblePaths = this._ftEquation.findPaths(null, varPath, false)).indexOf(this._currentPath) == possiblePaths.size() - 1 ? (listSearchVar.indexOf(varPath) == listSearchVar.size() - 1 ? (FTVariableAbstract)listSearchVar.get(0) : (FTVariableAbstract)listSearchVar.get(listSearchVar.indexOf(varPath) + 1)) : varPath) : (FTVariableAbstract)listSearchVar.get(0);
        }
        SelectionPackage.ChangeSelectionEvent<FTVariableAbstract> unselectAllEvents = new SelectionPackage.ChangeSelectionEvent<FTVariableAbstract>(this._ftEquation.getAllVariables().get(0), false, (Collection<FTVariableAbstract>)this._ftEquation.getAllVariables());
        SelectionPackage.ChangeSelectionEvent<FTVariableAbstract> changeEvent = new SelectionPackage.ChangeSelectionEvent<FTVariableAbstract>(ftVarAbs, true);
        List<List<FTVariableAbstract>> paths = this._ftEquation.findPaths(null, ftVarAbs, false);
        assert (paths != null && !paths.isEmpty());
        this._currentPath = paths.size() != 1 && this._currentPath != null && paths.contains(this._currentPath) ? ((indexCurrentPath = paths.indexOf(this._currentPath)) + 1 == paths.size() ? paths.get(0) : paths.get(indexCurrentPath + 1)) : paths.get(0);
        this._contentView.browseByPath(this._currentPath, ftVarAbs);
        this._currentPath.add(ftVarAbs);
        for (FTVariableAbstract ftVar : this._ftEquation.getAllVariables()) {
            ftVar.setSelected(false);
        }
        ftVarAbs.setSelected(true);
        this._ftEquation.fireChangeSelection(unselectAllEvents, this._contentView);
        this._ftEquation.fireChangeSelection(changeEvent, this._contentView);
        this.refreshScroll(Collections.singleton(ftVarAbs));
    }

    protected void changeBrowseActions() {
        FTVariableAbstract ftVar;
        if (!this._bIAmActived) {
            return;
        }
        boolean eDown = false;
        FGVariable fgVar = this._contentView.getPivot();
        if (fgVar != null && !fgVar.getVar().isRoot() && fgVar != this._contentView.getContent().getTop() && ((ftVar = fgVar.getVar()).getLink() != null || ftVar.getDefinition() != null || ftVar.isLeaf())) {
            eDown = true;
        }
        this.getGUI().getDelegateAction("OCAS_DOWN").setEnabled(this._actionNavDown, eDown);
        this.getGUI().getDelegateAction("OCAS_DOWN_OTHER").setEnabled(this._actionNavDownOther, eDown);
        this._ctrlNavDown.setEnabled(eDown);
        boolean eUp = false;
        FGVariable fgTop = this._contentView.getContent().getTop();
        if (fgTop != null && !fgTop.getVar().isRoot()) {
            eUp = true;
        }
        this._ctrlNavTop.setEnabled(eUp);
        this._actionNavTop.setEnabled(eUp);
        this.getGUI().getDelegateAction("OCAS_UP").setEnabled(this._actionNavUp, eUp);
        this._ctrlNavUp.setEnabled(eUp);
    }

    @Override
    public void changeSelection(SelectionPackage.ChangeSelectionEvent<FTVariableAbstract> event) {
        if (event.getOwner() != this._contentView) {
            this._contentView.setPivot(null, null);
        }
        if (this._contentView.couldPerhapsBeResized()) {
            this.refreshScroll(Collections.singleton(event.getSource()));
        }
        this.changeBrowseActions();
        this.refreshActions();
        this._contentView.repaint();
    }

    protected void refreshActions() {
        Transferable transferable;
        FGVariable fgVar;
        FTVariableAbstract firstVar = null;
        FTVariable firstInterneVar = null;
        int cptEvents = 0;
        int cptGate = 0;
        int cptLink = 0;
        boolean enableEdit = false;
        boolean canDelete = true;
        int nbrSelect = 0;
        Iterator<FGVariable> iterGrf = this._contentView.getContent().iterator();
        while (iterGrf.hasNext()) {
            fgVar = iterGrf.next();
            fgVar.getVar().setFlags(0);
        }
        iterGrf = this._contentView.getContent().iterator();
        while (iterGrf.hasNext()) {
            FTVariableAbstract ftVar;
            fgVar = iterGrf.next();
            if (!fgVar.getVar().isSelected() || (ftVar = fgVar.getVar()).getFlags() != 0) continue;
            ftVar.setFlags(1);
            ++nbrSelect;
            if (canDelete) {
                boolean bl = canDelete = ftVar.isIntern() && !ftVar.isRoot();
            }
            if (!ftVar.isIntern()) continue;
            if (firstInterneVar == null) {
                firstInterneVar = (FTVariable)ftVar;
            }
            if (ftVar.isLocked()) continue;
            if (firstVar == null) {
                firstVar = ftVar;
                enableEdit = true;
            }
            if (ftVar.getEvent() != null) {
                ++cptEvents;
            } else if (ftVar.getLink() != null) {
                ++cptLink;
            } else if (ftVar.getDefinition() != null) {
                ++cptGate;
            }
            if (!enableEdit) continue;
            if (cptGate > 1 || cptLink > 1) {
                enableEdit = false;
                continue;
            }
            if (cptEvents > 0 && (cptGate > 0 || cptLink > 0)) {
                enableEdit = false;
                continue;
            }
            if (cptGate <= 0 || cptLink <= 0) continue;
            enableEdit = false;
        }
        this._actionEdit.setEnabled(enableEdit);
        this.getGUI().getDelegateAction("DELETE").setEnabled(this._actionDelete, canDelete && nbrSelect > 0);
        this.getGUI().getDelegateAction("CUT").setEnabled(this._actionCut, canDelete && nbrSelect == 1 && firstInterneVar != null);
        this.getGUI().getDelegateAction("COPY").setEnabled(this._actionCopy, nbrSelect == 1 && firstInterneVar != null);
        if (firstVar != null && nbrSelect != 1) {
            firstVar = null;
        }
        boolean canPaste = (transferable = this.getAppl().getLocalClipboard(false).getContents(this)) != null && transferable.isDataFlavorSupported(FTClipboardTransferable.DB_FLAVOR) && firstVar != null && (cptGate == 1 || cptEvents == 1);
        this.getGUI().getDelegateAction("PASTE").setEnabled(this._actionPaste, canPaste);
        this._actionRename.setEnabled(firstVar != null);
        List<List<FTVariableAbstract>> listParents = this._ftEquation.findPaths(null, firstVar, false);
        this._actionDuplicate.setEnabled(listParents.size() > 1);
        this._actionConvertToGate.setEnabled(firstVar != null && (firstVar.getLink() != null || firstVar.getEvent() != null));
        this._actionConvertToLink.setEnabled(firstVar != null && !firstVar.isRoot() && firstVar.getLink() == null);
        this._actionConvertToEvent.setEnabled(firstVar != null && !firstVar.isRoot() && firstVar.getEvent() == null);
        boolean canSubTree = firstVar != null && !firstVar.isRoot() && firstVar.getLink() == null && firstVar.getDefinition() != null;
        this._actionSubTreeCreate.setEnabled(canSubTree);
        this._actionSubTreeMove.setEnabled(canSubTree);
        this._actionSubTreeRestore.setEnabled(firstVar != null && firstVar.getLink() != null && !firstVar.getLink().isDSF());
        this._actionSubTreeOpen.setEnabled(firstVar != null && firstVar.getLink() != null);
        if (nbrSelect > 1) {
            this.getGUI().getDelegateAction("OCAS_DOWN_OTHER").setEnabled(this._actionNavDownOther, false);
        }
        boolean canCompute = !this._ftEquation.getManuelInstanciate() && firstVar != null && firstVar.getDefinition() != null;
        this._pluginMCS.setEnabled(canCompute);
        this._pluginMEL.setEnabled(canCompute);
    }

    @Override
    public void toDoWhenDeActivated() {
        this._bIAmActived = false;
        this.getGUI().setEnabledAction("PRINT", false);
        this.getGUI().setEnabledAction("PRINT_PREVIEW", false);
        this.getGUI().getDelegateAction("OCAS_UP").delDelegate(this._actionNavUp).setEnabled(false);
        this.getGUI().getDelegateAction("OCAS_DOWN").delDelegate(this._actionNavDown).setEnabled(false);
        this.getGUI().getDelegateAction("OCAS_DOWN_OTHER").delDelegate(this._actionNavDownOther).setEnabled(false);
        this.getGUI().getDelegateAction("DELETE").delDelegate(this._actionDelete).setEnabled(false);
        this.getGUI().getDelegateAction("CUT").delDelegate(this._actionCut).setEnabled(false);
        this.getGUI().getDelegateAction("COPY").delDelegate(this._actionCopy).setEnabled(false);
        this.getGUI().getDelegateAction("PASTE").delDelegate(this._actionPaste).setEnabled(false);
        this._ctrlNavUp.setEnabled(false);
        this._ctrlNavDown.setEnabled(false);
        this._ctrlNavTop.setEnabled(false);
        this._actionNavTop.setEnabled(false);
        this._zoomDecorator.toDoWhenDeActivated();
        super.toDoWhenDeActivated();
    }

    @Override
    public void toDoWhenActivated() {
        this._bIAmActived = true;
        this.getGUI().setEnabledAction("PRINT", true);
        this.getGUI().setEnabledAction("PRINT_PREVIEW", true);
        this.getGUI().getDelegateAction("OCAS_UP").addDelegate(this._actionNavUp);
        this.getGUI().getDelegateAction("OCAS_DOWN").addDelegate(this._actionNavDown);
        this.getGUI().getDelegateAction("OCAS_DOWN_OTHER").addDelegate(this._actionNavDownOther);
        this.getGUI().getDelegateAction("DELETE").addDelegate(this._actionDelete);
        this.getGUI().getDelegateAction("CUT").addDelegate(this._actionCut);
        this.getGUI().getDelegateAction("COPY").addDelegate(this._actionCopy);
        this.getGUI().getDelegateAction("PASTE").addDelegate(this._actionPaste);
        this.changeBrowseActions();
        this.refreshActions();
        this._zoomDecorator.toDoWhenActivated();
        super.toDoWhenActivated();
    }

    public FGContentView getView() {
        return this._contentView;
    }

    public void refreshScroll(Collection<? extends FTVariableAbstract> vars) {
        Dimension currentSize = this._contentView.getSize();
        FGContent content = this._contentView.getContent();
        content.computeSize((Graphics2D)this.getGraphics(), this._contentView.getContext());
        Dimension preferrSize = this._contentView.getPreferredSize();
        if (!currentSize.equals(preferrSize)) {
            this._contentView.setSize(preferrSize);
            this.revalidate();
        }
        if (vars != null && !vars.isEmpty() && (vars.size() != 1 || vars.iterator().next().isSelected())) {
            FGVariable pivot = this._contentView.getPivot();
            Point pt = null;
            pt = pivot != null ? content.getPointForFGVariable(pivot) : content.getPointForVariable(vars.iterator().next());
            JViewport vp = this._scrollView.getViewport();
            Point pointViewPort = vp.getViewPosition();
            Dimension sizeViewPort = vp.getExtentSize();
            double zoom = this._contentView.getZoom();
            int xViewPort = (int)(pointViewPort.getX() / zoom);
            int yViewPort = (int)(pointViewPort.getY() / zoom);
            int xEndViewPort = (int)((double)xViewPort + sizeViewPort.getWidth() / zoom);
            int yEndViewPort = (int)((double)yViewPort + sizeViewPort.getHeight() / zoom);
            if (pt != null && (pt.getX() < (double)xViewPort || pt.getX() > (double)xEndViewPort || pt.getY() < (double)yViewPort || pt.getY() > (double)yEndViewPort)) {
                FGVariable fgVar = content.getGraphAtPoint(pt.x, pt.y);
                Rectangle rect = new Rectangle((int)((double)(pt.x - fgVar.getWAll() / 2) * zoom), (int)((double)(pt.y - fgVar.getH() / 2 - 10) * zoom), (int)((double)fgVar.getWAll() * zoom), (int)((double)(fgVar.getHAll() + 10) * zoom));
                this._contentView.scrollRectToVisible(rect);
                rect = new Rectangle((int)((double)(pt.x - fgVar.getW() / 2) * zoom), (int)((double)(pt.y - fgVar.getH() / 2 - 10) * zoom), (int)((double)(fgVar.getW() + 10) * zoom), (int)((double)(fgVar.getH() + 10) * zoom));
                this._contentView.scrollRectToVisible(rect);
            }
        }
        this.repaint();
    }

    public void changePreferencies(Preferencies prefs) {
        if (this._prefsCode == prefs.getRefresh()) {
            return;
        }
        this._prefsCode = prefs.getRefresh();
        this._contentView.getContext().updateFromPreferencies(prefs);
        this.refreshContent();
    }

    @Override
    public void displayPopup(MouseEvent e) {
        this._popupMenu.show(e.getComponent(), e.getX(), e.getY());
    }

    @Override
    public void changeEvents(Collection<? extends FTVariableAbstract> vars, Component source) {
        this._contentView.repaint();
    }

    @Override
    public void changeDefinitions(Collection<FTVariable> vars, Component source) {
        FGVariable fgVarPivot = this._contentView.getContent().getTop();
        FTVariableAbstract ftVarPivot = fgVarPivot.getVar();
        FTVariableAbstract ftSrc = this._ftEquation.getVariable(ftVarPivot.getName());
        if (ftSrc == null) {
            this._contentView.browse(FGContentView.BrowseOrientation.TOP);
            this.refreshScroll(vars);
            this.changeBrowseActions();
        } else if (ftSrc != ftVarPivot) {
            this._contentView.getContent().browse(ftSrc);
            if (vars != null && !vars.isEmpty()) {
                this._contentView.setPivot(vars.iterator().next(), null);
            }
            this.refreshScroll(vars);
            this.changeBrowseActions();
        } else {
            this._contentView.browse(FGContentView.BrowseOrientation.NONE);
            this.refreshScroll(vars);
            this.changeBrowseActions();
        }
        this.refreshActions();
    }

    @Override
    public void doEdit() {
        StringBuilder names = new StringBuilder(64);
        boolean stopAppendName = false;
        FTVariableAbstract ftDef = null;
        FTVariableAbstract ftLink = null;
        ArrayList<FTVariable> selects = new ArrayList<FTVariable>();
        Iterator<FGVariable> iterGrf = this._contentView.getContent().iterator();
        while (iterGrf.hasNext()) {
            FTVariableAbstract ftVar;
            FGVariable fgVar = iterGrf.next();
            if (!fgVar.getVar().isSelected() || (ftVar = fgVar.getVar()) == null || !ftVar.isIntern() || ftVar.isLocked()) continue;
            if (ftVar.getLink() != null) {
                if (ftLink != ftVar) {
                    if (ftLink != null) {
                        return;
                    }
                    ftLink = ftVar;
                }
            } else if (ftVar.getEvent() != null) {
                if (!selects.contains(ftVar)) {
                    if (!stopAppendName) {
                        if (names.length() > 0) {
                            names.append(", ");
                        }
                        if (names.length() > 48) {
                            names.append("...");
                            stopAppendName = true;
                        } else {
                            names.append(ftVar.getName());
                        }
                    }
                    selects.add((FTVariable)ftVar);
                }
            } else if (ftVar.getDefinition() != null && ftDef != ftVar) {
                if (ftDef != null) {
                    return;
                }
                ftDef = ftVar;
            }
            if (!(selects.isEmpty() || ftLink == null && ftDef == null)) {
                return;
            }
            if (ftLink == null || ftDef == null) continue;
            return;
        }
        if (selects.size() == 1 && ((FTVariable)selects.get(0)).isRoot()) {
            cmd = new FTCmdVarGateEdit(this.getAppl(), this.getFrame(), selects.get(0), this);
            cmd.realiseDo();
        } else if (!selects.isEmpty()) {
            cmd = new FTCmdEventsEdit(this.getAppl(), this.getFrame(), names.toString(), selects, this);
            cmd.realiseDo();
        } else if (ftDef != null) {
            cmd = new FTCmdVarGateEdit(this.getAppl(), this.getFrame(), (FTVariable)ftDef, this);
            cmd.realiseDo();
        } else if (ftLink != null) {
            cmd = new FTCmdVarLinkEdit(this.getAppl(), this.getFrame(), (FTVariable)ftLink, this);
            cmd.realiseDo();
        }
    }

    private Pageable createPageable() {
        return this.createPageable(this.getAppl().getPageFormat(), this.getAppl().getPreferencies());
    }

    private Pageable createPageable(final PageFormat format, final Preferencies preferencies) {
        PageableThread thread = new PageableThread(this){

            @Override
            protected Pageable doCreatePageable() {
                FGBook fgBook = null;
                FTVariable ftVar = FGContentPanel.this.getSelectSingleInterneVariable(true);
                if (ftVar != null && !ftVar.equals(FGContentPanel.this._ftEquation.getTopEvent())) {
                    String msg = ResMsgArbor.msgFormat("MSG_ANSWER_PRINT_GATE", ftVar.getName());
                    int confirm = JOptionPane.showConfirmDialog(JOptionCecilia.getTopContainerOf(FGContentPanel.this), msg, FGContentPanel.this.getFrame().getTitle(), 0);
                    if (confirm == 0) {
                        fgBook = new FGBook(FGContentPanel.this._ftEquation, ftVar);
                    }
                }
                if (fgBook == null) {
                    fgBook = new FGBook(FGContentPanel.this._ftEquation);
                }
                fgBook.getContext().setLawManager(FGContentPanel.this.getAppl().getDAOFactory().getLawManager());
                fgBook.updateFromPreferencies(preferencies);
                fgBook.prepare();
                FGBookPrintable fgPageable = new FGBookPrintable(fgBook, format);
                fgPageable.updateFromPreferencies(preferencies);
                return fgPageable;
            }
        };
        thread.realiseDo();
        return thread.getPageable();
    }

    @Override
    public boolean print() {
        Pageable fgPageable = this.createPageable();
        if (fgPageable == null) {
            return false;
        }
        PrinterJob job = PrinterJob.getPrinterJob();
        job.setPageable(fgPageable);
        if (job.printDialog()) {
            try {
                job.print();
            }
            catch (PrinterException e) {
                e.printStackTrace();
            }
        }
        return true;
    }

    @Override
    public boolean preview() {
        Pageable fgPageable = this.createPageable();
        if (fgPageable == null) {
            return false;
        }
        FTContentPrintPreviewDlg dlg = new FTContentPrintPreviewDlg(JOptionCecilia.getWindowOf(this), fgPageable, this.getAppl(), new PrefFieldsCategory[]{(PrefFieldsCategory)this.getAppl().getPreferencies().getOptions(FTEquationViewPrintPreferencies.PREF_KEY)}){

            @Override
            public void updatePreferencies() {
                this.setBook(FGContentPanel.this.createPageable(this.getFormat(), this.getPreferencies()));
            }
        };
        dlg.setLocationRelativeTo(JOptionCecilia.getWindowOf(this));
        dlg.setVisible(true);
        return true;
    }

    @Override
    public IModel getModel(String key, File file) {
        if (key.equals("docbook.file") || key.equals("word.file")) {
            ExpBook book = this.prepareBook();
            if (ExpBookUtility.realiseExport(book, file, this)) {
                return new IModel.DefaultModel(key, file, this._ftEquation.getTopEvent().getName(), this._ftEquation.getDBFolder().getID());
            }
            return null;
        }
        _LOG.fine("Call getModel with unknown key: " + key);
        return null;
    }

    private ExpBook prepareBook() {
        ExpBook expBook = new ExpBook(this.getAppl().getDAOFactory());
        expBook.setPageFormat(this.getAppl().getPageFormat());
        expBook.setPreferencies(this.getAppl().getPreferencies());
        expBook.setInfo(new ExpObjectInfo(this._ftEquation.getDBFolder()));
        expBook.add(new ExpFTGeneral(this._ftEquation));
        expBook.add(new ExpFTComputeParameters(this._ftEquation));
        expBook.add(new ExpFTGraphicTree(this._ftEquation));
        return expBook;
    }

    @Override
    public CeciliaGUI getGUI() {
        return super.getGUI();
    }

    @Override
    public JComboBox getGUIZoom() {
        return (JComboBox)this.getGUI().getComponentAction("ZOOM_EDITOR");
    }

    @Override
    public JScrollPane getScrollView() {
        return this._scrollView;
    }

    @Override
    public Rectangle getSelectionRect() {
        this.getContentView().setSize(this.getContentView().getPreferredSize());
        if (this.getContentView().getPivot() == null) {
            return null;
        }
        int minX = Integer.MAX_VALUE;
        int minY = Integer.MAX_VALUE;
        int maxX = Integer.MIN_VALUE;
        int maxY = Integer.MIN_VALUE;
        Iterator<FGVariable> fgVarsIterator = this.getContentView().getContent().iterator();
        while (fgVarsIterator.hasNext()) {
            FGVariable fgVar = fgVarsIterator.next();
            if (!fgVar.isPivot()) continue;
            Point p = this.getContentView().getContent().getPointForFGVariable(fgVar);
            double startX = (p.getX() - (double)(fgVar.getW() / 2)) * this.getZoom();
            double startY = (p.getY() - (double)(fgVar.getH() / 2)) * this.getZoom();
            double endX = startX + (double)fgVar.getW() * this.getZoom();
            double endY = startY + (double)fgVar.getH() * this.getZoom();
            minX = Math.min((int)startX, minX);
            minY = Math.min((int)startY, minY);
            maxX = Math.max((int)endX, maxX);
            maxY = Math.max((int)endY, maxY);
        }
        return new Rectangle(minX, minY, maxX - minX, maxY - minY);
    }

    @Override
    public double getZoom() {
        return this._contentView.getZoom();
    }

    @Override
    public void setZoom(double value) {
        this._contentView.setZoom(value);
    }
}

