/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.dbobj.faulttree.ft.gui;

import com.dassault.cecilia.core.swing.CeciliaAction;
import com.dassault.cecilia.core.swing.JDialogCecilia;
import com.dassault.cecilia.core.swing.JOptionCecilia;
import com.dassault.cecilia.dbobj.faulttree.ResMsgArbor;
import com.dassault.cecilia.dbobj.faulttree.ft.FTVariable;
import com.dassault.cecilia.dbobj.faulttree.ft.SelectionPackage;
import com.dassault.cecilia.dbobj.faulttree.ft.grf.FGContent;
import com.dassault.cecilia.dbobj.faulttree.ft.grf.FGContext;
import com.dassault.cecilia.dbobj.faulttree.ft.grf.FGScissorDepth;
import com.dassault.cecilia.dbobj.faulttree.ft.grf.FGVariable;
import com.dassault.cecilia.dbobj.faulttree.ft.gui.FGContentPanel;
import com.dassault.cecilia.dbobj.faulttree.obj.FTVariableAbstract;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComponent;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;

public class FGContentView
extends JComponent {
    FGContent _content = null;
    FGContext _context;
    double _zoom = 1.0;
    CtrlMouse _ctrlMouse;
    FGVariable _pivotVar = null;
    private boolean _bCouldPerhapsBeResized = true;
    private static final int ID_MOVE_LEFT = 0;
    private static final int ID_MOVE_RIGHT = 1;
    private static final int ID_MOVE_UP = 2;
    private static final int ID_MOVE_DOWN = 3;
    private CeciliaAction _editAction;
    boolean _bFirstPaint = false;

    private void setPivot(FGVariable var) {
        if (this._pivotVar == var) {
            return;
        }
        if (this._pivotVar != null) {
            this._pivotVar.setPivot(false);
        }
        this._pivotVar = var;
        if (this._pivotVar != null) {
            this._pivotVar.setPivot(true);
        }
    }

    public FGVariable getPivot() {
        return this._pivotVar;
    }

    private void setCouldPerhapsBeResized(boolean value) {
        this._bCouldPerhapsBeResized = value;
    }

    public boolean couldPerhapsBeResized() {
        return this._bCouldPerhapsBeResized;
    }

    public Point convertViewToLogical(Point pt) {
        double zoom = this.getInternalZoom();
        int dx = this.getWidth() - (int)((double)this._content.getWidth() * zoom);
        int dy = this.getHeight() - (int)((double)this._content.getHeight() * zoom);
        if (dx < 0) {
            dx = 0;
        }
        if (dy < 0) {
            dy = 0;
        }
        pt.x = (int)((double)(pt.x - dx / 2) / zoom);
        pt.y = (int)((double)(pt.y - dy / 2) / zoom);
        return pt;
    }

    public FGContentView(FGContext context) {
        this._context = context;
        this.setOpaque(true);
        this._ctrlMouse = new CtrlMouse();
        this.setAutoscrolls(true);
        this.addMouseListener(this._ctrlMouse);
        this.addMouseMotionListener(this._ctrlMouse);
        this.addKeyboardActions();
    }

    public void addKeyboardActions() {
        this.getInputMap().put(KeyStroke.getKeyStroke(10, 128, false), "moveSubTree");
        this.getInputMap().put(KeyStroke.getKeyStroke(37, 128, false), "moveLeft");
        this.getInputMap().put(KeyStroke.getKeyStroke(39, 128, false), "moveRight");
        this.getInputMap().put(KeyStroke.getKeyStroke(38, 128, false), "moveUp");
        this.getInputMap().put(KeyStroke.getKeyStroke(40, 128, false), "moveDown");
        this.getInputMap().put(KeyStroke.getKeyStroke(37, 192, false), "moveLeftShift");
        this.getInputMap().put(KeyStroke.getKeyStroke(39, 192, false), "moveRightShift");
        this.getInputMap().put(KeyStroke.getKeyStroke(40, 192, false), "moveDownShift");
        this.getInputMap().put(KeyStroke.getKeyStroke(10, 512, false), "edit");
        this.getInputMap().put(KeyStroke.getKeyStroke(38, 192, false), "goRoot");
        this.getActionMap().put("moveSubTree", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FGContentView.this.actionGoSubTree();
            }
        });
        this.getActionMap().put("moveLeft", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FGContentView.this.actionMovePort(0, false);
            }
        });
        this.getActionMap().put("moveRight", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FGContentView.this.actionMovePort(1, false);
            }
        });
        this.getActionMap().put("moveUp", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FGContentView.this.actionMovePort(2, false);
            }
        });
        this.getActionMap().put("moveDown", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FGContentView.this.actionMovePort(3, false);
            }
        });
        this.getActionMap().put("moveLeftShift", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FGContentView.this.actionMovePort(0, true);
            }
        });
        this.getActionMap().put("moveRightShift", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FGContentView.this.actionMovePort(1, true);
            }
        });
        this.getActionMap().put("moveUpShift", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FGContentView.this.actionMovePort(2, true);
            }
        });
        this.getActionMap().put("moveDownShift", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FGContentView.this.actionMovePort(3, true);
            }
        });
        this.getActionMap().put("edit", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FGContentView.this._editAction.actionPerformed(null);
            }
        });
        this.getActionMap().put("goRoot", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FGContentView.this.browse(BrowseOrientation.TOP);
                FGContentView.this.actionUnselectAll();
                FGContentView.this.setPivot(FGContentView.this._content.getTop());
                FGContentView.this._content.getTop().getVar().setSelected(true);
                SelectionPackage.ChangeSelectionEvent<FTVariableAbstract> evtChangeSelect = new SelectionPackage.ChangeSelectionEvent<FTVariableAbstract>(FGContentView.this._content.getTop().getVar(), true);
                FGContentView.this._content.getEquation().fireChangeSelection(evtChangeSelect, FGContentView.this);
            }
        });
    }

    private void actionUnselectAll() {
        ArrayList<FTVariableAbstract> setSelectedNode = new ArrayList<FTVariableAbstract>();
        Iterator<FGVariable> iterator = this._content.iterator();
        while (iterator.hasNext()) {
            FTVariableAbstract ftVar = iterator.next().getVar();
            if (setSelectedNode.contains(ftVar) || !ftVar.isSelected()) continue;
            setSelectedNode.add(ftVar);
            ftVar.setSelected(false);
        }
        if (!setSelectedNode.isEmpty()) {
            SelectionPackage.ChangeSelectionEvent<FTVariableAbstract> evtChangeSelect = new SelectionPackage.ChangeSelectionEvent<FTVariableAbstract>((FTVariableAbstract)setSelectedNode.remove(0), false, (Collection<FTVariableAbstract>)setSelectedNode);
            this._content.getEquation().fireChangeSelection(evtChangeSelect, this);
        }
    }

    private void actionGoSubTree() {
        FGVariable fgPivot = this.getPivot();
        if (fgPivot == null) {
            return;
        }
        FTVariableAbstract ftVar = fgPivot.getVar();
        List<FGVariable> children = fgPivot.getChildren();
        boolean refresh = false;
        if (children == null || children.isEmpty()) {
            boolean eDown = false;
            if (!(ftVar.isRoot() || fgPivot == this.getContent().getTop() || ftVar.getLink() == null && ftVar.getDefinition() == null)) {
                eDown = true;
            }
            if (eDown) {
                refresh = this.browse(BrowseOrientation.DOWN);
            }
        } else if (fgPivot.getParent() == null) {
            boolean eUp = false;
            FGVariable fgTop = this.getContent().getTop();
            if (fgTop == this.getContent().getTop() && !fgTop.getVar().isRoot()) {
                eUp = true;
            }
            if (eUp) {
                refresh = this.browse(BrowseOrientation.UP);
            }
        }
        if (refresh) {
            this.setCouldPerhapsBeResized(true);
            this._content.getEquation().fireChangeSelection(new SelectionPackage.ChangeSelectionEvent<FTVariableAbstract>(this._pivotVar.getVar(), true), this);
        }
    }

    public void setActionEdit(CeciliaAction actionEdit) {
        this._editAction = actionEdit;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void actionMovePort(int idMove, boolean keepSelection) {
        ArrayList<FTVariableAbstract> selectedNodeSet = new ArrayList<FTVariableAbstract>();
        Iterator<FGVariable> iterator = this._content.iterator();
        while (iterator.hasNext()) {
            FTVariableAbstract var = iterator.next().getVar();
            if (selectedNodeSet.contains(var) || !var.isSelected()) continue;
            selectedNodeSet.add(var);
        }
        if (selectedNodeSet.isEmpty()) {
            if (idMove != 3) return;
            this.setPivot(this._content.getTop());
            this._content.getTop().getVar().setSelected(true);
            SelectionPackage.ChangeSelectionEvent<FTVariableAbstract> evtChangeSelect = new SelectionPackage.ChangeSelectionEvent<FTVariableAbstract>(this._pivotVar.getVar(), true);
            this._content.getEquation().fireChangeSelection(evtChangeSelect, this);
        } else if (selectedNodeSet.size() == 1 || idMove == 3 || idMove == 2) {
            SelectionPackage.ChangeSelectionEvent<FTVariableAbstract> evtChangeSelect;
            fgVar = null;
            switch (idMove) {
                case 3: {
                    if (this.getPivot().getVar().isLeaf()) {
                        return;
                    }
                    List<FGVariable> children = this.getPivot().getChildren();
                    if (children == null || children.isEmpty()) {
                        return;
                    }
                    fgVar = children.get(0);
                    break;
                }
                case 2: {
                    if (this.getPivot().getParent() == null) {
                        this.getPivot().getVar().setSelected(false);
                        SelectionPackage.ChangeSelectionEvent<FTVariableAbstract> evtChangeSelect2 = new SelectionPackage.ChangeSelectionEvent<FTVariableAbstract>(this.getPivot().getVar(), false);
                        this._content.getEquation().fireChangeSelection(evtChangeSelect2, this);
                        this.setPivot(null);
                        return;
                    }
                    fgVar = this.getPivot().getParent();
                    break;
                }
                case 0: 
                case 1: {
                    if (this.getPivot().getVar().isRoot()) {
                        return;
                    }
                    FGVariable parent = this.getPivot().getParent();
                    if (parent == null) {
                        return;
                    }
                    int indexOfVar = parent.getChildren().indexOf(this.getPivot());
                    if (idMove == 1) {
                        if (indexOfVar == parent.getChildren().size() - 1) {
                            return;
                        }
                        fgVar = parent.getChildren().get(indexOfVar + 1);
                        break;
                    }
                    if (indexOfVar == 0) {
                        return;
                    }
                    fgVar = parent.getChildren().get(indexOfVar - 1);
                    break;
                }
            }
            if (fgVar == null) {
                return;
            }
            if (!fgVar.getVar().isSelected()) {
                fgVar.getVar().setSelected(true);
                this.setPivot(fgVar);
            } else {
                fgVar.getVar().setSelected(false);
            }
            if (!keepSelection || idMove == 3 || idMove == 2) {
                for (FTVariableAbstract varAbs : selectedNodeSet) {
                    varAbs.setSelected(false);
                }
                evtChangeSelect = new SelectionPackage.ChangeSelectionEvent<FTVariableAbstract>(fgVar.getVar(), false, (Collection<FTVariableAbstract>)selectedNodeSet);
                this._content.getEquation().fireChangeSelection(evtChangeSelect, this);
            }
            evtChangeSelect = new SelectionPackage.ChangeSelectionEvent<FTVariableAbstract>(fgVar.getVar(), true);
            this._content.getEquation().fireChangeSelection(evtChangeSelect, this);
        } else {
            SelectionPackage.ChangeSelectionEvent<FTVariableAbstract> evtChangeSelect;
            int limit;
            fgVar = null;
            FGVariable pivot = this.getPivot();
            FGVariable parent = pivot.getParent();
            List<FGVariable> vars = parent.getChildren();
            boolean hasToBeSelected = false;
            boolean nextIsNewPivot = false;
            LinkedHashSet<FTVariableAbstract> varsToSelect = new LinkedHashSet<FTVariableAbstract>();
            int i = idMove == 0 ? vars.size() - 1 : 0;
            int n = limit = idMove == 0 ? 0 : vars.size();
            while (idMove == 0 ? i >= limit : i < limit) {
                FGVariable var = vars.get(i);
                FTVariableAbstract varAbs = var.getVar();
                if (hasToBeSelected && !varAbs.isSelected()) {
                    varsToSelect.add(var.getVar());
                }
                hasToBeSelected = varAbs.isSelected();
                if (nextIsNewPivot) {
                    fgVar = var;
                    nextIsNewPivot = false;
                }
                if (var == this.getPivot()) {
                    nextIsNewPivot = true;
                }
                i = idMove == 0 ? i - 1 : i + 1;
            }
            if (fgVar == null) {
                fgVar = this.getPivot();
            }
            if (!keepSelection) {
                evtChangeSelect = new SelectionPackage.ChangeSelectionEvent<FTVariableAbstract>((FTVariableAbstract)selectedNodeSet.iterator().next(), false, (Collection<FTVariableAbstract>)selectedNodeSet);
                this._content.getEquation().fireChangeSelection(evtChangeSelect, this);
                for (FTVariableAbstract ftVar : selectedNodeSet) {
                    ftVar.setSelected(false);
                }
            }
            evtChangeSelect = new SelectionPackage.ChangeSelectionEvent<FTVariableAbstract>(fgVar.getVar(), true, (Collection<FTVariableAbstract>)varsToSelect);
            this._content.getEquation().fireChangeSelection(evtChangeSelect, this);
            fgVar.getVar().setSelected(true);
            this.setPivot(fgVar);
            evtChangeSelect = new SelectionPackage.ChangeSelectionEvent<FTVariableAbstract>(fgVar.getVar(), true);
            this._content.getEquation().fireChangeSelection(evtChangeSelect, this);
        }
        FGContentPanel panel = (FGContentPanel)this.getParent().getParent().getParent();
        panel.refreshScroll(Collections.singleton(this.getPivot().getVar()));
    }

    public FGContent getContent() {
        return this._content;
    }

    public void setContent(FGContent content) {
        this._content = content;
    }

    public FGContext getContext() {
        return this._context;
    }

    private double getInternalZoom() {
        return this._zoom * 1.0;
    }

    public double getZoom() {
        return this._zoom;
    }

    public void setZoom(double zoom) {
        this._zoom = zoom;
        if (this._context != null) {
            this._context.setZoom(this.getInternalZoom());
        }
    }

    @Override
    public Dimension getPreferredSize() {
        int h;
        int w;
        double zoom = this.getInternalZoom();
        if (zoom == 1.0) {
            w = this._content.getWidth();
            h = this._content.getHeight();
        } else {
            w = (int)((double)this._content.getWidth() * zoom) + 1;
            h = (int)((double)this._content.getHeight() * zoom) + 1;
        }
        return new Dimension(w + 20, h + 20);
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2 = (Graphics2D)g;
        if (!this._bFirstPaint) {
            this._bFirstPaint = true;
            this._content.computeSize(g2, this._context);
            this.revalidate();
        }
        g2.setColor(Color.white);
        g2.fillRect(0, 0, this.getWidth(), this.getHeight());
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        double zoom = this.getInternalZoom();
        int dx = this.getWidth() - (int)((double)this._content.getWidth() * zoom);
        int dy = this.getHeight() - (int)((double)this._content.getHeight() * zoom);
        if (dx < 0) {
            dx = 0;
        }
        if (dy < 0) {
            dy = 0;
        }
        g2.translate(dx / 2, dy / 2);
        this._content.paint(g2, this._context);
    }

    public void setPivot(FTVariableAbstract ftVar, FTVariableAbstract parent) {
        this.refreshPivot(ftVar, parent);
    }

    public boolean changeLevel(int parseInt) {
        FTVariableAbstract ftPivot = this._pivotVar != null ? this._pivotVar.getVar() : null;
        boolean result = this._content.setScissor(new FGScissorDepth(parseInt));
        this.refreshPivot(ftPivot, null);
        return result;
    }

    public boolean browse(BrowseOrientation orientation) {
        switch (orientation) {
            case TOP: {
                this._content.browse(this._content.getEquation().getTopEvent());
                this.refreshPivot(this._content.getEquation().getTopEvent(), null);
                FTVariable ftRoot = this._content.getEquation().getTopEvent();
                if (!ftRoot.isSelected()) {
                    ftRoot.setSelected(true);
                    SelectionPackage.ChangeSelectionEvent<FTVariableAbstract> evtChangeSelect = new SelectionPackage.ChangeSelectionEvent<FTVariableAbstract>((FTVariableAbstract)ftRoot, true, 16);
                    Iterator<FGVariable> iterator = this._content.iterator();
                    while (iterator.hasNext()) {
                        FTVariableAbstract var = iterator.next().getVar();
                        if (var == ftRoot || !var.isSelected()) continue;
                        var.setSelected(false);
                        evtChangeSelect.addOther(var);
                    }
                    this._content.getEquation().fireChangeSelection(evtChangeSelect, this);
                }
                return true;
            }
            case NONE: {
                FTVariableAbstract ftPivot = this._pivotVar != null ? this._pivotVar.getVar() : null;
                this._content.browse(this._content.getTop().getVar());
                this.refreshPivot(ftPivot, null);
                return true;
            }
            case UP: {
                return this.browseUp();
            }
            case DOWN: {
                if (this._pivotVar == null) break;
                FTVariableAbstract ftVar = this._pivotVar.getVar();
                this._content.browse(ftVar);
                this.refreshPivot(ftVar, null);
                return true;
            }
        }
        return false;
    }

    private boolean browseUp() {
        FTVariableAbstract ftChild = this._content.getTop().getVar();
        List<List<FTVariableAbstract>> paths = this._content.getEquation().findPaths(null, ftChild, false);
        List<FTVariableAbstract> path = null;
        if (paths.size() == 1) {
            path = paths.get(0);
        } else if (paths.size() > 1) {
            path = this.selectPath(paths, ftChild);
        }
        if (path != null && path.size() >= 1) {
            FTVariableAbstract ftPivot = this._pivotVar != null ? this._pivotVar.getVar() : null;
            FTVariableAbstract ftVar = path.get(path.size() - 1);
            this._content.browse(ftVar);
            this.refreshPivot(ftPivot, null);
            if (this.getPivot() == null) {
                this.refreshPivot(ftVar, null);
            }
            return true;
        }
        return false;
    }

    private void refreshPivot(FTVariableAbstract ftPivot, FTVariableAbstract ftParent) {
        this.setPivot(null);
        if (ftPivot == null) {
            return;
        }
        Iterator<FGVariable> iter = this._content.iterator();
        while (this.getPivot() == null && iter.hasNext()) {
            FGVariable fgVar = iter.next();
            if (fgVar.getVar() != ftPivot || ftParent != null && !fgVar.getParent().getVar().equals(ftParent)) continue;
            this.setPivot(fgVar);
        }
    }

    private List<FTVariableAbstract> selectPath(List<List<FTVariableAbstract>> paths, FTVariableAbstract ftChild) {
        Window win = SwingUtilities.getWindowAncestor(this);
        SelectPathDlg dlg = new SelectPathDlg(win, paths, ftChild);
        JInternalFrame iframe = (JInternalFrame)SwingUtilities.getAncestorOfClass(JInternalFrame.class, this);
        if (iframe != null) {
            dlg.setLocationRelativeTo(iframe);
            dlg.setTitle(iframe.getTitle());
        } else {
            dlg.setLocationRelativeTo(JOptionCecilia.getTopContainerOf(this));
            dlg.setTitle("<???>");
        }
        dlg.setVisible(true);
        if (dlg.getResult()) {
            return dlg.getSelectPath();
        }
        return null;
    }

    public void browseByPath(List<FTVariableAbstract> currentPath, FTVariableAbstract var) {
        this.browse(BrowseOrientation.TOP);
        FGVariable fgVar = this.getContent().getTop();
        assert (fgVar.getVar().equals(currentPath == null || currentPath.isEmpty() ? var : currentPath.get(0)));
        block0: for (FTVariableAbstract varAbs : currentPath) {
            if (varAbs.equals(fgVar.getVar())) continue;
            if (fgVar.getChildren() != null) {
                for (FGVariable child : fgVar.getChildren()) {
                    if (!child.getVar().equals(varAbs)) continue;
                    fgVar = child;
                    continue block0;
                }
                continue;
            }
            this._content.browse(varAbs);
            fgVar = this.getContent().getTop();
        }
        if (fgVar.getChildren() == null) {
            this._content.browse(fgVar.getVar());
        }
        if (fgVar.getChildren() == null) {
            fgVar = this._content.getTop();
        }
        for (FGVariable child : fgVar.getChildren()) {
            if (!child.getVar().equals(var)) continue;
            this.setPivot(child);
            return;
        }
    }

    class CtrlMouse
    extends MouseAdapter {
        int _originX;
        int _originY;
        int _currentX;
        int _currentY;

        CtrlMouse() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (!FGContentView.this.hasFocus()) {
                FGContentView.this.requestFocus();
            }
            this._currentX = this._originX = e.getX();
            this._currentY = this._originY = e.getY();
            double zoom = FGContentView.this.getInternalZoom();
            int dx = FGContentView.this.getWidth() - (int)((double)FGContentView.this._content.getWidth() * zoom);
            int dy = FGContentView.this.getHeight() - (int)((double)FGContentView.this._content.getHeight() * zoom);
            if (dx < 0) {
                dx = 0;
            }
            if (dy < 0) {
                dy = 0;
            }
            int x = (int)((double)(this._originX - dx / 2) / zoom);
            int y = (int)((double)(this._originY - dy / 2) / zoom);
            FGContentView.this.setPivot(FGContentView.this._content.getGraphAtPoint(x, y));
            SelectionPackage.ChangeSelectionEvent<FTVariableAbstract> evtChangeSelect = null;
            if (FGContentView.this._pivotVar != null) {
                boolean bSrcWasSelected = FGContentView.this._pivotVar.getVar().isSelected();
                if (e.isShiftDown()) {
                    if (e.isPopupTrigger()) {
                        if (!bSrcWasSelected) {
                            evtChangeSelect = new SelectionPackage.ChangeSelectionEvent<FTVariableAbstract>(FGContentView.this._pivotVar.getVar(), true);
                            FGContentView.this._pivotVar.getVar().setSelected(true);
                        }
                    } else {
                        evtChangeSelect = new SelectionPackage.ChangeSelectionEvent<FTVariableAbstract>(FGContentView.this._pivotVar.getVar(), !FGContentView.this._pivotVar.getVar().isSelected());
                        FGContentView.this._pivotVar.getVar().setSelected(!FGContentView.this._pivotVar.getVar().isSelected());
                        if (!FGContentView.this._pivotVar.getVar().isSelected()) {
                            FGContentView.this.setPivot(null);
                        }
                    }
                } else {
                    evtChangeSelect = new SelectionPackage.ChangeSelectionEvent<FTVariableAbstract>(FGContentView.this._pivotVar.getVar(), true, 16);
                    Iterator<FGVariable> iterator = FGContentView.this._content.iterator();
                    while (iterator.hasNext()) {
                        FTVariableAbstract var = iterator.next().getVar();
                        if (!var.isSelected()) continue;
                        var.setSelected(false);
                        evtChangeSelect.addOther(var);
                    }
                    if (!FGContentView.this._pivotVar.getVar().isSelected()) {
                        FGContentView.this._pivotVar.getVar().setSelected(true);
                    }
                }
            } else {
                ArrayList<FTVariableAbstract> deselect = new ArrayList<FTVariableAbstract>(16);
                Iterator<FGVariable> iterator = FGContentView.this._content.iterator();
                while (iterator.hasNext()) {
                    FTVariableAbstract var = iterator.next().getVar();
                    if (!var.isSelected()) continue;
                    var.setSelected(false);
                    deselect.add(var);
                }
                if (deselect.size() > 0) {
                    evtChangeSelect = new SelectionPackage.ChangeSelectionEvent<FTVariableAbstract>((FTVariableAbstract)deselect.remove(0), false, (Collection<FTVariableAbstract>)deselect);
                }
            }
            if (evtChangeSelect != null) {
                FGContentView.this._content.getEquation().fireChangeSelection(evtChangeSelect, FGContentView.this);
            }
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            FGContentView.this.scrollRectToVisible(new Rectangle(e.getX(), e.getY(), 1, 1));
        }
    }

    public static enum BrowseOrientation {
        TOP,
        DOWN,
        UP,
        NONE;

    }

    static class SelectPathDlg
    extends JDialogCecilia {
        JList _ctrlList = new JList();

        SelectPathDlg(Window win, List<List<FTVariableAbstract>> paths, FTVariableAbstract ftChild) {
            super(win, true);
            this._ctrlList.setListData(paths.toArray());
            this._ctrlList.setCellRenderer(new DefaultListCellRenderer(){

                @Override
                public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                    super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                    List item = (List)value;
                    String parent = null;
                    int idxParent = item.size() - 1;
                    StringBuilder sb = new StringBuilder();
                    sb.append("<html>");
                    for (int i = 0; i < item.size(); ++i) {
                        for (int j = i; j > 0; --j) {
                            sb.append("&nbsp;&nbsp;");
                        }
                        if (i == idxParent) {
                            parent = ((FTVariableAbstract)item.get(i)).getName();
                            sb.append("<b>");
                        }
                        sb.append(((FTVariableAbstract)item.get(i)).getName());
                        if (i == idxParent) {
                            sb.append("</b>");
                        }
                        sb.append("<br/>");
                    }
                    sb.append("</html>");
                    if (parent == null) {
                        this.setText("<???>");
                        this.setToolTipText(null);
                    } else {
                        this.setText(parent);
                        this.setToolTipText(sb.toString());
                    }
                    return this;
                }
            });
            this._ctrlList.setSelectionMode(0);
            this._ctrlList.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (e.getClickCount() < 2) {
                        return;
                    }
                    if (!SwingUtilities.isLeftMouseButton(e)) {
                        return;
                    }
                    this.validDialog();
                }
            });
            JScrollPane scroll = new JScrollPane(this._ctrlList);
            scroll.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
            this.getContentPane().setLayout(new BorderLayout());
            this.getContentPane().add((Component)scroll, "Center");
            JLabel label = new JLabel(ResMsgArbor.msgFormat("LBL_BROWSE_UP_CONFLICT", ftChild.getName()));
            label.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
            this.getContentPane().add((Component)label, "North");
            this.getContentPane().add((Component)this.createButPanel(true), "South");
            this.init();
            this.pack();
            this.setModal(true);
        }

        @Override
        protected boolean verifyParameters() {
            return this._ctrlList.getSelectedValue() != null;
        }

        public List<FTVariableAbstract> getSelectPath() {
            return (List)this._ctrlList.getSelectedValue();
        }
    }
}

