/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.dbobj.faulttree.ft.gui;

import com.dassault.cecilia.core.ResMsgVoc;
import com.dassault.cecilia.core.cecilia.CAppl;
import com.dassault.cecilia.core.cecilia.pref.PrefFieldsCategory;
import com.dassault.cecilia.core.cecilia.pref.PrintPreviewPrefsDlg;
import com.dassault.cecilia.dbobj.faulttree.ft.grf.FGBook;
import com.dassault.cecilia.dbobj.faulttree.ft.grf.FGBookPrintable;
import com.dassault.cecilia.dbobj.faulttree.ft.grf.FGContent;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.print.PageFormat;
import java.awt.print.Pageable;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumnModel;

public abstract class FTContentPrintPreviewDlg
extends PrintPreviewPrefsDlg {
    PrintPreviewPrefsTableModel _model;
    JTable _table;
    JScrollPane _scrollPaneTable;

    public FTContentPrintPreviewDlg(Window owner, Pageable book, CAppl appl, PrefFieldsCategory ... prefFields) {
        super(owner, book, appl, prefFields);
    }

    @Override
    protected void updateBrowse() {
        super.updateBrowse();
        this._table.setRowSelectionInterval(this._currentPage, this._currentPage);
        this._table.scrollRectToVisible(new Rectangle(this._table.getCellRect(this._currentPage, 0, true)));
        this._table.revalidate();
    }

    @Override
    public void setBook(Pageable book) {
        super.setBook(book);
        this._model.setBook(book);
    }

    @Override
    protected Component createCenter() {
        super.createCenter();
        JPanel tablePane = new JPanel(new BorderLayout());
        this._model = new PrintPreviewPrefsTableModel(this._book);
        this._table = new JTable(this._model){

            @Override
            public void createDefaultColumnsFromModel() {
                super.createDefaultColumnsFromModel();
                TableColumnModel colModel = this.getColumnModel();
                colModel.getColumn(0).setPreferredWidth(60);
                colModel.getColumn(1).setPreferredWidth(160);
                colModel.getColumn(2).setPreferredWidth(80);
            }
        };
        this._table.setSelectionMode(0);
        this._table.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent event) {
                if (FTContentPrintPreviewDlg.this._table.getSelectedRow() > -1) {
                    FTContentPrintPreviewDlg.this._currentPage = FTContentPrintPreviewDlg.this._table.getSelectedRow();
                    FTContentPrintPreviewDlg.this._ctrlPreview.changeCurrentPage(FTContentPrintPreviewDlg.this._currentPage);
                    FTContentPrintPreviewDlg.this.updateBrowse();
                }
            }
        });
        this._table.setDefaultRenderer(String.class, new DefaultTableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                this.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 5));
                return this;
            }
        });
        this._table.setDefaultRenderer(Double.class, new DefaultTableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                if (value != null && value instanceof Double) {
                    double dvalue = (Double)value;
                    if (dvalue >= 1.0) {
                        this.setText("100%");
                        if (isSelected) {
                            this.setBackground(new Color(0, 192, 0));
                        } else {
                            this.setBackground(Color.GREEN);
                        }
                        this.setForeground(Color.BLACK);
                    } else if (dvalue >= 0.8) {
                        this.setText((int)(dvalue * 100.0) + "%");
                        if (isSelected) {
                            this.setBackground(new Color(192, 125, 0));
                        } else {
                            this.setBackground(Color.ORANGE);
                        }
                        this.setForeground(Color.BLACK);
                    } else {
                        this.setText((int)(dvalue * 100.0) + "%");
                        if (isSelected) {
                            this.setBackground(new Color(192, 0, 0));
                        } else {
                            this.setBackground(Color.RED);
                        }
                        this.setForeground(Color.WHITE);
                    }
                    this.setHorizontalTextPosition(0);
                    this.setHorizontalAlignment(0);
                }
                return this;
            }
        });
        this._scrollPaneTable = new JScrollPane(this._table);
        tablePane.add((Component)this._scrollPaneTable, "Center");
        JSplitPane splitPane = new JSplitPane(1, tablePane, this._scrollView);
        splitPane.setDividerLocation(300);
        return splitPane;
    }

    @Override
    protected synchronized void doPreferenciesAction() {
        super.doPreferenciesAction();
        this._table.repaint();
        this._scrollPaneTable.revalidate();
    }

    private static class PrintPreviewPrefsTableModel
    extends DefaultTableModel {
        public static final int IDX_NUM_PAGE = 0;
        public static final int IDX_NAME_PAGE = 1;
        public static final int IDX_SCALE_PAGE = 2;
        private Pageable _book;

        public PrintPreviewPrefsTableModel(Pageable book) {
            this._book = book;
        }

        public final void setBook(Pageable book) {
            this._book = book;
        }

        @Override
        public int getColumnCount() {
            return 3;
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            switch (columnIndex) {
                case 1: {
                    return String.class;
                }
                case 0: {
                    return Integer.class;
                }
                case 2: {
                    return Double.class;
                }
            }
            assert (false);
            return String.class;
        }

        @Override
        public String getColumnName(int column) {
            switch (column) {
                case 0: {
                    return ResMsgVoc.getString("VOC_NUMBER");
                }
                case 1: {
                    return ResMsgVoc.getString("VOC_NAME");
                }
                case 2: {
                    return ResMsgVoc.getString("VOC_ZOOM");
                }
            }
            assert (false);
            return null;
        }

        @Override
        public int getRowCount() {
            return this._book != null ? this._book.getNumberOfPages() : 0;
        }

        @Override
        public Object getValueAt(int row, int column) {
            switch (column) {
                case 0: {
                    return row + 1;
                }
                case 1: {
                    if (this._book instanceof FGBookPrintable) {
                        FGBook fgBook = ((FGBookPrintable)this._book).getBook();
                        return fgBook.getPageAt(row).getTopVar().getName();
                    }
                    return null;
                }
                case 2: {
                    if (this._book instanceof FGBookPrintable) {
                        FGBook fgBook = ((FGBookPrintable)this._book).getBook();
                        FGContent content = fgBook.getPageAt(row).getContent();
                        PageFormat pf = this._book.getPageFormat(row);
                        double pfWidth = pf.getImageableWidth() * 2.0;
                        double pfHeight = pf.getImageableHeight() * 2.0;
                        return Math.min(pfWidth / (double)content.getWidth(), pfHeight / (double)content.getHeight());
                    }
                    return 1;
                }
            }
            assert (false);
            return null;
        }

        @Override
        public boolean isCellEditable(int row, int column) {
            return false;
        }
    }
}

