/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.dbobj.faulttree.ft.gui;

import com.dassault.cecilia.core.ResMsgVoc;
import com.dassault.cecilia.db.DBFolder;
import com.dassault.cecilia.dbobj.faulttree.config.FTConfig;
import com.dassault.cecilia.dbobj.faulttree.ft.FTEquation;
import com.dassault.cecilia.dbobj.faulttree.ft.gui.FTEquationFrame;
import com.dassault.cecilia.dbobj.general.log.DBLogs;
import com.dassault.cecilia.dbobj.general.log.gui.DBLogsDlg;
import com.dassault.cecilia.dbobj.wrap.DBWrap;
import com.dassault.cecilia.dbobj.wrap.DBWrapCmdEdit;
import com.dassault.cecilia.main.cecilia.CeciliaAppl;
import com.dassault.cecilia.main.cecilia.gui.DBInternalFrame;
import java.awt.Component;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;

public class FTEquationCmdEdit
extends DBWrapCmdEdit {
    private static Logger _LOG = Logger.getLogger(FTEquationCmdEdit.class.getPackage().getName());

    public FTEquationCmdEdit(CeciliaAppl appl, Component c, DBFolder folder, boolean readOnly) {
        super(appl, c, folder, readOnly);
    }

    @Override
    protected DBFolder.Family getFamily() {
        return DBFolder.Family.PROJECT;
    }

    @Override
    protected String getLabel() {
        return ResMsgVoc.getString("VOC_TREE");
    }

    @Override
    protected DBWrap readWrap(DBFolder folder) {
        DBWrap wrap = super.readWrap(folder);
        if (wrap == null) {
            return null;
        }
        FTEquation ftEqu = (FTEquation)wrap;
        try {
            ftEqu = ftEqu.getCopy();
        }
        catch (Throwable th) {
            _LOG.log(Level.WARNING, "Copy d'une variable externe ?", th);
            return null;
        }
        for (FTConfig ftCfg : ftEqu.getConfigs()) {
            ftCfg.validateConfig(ftEqu.getDBFolder(), ftEqu.getWorkingRelations(), this.getAppl().getDAOFactory(), true);
        }
        if (!ftEqu.instanciate(true, this.getAppl().getDBUser())) {
            DBLogsDlg logsDlg = new DBLogsDlg(SwingUtilities.getWindowAncestor(this.getSource()), DBLogs.DBLevel.INFO);
            logsDlg.setDBLogs(ftEqu.getInstanciateLogs(), folder, this.getAppl().getDBUser().getLogin());
            logsDlg.addDependLogs(this.generateDependLogs(wrap));
            logsDlg.refreshData();
            logsDlg.setVisible(true);
            ftEqu.setManuelInstanciate(true);
        }
        ftEqu.defineLockedVariables();
        if (!ftEqu.getManuelInstanciate() && !ftEqu.readCurrentResults(this.getAppl().getDBUser(), this.getAppl().getDAOFactory())) {
            ftEqu.clearResults();
        }
        return ftEqu;
    }

    @Override
    protected DBInternalFrame editWrap(DBWrap wrap, boolean readOnly) {
        FTEquation ftEquation = (FTEquation)wrap;
        FTEquationFrame iframe = new FTEquationFrame(ftEquation, this.getAppl());
        this.verifyLogsLevel(iframe.getLogs().getMaxLevel());
        iframe.setEditable(!readOnly);
        iframe.showView(this.getAppl().getTopWindow().getDesktop());
        if (ftEquation.getInstanciateLogs().withLogs(DBLogs.DBLevel.INFO)) {
            final DBLogsDlg logsDlg = new DBLogsDlg(SwingUtilities.getWindowAncestor(this.getSource()), DBLogs.DBLevel.INFO);
            logsDlg.setDBLogs(ftEquation.getInstanciateLogs(), ftEquation.getDBFolder(), this.getAppl().getDBUser().getLogin());
            logsDlg.addDependLogs(this.generateDependLogs(wrap));
            logsDlg.refreshData();
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    logsDlg.setVisible(true);
                }
            });
        }
        return iframe;
    }
}

