/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.dbobj.faulttree.ft.gui;

import com.dassault.cecilia.core.cecilia.pref.GeneralTextPreferencies;
import com.dassault.cecilia.core.plugin.InfoDatum;
import com.dassault.cecilia.core.plugin.PluginWithOptions;
import com.dassault.cecilia.db.DBFolder;
import com.dassault.cecilia.db.DBObjModel;
import com.dassault.cecilia.dbobj.faulttree.TreeInfoCompute;
import com.dassault.cecilia.dbobj.faulttree.config.FTConfig;
import com.dassault.cecilia.dbobj.faulttree.ft.FTComputeGenerator;
import com.dassault.cecilia.dbobj.faulttree.ft.FTComputeParameters;
import com.dassault.cecilia.dbobj.faulttree.ft.FTEquation;
import com.dassault.cecilia.dbobj.faulttree.ft.gui.FTComputeDlgSelect;
import com.dassault.cecilia.dbobj.faulttree.obj.FTVariableAbstract;
import com.dassault.cecilia.dbobj.general.log.DBLogs;
import com.dassault.cecilia.dbobj.project.DBProject;
import com.dassault.cecilia.dbobj.wrap.DBWrap;
import com.dassault.cecilia.lib.util.format.StringUtilities;
import com.dassault.cecilia.main.cecilia.CeciliaAppl;
import java.awt.Component;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;

public class FTEquationDatumUtility {
    private static Logger _LOG = Logger.getLogger(FTEquationDatumUtility.class.getPackage().getName());
    FTEquation _ftEquation;
    DBFolder _dbFolder;
    CeciliaAppl _application;
    Component _owner;

    public FTEquationDatumUtility(FTEquation ftEquation, Component owner, CeciliaAppl appl) {
        this._ftEquation = ftEquation;
        this._dbFolder = ftEquation.getDBFolder();
        this._application = appl;
        this._owner = owner;
    }

    public TreeInfoCompute getDatum(String key) {
        String crcDag;
        File file;
        String crcXml;
        File fileXml;
        String strConfig;
        DBProject project;
        if (!key.startsWith("Tree.Compute.")) {
            return null;
        }
        _LOG.finer("Call getDatum('" + key + "', ...)");
        String strType = null;
        FTConfig ftConfig = null;
        FTVariableAbstract ftRoot = null;
        if (!this._ftEquation.instanciate(false, this._application.getDBUser())) {
            _LOG.severe("L'\u00e9quation n'a pas pu \u00eatre instanci\u00e9e.");
            return null;
        }
        if (this._ftEquation.getCriticityLevel() != null && (project = this.getProjectObj()) == null) {
            _LOG.severe("Le Projet a \u00e9t\u00e9 modifi\u00e9 entre temps, et est par cons\u00e9quent \u00e9gale \u00e0 null.");
            return null;
        }
        if (key.startsWith("Tree.Compute.")) {
            strType = key.substring("Tree.Compute.".length());
        }
        if (strType.indexOf("@") != -1) {
            strConfig = null;
            String strRoot = null;
            int idx = strType.indexOf("@");
            strConfig = strType.substring(idx + 1);
            strType = strType.substring(0, idx);
            if (strConfig.indexOf("@") != -1) {
                idx = strConfig.indexOf("@");
                strRoot = strConfig.substring(idx + 1);
                strConfig = strConfig.substring(0, idx);
            }
            if ((ftConfig = this._ftEquation.getConfig(strConfig)) == null) {
                if (!this._ftEquation.getConfigs().isEmpty() || !strConfig.equalsIgnoreCase("Default")) {
                    _LOG.info("L'equation booleenne '" + this._ftEquation.getDBFolder().getRefPath() + "' n'a pas de configuration : " + strConfig);
                    return null;
                }
            } else if (!ftConfig.verifyRight(this._application.getDBUser(), this._application.getDAOFactory())) {
                _LOG.severe("Probleme de droit d'integration pour l'arbre '" + this._ftEquation.getDBFolder().getRefPath() + "' et pour la configuration selectionnee : " + strConfig);
                return null;
            }
            if (strRoot != null) {
                ftRoot = this._ftEquation.getVariable(strRoot);
                if (ftRoot == null) {
                    _LOG.info("L'equation booleenne '" + this._ftEquation.getDBFolder().getRefPath() + "' n'a pas de variable : " + strRoot);
                    return null;
                }
            } else {
                ftRoot = this._ftEquation.getTopEvent();
            }
        } else {
            if (ftConfig == null) {
                ftConfig = this._ftEquation.getConfig("Default");
            }
            if (ftRoot == null) {
                ftRoot = this._ftEquation.getTopEvent();
            }
            try {
                ArrayList<FTVariableAbstract> roots = new ArrayList<FTVariableAbstract>();
                roots.add(ftRoot);
                for (FTVariableAbstract ftVar : this._ftEquation.getAllVariables()) {
                    if (ftVar == ftRoot || !ftVar.isIntern() || ftVar.isLeaf() || !ftVar.isSelected()) continue;
                    roots.add(ftVar);
                }
                boolean withVerifyRight = false;
                ArrayList<FTConfig> configs = new ArrayList<FTConfig>(this._ftEquation.getConfigs());
                for (FTConfig fTConfig : this._ftEquation.getConfigs()) {
                    if (fTConfig.verifyRight(this._application.getDBUser(), this._application.getDAOFactory())) continue;
                    withVerifyRight = true;
                }
                if (configs != null && configs.size() > 1 || withVerifyRight || roots.size() > 1) {
                    if (this.isACritCompute()) {
                        boolean hasACritCompute = false;
                        for (FTConfig config : configs) {
                            if (!config.isCritCompute()) continue;
                            if (!config.getLastVerifyRight()) {
                                _LOG.info("La configuration pour le calcul de criticit\u00e9 de l'equation booleenne '" + this._ftEquation.getDBFolder().getRefPath() + "' n'est pas exploitable par l'utilisateur courant (" + this._application.getDBUser().getLogin() + ").");
                                return null;
                            }
                            ftConfig = config;
                            hasACritCompute = true;
                            break;
                        }
                        if (!hasACritCompute) {
                            _LOG.info("L'equation booleenne '" + this._ftEquation.getDBFolder().getRefPath() + "' n'a pas de configuration pour le calcul de criticit\u00e9.");
                            return null;
                        }
                        ftRoot = this._ftEquation.getTopEvent();
                    } else {
                        FTComputeDlgSelect dlg = new FTComputeDlgSelect(SwingUtilities.getWindowAncestor(this._owner));
                        if (!dlg.display(roots, ftRoot, configs, ftConfig)) {
                            return null;
                        }
                        ftConfig = dlg.getConfig();
                        ftRoot = dlg.getRoot();
                    }
                } else if (configs != null && configs.size() == 1) {
                    ftConfig = configs.get(0);
                }
            }
            catch (Exception e) {
                _LOG.log(Level.SEVERE, "Exception", e);
                return null;
            }
        }
        strConfig = "Default";
        boolean useCCF = false;
        FTComputeGenerator ftEquCompute = new FTComputeGenerator(this._ftEquation);
        PluginWithOptions pref = this._application.getPreferencies().getOptions(GeneralTextPreferencies.PREF_KEY);
        if (pref != null && pref instanceof GeneralTextPreferencies) {
            ftEquCompute.setDateFormat(((GeneralTextPreferencies)pref).getDateFormat());
        }
        if (ftConfig != null) {
            if (!ftConfig.validateConfig(this._ftEquation.getDBFolder(), this._ftEquation.getWorkingRelations(), this._application.getDAOFactory(), false)) {
                _LOG.info("::getDatum(): !" + ftConfig.getName() + ".validateConfig(...)");
            }
            strConfig = ftConfig.getName();
        }
        ftEquCompute.prepareWith(ftConfig, ftRoot);
        try {
            fileXml = File.createTempFile("TreeModelEvent", ".xml");
            crcXml = ftEquCompute.generateModelEvents(fileXml, ftRoot, useCCF, ftConfig, this._application.getDAOFactory(), this._application.getDBUser());
            file = File.createTempFile("TreeEquation", ".dag");
            crcDag = ftEquCompute.generateEquation(file, this._application.getDAOFactory());
        }
        catch (IOException e) {
            _LOG.log(Level.INFO, "IOException", e);
            TreeInfoCompute ierror = new TreeInfoCompute(key, strType, this._dbFolder.getID());
            ierror.getParameters().put("tree.error", e.getMessage());
            return ierror;
        }
        catch (Exception e) {
            _LOG.log(Level.SEVERE, "Exception", e);
            return null;
        }
        String mapKey = strType + "." + strConfig;
        if (!ftRoot.equals(this._ftEquation.getTopEvent())) {
            TreeInfoCompute icompute = new TreeInfoCompute(key, strType, this._dbFolder.getID());
            icompute.getInputFiles().put("ceciliabdd.file.dag", file);
            icompute.getInputFiles().put("ceciliabdd.file.xml", fileXml);
            Map<String, String> params = icompute.getParameters();
            params.put("Config", strConfig);
            params.put("CRC", crcDag);
            params.put("CRC.Xml", crcXml);
            params.put("Root", ftRoot.getName());
            params.put("User", this._application.getDBUser().getLogin());
            return icompute;
        }
        TreeInfoCompute icompute = this._ftEquation.findInfoCompute(this._application.getDAOFactory().createObjModelDAO(), strType, strConfig, crcDag);
        if (icompute != null) {
            String iCrcDag = icompute.getParameters().get("CRC");
            _LOG.finest("CRC DAG memorized: " + iCrcDag);
            if (crcDag.equals(iCrcDag)) {
                TreeInfoCompute idatum = new TreeInfoCompute(icompute);
                String iCrcXml = icompute.getParameters().get("CRC.Xml");
                idatum.getInputFiles().put("ceciliabdd.file.dag", file);
                idatum.getInputFiles().put("ceciliabdd.file.xml", fileXml);
                Map<String, String> params = idatum.getParameters();
                params.put("ID", Long.toString(this._dbFolder.getID()));
                params.put("Config", strConfig);
                params.put("Root", ftRoot.getName());
                if (crcXml.equals(iCrcXml)) {
                    params.put("CRC.Xml.equals", "true");
                } else {
                    _LOG.finer("CRC XML is different : " + iCrcXml + " != " + crcXml);
                    params.put("CRC.Xml.equals", "false");
                }
                params.put("CRC.Xml", crcXml);
                params.put("User", this._application.getDBUser().getLogin());
                return idatum;
            }
            _LOG.finer("CRC DAG is different : " + iCrcDag + " != " + crcDag);
            icompute.clean();
            this._ftEquation.getInfoComputes().remove(mapKey);
        }
        icompute = new TreeInfoCompute(key, strType, this._ftEquation.getRefID());
        icompute.getInputFiles().put("ceciliabdd.file.dag", file);
        icompute.getInputFiles().put("ceciliabdd.file.xml", fileXml);
        Map<String, String> params = icompute.getParameters();
        params.put("CRC", crcDag);
        params.put("Config", strConfig);
        params.put("CRC.Xml", crcXml);
        params.put("Root", ftRoot.getName());
        params.put("User", this._application.getDBUser().getLogin());
        return icompute;
    }

    protected boolean isACritCompute() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setDatum(InfoDatum idatum) {
        File file;
        TreeInfoCompute icompute;
        if (idatum.getModel().getUID() != this._ftEquation.getRefID()) {
            return false;
        }
        String key = idatum.getKey();
        if (!key.startsWith("Tree.Compute.")) {
            return false;
        }
        String computeType = key.substring("Tree.Compute.".length());
        String config = idatum.getParameters().get("Config");
        String mapKey = computeType + "." + config;
        _LOG.finer("Call setDatum with mapkey=" + mapKey);
        if (Boolean.parseBoolean(idatum.getParameters().get("result.save")) && (icompute = this._ftEquation.getInfoComputes().get(mapKey)) != idatum) {
            if (icompute != null) {
                icompute.clean();
                this._ftEquation.getInfoComputes().remove(mapKey);
            }
            icompute = new TreeInfoCompute(idatum);
            this._ftEquation.getInfoComputes().put(mapKey, icompute);
            byte[] data = icompute.generateData();
            if (data == null) {
                _LOG.fine(StringUtilities.STR((String[])new String[]{"Non generation des donnees de la sauvegarde des resultats de calcul : ", this._dbFolder.getRefPath(), ", ", computeType, ", ", config}));
            } else {
                String nature = DBObjModel.constructNature("tree.compute", config, computeType);
                DBObjModel modelXTra = this._dbFolder.getObject().getModel(nature);
                if (!DBObjModel.validXTraSize(data.length)) {
                    _LOG.info(StringUtilities.STR((String[])new String[]{"La sauvegarde des resultats de calcul n'est pas effective a cause de la taille du flux : ", this._dbFolder.getRefPath(), ", ", computeType, ", ", config, ", ", Integer.toString(data.length)}));
                    if (modelXTra != null) {
                        this._dbFolder.getObject().delModel(modelXTra);
                    }
                } else {
                    if (modelXTra == null) {
                        modelXTra = new DBObjModel();
                        modelXTra.setNature(nature);
                        this._dbFolder.getObject().addModel(modelXTra);
                    }
                    modelXTra.setFormat("ZIP");
                    modelXTra.setCRC(icompute.getParameters().get("CRC"));
                    modelXTra.setSize(data.length);
                    modelXTra.setStreamToSave(new ByteArrayInputStream(data));
                    this._ftEquation.setModified(true);
                    if (!computeType.endsWith(".Abstract")) {
                        DBLogs.DefaultManager logMng = new DBLogs.DefaultManager(idatum.getParameters().get("User"), this._ftEquation.getLogs());
                        logMng.addLog(DBLogs.DBLevel.FINEST, "Save result (nature='" + nature + "', size='" + data.length + "')");
                    }
                }
            }
        }
        if ((file = idatum.getInputFiles().get("result.abstract")) != null) {
            InputStream inStream = null;
            try {
                inStream = new BufferedInputStream(new FileInputStream(file));
                this._ftEquation.loadMCSAbstract(inStream);
                String ftRoot = idatum.getParameters().get("Root");
                if (ftRoot != null && ftRoot.equals(this._ftEquation.getTopEvent().getName())) {
                    FTComputeParameters params = this._ftEquation.getComputeParameters();
                    params.setConfigName(config);
                    if (params.getLastCRC() == null) {
                        this._ftEquation.setModified(true);
                    }
                    params.setLastCRC(idatum.getParameters().get("CRC"));
                    params.setLastCRCXml(idatum.getParameters().get("CRC.Xml"));
                }
                this._ftEquation.fireChangeEvents(new ArrayList(1), this._owner);
            }
            catch (IOException e) {
                _LOG.log(Level.SEVERE, "Error during load 'result.abstract'", e);
            }
            finally {
                if (inStream != null) {
                    try {
                        inStream.close();
                    }
                    catch (IOException e) {
                        _LOG.log(Level.INFO, "Error during close 'result.abstract'", e);
                    }
                }
            }
        }
        return true;
    }

    public DBProject getProjectObj() {
        DBFolder folder = this._ftEquation.getDBFolder();
        while (!folder.getParent().isSystem()) {
            if (folder.getParent() == null) {
                return null;
            }
            folder = folder.getParent();
        }
        DBWrap dbWrap = this._application.getDAOFactory().findOrCreateWrap(folder);
        if (dbWrap == null) {
            return null;
        }
        if (dbWrap instanceof DBProject) {
            return (DBProject)dbWrap;
        }
        return null;
    }
}

