/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.dbobj.faulttree.ft.gui;

import com.dassault.cecilia.core.cecilia.pref.GeneralTextPreferencies;
import com.dassault.cecilia.core.cecilia.pref.PrefFieldBoolean;
import com.dassault.cecilia.core.cecilia.pref.Preferencies;
import com.dassault.cecilia.core.plugin.PluginWithOptions;
import com.dassault.cecilia.core.swing.JOptionCecilia;
import com.dassault.cecilia.core.swing.table.JTableTransfertHandler;
import com.dassault.cecilia.db.DBFactory;
import com.dassault.cecilia.db.DBFolder;
import com.dassault.cecilia.dbobj.CLawManager;
import com.dassault.cecilia.dbobj.faulttree.ResMsgArbor;
import com.dassault.cecilia.dbobj.faulttree.ft.FTEquation;
import com.dassault.cecilia.dbobj.faulttree.ft.gui.FTVariableListModel;
import com.dassault.cecilia.dbobj.faulttree.gui.ItemDefaultJTable;
import com.dassault.cecilia.dbobj.faulttree.obj.FTDefinition;
import com.dassault.cecilia.dbobj.faulttree.obj.FTEvent;
import com.dassault.cecilia.dbobj.faulttree.obj.FTVariableAbstract;
import com.dassault.cecilia.dbobj.faulttree.pref.FTVariableColorPreferencies;
import com.dassault.cecilia.dbobj.general.attrib.DBAttrib;
import com.dassault.cecilia.dbobj.general.law.Law;
import com.dassault.cecilia.dbobj.general.law.LawFormat;
import com.dassault.cecilia.dbobj.general.law.Param;
import com.dassault.cecilia.dbobj.general.law.ParamValue;
import com.dassault.cecilia.dbobj.wrap.DBWrap;
import com.dassault.cecilia.lib.util.format.DoubleFormat;
import com.dassault.cecilia.lib.util.format.DoubleFormatJava;
import com.dassault.cecilia.main.cecilia.CeciliaAppl;
import java.awt.Color;
import java.awt.Component;
import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultListSelectionModel;
import javax.swing.JCheckBox;
import javax.swing.JInternalFrame;
import javax.swing.JOptionPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.UIResource;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;

public class FTVariableListTable
extends ItemDefaultJTable
implements JTableTransfertHandler.HelperConvert {
    private static Logger _LOG = Logger.getLogger(FTVariableListTable.class.getPackage().getName());
    FTVariableListModel _model;
    FTEquation _ftEquation;
    CLawManager _lawManager;
    Color _clrBackNormal = FTVariableColorPreferencies.COLOR_BACK_NORMAL;
    Color _clrBackSelected = FTVariableColorPreferencies.COLOR_BACK_SELECTED;
    Color _clrBackLast = FTVariableColorPreferencies.COLOR_BACK_LAST;
    Color _clrForeNormal = FTVariableColorPreferencies.COLOR_FORE_NORMAL;
    Color _clrForeLock = FTVariableColorPreferencies.COLOR_FORE_LOCKED;
    Color _clrForeExtern = FTVariableColorPreferencies.COLOR_FORE_EXTERN;
    Color _clrForeTrue = FTVariableColorPreferencies.COLOR_FORE_TRUE;
    Color _clrForeFalse = FTVariableColorPreferencies.COLOR_FORE_FALSE;
    DoubleFormat _format = new DoubleFormatJava();
    long _prefsCode = -1L;

    public FTVariableListTable(FTVariableListModel model, CeciliaAppl appl) {
        super(model);
        this._model = model;
        this._ftEquation = model.getEquation();
        this._lawManager = appl.getDAOFactory().getLawManager();
        this.setTransferHandler(new JTableTransfertHandler());
        this.setAutoResizeMode(0);
        this.setDefaultRenderer(String.class, new FTVarStringCellRenderer());
        this.setDefaultRenderer(Double.class, new FTVarDoubleCellRenderer());
        this.setDefaultRenderer(Boolean.class, new FTVarBooleanCellRenderer());
        this.setDefaultRenderer(Law.class, new FTVarLawCellRenderer());
        this.setDefaultRenderer(Param.class, new FTVarParamCellRenderer());
        this.setDefaultRenderer(DBWrap.class, new FTVarDBWrapCellRenderer());
        this.setDefaultRenderer(FTEvent.State.class, new FTVarStateCellRenderer());
        this.setDefaultRenderer(FTEvent.Style.class, new FTVarStyleCellRenderer());
        this.setDefaultRenderer(FTDefinition.class, new FTDefinitionCellRenderer());
        this.setDefaultRenderer(Collection.class, new FTAttributesCellRenderer());
        this.setDefaultRenderer(DBFolder.class, new FTVarDBFolderCellRenderer());
        this.setDefaultEditor(String.class, new FTVarStringCellEditor(new JTextField()));
        this.setSelectionModel(new PublicListSelectionModel());
        this.changePreferencies(appl.getPreferencies());
    }

    @Override
    protected boolean withSorter() {
        return true;
    }

    @Override
    public PublicListSelectionModel getSelectionModel() {
        return (PublicListSelectionModel)super.getSelectionModel();
    }

    protected void defineCellRendererUI(Component comp, FTVariableAbstract itemArbre) {
        FTEvent.State state = FTEvent.State.DEFAULT;
        if (itemArbre.getEvent() != null) {
            state = itemArbre.getEvent().getState();
        }
        switch (state) {
            case TRUE: {
                comp.setForeground(this._clrForeTrue);
                break;
            }
            case FALSE: {
                comp.setForeground(this._clrForeFalse);
                break;
            }
            default: {
                if (itemArbre.isLocked()) {
                    comp.setForeground(this._clrForeLock);
                    break;
                }
                if (!itemArbre.isIntern()) {
                    comp.setForeground(this._clrForeExtern);
                    break;
                }
                comp.setForeground(this._clrForeNormal);
            }
        }
        if (itemArbre.isSelected()) {
            comp.setBackground(this._clrBackSelected);
        } else {
            comp.setBackground(this._clrBackNormal);
        }
    }

    public void changePreferencies(Preferencies prefs) {
        if (this._prefsCode == prefs.getRefresh()) {
            return;
        }
        this._prefsCode = prefs.getRefresh();
        PluginWithOptions opts = prefs.getOptions(FTVariableColorPreferencies.PREF_KEY);
        if (opts != null && opts instanceof FTVariableColorPreferencies) {
            FTVariableColorPreferencies colors = (FTVariableColorPreferencies)opts;
            this._clrBackNormal = colors.getPref("EvtNormal").getColor();
            this._clrBackSelected = colors.getPref("EvtSelected").getColor();
            this._clrBackLast = colors.getPref("EvtSelectedLast").getColor();
            this._clrForeLock = colors.getPref("EvtForeNormal").getColor();
            this._clrForeLock = colors.getPref("EvtLocked").getColor();
            this._clrForeExtern = colors.getPref("EvtForeExtern").getColor();
            this._clrForeTrue = colors.getPref("EvtTrue").getColor();
            this._clrForeFalse = colors.getPref("EvtFalse").getColor();
        }
        if ((opts = prefs.getOptions(GeneralTextPreferencies.PREF_KEY)) != null && opts instanceof GeneralTextPreferencies) {
            GeneralTextPreferencies gpref = (GeneralTextPreferencies)opts;
            this._format = gpref.getDoubleFormat();
        }
    }

    @Override
    public String convertToString(Object obj, int row, int col) {
        row = this.convertRowIndexToModel(row);
        col = this.convertColumnIndexToModel(col);
        Object objCol = this._model.getValueAt(row, col);
        switch (this._model.getColumnModel().getColumnField(col).getIdxCode()) {
            case 1: 
            case 8: 
            case 11: 
            case 13: 
            case 14: {
                if (objCol == null) {
                    return "";
                }
                return (String)objCol;
            }
            case 2: {
                if (objCol == null) {
                    return "";
                }
                String label = (String)objCol;
                if (label.length() == 0) {
                    return "";
                }
                return "\"" + label.replaceAll("\\\"", "\\\"\\\"") + "\"";
            }
            case 18: {
                if (objCol == null) {
                    return "";
                }
                return objCol.toString();
            }
            case 30: {
                if (objCol == null) {
                    return "";
                }
                StringBuilder sb = new StringBuilder();
                try {
                    sb.append("\"");
                    ((FTDefinition)objCol).writeEqu(sb);
                    sb.append("\"");
                }
                catch (IOException e) {
                    _LOG.log(Level.SEVERE, "Internal error", e);
                }
                return sb.toString();
            }
            case 5: 
            case 6: {
                if (objCol == null) {
                    return "";
                }
                return objCol.toString().toLowerCase();
            }
            case 12: 
            case 19: {
                if (objCol == null) {
                    return "";
                }
                return ((DBWrap)objCol).getRefPath();
            }
            case 16: 
            case 17: {
                if (objCol == null) {
                    return "";
                }
                return objCol.toString();
            }
            case 3: {
                if (objCol == null) {
                    return "";
                }
                return objCol.toString();
            }
            case 4: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: {
                if (objCol == null) {
                    return "";
                }
                double value = (Double)objCol;
                if (Double.isNaN(value)) {
                    return "-";
                }
                return Double.toString(value);
            }
            case 7: 
            case 9: 
            case 10: 
            case 15: {
                return (Boolean)objCol != false ? "true" : "false";
            }
        }
        return objCol.toString();
    }

    protected class FTVarStringCellRenderer
    extends DefaultTableCellRenderer {
        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int col) {
            super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, col);
            col = table.convertColumnIndexToModel(col);
            row = table.convertRowIndexToModel(row);
            this.setHorizontalAlignment(FTVariableListTable.this.getAlignRenderer(table, col));
            FTVariableAbstract itemArbre = FTVariableListTable.this._model.getItem(row);
            FTVariableListTable.this.defineCellRendererUI(this, itemArbre);
            return this;
        }
    }

    protected class FTVarDoubleCellRenderer
    extends FTVarStringCellRenderer {
        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int col) {
            double dvalue;
            super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, col);
            String txt = "-";
            if (value != null && !Double.isNaN(dvalue = ((Double)value).doubleValue())) {
                txt = FTVariableListTable.this._format.format(dvalue);
                if (FTVariableListTable.this._ftEquation.getComputeParameters().isOneHourOption() && !Double.isNaN(FTVariableListTable.this._ftEquation.getComputeParameters().getTime())) {
                    FTEvent ftEvent;
                    FTVariableAbstract item;
                    col = table.convertColumnIndexToModel(col);
                    row = table.convertRowIndexToModel(row);
                    PrefFieldBoolean pref = FTVariableListTable.this._model.getColumnModel().getColumnField(col);
                    if (pref.getIdxCode() == 4 && (item = FTVariableListTable.this._model.getItem(row)).isRoot() && (item.getEvent() == null || (ftEvent = item.getEvent()).getState() == FTEvent.State.DEFAULT && !ftEvent.isInspected() && !ftEvent.isInflightTested() && !ftEvent.getLaw().getManager().isConstanteCompatible(ftEvent.getLaw()))) {
                        double time = FTVariableListTable.this._ftEquation.getComputeParameters().getFlightDuration();
                        if (Double.isNaN(time)) {
                            time = FTVariableListTable.this._ftEquation.getComputeParameters().getTime();
                        }
                        StringBuilder buffer = new StringBuilder(128);
                        buffer.append(ResMsgArbor.msgFormat("PFH_COMPUTE", FTVariableListTable.this._format.format(dvalue / time * 3600.0)));
                        buffer.append(" ").append(FTVariableListTable.this._format.format(dvalue));
                        txt = buffer.toString();
                    }
                }
            }
            this.setText(txt);
            return this;
        }
    }

    class FTVarBooleanCellRenderer
    extends JCheckBox
    implements TableCellRenderer,
    UIResource {
        private final Border noFocusBorder = new EmptyBorder(1, 1, 1, 1);

        public FTVarBooleanCellRenderer() {
            this.setHorizontalAlignment(0);
            this.setBorderPainted(true);
            this.setEnabled(false);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (isSelected) {
                this.setForeground(table.getSelectionForeground());
                super.setBackground(table.getSelectionBackground());
            } else {
                this.setForeground(table.getForeground());
                this.setBackground(table.getBackground());
            }
            row = table.convertRowIndexToModel(row);
            FTVariableAbstract itemArbre = FTVariableListTable.this._model.getItem(row);
            FTVariableListTable.this.defineCellRendererUI(this, itemArbre);
            this.setSelected(value != null && (Boolean)value != false);
            if (hasFocus) {
                this.setBorder(UIManager.getBorder("Table.focusCellHighlightBorder"));
            } else {
                this.setBorder(this.noFocusBorder);
            }
            return this;
        }
    }

    protected class FTVarLawCellRenderer
    extends FTVarStringCellRenderer {
        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int col) {
            super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, col);
            String txt = "-";
            if (value != null && value instanceof Law) {
                txt = LawFormat.DEFAULT.format((Law)value, FTVariableListTable.this._format);
            }
            this.setText(txt);
            return this;
        }
    }

    protected class FTVarParamCellRenderer
    extends FTVarStringCellRenderer {
        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int col) {
            super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, col);
            String txt = "-";
            String tooltip = null;
            if (value != null) {
                Param param = (Param)value;
                txt = LawFormat.DEFAULT.format(param, FTVariableListTable.this._format);
                if (!(param instanceof ParamValue)) {
                    double pval = FTVariableListTable.this._lawManager.evaluate(param);
                    tooltip = FTVariableListTable.this._format.format(pval);
                }
            }
            this.setText(txt);
            this.setToolTipText(tooltip);
            return this;
        }
    }

    protected class FTVarDBWrapCellRenderer
    extends FTVarStringCellRenderer {
        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int col) {
            super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, col);
            String txt = "-";
            if (value != null) {
                DBWrap dbModelLaw = (DBWrap)value;
                txt = dbModelLaw.getRefPath();
            }
            this.setText(txt);
            return this;
        }
    }

    protected class FTVarStateCellRenderer
    extends FTVarStringCellRenderer {
        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int col) {
            super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, col);
            String txt = "-";
            if (value != null) {
                FTEvent.State state = (FTEvent.State)((Object)value);
                txt = state.getLabel();
            }
            this.setText(txt);
            return this;
        }
    }

    protected class FTVarStyleCellRenderer
    extends FTVarStringCellRenderer {
        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int col) {
            super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, col);
            String txt = "-";
            if (value != null) {
                FTEvent.Style style = (FTEvent.Style)((Object)value);
                txt = style.getLabel();
            }
            this.setText(txt);
            return this;
        }
    }

    protected class FTDefinitionCellRenderer
    extends FTVarStringCellRenderer {
        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int col) {
            super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, col);
            String txt = "-";
            if (value != null) {
                txt = value.toString();
            }
            this.setText(txt);
            return this;
        }
    }

    protected class FTAttributesCellRenderer
    extends FTVarStringCellRenderer {
        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int col) {
            super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, col);
            StringBuilder buf = new StringBuilder();
            if (value == null) {
                buf.append("-");
            } else {
                Iterator iterAttrib = ((Collection)value).iterator();
                while (iterAttrib.hasNext()) {
                    DBAttrib.Value dbValue = (DBAttrib.Value)iterAttrib.next();
                    dbValue.appendDisplay(buf);
                    if (!iterAttrib.hasNext()) continue;
                    buf.append("; ");
                }
            }
            this.setText(buf.toString());
            return this;
        }
    }

    protected class FTVarDBFolderCellRenderer
    extends FTVarStringCellRenderer {
        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int col) {
            super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, col);
            String txt = "-";
            if (value != null) {
                DBFolder dbModelLaw = (DBFolder)value;
                txt = dbModelLaw.getRefPath();
            }
            this.setText(txt);
            return this;
        }
    }

    protected class FTVarStringCellEditor
    extends DefaultCellEditor {
        Object _previousValue;

        public FTVarStringCellEditor(JTextField textField) {
            super(textField);
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            this._previousValue = value;
            return super.getTableCellEditorComponent(table, value, isSelected, row, column);
        }

        @Override
        public boolean stopCellEditing() {
            String currentValue = ((JTextField)this.getComponent()).getText();
            if (this._previousValue == null || !this._previousValue.equals(currentValue)) {
                String msgError = null;
                if (DBFactory.verifyName(currentValue) != 0) {
                    msgError = ResMsgArbor.msgFormat("MSG_ERR_VAR_BADNAME", currentValue);
                } else if (FTVariableListTable.this._ftEquation.getVariable(currentValue) != null) {
                    msgError = ResMsgArbor.msgFormat("MSG_ERR_XML_FT_NAME_ALREADY", currentValue);
                }
                if (msgError != null) {
                    ((JTextField)this.getComponent()).setText(this._previousValue.toString());
                    JInternalFrame iframe = (JInternalFrame)SwingUtilities.getAncestorOfClass(JInternalFrame.class, FTVariableListTable.this);
                    JOptionPane.showMessageDialog(JOptionCecilia.getTopContainerOf(FTVariableListTable.this), msgError, iframe.getTitle(), 0);
                }
            }
            return super.stopCellEditing();
        }
    }

    class PublicListSelectionModel
    extends DefaultListSelectionModel {
        PublicListSelectionModel() {
        }

        @Override
        public void fireValueChanged(int firstIndex, int lastIndex, boolean isAdjusting) {
            super.fireValueChanged(firstIndex, lastIndex, isAdjusting);
        }
    }
}

