/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.dbobj.faulttree.ft.gui.actions;

import com.dassault.cecilia.core.ConfigManager;
import com.dassault.cecilia.core.cecilia.action.CCmdFolder;
import com.dassault.cecilia.core.cecilia.action.UndoItem;
import com.dassault.cecilia.core.swing.JOptionCecilia;
import com.dassault.cecilia.dbobj.demo.DemoLimitedException;
import com.dassault.cecilia.dbobj.demo.DemoLimitedFactory;
import com.dassault.cecilia.dbobj.faulttree.ResMsgArbor;
import com.dassault.cecilia.dbobj.faulttree.ft.FTEquation;
import com.dassault.cecilia.dbobj.faulttree.ft.gui.FTEquationFrame;
import com.dassault.cecilia.dbobj.faulttree.ft.gui.actions.FTUtilCmdChangeDSFConfig;
import com.dassault.cecilia.main.cecilia.CeciliaAppl;
import java.awt.EventQueue;
import java.util.logging.Logger;
import javax.swing.JOptionPane;

public abstract class FTCmd
extends CCmdFolder
implements UndoItem {
    private static Logger _LOG = Logger.getLogger(FTCmd.class.getPackage().getName());
    FTEquationFrame _frame;
    FTEquation _ftEquation;
    FTUtilCmdChangeDSFConfig _utilDSFConfig = null;

    public FTCmd(CeciliaAppl appl, FTEquationFrame frame) {
        super(appl, frame, frame != null ? frame.getDBFolder() : null);
        this._frame = frame;
        this._ftEquation = this._frame.getDBWrap();
    }

    @Override
    protected boolean prepareDo() {
        return true;
    }

    @Override
    protected CeciliaAppl getAppl() {
        return (CeciliaAppl)super.getAppl();
    }

    @Override
    protected FTEquationFrame getSource() {
        return this._frame;
    }

    @Override
    public void debugTrace(StringBuilder out) {
        out.append(this.getClass().getSimpleName());
    }

    protected boolean prepareChangeDSFConfig(boolean force) {
        FTUtilCmdChangeDSFConfig utilDSFConfig;
        if (force && (utilDSFConfig = new FTUtilCmdChangeDSFConfig(this._ftEquation, this.getAppl().getDAOFactory())).prepareDo()) {
            this._utilDSFConfig = utilDSFConfig;
            return true;
        }
        return false;
    }

    public void redoChangeDSFConfig() {
        if (this._utilDSFConfig != null) {
            this._utilDSFConfig.redo();
        }
    }

    public void undoChangeDSFConfig() {
        if (this._utilDSFConfig != null) {
            this._utilDSFConfig.undo();
        }
    }

    protected boolean verifyInstanciate(boolean afterChangeDefinition) {
        boolean result = false;
        result = afterChangeDefinition ? this._ftEquation.instanciateAfterChangeDefinition(this.getAppl().getDBUser()) : this._ftEquation.instanciate(true, this.getAppl().getDBUser());
        if (!result) {
            this._ftEquation.setManuelInstanciate(true);
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    JOptionPane.showMessageDialog(JOptionCecilia.getTopContainerOf(FTCmd.this.getSource()), ResMsgArbor.getString("FT_INSTANCIATE_MSG"), JOptionCecilia.getTopTitleOf(FTCmd.this.getSource()), 0);
                }
            });
        }
        return result;
    }

    @Override
    public boolean realiseDo() {
        boolean result = super.realiseDo();
        if (ConfigManager.getVersion() == ConfigManager.TypeVersion.DEMO) {
            try {
                ((DemoLimitedFactory)this.getAppl().getDAOFactory()).verifyModelLimits(this._ftEquation);
            }
            catch (DemoLimitedException e) {
                _LOG.info("DemoLimited " + e.toString());
                if (this._ftEquation.getUndoManager().undoable()) {
                    UndoItem cmd = this._ftEquation.getUndoManager().removeLastCmd();
                    if (cmd != this) {
                        _LOG.severe("DemoVersion: FautTree undo with another cmd");
                    }
                    cmd.undo();
                }
                JOptionPane.showMessageDialog(this._frame, ResMsgArbor.getString("DEMO_TREE"), JOptionCecilia.getTopTitleOf(this._frame), 0);
            }
        }
        return result;
    }
}

