/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.dbobj.faulttree.ft.gui.actions;

import com.dassault.cecilia.core.ResMsgVoc;
import com.dassault.cecilia.core.cecilia.error.GeneralDlgDisplayError;
import com.dassault.cecilia.core.cecilia.error.GeneralError;
import com.dassault.cecilia.core.cecilia.error.MsgType;
import com.dassault.cecilia.core.swing.JOptionCecilia;
import com.dassault.cecilia.dbobj.faulttree.ResMsgArbor;
import com.dassault.cecilia.dbobj.faulttree.ft.FTVariable;
import com.dassault.cecilia.dbobj.faulttree.ft.grf.FGVariable;
import com.dassault.cecilia.dbobj.faulttree.ft.gui.FTEquationFrame;
import com.dassault.cecilia.dbobj.faulttree.ft.gui.actions.FTCmd;
import com.dassault.cecilia.dbobj.faulttree.ft.gui.actions.SelectPathDlg;
import com.dassault.cecilia.dbobj.faulttree.obj.FTDefinition;
import com.dassault.cecilia.dbobj.faulttree.obj.FTEvent;
import com.dassault.cecilia.dbobj.faulttree.obj.FTVariableAbstract;
import com.dassault.cecilia.main.cecilia.CeciliaAppl;
import java.awt.Component;
import java.awt.Window;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;

public class FTCmdDelete
extends FTCmd {
    Collection<FTVariable> _ftInitialVars;
    Collection<FTVariable> _ftFinalVars;
    List<DeleteInformation> _deleteInformations;
    Component _source;
    private FTVariable _parent;
    private FGVariable _pivot;

    public FTCmdDelete(CeciliaAppl appl, FTEquationFrame frame, Collection<FTVariable> ftVars, Component source) {
        super(appl, frame);
        this._ftInitialVars = ftVars;
        this._source = source;
        this._deleteInformations = new ArrayList<DeleteInformation>();
    }

    public final void setParent(FTVariable var) {
        this._parent = var;
    }

    public final void setPivot(FGVariable var) {
        this._pivot = var;
    }

    @Override
    protected boolean prepareDo() {
        ArrayList errors = new ArrayList();
        this.prepareDelete(errors);
        if (!errors.isEmpty()) {
            GeneralDlgDisplayError<FTVariableAbstract> dlg = new GeneralDlgDisplayError<FTVariableAbstract>(JOptionCecilia.getWindowOf(this._source)){

                @Override
                protected Class<?> getSourceClass() {
                    return FTVariableAbstract.class;
                }

                @Override
                protected String getSourceName() {
                    return ResMsgVoc.getString("VOC_EVENTS");
                }

                @Override
                protected TableCellRenderer getSourceRenderer() {
                    return new DefaultTableCellRenderer();
                }
            };
            dlg.setErrors(errors);
            dlg.setTitle(ResMsgVoc.getString("VOC_ERROR") + " - " + ResMsgVoc.getString("VOC_DELETE"));
            dlg.setModal(true);
            dlg.setLocationRelativeTo(JOptionCecilia.getTopContainerOf(this._source));
            dlg.setVisible(true);
            return false;
        }
        if (!this.checkForMultiplesParents()) {
            return false;
        }
        this.prepareChangeDSFConfig(this._ftEquation.withLinks());
        return true;
    }

    protected void prepareDelete(List<GeneralError<FTVariableAbstract>> errors) {
        this._ftEquation.setFlags(0);
        int nbr = 0;
        for (FTVariable fTVariable : this._ftInitialVars) {
            if (this.withError(fTVariable, errors)) continue;
            fTVariable.setFlags(3);
            ++nbr;
        }
        if (nbr == 0) {
            errors.add(new GeneralError<Object>(null, ResMsgArbor.getString("FT_DELETE_ERR_EMPTY"), MsgType.ERROR));
            return;
        }
        LinkedHashMap<FTVariable, DeleteInformation> collectVars = new LinkedHashMap<FTVariable, DeleteInformation>();
        this.recupChangeVars_rec(this._ftEquation.getTopEvent(), collectVars, errors);
        if (collectVars.isEmpty()) {
            errors.add(new GeneralError<Object>(null, ResMsgArbor.getString("FT_DELETE_ERR_EMPTY"), MsgType.ERROR));
            return;
        }
        this._ftFinalVars = new ArrayList<FTVariable>();
        for (DeleteInformation info : collectVars.values()) {
            if (info.verifyDelete() || collectVars.size() > 1) {
                this._deleteInformations.add(info);
                this._ftFinalVars.add(info._ftVar);
                continue;
            }
            errors.add(new GeneralError<FTVariable>(info._ftVar, ResMsgArbor.getString("FT_DELETE_ERR_ARGS"), MsgType.WARNING));
        }
        if (collectVars.size() > 1) {
            boolean bl;
            boolean bl2 = false;
            for (DeleteInformation info : this._deleteInformations) {
                if (!info.verifyDelete()) continue;
                bl = true;
                break;
            }
            if (!bl) {
                errors.add(new GeneralError<Object>(null, ResMsgArbor.getString("FT_DELETE_ERR_ARGS"), MsgType.WARNING));
            }
        }
        if (this._deleteInformations.isEmpty()) {
            errors.add(new GeneralError<Object>(null, ResMsgArbor.getString("FT_DELETE_ERR_EMPTY"), MsgType.ERROR));
            return;
        }
    }

    private boolean withError(FTVariableAbstract ftVar, List<GeneralError<FTVariableAbstract>> errors) {
        if (ftVar.isRoot()) {
            return errors.add(new GeneralError<FTVariableAbstract>(ftVar, ResMsgArbor.getString("FT_DELETE_ERR_ROOT"), MsgType.WARNING));
        }
        if (!ftVar.isIntern()) {
            return errors.add(new GeneralError<FTVariableAbstract>(ftVar, ResMsgArbor.getString("FT_DELETE_ERR_EXTERN"), MsgType.WARNING));
        }
        return false;
    }

    private void recupChangeVars_rec(FTVariable ftCur, Map<FTVariable, DeleteInformation> collectVars, List<GeneralError<FTVariableAbstract>> errors) {
        if (ftCur.getFlags() != 0) {
            return;
        }
        ftCur.setFlags(1);
        FTDefinition ftDef = ftCur.getDefinition();
        if (ftDef != null && ftCur.getLink() == null) {
            for (FTVariableAbstract ftArg : ftDef.getArgs()) {
                if (ftArg.getFlags() == 3) {
                    if (!ftCur.isIntern()) {
                        errors.add(new GeneralError<FTVariable>(ftCur, ResMsgArbor.getString("FT_DELETE_ERR_EXTERN"), MsgType.WARNING));
                        return;
                    }
                    if (ftCur.isLocked()) {
                        errors.add(new GeneralError<FTVariable>(ftCur, ResMsgArbor.getString("FT_DELETE_ERR_LOCK"), MsgType.WARNING));
                        return;
                    }
                    DeleteInformation infos = collectVars.get(ftCur);
                    if (infos == null) {
                        infos = new DeleteInformation(ftCur);
                        collectVars.put(ftCur, infos);
                    }
                    infos.addDeletaArgs(ftArg);
                    continue;
                }
                if (!(ftArg instanceof FTVariable)) continue;
                this.recupChangeVars_rec((FTVariable)ftArg, collectVars, errors);
            }
        }
    }

    private final boolean checkForMultiplesParents() {
        LinkedHashMap mapElemDelToFather = new LinkedHashMap();
        for (FTVariable var : this._ftInitialVars) {
            for (DeleteInformation info : this._deleteInformations) {
                if (!info._deleteArgs.contains(var)) continue;
                if (mapElemDelToFather.get(var) == null) {
                    mapElemDelToFather.put(var, new ArrayList());
                }
                if (((List)mapElemDelToFather.get(var)).contains(info._ftVar)) continue;
                ((List)mapElemDelToFather.get(var)).add(info._ftVar);
            }
        }
        if (mapElemDelToFather.size() > 1) {
            for (List listFTVars : mapElemDelToFather.values()) {
                if (listFTVars.size() <= 1) continue;
                JOptionPane.showMessageDialog(JOptionCecilia.getTopContainerOf(this._source), ResMsgArbor.getString("MULTIPLES_SELECTION_CONFLICT_ERROR"), ResMsgVoc.getString("VOC_ERROR") + " - " + ResMsgVoc.getString("VOC_DELETE"), 0);
                return false;
            }
        } else {
            Map.Entry entry = mapElemDelToFather.entrySet().iterator().next();
            List listVars = (List)entry.getValue();
            if (listVars.size() > 1) {
                ArrayList<Object> parentToRemove = new ArrayList();
                if (this._parent == null) {
                    FGVariable fgVarPivot;
                    FTVariable var = (FTVariable)entry.getKey();
                    List<List<FTVariableAbstract>> listPaths = this._frame.getDBWrap().findPaths(null, var, false);
                    SelectPathDlgDeletion selectPathDlg = new SelectPathDlgDeletion((Window)this.getAppl().getTopWindow(), listPaths, var, this._deleteInformations);
                    selectPathDlg.setTitle(this._frame.getTitle());
                    selectPathDlg.setLocationRelativeTo(this.getAppl().getTopWindow());
                    if (this._pivot != null && (fgVarPivot = this._pivot.getParent()) != null) {
                        selectPathDlg.setSelectedParent(fgVarPivot.getVar());
                    }
                    selectPathDlg.setVisible(true);
                    if (!selectPathDlg.getResult()) {
                        return false;
                    }
                    List<List<FTVariableAbstract>> listFTVar = selectPathDlg.getSelectPath();
                    for (List list : listFTVar) {
                        FTVariableAbstract ftVar = (FTVariableAbstract)list.get(list.size() - 1);
                        parentToRemove.add(ftVar);
                    }
                } else {
                    parentToRemove = new ArrayList<FTVariable>(Collections.singleton(this._parent));
                }
                this._ftFinalVars.clear();
                ArrayList<DeleteInformation> newListDeletion = new ArrayList<DeleteInformation>();
                for (DeleteInformation delInfo : this._deleteInformations) {
                    boolean ftVarToDel = false;
                    for (FTVariableAbstract fTVariableAbstract : parentToRemove) {
                        if (!delInfo._ftVar.equals(fTVariableAbstract)) continue;
                        if (!delInfo.verifyDelete()) {
                            // empty if block
                        }
                        ftVarToDel = true;
                        this._ftFinalVars.add((FTVariable)fTVariableAbstract);
                        break;
                    }
                    if (!ftVarToDel) continue;
                    newListDeletion.add(delInfo);
                }
                this._deleteInformations = newListDeletion;
            }
        }
        return true;
    }

    @Override
    protected void firstDo() {
        this.redo();
        this.getSource().addHisto(this);
    }

    @Override
    public void redo() {
        for (DeleteInformation info : this._deleteInformations) {
            if (info._newEvent != null) {
                info._ftVar.setLink(null);
                info._ftVar.setEvent(info._newEvent);
                this._ftEquation.changeDefinitionOf(info._ftVar, null);
                continue;
            }
            this._ftEquation.changeDefinitionOf(info._ftVar, info._newDefine);
        }
        this.verifyInstanciate(true);
        this._ftEquation.defineLockedVariables();
        this._ftEquation.fireChangeDefinitions(this._ftFinalVars, this._source);
        this.redoChangeDSFConfig();
        this._ftEquation.clearResults();
        this._ftEquation.updateDependTimeUpdt(this.getAppl().getDAOFactory(), this._ftEquation.getWorkingRelations());
        this._ftEquation.setModified(true);
        this.getSource().refreshCtrlInstanciate();
        this.getSource().refreshCtrlLogs();
    }

    @Override
    public void undo() {
        for (DeleteInformation info : this._deleteInformations) {
            info._ftVar.setLink(null);
            info._ftVar.setEvent(null);
            this._ftEquation.changeDefinitionOf(info._ftVar, info._oldDefine);
        }
        this.verifyInstanciate(true);
        this._ftEquation.defineLockedVariables();
        this._ftEquation.fireChangeDefinitions(this._ftFinalVars, this._source);
        this.undoChangeDSFConfig();
        this._ftEquation.clearResults();
        this._ftEquation.updateDependTimeUpdt(this.getAppl().getDAOFactory(), this._ftEquation.getWorkingRelations());
        this._ftEquation.setModified(true);
        this.getSource().refreshCtrlInstanciate();
        this.getSource().refreshCtrlLogs();
    }

    class DeleteInformation {
        FTVariable _ftVar;
        FTDefinition _oldDefine;
        FTDefinition _newDefine;
        FTEvent _newEvent;
        List<FTVariableAbstract> _deleteArgs;

        public DeleteInformation(FTVariable ftVar) {
            this._ftVar = ftVar;
            this._oldDefine = this._ftVar.getDefinition();
            this._deleteArgs = new ArrayList<FTVariableAbstract>(this._oldDefine.getArgs().size());
        }

        public void addDeletaArgs(FTVariableAbstract ftArg) {
            if (this._deleteArgs.contains(ftArg)) {
                return;
            }
            this._deleteArgs.add(ftArg);
        }

        public boolean verifyDelete() {
            int nbrArgs = this._oldDefine.getArgs().size() - this._deleteArgs.size();
            if (nbrArgs == 0) {
                this._newDefine = null;
                this._newEvent = new FTEvent();
                this._newEvent.initialise(FTCmdDelete.this.getAppl());
                this._newEvent.setVariable(this._ftVar);
                return true;
            }
            FTDefinition.Type type = this._oldDefine.getType();
            if (nbrArgs < type.getMinArg() || nbrArgs > type.getMaxArg()) {
                return false;
            }
            if (type == FTDefinition.Type.KOFN && nbrArgs < this._oldDefine.getAtLeast()) {
                return false;
            }
            ArrayList<FTVariableAbstract> newArgs = new ArrayList<FTVariableAbstract>(this._oldDefine.getArgs().size());
            for (FTVariableAbstract ftArg : this._oldDefine.getArgs()) {
                if (this._deleteArgs.contains(ftArg)) continue;
                newArgs.add(ftArg);
            }
            this._newDefine = new FTDefinition(this._oldDefine.getType(), newArgs);
            this._newDefine.setAtLeast(this._oldDefine.getAtLeast());
            this._newDefine.setGSR(this._oldDefine.isGSR());
            return true;
        }
    }

    public static class SelectPathDlgDeletion
    extends SelectPathDlg {
        private List<DeleteInformation> _deleteInfos;
        private FTVariableAbstract _ftChild;

        public SelectPathDlgDeletion(Window win, List<List<FTVariableAbstract>> paths, FTVariableAbstract ftChild, List<DeleteInformation> deleteInfos) {
            super(win, paths, ftChild, 2, "LBL_SUPPRESS_CONFLICT");
            this._deleteInfos = deleteInfos;
            this._ftChild = ftChild;
        }

        @Override
        protected DefaultListCellRenderer getDefaultListCellRendererSelectPath() {
            final DefaultListCellRenderer renderer = super.getDefaultListCellRendererSelectPath();
            return new DefaultListCellRenderer(){

                @Override
                public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                    JLabel label = (JLabel)renderer.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
                    List item = (List)value;
                    int idxParent = item.size() - 1;
                    if (_deleteInfos != null) {
                        FTVariable ftVar = (FTVariable)item.get(idxParent);
                        DeleteInformation info = null;
                        for (DeleteInformation infoInList : _deleteInfos) {
                            if (infoInList._ftVar != ftVar) continue;
                            info = infoInList;
                            break;
                        }
                        if (info != null && !info.verifyDelete()) {
                            label.setText("<html><i>" + label.getText() + "</i></html>");
                        }
                    }
                    return label;
                }
            };
        }

        @Override
        protected boolean verifyParameters() {
            if (!super.verifyParameters()) {
                return false;
            }
            for (Object obj : this._ctrlList.getSelectedValuesList()) {
                List list = (List)obj;
                int indexParent = list.size() - 1;
                FTVariable ftVar = (FTVariable)list.get(indexParent);
                for (DeleteInformation info : this._deleteInfos) {
                    if (info._ftVar != ftVar || info.verifyDelete()) continue;
                    JOptionPane.showMessageDialog(this.getOwner(), ResMsgArbor.msgFormat("SELECTION_PATH_NOT_DELETABLE", this._ftChild.getName(), ftVar.getName()), ResMsgVoc.getString("VOC_ERROR"), 0);
                    return false;
                }
            }
            return true;
        }
    }
}

