/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.dbobj.faulttree.ft.gui.actions;

import com.dassault.cecilia.core.ResMsgVoc;
import com.dassault.cecilia.core.swing.JDialogCecilia;
import com.dassault.cecilia.core.swing.JOptionCecilia;
import com.dassault.cecilia.db.DBFactory;
import com.dassault.cecilia.dbobj.faulttree.ResMsgArbor;
import com.dassault.cecilia.dbobj.faulttree.ft.FTEquation;
import com.dassault.cecilia.dbobj.faulttree.ft.FTVariable;
import com.dassault.cecilia.dbobj.faulttree.ft.gui.FTEquationFrame;
import com.dassault.cecilia.dbobj.faulttree.ft.gui.actions.FTCmd;
import com.dassault.cecilia.dbobj.faulttree.obj.FTVariableAbstract;
import com.dassault.cecilia.main.cecilia.CeciliaAppl;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.util.Collections;
import java.util.logging.Logger;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class FTCmdVarRename
extends FTCmd {
    private static Logger _LOG = Logger.getLogger(FTCmdVarRename.class.getPackage().getName());
    protected FTVariable _ftVariable;
    protected String _newName;
    protected String _oldName;
    protected Component _source;

    public FTCmdVarRename(CeciliaAppl appl, FTEquationFrame frame, FTVariable ftVar, String newName, Component source) {
        super(appl, frame);
        this._ftVariable = ftVar;
        this._newName = newName;
        this._source = source;
    }

    @Override
    public void debugTrace(StringBuilder out) {
        out.append(this.getClass().getSimpleName()).append(" : ").append(this._oldName).append(" => ").append(this._newName);
    }

    @Override
    protected boolean prepareDo() {
        if (!super.prepareDo()) {
            return false;
        }
        if (this._newName == null) {
            FTCmdVarRenameDlg dlg = new FTCmdVarRenameDlg(JOptionCecilia.getWindowOf(this.getSource()), this._ftEquation, this.getTitleAction(), this._ftVariable.getName());
            dlg.setLocationRelativeTo(JOptionCecilia.getTopContainerOf(this.getSource()));
            dlg.setVisible(true);
            if (!dlg.getResult()) {
                return false;
            }
            this._newName = dlg.getRenameValue();
            if (this._ftVariable.getName().equals(this._newName)) {
                return false;
            }
        }
        return true;
    }

    @Override
    protected void firstDo() {
        this._oldName = this._ftVariable.getName();
        this.redo();
        this.getSource().addHisto(this);
    }

    @Override
    public void redo() {
        FTVariableAbstract ftVar = this._ftEquation.getVariable(this._oldName);
        if (ftVar instanceof FTVariable) {
            this._ftEquation.rename((FTVariable)ftVar, this._newName);
            this.refreshEvents();
        } else {
            _LOG.severe("Tentative de renommage d'une variable externe : " + this._oldName + " => " + this._newName);
            this.getSource().clearHisto();
        }
    }

    @Override
    public void undo() {
        FTVariableAbstract ftVar = this._ftEquation.getVariable(this._newName);
        if (ftVar instanceof FTVariable) {
            this._ftEquation.rename((FTVariable)ftVar, this._oldName);
            this.refreshEvents();
        } else {
            _LOG.severe("Tentative de renommage d'une variable externe : " + this._newName + " => " + this._oldName);
            this.getSource().clearHisto();
        }
    }

    protected void refreshEvents() {
        this._ftEquation.fireChangeEvents(Collections.singleton(this._ftVariable), this._source);
        this._ftEquation.setModified(true);
    }

    protected String getTitleAction() {
        return ResMsgVoc.getString("VOC_RENAME");
    }

    static class FTCmdVarRenameDlg
    extends JDialogCecilia {
        private final FTEquation _ftEquation;
        private final String _cmdStr;
        private final String _oldName;
        private JTextField _renameJtf;

        public FTCmdVarRenameDlg(Window owner, FTEquation equation, String titleDlg, String oldName) {
            super(owner, titleDlg, true);
            this._ftEquation = equation;
            this._cmdStr = titleDlg;
            this._oldName = oldName;
            JPanel mainPanel = this.createPanelRename();
            this.getContentPane().setLayout(new BorderLayout());
            this.getContentPane().add((Component)mainPanel, "North");
            this.getContentPane().add((Component)this.createButPanel(true), "South");
            this.init();
            this.pack();
        }

        public final String getRenameValue() {
            return this._renameJtf.getText();
        }

        private final JPanel createPanelRename() {
            JPanel mainPanel = new JPanel(new GridBagLayout());
            JLabel renameLbl = new JLabel(ResMsgVoc.getString("VOC_RENAME_NEW_NAME_DLG"));
            this._renameJtf = new JTextField();
            this._renameJtf.setText(this._oldName);
            this._renameJtf.selectAll();
            mainPanel.add((Component)renameLbl, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
            mainPanel.add((Component)this._renameJtf, new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
            return mainPanel;
        }

        @Override
        protected boolean verifyParameters() {
            String renameStr = this._renameJtf.getText();
            if (renameStr == null || renameStr.isEmpty()) {
                JOptionPane.showMessageDialog(this.getOwner(), ResMsgArbor.getString("MSG_ERR_VAR_EMPTY"), ResMsgVoc.getString("VOC_ERROR") + " - " + this._cmdStr, 0);
                return false;
            }
            if (DBFactory.verifyName(renameStr) != 0) {
                JOptionPane.showMessageDialog(this.getOwner(), ResMsgArbor.msgFormat("MSG_ERR_VAR_BADNAME", renameStr), ResMsgVoc.getString("VOC_ERROR") + " - " + this._cmdStr, 0);
                return false;
            }
            if (this._ftEquation.getVariable(renameStr) != null) {
                JOptionPane.showMessageDialog(this.getOwner(), ResMsgArbor.msgFormat("MSG_ERR_XML_FT_NAME_ALREADY", renameStr), ResMsgVoc.getString("VOC_ERROR") + " - " + this._cmdStr, 0);
                return false;
            }
            return true;
        }
    }
}

