/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.dbobj.faulttree.ft.gui.actions;

import com.dassault.cecilia.dbobj.faulttree.ft.FTVariable;
import com.dassault.cecilia.dbobj.faulttree.ft.gui.FTEquationFrame;
import com.dassault.cecilia.dbobj.faulttree.ft.gui.actions.FTCmd;
import com.dassault.cecilia.dbobj.faulttree.obj.FTVariableAbstract;
import com.dassault.cecilia.dbobj.general.log.DBLogs;
import com.dassault.cecilia.main.cecilia.CeciliaAppl;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Logger;

public abstract class FTCmdWithExtract
extends FTCmd {
    private static Logger _LOG = Logger.getLogger(FTCmdWithExtract.class.getPackage().getName());
    Component _source;
    FTVariable _ftVariable;
    private FTVariable _ftUndoVariable;
    private FTVariable _ftRedoVariable;
    private List<FTVariable> _undoVars;
    private List<FTVariable> _redoVars;

    public FTCmdWithExtract(CeciliaAppl appl, FTEquationFrame frame, FTVariable ftVar, Component source) {
        super(appl, frame);
        this._ftVariable = ftVar;
        this._source = source;
    }

    @Override
    public void debugTrace(StringBuilder out) {
        out.append(this.getClass().getSimpleName());
        if (this._undoVars != null) {
            out.append("\n  ").append(this.debugBuilder("Undo-Info ", this._undoVars, this._ftUndoVariable));
        }
        if (this._redoVars != null) {
            out.append("\n  ").append(this.debugBuilder("Redo-Info ", this._redoVars, this._ftRedoVariable));
        }
    }

    private String debugBuilder(String header, List<FTVariable> vars, FTVariable var) {
        StringBuilder sb = new StringBuilder();
        sb.append(header).append("{").append(vars.size()).append("}");
        for (FTVariable curVar : vars) {
            if (curVar.isRoot()) {
                sb.append("{r:").append(curVar.getName());
                if (curVar.getDefinition() != null) {
                    sb.append(":").append(curVar.getDefinition());
                }
                sb.append("}");
            }
            if (curVar != var) continue;
            sb.append("{v:").append(curVar.getName());
            if (curVar.getDefinition() != null) {
                sb.append(":").append(curVar.getDefinition());
            }
            sb.append("}");
        }
        return sb.toString();
    }

    @Override
    protected boolean prepareDo() {
        this.prepareChangeDSFConfig(true);
        return true;
    }

    protected void prepareUndo() {
        List<FTVariable> saveVars = this._ftEquation.getTopEvent().extractVariables();
        saveVars.iterator().next().setRoot(true);
        FTVariable saveVariable = null;
        for (FTVariable ftVar : saveVars) {
            if (!ftVar.getName().equals(this._ftVariable.getName())) continue;
            saveVariable = ftVar;
            break;
        }
        this._undoVars = new ArrayList<FTVariable>(saveVars.size() + 1);
        for (FTVariableAbstract varAbs : this._ftEquation.getAllVariables()) {
            if (!(varAbs instanceof FTVariable)) continue;
            FTVariable var = (FTVariable)varAbs;
            if (var.getLink() != null) {
                var.setDefinition(null);
            }
            this._undoVars.add(var);
        }
        DBLogs dbLogs = new DBLogs();
        DBLogs.DefaultManager logMng = new DBLogs.DefaultManager(this.getAppl().getDBUser().getLogin(), dbLogs);
        this._ftEquation.setVariables(saveVars, logMng, false);
        if (logMng.withLogs(DBLogs.DBLevel.WARNING)) {
            dbLogs.traceLogs(_LOG, DBLogs.DBLevel.INFO);
        }
        this._ftUndoVariable = this._ftVariable;
        this._ftVariable = saveVariable;
    }

    protected void prepareRedo() {
        this._redoVars = new ArrayList<FTVariable>(Math.max(100, this._undoVars.size()) * 2);
        for (FTVariableAbstract varAbs : this._ftEquation.getAllVariables()) {
            if (!(varAbs instanceof FTVariable)) continue;
            FTVariable var = (FTVariable)varAbs;
            this._redoVars.add(var);
        }
        this._ftRedoVariable = this._ftVariable;
    }

    @Override
    public void redo() {
        DBLogs dbLogs = new DBLogs();
        DBLogs.DefaultManager logMng = new DBLogs.DefaultManager(this.getAppl().getDBUser().getLogin(), dbLogs);
        this._ftEquation.setVariables(this._redoVars, logMng, false);
        if (logMng.withLogs(DBLogs.DBLevel.WARNING)) {
            dbLogs.traceLogs(_LOG, DBLogs.DBLevel.INFO);
        }
        this.verifyInstanciate(false);
        this._ftEquation.defineLockedVariables();
        this.redoChangeDSFConfig();
        this._ftEquation.updateDependTimeUpdt(this.getAppl().getDAOFactory(), this._ftEquation.getWorkingRelations());
        this.getSource().refreshCtrlInstanciate();
        this._ftEquation.fireChangeDefinitions(Collections.singleton(this._ftRedoVariable), this._source);
        this.getSource().refreshCtrlLogs();
    }

    @Override
    public void undo() {
        DBLogs dbLogs = new DBLogs();
        DBLogs.DefaultManager logMng = new DBLogs.DefaultManager(this.getAppl().getDBUser().getLogin(), dbLogs);
        this._ftEquation.setVariables(this._undoVars, logMng, false);
        if (logMng.withLogs(DBLogs.DBLevel.WARNING)) {
            dbLogs.traceLogs(_LOG, DBLogs.DBLevel.INFO);
        }
        this.verifyInstanciate(false);
        this._ftEquation.defineLockedVariables();
        this.undoChangeDSFConfig();
        this._ftEquation.updateDependTimeUpdt(this.getAppl().getDAOFactory(), this._ftEquation.getWorkingRelations());
        this.getSource().refreshCtrlInstanciate();
        this._ftEquation.fireChangeDefinitions(Collections.singleton(this._ftUndoVariable), this._source);
        this.getSource().refreshCtrlLogs();
    }
}

