/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.dbobj.faulttree.ft.io;

import com.dassault.cecilia.core.cecilia.ResMsgCore;
import com.dassault.cecilia.db.DBFactory;
import com.dassault.cecilia.dbobj.CECFactory;
import com.dassault.cecilia.dbobj.faulttree.ResMsgArbor;
import com.dassault.cecilia.dbobj.faulttree.config.FTConfig;
import com.dassault.cecilia.dbobj.faulttree.config.io.FTConfigHandlerXml;
import com.dassault.cecilia.dbobj.faulttree.ft.FTVariable;
import com.dassault.cecilia.dbobj.faulttree.ft.io.FTXmlConstant;
import com.dassault.cecilia.dbobj.faulttree.obj.FTDefinition;
import com.dassault.cecilia.dbobj.faulttree.obj.FTEquationAbstract;
import com.dassault.cecilia.dbobj.faulttree.obj.FTEvent;
import com.dassault.cecilia.dbobj.faulttree.obj.FTLink;
import com.dassault.cecilia.dbobj.faulttree.obj.io.FTEventHandlerXml;
import com.dassault.cecilia.dbobj.faulttree.obj.io.FTLinkHandlerXml;
import com.dassault.cecilia.dbobj.general.log.DBLogs;
import com.dassault.cecilia.dbobj.wrap.io.SAXWrapHandler;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.logging.Logger;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class FTEquationHandlerXml
extends SAXWrapHandler
implements FTXmlConstant {
    private static Logger _LOG = Logger.getLogger(FTEquationHandlerXml.class.getPackage().getName());
    protected CECFactory _daoFactory;
    State _state = State.ROOT;
    Map<Long, FTVariable> _idVariables = new LinkedHashMap<Long, FTVariable>();
    Map<String, FTVariable> _nameVariables = new LinkedHashMap<String, FTVariable>();
    Map<String, FTConfig> _configs = new LinkedHashMap<String, FTConfig>();
    Map<String, String> _parameters = new LinkedHashMap<String, String>();
    protected FTEventHandlerXml _eventHandler = null;
    protected FTLinkHandlerXml _linkHandler = null;
    protected FTConfigHandlerXml _configHandler = null;
    protected FTVariable _lastVariable = null;
    protected String _criticity = null;
    protected String _mbsaInitialConf = null;
    protected String _mbsaUserGeneration = null;
    protected String _mbsaLastModifiedDateModel = null;
    protected String _mbsaModelPath = null;
    protected String _mbsaTarget = null;

    public FTEquationHandlerXml(DBLogs.DBLogsManager logMng, Locator locator, CECFactory daoFactory) {
        super(logMng, locator);
        this._daoFactory = daoFactory;
    }

    public Collection<FTVariable> getVariables() {
        return this._idVariables.values();
    }

    public Collection<FTConfig> getConfigs() {
        return this._configs.values();
    }

    public Map<String, String> getParameters() {
        return this._parameters;
    }

    public String getCriticityLevel() {
        return this._criticity;
    }

    public String getMBSAInitialConf() {
        return this._mbsaInitialConf;
    }

    public String getMBSAUserGeneration() {
        return this._mbsaUserGeneration;
    }

    public String getMBSALastModifiedDateModel() {
        return this._mbsaLastModifiedDateModel;
    }

    public String getMBSAModelPath() {
        return this._mbsaModelPath;
    }

    public String getMBSATarget() {
        return this._mbsaTarget;
    }

    public void startAction(String key, Map<String, String> attrs, boolean startAction) throws SAXException {
        if (this._eventHandler != null) {
            this._eventHandler.startAction(key, attrs, startAction);
        } else if (this._linkHandler != null) {
            this._linkHandler.startAction(key, attrs, startAction);
        } else if (this._configHandler != null) {
            this._configHandler.startAction(key, attrs, startAction);
        } else if (startAction) {
            if (!"cec.faulttree".equals(key)) {
                this.error(new SAXParseException(ResMsgCore.msgFormat("MSG_ERR_DBMOD_XML_START", "cec.faulttree"), this.getLocator()));
            }
            this._state = State.ROOT;
        } else if (this._state == State.ROOT) {
            if ("ft.variables".equals(key)) {
                this._state = State.VARS;
            } else if ("ft.equations".equals(key)) {
                this._state = State.EQUS;
            } else if ("ft.configs".equals(key)) {
                this._state = State.CFGS;
            } else if ("ft.compute".equals(key)) {
                this._state = State.PARAMS;
            } else if ("ft.criticity".equals(key)) {
                this._criticity = this.readAttr(key, "value", attrs);
            } else if ("ft.mbsafields".equals(key)) {
                this._mbsaInitialConf = this.readAttrNullable(key, "mbsaInitialConf", attrs, "");
                this._mbsaUserGeneration = this.readAttrNullable(key, "mbsaUserGeneration", attrs, "");
                this._mbsaLastModifiedDateModel = this.readAttrNullable(key, "mbsaLastModif", attrs, "");
                this._mbsaModelPath = this.readAttrNullable(key, "mbsaModelPath", attrs, "");
                this._mbsaTarget = this.readAttrNullable(key, "mbsaTarget", attrs, "");
            } else {
                this.errorElementUnknown(key);
            }
        } else if (this._state == State.VARS) {
            if ("ft.var".equals(key)) {
                this.readVar(key, attrs);
            } else {
                this.errorElementUnknown(key);
            }
        } else if (this._state == State.EQUS) {
            if ("ft.equ".equals(key)) {
                this.readEqu(key, attrs);
            } else {
                this.errorElementUnknown(key);
            }
        } else if (this._state == State.VAR) {
            if (!"label".equals(key)) {
                this.errorElementUnknown(key);
            }
        } else if (this._state == State.CFGS) {
            if ("ft.cfg".equals(key)) {
                this._configHandler = new FTConfigHandlerXml(this.getLogManager(), this.getLocator(), this._daoFactory);
                this._configHandler.startAction(key, attrs, true);
            } else {
                this.errorElementUnknown(key);
            }
        } else if (this._state == State.PARAMS) {
            if ("ft.cpt.param".equals(key)) {
                String type = this.readAttr(key, "type", attrs);
                String value = this.readAttr(key, "value", attrs);
                this._parameters.put(type, value);
            } else {
                this.errorElementUnknown(key);
            }
        } else {
            this.errorElementUnknown(key);
        }
    }

    public boolean endAction(String key, Map<String, String> attrs, String txt) throws SAXException {
        if (this._eventHandler != null) {
            return this.endEvent(key, attrs, txt);
        }
        if (this._linkHandler != null) {
            boolean result = this._linkHandler.endAction(key, attrs, txt);
            if (result) {
                if ("ft.var".equals(key)) {
                    FTEquationAbstract ftEquation = this._linkHandler.getSubTree();
                    if (ftEquation != null) {
                        FTLink ftLink = new FTLink().setSubTree(ftEquation.getCopy());
                        if (this._linkHandler.getGeneric() != null) {
                            ftLink.setGeneric(this._linkHandler.getGeneric());
                        }
                        this._lastVariable.setLink(ftLink);
                    } else {
                        this.warning(new SAXParseException(ResMsgArbor.msgFormat("FT_READ_ERR_LINK_CONVERT", this._lastVariable.getName()), this.getLocator()));
                        this._lastVariable.setEvent(new FTEvent());
                    }
                    String label = this._linkHandler.getLabel();
                    if (label != null) {
                        this._lastVariable.setLabel(label);
                    }
                } else {
                    _LOG.warning("Erreur interne \u00e0 la fermeture de l'\u00e9l\u00e9ment '" + key + "'");
                }
                this._linkHandler = null;
            }
        } else if (this._configHandler != null) {
            boolean result = this._configHandler.endAction(key, attrs, txt);
            if (result) {
                FTConfig create = this._configHandler.getConfig();
                String name = create.getName();
                if (this._configs.get(name) != null) {
                    this.error(new SAXParseException(ResMsgArbor.msgFormat("MSG_ERR_XML_FT_NAME_ALREADY", name), this.getLocator()));
                }
                this._configs.put(name, create);
                this._configHandler = null;
            }
        } else if (this._state == State.VARS && "ft.variables".equals(key)) {
            this._state = State.ROOT;
        } else if (this._state == State.EQUS && "ft.equations".equals(key)) {
            this._state = State.ROOT;
        } else if (this._state == State.CFGS && "ft.configs".equals(key)) {
            this._state = State.ROOT;
        } else if (this._state == State.PARAMS && "ft.compute".equals(key)) {
            this._state = State.ROOT;
        } else if (this._state == State.VAR) {
            if ("label".equals(key)) {
                this._lastVariable.setLabel(txt);
            } else if ("ft.var".equals(key)) {
                this._state = State.VARS;
            }
        }
        return "cec.faulttree".equals(key);
    }

    protected boolean endEvent(String key, Map<String, String> attrs, String txt) throws SAXException {
        boolean result = this._eventHandler.endAction(key, attrs, txt);
        if (result) {
            if ("ft.var".equals(key)) {
                String label;
                FTEvent event = this._eventHandler.getEvent();
                if (event != null) {
                    this._lastVariable.setEvent(event);
                }
                if ((label = this._eventHandler.getLabel()) != null) {
                    this._lastVariable.setLabel(label);
                }
            } else {
                _LOG.warning("Erreur interne \u00e0 la fermeture de l'\u00e9l\u00e9ment '" + key + "'");
            }
            this._eventHandler = null;
        }
        return false;
    }

    private void readVar(String key, Map<String, String> attrs) throws SAXException {
        long id = this.readID(key, "id", attrs);
        String name = this.readName(key, "name", attrs);
        String export = attrs.get("export");
        boolean isRoot = this.readBoolean(key, "isRoot", attrs, true, false);
        boolean isLeaf = this.readBoolean(key, "isLeaf", attrs, true, false);
        boolean isLink = this.readBoolean(key, "isLink", attrs, true, false);
        boolean isGeneric = this.readBoolean(key, "isGeneric", attrs, true, false);
        double proba = this.readDouble(key, "pr", attrs, true, Double.NaN);
        FTVariable var = this._idVariables.get(id);
        if (var != null) {
            this.error(new SAXParseException(ResMsgArbor.msgFormat("MSG_ERR_XML_FT_ID_ALREADY", id), this.getLocator()));
        }
        if ((var = this._nameVariables.get(name)) != null) {
            this.error(new SAXParseException(ResMsgArbor.msgFormat("MSG_ERR_XML_FT_NAME_ALREADY", name), this.getLocator()));
        }
        var = new FTVariable().setName(name);
        this._idVariables.put(id, var);
        this._nameVariables.put(name, var);
        this._lastVariable = var;
        if (!Double.isNaN(proba)) {
            var.setProbability(proba);
        }
        if (export != null && !export.isEmpty()) {
            var.setExportName(export);
        }
        if (isGeneric) {
            var.setGeneric(isGeneric);
        }
        if (isRoot) {
            var.setRoot(true);
        }
        if (isLink) {
            this._linkHandler = new FTLinkHandlerXml(this.getLogManager(), this.getLocator(), this._daoFactory);
            this._linkHandler.startAction(key, attrs, true);
        } else if (isLeaf) {
            this._eventHandler = new FTEventHandlerXml(this.getLogManager(), this.getLocator(), this._daoFactory);
            this._eventHandler.startAction(key, attrs, true);
        } else {
            this._state = State.VAR;
        }
    }

    private void readEqu(String key, Map<String, String> attrs) throws SAXException {
        FTVariable var = null;
        long id = this.readID(key, "id", attrs);
        var = this._idVariables.get(id);
        if (var == null) {
            this.error(new SAXParseException(ResMsgArbor.msgFormat("MSG_ERR_XML_FT_ID_UNKNOWN", id), this.getLocator()));
        }
        FTDefinition.Type type = null;
        String attr = attrs.get("type");
        if (attr == null || attr.isEmpty()) {
            this.error(new SAXParseException(ResMsgCore.msgFormat("MSG_ERR_DBMOD_XML_ATTR_NO", key, "type"), this.getLocator()));
        } else {
            type = (FTDefinition.Type)FTEquationHandlerXml.valueOfEnum(FTDefinition.Type.class, (String)attr.toUpperCase());
            if (type == null) {
                this.warning(new SAXParseException(ResMsgCore.msgFormat("MSG_ERR_DBMOD_XML_ATTR_FORMAT", key, "type", attr), this.getLocator()));
                type = FTDefinition.Type.OR;
            }
        }
        int atLeast = 1;
        if (type == FTDefinition.Type.KOFN) {
            String attr2 = attrs.get("atLeast");
            if (attr2 == null || attr2.isEmpty()) {
                this.error(new SAXParseException(ResMsgCore.msgFormat("MSG_ERR_DBMOD_XML_ATTR_NO", key, "atLeast"), this.getLocator()));
            } else {
                try {
                    atLeast = Integer.parseInt(attr2);
                }
                catch (NumberFormatException nfe) {
                    this.warning(new SAXParseException(ResMsgCore.msgFormat("MSG_ERR_DBMOD_XML_ATTR_FORMAT", key, "atLeast", attr2), this.getLocator()));
                }
            }
        }
        ArrayList<FTVariable> args = new ArrayList<FTVariable>(16);
        String children = attrs.get("children");
        if (children == null || children.isEmpty()) {
            this.error(new SAXParseException(ResMsgCore.msgFormat("MSG_ERR_DBMOD_XML_ATTR_NO", key, "children"), this.getLocator()));
        } else {
            StringTokenizer st = new StringTokenizer(children, ",");
            while (st.hasMoreTokens()) {
                long id2;
                FTVariable arg;
                String tok = st.nextToken();
                if (!DBFactory.verifyInteger(tok)) {
                    this.error(new SAXParseException(ResMsgCore.msgFormat("MSG_ERR_DBMOD_XML_ATTR_FORMAT", key, "children", children), this.getLocator()));
                }
                if ((arg = this._idVariables.get(id2 = Long.parseLong(tok))) == null) {
                    this.error(new SAXParseException(ResMsgArbor.msgFormat("MSG_ERR_XML_FT_ID_UNKNOWN", id2), this.getLocator()));
                }
                args.add(arg);
            }
        }
        int nbrArg = args.size();
        if (nbrArg < type.getMinArg() || nbrArg > type.getMaxArg()) {
            this.warning(new SAXParseException(ResMsgArbor.msgFormat("MSG_ERR_DAG_NBRARG_DEF", var.getName(), nbrArg), this.getLocator()));
        } else if (type == FTDefinition.Type.KOFN && (atLeast < 1 || atLeast > nbrArg)) {
            this.warning(new SAXParseException(ResMsgArbor.msgFormat("MSG_ERR_DAG_NBRARG_DEF", var.getName(), nbrArg), this.getLocator()));
        } else {
            FTDefinition ftDefinition = new FTDefinition(type, args);
            if (type == FTDefinition.Type.KOFN) {
                ftDefinition.setAtLeast(atLeast);
            }
            if (this.readBoolean(key, "isGSR", attrs, true, false)) {
                ftDefinition.setGSR(true);
            }
            var.setDefinition(ftDefinition);
        }
    }

    private static enum State {
        ROOT,
        VARS,
        VAR,
        EQUS,
        CFGS,
        PARAMS,
        CRITICITY;

    }
}

