/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.dbobj.faulttree.ft.io.dagdef;

import com.dassault.cecilia.dbobj.faulttree.ft.io.dagdef.EquBoolNode;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class EquBoolBigNode
implements EquBoolNode {
    private String _name;
    int _flag;
    Collection<EquBoolBigNode> _depends;
    short _mark;
    private static final short MASK_RIGHT = 4;
    private static final short MASK_ROOT = 8;
    private static final short MASK_LEAF = 16;
    private static final short MASK_GATE = 32;
    private Map<String, String> _attributes;

    public EquBoolBigNode() {
    }

    public EquBoolBigNode(String a) {
        this._name = a;
        this._attributes = null;
        this._flag = 0;
    }

    @Override
    public String getName() {
        return this._name;
    }

    @Override
    public EquBoolNode.Type getType() {
        return EquBoolNode.Type.VAR;
    }

    @Override
    public int getFlag() {
        return this._flag;
    }

    @Override
    public void setFlag(int v) {
        this._flag = v;
    }

    public void setDepends(Collection<EquBoolBigNode> v) {
        this._depends = v;
    }

    public Collection<EquBoolBigNode> getDepends() {
        return this._depends;
    }

    @Override
    public List<? extends EquBoolNode> getChildren() {
        return null;
    }

    boolean isRight() {
        return (this._mark & 4) > 0;
    }

    void setRight() {
        this._mark = (short)(this._mark | 4);
    }

    @Override
    public boolean isRoot() {
        return (this._mark & 8) > 0;
    }

    void setRoot() {
        this._mark = (short)(this._mark | 8);
    }

    @Override
    public boolean isLeaf() {
        return (this._mark & 0x10) > 0;
    }

    void setLeaf() {
        this._mark = (short)(this._mark | 0x10);
    }

    boolean isGate() {
        return (this._mark & 0x20) > 0;
    }

    void setGate() {
        this._mark = (short)(this._mark | 0x20);
    }

    @Override
    public Map<String, String> getAttributes() {
        return this._attributes;
    }

    void addAttribute(String attr, String val) {
        if (this._attributes == null) {
            this._attributes = new TreeMap<String, String>();
        }
        this._attributes.put(attr, val);
    }

    @Override
    public String getAttribute(String nameAttr) {
        if (this._attributes == null) {
            return null;
        }
        return this._attributes.get(nameAttr);
    }

    public void printLeaf(Appendable out, boolean bigtree) throws IOException {
        boolean write = false;
        if (this._attributes != null) {
            for (Map.Entry<String, String> attr : this._attributes.entrySet()) {
                String key = attr.getKey();
                if (key.startsWith("#")) {
                    if (!key.equals("#Law")) continue;
                    out.append("law ");
                    out.append(this.getName());
                    out.append(" ");
                    out.append(attr.getValue());
                    out.append(";\n");
                    write = true;
                    continue;
                }
                out.append("attribute set ");
                out.append(key);
                out.append(" ");
                out.append(this.getName());
                out.append(" \"");
                out.append(attr.getValue());
                out.append("\" ;\n");
                write = true;
            }
        }
        if (!write && bigtree) {
            out.append("/* leaf : ");
            out.append(this.getName());
            out.append(" */\n");
        }
    }
}

