/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.dbobj.faulttree.ft.io.dagdef;

import com.dassault.cecilia.dbobj.faulttree.ResMsgArbor;
import com.dassault.cecilia.dbobj.faulttree.ft.io.dagdef.EquBoolNode;
import com.dassault.cecilia.dbobj.faulttree.ft.io.dagdef.EquBoolStdNode;
import com.dassault.cecilia.dbobj.faulttree.ft.io.dagdef.EquBoolStdParser;
import com.dassault.cecilia.dbobj.faulttree.ft.io.dagdef.EquBoolStore;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;

public class EquBoolStdStore
implements EquBoolStore {
    private static Logger _LOG = Logger.getLogger(EquBoolStdStore.class.getPackage().getName());
    private int _nextNode = 0;
    private Map<Integer, EquBoolStdNode> _nodes = new HashMap<Integer, EquBoolStdNode>();
    private Map<String, EquBoolStdNode> _variables = new LinkedHashMap<String, EquBoolStdNode>();
    private Map<String, String> _parameters = new LinkedHashMap<String, String>();
    private List<String> _syntaxError = new ArrayList<String>();
    private static final boolean __COPY_READER = false;

    public void clearAll() {
        this._nextNode = 0;
        this._nodes.clear();
        this._variables.clear();
        this._parameters.clear();
        this._syntaxError.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean loadFile(String name) {
        Reader br = null;
        try {
            File f = new File(name);
            br = new FileReader(f);
            _LOG.fine("Lecture de " + name + " .");
            boolean bl = this.parseFile(br);
            return bl;
        }
        catch (FileNotFoundException fnf) {
            _LOG.log(Level.WARNING, "Le fichier " + name + " est introuvable.", fnf);
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (Exception e) {
                    _LOG.log(Level.FINE, "Exception during close stream", e);
                }
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean loadStream(Reader in) {
        try {
            boolean bl = this.parseFile(in);
            return bl;
        }
        finally {
            try {
                in.close();
                _LOG.finest("Close EquBoolStdStore::loadStream(...)");
            }
            catch (Exception e) {
                _LOG.log(Level.INFO, "Exception during close stream", e);
            }
        }
    }

    public boolean parseFile(Reader br) {
        Object copy = null;
        EquBoolStdParser parse = null;
        parse = new EquBoolStdParser(br, this);
        try {
            parse.yyparse();
            return this._syntaxError.size() <= 0;
        }
        catch (Exception e) {
            _LOG.log(Level.WARNING, "Line " + parse.getCurrentLine() + " : Internal lexer error [" + e.getMessage() + "]", e);
            this.clearAll();
            return false;
        }
    }

    EquBoolStdNode createUniqueVariable(String name) {
        EquBoolStdNode node = null;
        try {
            node = this._variables.get(name);
            if (node == null) {
                node = new EquBoolStdNode(EquBoolNode.Type.VAR, name);
                this._nodes.put(this._nextNode++, node);
                this._variables.put(name, node);
            }
        }
        catch (Exception e) {
            _LOG.log(Level.WARNING, "Error creating variable " + name, e);
        }
        return node;
    }

    void setLawToVariables(Collection<String> variables, String law) {
        for (String id : variables) {
            EquBoolStdNode node = this._variables.get(id);
            if (node == null) {
                _LOG.info("Variable [" + id + "] unknow");
                continue;
            }
            node.addAttribute("#Law", law);
        }
    }

    void setAttributesToVariable(Collection<String> variables, String name, String value) {
        for (String id : variables) {
            EquBoolStdNode node = this._variables.get(id);
            if (node == null) {
                _LOG.info("Variable [" + id + "] unknow");
                continue;
            }
            node.addAttribute(name, value);
        }
    }

    void setParameter(String parameter, String value) {
        this._parameters.put(parameter, value);
    }

    @Override
    public Map<String, String> getParameters() {
        return Collections.unmodifiableMap(this._parameters);
    }

    EquBoolStdNode createTrue() {
        return EquBoolStdNode.__TRUE;
    }

    EquBoolStdNode createFalse() {
        return EquBoolStdNode.__FALSE;
    }

    EquBoolStdNode createAnd(List<EquBoolStdNode> children) {
        EquBoolStdNode node = new EquBoolStdNode(EquBoolNode.Type.AND, "&");
        return this.assignAndPut(children, node);
    }

    EquBoolStdNode createOr(List<EquBoolStdNode> children) {
        EquBoolStdNode node = new EquBoolStdNode(EquBoolNode.Type.OR, "|");
        return this.assignAndPut(children, node);
    }

    EquBoolStdNode createImply(List<EquBoolStdNode> children) {
        EquBoolStdNode node = new EquBoolStdNode(EquBoolNode.Type.IMPLY, "=>");
        return this.assignAndPut(children, node);
    }

    EquBoolStdNode createImplied(List<EquBoolStdNode> children) {
        EquBoolStdNode node = new EquBoolStdNode(EquBoolNode.Type.IMPLIED, "<=");
        return this.assignAndPut(children, node);
    }

    EquBoolStdNode createXor(List<EquBoolStdNode> children) {
        EquBoolStdNode node = new EquBoolStdNode(EquBoolNode.Type.XOR, "#");
        return this.assignAndPut(children, node);
    }

    EquBoolStdNode createIte(List<EquBoolStdNode> children) {
        EquBoolStdNode node = new EquBoolStdNode(EquBoolNode.Type.ITE, "?");
        return this.assignAndPut(children, node);
    }

    EquBoolStdNode createIff(List<EquBoolStdNode> children) {
        EquBoolStdNode node = new EquBoolStdNode(EquBoolNode.Type.IFF, "=");
        return this.assignAndPut(children, node);
    }

    EquBoolStdNode createAtLeast(List<EquBoolStdNode> children, int k) {
        EquBoolStdNode node = new EquBoolStdNode(EquBoolNode.Type.KOfN, "@");
        node.addAttribute("#AtLeast", Integer.toString(k));
        return this.assignAndPut(children, node);
    }

    EquBoolStdNode createCardinality(List<EquBoolStdNode> children, int k, int j) {
        EquBoolStdNode node = new EquBoolStdNode(EquBoolNode.Type.CARD, "#");
        node.addAttribute("#AtLeast", Integer.toString(k));
        node.addAttribute("#AtMost", Integer.toString(j));
        return this.assignAndPut(children, node);
    }

    EquBoolStdNode createExists(List<EquBoolStdNode> children) {
        EquBoolStdNode node = new EquBoolStdNode(EquBoolNode.Type.EXISTS, "exists");
        return this.assignAndPut(children, node);
    }

    EquBoolStdNode createForAll(List<EquBoolStdNode> children) {
        EquBoolStdNode node = new EquBoolStdNode(EquBoolNode.Type.FORALL, "forall");
        return this.assignAndPut(children, node);
    }

    EquBoolStdNode createCofactor(List<EquBoolStdNode> children) {
        EquBoolStdNode node = new EquBoolStdNode(EquBoolNode.Type.COF, "cofactor");
        return this.assignAndPut(children, node);
    }

    EquBoolStdNode createMinus(List<EquBoolStdNode> children) {
        EquBoolStdNode node = new EquBoolStdNode(EquBoolNode.Type.NOT, "-");
        return this.assignAndPut(children, node);
    }

    void assignDefinition(EquBoolStdNode parent, EquBoolStdNode child) {
        if (parent.getType() == EquBoolNode.Type.VAR && !parent.getChildren().isEmpty()) {
            List<EquBoolStdNode> children = parent.getChildren();
            while (!children.isEmpty()) {
                EquBoolStdNode oldchild = children.get(0);
                oldchild.getParents().remove(parent);
                children.remove(oldchild);
            }
        }
        parent.addChild(child);
        child.addParent(parent);
    }

    private EquBoolStdNode assignAndPut(List<EquBoolStdNode> children, EquBoolStdNode node) {
        for (EquBoolStdNode child : children) {
            this.assignDefinition(node, child);
        }
        this._nodes.put(this._nextNode++, node);
        return node;
    }

    public void printNodes(Writer out) throws IOException {
        TreeMap<String, String> parameters = new TreeMap<String, String>(this._parameters);
        for (Map.Entry param : parameters.entrySet()) {
            out.write("parameter set ");
            out.write((String)param.getKey());
            out.write(" ");
            out.write((String)param.getValue());
            out.write(";\n");
        }
        TreeMap<String, EquBoolStdNode> variables = new TreeMap<String, EquBoolStdNode>(this._variables);
        for (EquBoolStdNode node : variables.values()) {
            if (node.isRoot()) {
                out.write("/* root : ");
                out.write(node.getName());
                out.write(" */\n");
            }
            if (node.isLeaf()) {
                node.printLeaf(out, false);
                continue;
            }
            out.write(node.getName());
            out.write(" := ");
            EquBoolStdNode def = node.getChildren().get(0);
            def.printNode(out);
            out.write(";\n");
        }
    }

    public void printStatistics(Writer out) throws IOException {
        int nbrRoots = 0;
        int nbrLeaves = 0;
        int nbrGates = 0;
        for (EquBoolStdNode node : this._variables.values()) {
            if (node.isRoot()) {
                ++nbrRoots;
                continue;
            }
            if (node.isLeaf()) {
                ++nbrLeaves;
                continue;
            }
            ++nbrGates;
        }
        out.write("/* Statistics\n");
        out.write("\tNodes : ");
        out.write(Integer.toString(this._nodes.size()));
        out.write("\n");
        out.write("\tVariables : ");
        out.write(Integer.toString(this._variables.size()));
        out.write("\n");
        out.write("\t\tRoots : ");
        out.write(Integer.toString(nbrRoots));
        out.write("\n");
        out.write("\t\tLeaves : ");
        out.write(Integer.toString(nbrLeaves));
        out.write("\n");
        out.write("\t\tGates : ");
        out.write(Integer.toString(nbrGates));
        out.write("\n");
        out.write(" */\n");
    }

    public void saveFile(String filename) {
        try {
            BufferedWriter bw = new BufferedWriter(new FileWriter(filename));
            bw.write(filename);
            bw.flush();
            bw.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public List<EquBoolStdNode> getVariables() {
        return new ArrayList<EquBoolStdNode>(this._variables.values());
    }

    Set<String> getAllNames() {
        return this._variables.keySet();
    }

    @Override
    public List<String> getSyntaxError() {
        return this._syntaxError;
    }

    void addSyntaxError(String error) {
        this._syntaxError.add(error);
    }

    @Override
    public String verify() {
        for (EquBoolNode equBoolNode : this._nodes.values()) {
            equBoolNode.setFlag(0);
        }
        int nbrRoot = 0;
        for (EquBoolNode equBoolNode : this.getVariables()) {
            if (equBoolNode.isRoot()) {
                ++nbrRoot;
            }
            if (this.verifyDag_rec(equBoolNode)) continue;
            return ResMsgArbor.getString("MSG_ERR_DAG_FT_VERIFY_LOOP");
        }
        for (EquBoolNode equBoolNode : this._nodes.values()) {
            equBoolNode.setFlag(0);
        }
        if (nbrRoot == 0) {
            return ResMsgArbor.getString("MSG_ERR_DAG_FT_VERIFY_EMPTY");
        }
        if (nbrRoot > 1) {
            return ResMsgArbor.msgFormat("MSG_ERR_DAG_FT_VERIFY_MULTITOP", nbrRoot);
        }
        return null;
    }

    private boolean verifyDag_rec(EquBoolNode var) {
        if (var.getFlag() == 1) {
            return true;
        }
        if (var.getFlag() == 2) {
            return false;
        }
        var.setFlag(2);
        for (EquBoolNode equBoolNode : var.getChildren()) {
            if (this.verifyDag_rec(equBoolNode)) continue;
            return false;
        }
        var.setFlag(1);
        return true;
    }

    public static void main(String[] args) {
        for (int i = 0; i < args.length; ++i) {
            System.out.println("Load file : " + args[i]);
            try {
                EquBoolStdStore store = new EquBoolStdStore();
                store.loadStream(new FileReader(args[i]));
                StringWriter out = new StringWriter(512);
                store.printStatistics(out);
                store.printNodes(out);
                System.out.println(out.toString());
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

