/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.dbobj.faulttree.gui;

import com.dassault.cecilia.core.ResMsgVoc;
import com.dassault.cecilia.core.cecilia.pref.PrefFieldBoolean;
import com.dassault.cecilia.core.cecilia.pref.PrefFieldsFactory;
import com.dassault.cecilia.core.cecilia.print.ListProcessorJava;
import com.dassault.cecilia.core.cecilia.print.SrbInputStream;
import com.dassault.cecilia.dbobj.faulttree.gui.ItemAbstractTableModel;
import com.dassault.cecilia.dbobj.wrap.PageableThread;
import com.dassault.cecilia.main.cecilia.gui.CInternalFrame;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.print.PageFormat;
import java.awt.print.Pageable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.io.IOException;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;

public abstract class ItemAbstractInternalFrame<T>
extends CInternalFrame {
    private static Logger _LOG = Logger.getLogger(ItemAbstractInternalFrame.class.getPackage().getName());
    protected ItemAbstractTableModel<T> _modelTable;
    protected JTable _table;
    protected JScrollPane _scrollTable;

    public ItemAbstractInternalFrame(String strTitle) {
        super(strTitle);
    }

    public ItemAbstractInternalFrame(ImageIcon icone, String strTitle) {
        super(icone, strTitle);
    }

    public ItemAbstractInternalFrame(ImageIcon icone, String iconeLabel, String strTitle) {
        super(icone, iconeLabel, strTitle);
    }

    protected abstract ItemAbstractTableModel<T> createModel();

    protected abstract JTable createTable(ItemAbstractTableModel<T> var1);

    protected void build() {
        this._modelTable = this.createModel();
        this._table = this.createTable(this._modelTable);
        this._table.setAutoResizeMode(0);
        this.getContentPane().setLayout(new GridBagLayout());
        JPanel panelList = new JPanel(new GridBagLayout());
        panelList.setBorder(BorderFactory.createEtchedBorder());
        JPanel buttonsPanel = this.createButtonsPanel();
        panelList.add((Component)buttonsPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 10, 0, 10), 0, 0));
        this._scrollTable = new JScrollPane(this._table);
        panelList.add((Component)this._scrollTable, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 10, 10, 10), 0, 0));
        this.getContentPane().add((Component)panelList, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(10, 10, 0, 10), 0, 0));
        this.pack();
        this.setResizable(true);
    }

    protected JPanel createButtonsPanel() {
        JPanel panelButtons = new JPanel(new GridBagLayout());
        int idxX = 0;
        JLabel glue = new JLabel();
        panelButtons.add((Component)glue, new GridBagConstraints(idxX++, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(10, 10, 10, 10), 0, 0));
        JButton fieldsDlg = new JButton(ResMsgVoc.getString("VOC_FIELDS"));
        panelButtons.add((Component)fieldsDlg, new GridBagConstraints(idxX++, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(10, 10, 10, 0), 0, 0));
        fieldsDlg.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                List<PrefFieldBoolean> originItems = ItemAbstractInternalFrame.this._modelTable.getColumnModel().getOptionnalFields();
                List<PrefFieldBoolean> copyItems = PrefFieldsFactory.clone(originItems);
                if (!PrefFieldsFactory.displayDlgChangeFields(ItemAbstractInternalFrame.this._table, copyItems)) {
                    return;
                }
                boolean change = PrefFieldsFactory.copySelected(copyItems, originItems);
                if (change) {
                    ItemAbstractInternalFrame.this._modelTable.getColumnModel().resetFilterIndexes();
                    ItemAbstractInternalFrame.this._modelTable.refresh(false, true);
                }
            }
        });
        return panelButtons;
    }

    public abstract List<PrefFieldBoolean> getPrintExportOptionnalFields();

    public abstract PageFormat getDefaultPageFormat();

    protected Pageable createPageable() {
        PageableThread thread = new PageableThread(this){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected Pageable doCreatePageable() {
                PageFormat format = ItemAbstractInternalFrame.this.getDefaultPageFormat();
                ListProcessorJava printable = null;
                List<PrefFieldBoolean> listPrefs = ItemAbstractInternalFrame.this.getPrintExportOptionnalFields();
                SrbInputStream scribe = new SrbInputStream("");
                List<PrefFieldBoolean> currentPrefs = ItemAbstractInternalFrame.this._modelTable.getColumnModel().getOptionnalFields();
                try {
                    ItemAbstractInternalFrame.this._modelTable.getColumnModel().setOptionnalFields(listPrefs);
                    ItemAbstractInternalFrame.this._modelTable.exportToScribeFile(scribe, ItemAbstractInternalFrame.this._table);
                }
                catch (IOException err) {
                    _LOG.log(Level.WARNING, "Exception lors de l'impression de la vue en cours : " + ItemAbstractInternalFrame.this.getDBFolder(), err);
                    Pageable pageable = null;
                    return pageable;
                }
                finally {
                    ItemAbstractInternalFrame.this._modelTable.getColumnModel().setOptionnalFields(currentPrefs);
                    scribe.close();
                }
                printable = new ListProcessorJava(scribe);
                printable.processScribeFile();
                printable.computePageCount(format);
                return printable;
            }
        };
        thread.realiseDo();
        return thread.getPageable();
    }

    @Override
    public boolean print() {
        PrinterJob job = PrinterJob.getPrinterJob();
        try {
            job.setPageable(this.createPageable());
            if (!job.printDialog()) {
                return true;
            }
            try {
                job.print();
            }
            catch (PrinterException e) {
                _LOG.log(Level.FINE, "Probleme d'impression de la vue en cours : " + this.getDBFolder(), e);
                return false;
            }
        }
        catch (Throwable th) {
            _LOG.log(Level.WARNING, "Exception lors de l'impression de la vue en cours : " + this.getDBFolder(), th);
            return false;
        }
        return true;
    }
}

