/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.dbobj.faulttree.gui;

import com.dassault.cecilia.core.cecilia.export.DBKOutput;
import com.dassault.cecilia.core.cecilia.export.DBKTableModel;
import com.dassault.cecilia.core.cecilia.pref.PrefFieldBoolean;
import com.dassault.cecilia.core.cecilia.print.SrbInputStream;
import com.dassault.cecilia.dbobj.faulttree.gui.ItemAbstractColumnsModel;
import com.dassault.cecilia.dbobj.faulttree.gui.ItemTableModel;
import java.io.IOException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import javax.swing.JTable;
import javax.swing.event.EventListenerList;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;

public abstract class ItemAbstractTableModel<T>
implements ItemTableModel {
    private ItemAbstractColumnsModel _columnsModel;
    protected EventListenerList _listenerList = new EventListenerList();
    static final SimpleDateFormat __exportDateFormat = (SimpleDateFormat)DateFormat.getDateInstance(3);

    public ItemAbstractTableModel(ItemAbstractColumnsModel columnsModel) {
        this._columnsModel = columnsModel;
    }

    @Override
    public void addTableModelListener(TableModelListener l) {
        this._listenerList.add(TableModelListener.class, l);
    }

    @Override
    public void removeTableModelListener(TableModelListener l) {
        this._listenerList.remove(TableModelListener.class, l);
    }

    public void fireTableChanged(TableModelEvent e) {
        Object[] listeners = this._listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != TableModelListener.class) continue;
            ((TableModelListener)listeners[i + 1]).tableChanged(e);
        }
    }

    @Override
    public void refresh(boolean rowsChanged, boolean columnsChanged) {
        if (columnsChanged) {
            this.fireTableChanged(new TableModelEvent(this, -1));
        }
        if (rowsChanged) {
            this.fireTableChanged(new TableModelEvent(this));
        }
    }

    @Override
    public ItemAbstractColumnsModel getColumnModel() {
        return this._columnsModel;
    }

    @Override
    public int getColumnCount() {
        return this._columnsModel.getColumnCount();
    }

    public abstract int getFullRowCount();

    public abstract T getItem(int var1);

    public abstract Object getValueAt(T var1, int var2);

    @Override
    public Object getValueAt(int row, int col) {
        Object result = this.getValueAt(this.getItem(row), col);
        return result;
    }

    @Override
    public String getColumnName(int column) {
        return this._columnsModel.getColumnName(column);
    }

    public abstract Class getColumnClass(int var1);

    @Override
    public boolean isCellEditable(int row, int col) {
        return false;
    }

    @Override
    public void setValueAt(Object aValue, int row, int column) {
    }

    protected String getExportValueAt(int row, int col, int idx, JTable table) {
        return this.getValueAt(row, col).toString();
    }

    protected int getExportNbrSubCell(int row, int col, JTable table) {
        return 1;
    }

    public abstract void exportToScribeFile(SrbInputStream var1, JTable var2) throws IOException;

    public void exportTableToScribeFile(Appendable b, JTable table) throws IOException {
        for (int col = 0; col < this.getColumnCount(); ++col) {
            b.append("<TABCOL>" + this.getColumnName(col) + "\n");
        }
        StringBuffer cwidth = new StringBuffer();
        StringBuffer align = new StringBuffer();
        for (int col = 0; col < this.getColumnCount(); ++col) {
            PrefFieldBoolean field = this.getColumnModel().getColumnField(col);
            Object info = field.getInfo("Width");
            int width = info != null && info instanceof Number ? ((Number)info).intValue() : 5;
            cwidth.append(width * 5 / 3);
            cwidth.append(" ");
            info = field.getInfo("Align");
            align.append(info == null ? "C" : info.toString());
            align.append(" ");
        }
        cwidth.deleteCharAt(cwidth.length() - 1);
        align.deleteCharAt(align.length() - 1);
        b.append("<TABDEF CWIDTH = '");
        b.append(cwidth);
        b.append("' ALIGN = '");
        b.append(align);
        b.append("'>\n");
        for (int row = 0; row < this.getRowCount(); ++row) {
            int maxSubCell = 1;
            for (int col = 0; col < this.getColumnCount(); ++col) {
                maxSubCell = Math.max(maxSubCell, this.getExportNbrSubCell(row, col, table));
            }
            for (int idxSubCell = 0; idxSubCell < maxSubCell; ++idxSubCell) {
                for (int col = 0; col < this.getColumnCount(); ++col) {
                    b.append("<C>" + this.getExportValueAt(row, col, idxSubCell, table) + "\n");
                }
            }
        }
    }

    public String getCurrentDateAsDDMMYYYY() {
        return __exportDateFormat.format(new Date());
    }

    public abstract void exportToXMLDocBook(DBKOutput var1) throws IOException;

    public void exportTableToXMLDocBook(DBKOutput xmlWriter, JTable table) {
        ArrayList<String> columns = new ArrayList<String>();
        for (int col = 0; col < this.getColumnCount(); ++col) {
            columns.add(this.getColumnName(col));
        }
        ArrayList rows = new ArrayList();
        for (int row = 0; row < this.getRowCount(); ++row) {
            ArrayList<String> irow = new ArrayList<String>();
            for (int col = 0; col < this.getColumnCount(); ++col) {
                irow.add(this.getExportValueAt(row, col, -1, table));
            }
            rows.add(irow);
        }
        DBKTableModel tableModel = new DBKTableModel(rows, columns, DBKTableModel.DataType.OBJECTS);
        xmlWriter.insertTable(tableModel);
    }
}

