/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.dbobj.faulttree.obj;

import com.dassault.cecilia.db.DBFolder;
import com.dassault.cecilia.db.DBGlobEvent;
import com.dassault.cecilia.db.DBUser;
import com.dassault.cecilia.db.IUser;
import com.dassault.cecilia.dbobj.faulttree.egli.FTGlobEventVar;
import com.dassault.cecilia.dbobj.faulttree.ft.FTVariable;
import com.dassault.cecilia.dbobj.faulttree.obj.FTDefinition;
import com.dassault.cecilia.dbobj.faulttree.obj.FTVariableAbstract;
import com.dassault.cecilia.dbobj.faulttree.obj.FTVariableExtern;
import com.dassault.cecilia.dbobj.general.log.DBLogs;
import com.dassault.cecilia.dbobj.wrap.DBWrap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class FTEquationAbstract
extends DBWrap {
    private static Logger _LOG = Logger.getLogger(FTEquationAbstract.class.getPackage().getName());
    protected static final int FLAG_INIT = 0;
    protected static final int FLAG_TREATED = 1;
    protected static final int FLAG_GENERIC = 2;
    protected static final int FLAG_REMOVED = 3;

    @Override
    protected Logger getJavaLog() {
        return _LOG;
    }

    @Override
    public DBFolder.Family getFamily() {
        return DBFolder.Family.PROJECT;
    }

    public FTEquationAbstract(DBFolder dbFolder) {
        super(dbFolder);
    }

    public String toString() {
        List<FTVariableAbstract> vars = this.getAllVariables();
        StringBuilder out = new StringBuilder(vars.size() * 48);
        try {
            for (FTVariableAbstract var : vars) {
                var.writeEqu(out);
            }
        }
        catch (Exception e) {
            _LOG.log(Level.FINEST, "", e);
            return super.toString();
        }
        return out.toString();
    }

    @Override
    public abstract FTEquationAbstract getCopy();

    public abstract String getAbstract();

    public abstract List<FTVariableAbstract> getAllVariables();

    public abstract FTVariableAbstract getVariable(String var1);

    public boolean isBigTree() {
        return false;
    }

    public void setFlags(int value) {
        for (FTVariableAbstract var : this.getAllVariables()) {
            var.setFlags(value);
        }
    }

    public void propageFlag(FTVariableAbstract var, int value) {
        if (var.getFlags() == value) {
            return;
        }
        var.setFlags(value);
        FTDefinition ftDefinition = var.getDefinition();
        if (ftDefinition != null) {
            for (FTVariableAbstract arg : ftDefinition.getArgs()) {
                this.propageFlag(arg, value);
            }
        }
    }

    protected void addInstanciateLog(DBLogs dbLogs, DBFolder dbFolderSrc, DBLogs.DBLevel dbLevel, String msg) {
        Date date = dbFolderSrc.getDateModify();
        IUser user = dbFolderSrc.getUserModify();
        dbLogs.addLog(date != null ? date : new Date(0L), user != null ? user.getLogin() : "???", dbLevel, msg);
    }

    public abstract boolean instanciate(boolean var1, DBUser var2);

    public abstract DBLogs getInstanciateLogs();

    public abstract List<FTVariableExtern> instanciateVariables(String var1);

    protected List<FTVariableExtern> instanciateVariables(List<FTVariableAbstract> vars, String append) {
        for (FTVariableAbstract var : vars) {
            var.setFlags(0);
        }
        for (FTVariableAbstract var : vars) {
            this.propageFlagForGeneric_rec(var);
        }
        IdentityHashMap<FTVariableAbstract, FTVariableExtern> mapSrc2Dst = new IdentityHashMap<FTVariableAbstract, FTVariableExtern>();
        ArrayList<FTVariableExtern> listVarsInstanciate = new ArrayList<FTVariableExtern>();
        for (FTVariableAbstract var : vars) {
            listVarsInstanciate.add(this.instanciateGenericVar(var, append, mapSrc2Dst));
        }
        return listVarsInstanciate;
    }

    private FTVariableExtern instanciateGenericVar(FTVariableAbstract src, String append, Map<FTVariableAbstract, FTVariableExtern> mapSrc2Dst) {
        FTVariableExtern dst = mapSrc2Dst.get(src);
        if (dst == null) {
            dst = src.isGeneric() ? new FTVariableExtern(this, src, src.getName() + append) : new FTVariableExtern(this, src, src.getName());
            FTDefinition ftSrcDefinition = src.getDefinition();
            if (ftSrcDefinition != null) {
                ArrayList<FTVariableExtern> dstArgs = new ArrayList<FTVariableExtern>(ftSrcDefinition.getArgs().size());
                for (FTVariableAbstract argSrc : ftSrcDefinition.getArgs()) {
                    dstArgs.add(this.instanciateGenericVar(argSrc, append, mapSrc2Dst));
                }
                FTDefinition ftDstDefinition = new FTDefinition(ftSrcDefinition.getType(), dstArgs);
                if (ftSrcDefinition.getType() == FTDefinition.Type.KOFN) {
                    ftDstDefinition.setAtLeast(ftSrcDefinition.getAtLeast());
                }
                ftDstDefinition.setGSR(ftSrcDefinition.isGSR());
                dst.setDefinition(ftDstDefinition);
            }
            mapSrc2Dst.put(src, dst);
        }
        return dst;
    }

    private void propageFlagForGeneric_rec(FTVariableAbstract var) {
        if (var.getFlags() != 0) {
            return;
        }
        boolean copy = var.isGeneric();
        FTDefinition ftDefinition = var.getDefinition();
        if (ftDefinition != null) {
            for (FTVariableAbstract arg : ftDefinition.getArgs()) {
                this.propageFlagForGeneric_rec(arg);
                copy |= arg.getFlags() == 2;
            }
        }
        var.setFlags(copy ? 2 : 1);
    }

    protected FTGlobEventVar createGEVar(DBFolder dbFolder, FTVariableAbstract ftVar) {
        FTGlobEventVar gEvt = new FTGlobEventVar(dbFolder, ftVar.getName());
        gEvt.setVariable(ftVar);
        return gEvt;
    }

    public Collection<DBGlobEvent> createGlobalEvents(DBFolder dbFolder) {
        LinkedHashMap<String, DBGlobEvent> egmap = new LinkedHashMap<String, DBGlobEvent>();
        for (FTVariableAbstract ftVar : this.getAllVariables()) {
            if (!ftVar.isIntern()) continue;
            FTGlobEventVar gEvt = this.createGEVar(dbFolder, ftVar);
            egmap.put(ftVar.getName(), gEvt.getDBGlobEvent());
        }
        return egmap.values();
    }

    public List<FTVariable> getInternalVariables() {
        List<FTVariableAbstract> allVars = this.getAllVariables();
        int len = allVars.size();
        ArrayList<FTVariable> internalVars = new ArrayList<FTVariable>(len / 2);
        for (int i = 0; i < len; ++i) {
            FTVariableAbstract ftVar = allVars.get(i);
            if (!ftVar.isIntern()) continue;
            internalVars.add((FTVariable)ftVar);
        }
        return internalVars;
    }

    public boolean withLinks() {
        for (FTVariableAbstract ftVar : this.getAllVariables()) {
            if (ftVar.getLink() == null) continue;
            return true;
        }
        return false;
    }

    public void clearResults() {
        List<FTVariableAbstract> vars = this.getAllVariables();
        for (int i = vars.size() - 1; i >= 0; --i) {
            FTVariableAbstract var = vars.get(i);
            var.setProbability(Double.NaN);
            if (var.getEvent() == null) continue;
            var.getEvent().clearIFs();
        }
    }
}

