/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.dbobj.faulttree.obj.gui;

import com.dassault.cecilia.core.ResIcoCore;
import com.dassault.cecilia.core.ResMsgVoc;
import com.dassault.cecilia.core.cecilia.ResMsgCore;
import com.dassault.cecilia.core.swing.CeciliaAction;
import com.dassault.cecilia.core.swing.JDialogCecilia;
import com.dassault.cecilia.core.swing.JOptionCecilia;
import com.dassault.cecilia.core.swing.list.ArrayListModel;
import com.dassault.cecilia.core.swing.list.ListPanel;
import com.dassault.cecilia.db.DBFactory;
import com.dassault.cecilia.dbobj.faulttree.ResMsgArbor;
import com.dassault.cecilia.dbobj.faulttree.ft.FTEquation;
import com.dassault.cecilia.dbobj.faulttree.obj.FTDefinition;
import com.dassault.cecilia.dbobj.faulttree.obj.FTVariableAbstract;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.HeadlessException;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.ListModel;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.plaf.basic.BasicComboBoxEditor;

public class FTGateDlgEdit
extends JDialogCecilia {
    private static FTGateDlgEdit __dlg;
    boolean _bEditable;
    JTextField _ctrlName;
    JTextArea _ctrlLabel;
    JComboBox _ctrlType;
    JComboBox _ctrlKofN;
    JLabel _lblKofN;
    JCheckBox _ctrlGSR;
    ArrayListModel<String> _ftArgsModel;
    FTArgsPanel _ftArgsPanel;
    FTEquation _ftEquation;
    FTVariableAbstract _ftVariable;
    FTDefinition _ftDefinition;

    public static FTGateDlgEdit getInstance(Window owner, boolean isEditable) {
        if (__dlg == null) {
            __dlg = new FTGateDlgEdit(owner, isEditable);
        }
        __dlg.setEditable(isEditable);
        return __dlg;
    }

    protected void setEditable(boolean value) {
        this._bEditable = value;
        this._ctrlLabel.setEditable(value);
        this._ctrlType.setEnabled(value);
        this._ctrlKofN.setEnabled(value);
    }

    protected boolean isEditable() {
        return this._bEditable;
    }

    private FTGateDlgEdit(Window owner, boolean editable) throws HeadlessException {
        super(owner, ResMsgArbor.getString("TITLE_EDIT_GATE"), true);
        this._bEditable = editable;
        this.make();
        this.fixSize(owner);
    }

    protected void fixSize(Window owner) {
        this.pack();
        this.setSize(720, 450);
        this.setLocationRelativeTo(JOptionCecilia.getTopContainerOf(owner));
    }

    private void make() {
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add(this.createContentPanel(), "Center");
        if (this.isEditable()) {
            this.getContentPane().add((Component)this.createButPanel(), "South");
        } else {
            this.getContentPane().add((Component)this.createButPanelClose(), "South");
        }
        this.init();
    }

    protected Component createContentPanel() {
        JPanel content = new JPanel(new GridBagLayout());
        content.add(this.createFatherPanel(), new GridBagConstraints(0, 0, 1, 1, 1.0, 0.6, 11, 1, new Insets(5, 5, 5, 5), 0, 0));
        content.add(this.createFTArgsPanel(), new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 15, 1, new Insets(5, 5, 5, 5), 0, 0));
        content.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        return content;
    }

    private Component createFatherPanel() {
        this._ctrlName = new JTextField(20);
        this._ctrlName.setEnabled(false);
        this._ctrlLabel = new JTextArea(5, 20);
        this._ctrlType = new JComboBox();
        this._ctrlType.setEditable(false);
        this._ctrlType.addItem(FTDefinition.Type.OR);
        this._ctrlType.addItem(FTDefinition.Type.AND);
        this._ctrlType.addItem(FTDefinition.Type.KOFN);
        this._ctrlType.addItem(FTDefinition.Type.XOR);
        this._ctrlType.addItem(FTDefinition.Type.NOR);
        this._ctrlType.addItem(FTDefinition.Type.NAND);
        this._ctrlType.addItem(FTDefinition.Type.NXOR);
        this._ctrlType.addItem(FTDefinition.Type.NOT);
        this._ctrlType.addItem(FTDefinition.Type.ITE);
        this._ctrlType.setRenderer(FTDefinition.Type.getListRenderer());
        this._ctrlType.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FTGateDlgEdit.this.refreshCtrlKOfN();
            }
        });
        this._lblKofN = new JLabel(ResMsgArbor.getString("VOC_K"));
        this._ctrlKofN = new JComboBox();
        this._ctrlKofN.setEditable(true);
        this._ctrlKofN.setEnabled(false);
        for (int i = 2; i <= 10; ++i) {
            this._ctrlKofN.addItem(i);
        }
        this._ctrlKofN.setEditor(new BasicComboBoxEditor(){

            @Override
            protected JTextField createEditorComponent() {
                this.editor = new JTextField("", 2){

                    @Override
                    public void setText(String s) {
                        if (this.getText().equals(s)) {
                            return;
                        }
                        super.setText(s);
                    }
                };
                return this.editor;
            }

            @Override
            public Object getItem() {
                Object result = super.getItem();
                try {
                    int ires = Integer.parseInt(result.toString());
                    if (ires >= 1) {
                        return ires;
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                return 0;
            }
        });
        this._ctrlGSR = new JCheckBox(ResMsgArbor.getString("VOC_GSR"));
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)new JLabel(ResMsgVoc.getString("VOC_NAME")), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        panel.add((Component)this._ctrlName, new GridBagConstraints(1, 0, 5, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
        JScrollPane scrollLabel = new JScrollPane(this._ctrlLabel);
        panel.add((Component)new JLabel(ResMsgVoc.getString("VOC_DESCRIPTION")), new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 18, 0, new Insets(5, 5, 5, 5), 0, 0));
        panel.add((Component)scrollLabel, new GridBagConstraints(1, 1, 5, 1, 1.0, 1.0, 17, 1, new Insets(5, 5, 5, 5), 0, 0));
        int idx = 0;
        panel.add((Component)new JLabel(ResMsgVoc.getString("VOC_TYPE")), new GridBagConstraints(idx++, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        panel.add((Component)this._ctrlType, new GridBagConstraints(idx++, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        panel.add((Component)this._lblKofN, new GridBagConstraints(idx++, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 25, 5, 5), 0, 0));
        panel.add((Component)this._ctrlKofN, new GridBagConstraints(idx++, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        panel.add((Component)new JLabel(""), new GridBagConstraints(idx++, 2, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
        panel.add((Component)this._ctrlGSR, new GridBagConstraints(idx++, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        return panel;
    }

    protected void refreshCtrlKOfN() {
        FTDefinition.Type type = (FTDefinition.Type)((Object)this._ctrlType.getSelectedItem());
        this._lblKofN.setEnabled(type == FTDefinition.Type.KOFN);
        this._ctrlKofN.setEnabled(type == FTDefinition.Type.KOFN && this.isEditable());
    }

    private Component createFTArgsPanel() {
        this._ftArgsModel = new ArrayListModel();
        this._ftArgsPanel = new FTArgsPanel(this._ftArgsModel);
        this._ftArgsPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Arguments"));
        return this._ftArgsPanel;
    }

    public void setVariable(FTEquation ftEquation, FTVariableAbstract ftVar, FTDefinition ftDef) {
        ArrayList<String> args;
        this._ftEquation = ftEquation;
        this._ftVariable = ftVar;
        this._ftDefinition = ftDef;
        this._ctrlName.setText(this._ftVariable.getName());
        this._ctrlName.setCaretPosition(0);
        this._ctrlLabel.setText(this._ftVariable.getLabel());
        this._ctrlLabel.setCaretPosition(0);
        this._ftArgsPanel.clear();
        if (this._ftDefinition != null) {
            int nbrArg = this._ftDefinition.getArgs().size();
            args = new ArrayList(nbrArg);
            this._ctrlType.setSelectedItem((Object)this._ftDefinition.getType());
            if (this._ftDefinition.getType() == FTDefinition.Type.KOFN) {
                this._ctrlKofN.setSelectedItem(this._ftDefinition.getAtLeast());
            }
            for (FTVariableAbstract ftArg : this._ftDefinition.getArgs()) {
                args.add(ftArg.getName());
            }
            this._ctrlGSR.setSelected(!this._ftVariable.isRoot() && this._ftDefinition.isGSR());
        } else {
            args = new ArrayList<String>(10);
            this._ctrlGSR.setSelected(false);
        }
        this._ctrlGSR.setEnabled(!this._ftVariable.isRoot() && this.isEditable());
        this._ftArgsModel.setList(args);
    }

    @Override
    protected boolean verifyParameters() {
        FTDefinition.Type type = (FTDefinition.Type)((Object)this._ctrlType.getSelectedItem());
        if (type == null) {
            this._ctrlType.requestFocus();
            return false;
        }
        List<String> args = this._ftArgsModel.getList();
        if (args.size() < type.getMinArg() || args.size() > type.getMaxArg()) {
            this._ftArgsPanel.getCtrlCollection().requestFocus();
            JOptionPane.showMessageDialog(JOptionCecilia.getTopContainerOf(this._ctrlType), ResMsgArbor.msgFormat("MSG_ERR_DAG_NBRARG_DEF", type.getLabel(), args.size()), this.getTitle(), 0);
            return false;
        }
        if (type == FTDefinition.Type.KOFN) {
            int k = (Integer)this._ctrlKofN.getSelectedItem();
            if (k < 1) {
                this._ctrlKofN.requestFocus();
                JOptionPane.showMessageDialog(JOptionCecilia.getTopContainerOf(this._ctrlKofN), ResMsgArbor.getString("MSG_ERR_DAG_KOFN"), this.getTitle(), 0);
                return false;
            }
            if (args.size() < k) {
                this._ctrlKofN.requestFocus();
                JOptionPane.showMessageDialog(JOptionCecilia.getTopContainerOf(this._ctrlKofN), ResMsgArbor.msgFormat("MSG_ERR_DAG_NBRARG_DEF", type.getLabel() + " [" + k + "]", args.size()), this.getTitle(), 0);
                return false;
            }
        }
        this._ftEquation.setFlags(0);
        for (int i = 0; i < args.size(); ++i) {
            String argName = args.get(i);
            FTVariableAbstract arg = this._ftEquation.getVariable(argName);
            if (arg == null || this._ftDefinition != null && this._ftDefinition.getArgs().contains(arg)) continue;
            boolean loop = arg.findDescendant(this._ftVariable);
            arg.resetFlagDescendant(0, true);
            if (!loop) continue;
            this._ftArgsPanel.getCtrlCollection().requestFocus();
            JOptionPane.showMessageDialog(JOptionCecilia.getTopContainerOf(this._ftArgsPanel), ResMsgArbor.msgFormat("MSG_ERR_VAR_DOLOOP", argName), this.getTitle(), 0);
            return false;
        }
        return true;
    }

    public List<String> getFTArgs() {
        return this._ftArgsModel.getList();
    }

    public FTDefinition.Type getFTType() {
        return (FTDefinition.Type)((Object)this._ctrlType.getSelectedItem());
    }

    public String getLabel() {
        return this._ctrlLabel.getText();
    }

    public int getK() {
        return (Integer)this._ctrlKofN.getSelectedItem();
    }

    public boolean isGSR() {
        return this._ctrlGSR.isSelected();
    }

    class FTArgsPanel
    extends ListPanel {
        JTextField _ctrlNameArg;
        protected CeciliaAction _ctrlUp;
        protected CeciliaAction _ctrlDown;

        public FTArgsPanel(ListModel model) {
            super(model, true, true);
            this._ctrlNameArg.getInputMap().put(KeyStroke.getKeyStroke("ENTER"), "CECILIA_ENTER");
            this._ctrlNameArg.getActionMap().put("CECILIA_ENTER", this._ctrlAdd);
            this._ctrlList.getInputMap().put(KeyStroke.getKeyStroke("DELETE"), "CECILIA_DELETE");
            this._ctrlList.getActionMap().put("CECILIA_DELETE", this._ctrlDel);
        }

        @Override
        protected Component createPanel() {
            this._ctrlNameArg = new JTextField(10);
            this._ctrlNameArg.addCaretListener(new CaretListener(){

                @Override
                public void caretUpdate(CaretEvent e) {
                    FTArgsPanel.this._ctrlAdd.setEnabled(!FTArgsPanel.this._ctrlNameArg.getText().isEmpty());
                }
            });
            return super.createPanel();
        }

        @Override
        protected void createActions() {
            super.createActions();
            this._ctrlUp = new CeciliaAction(ResIcoCore.getImageIcon("BUT_UP"), ResMsgVoc.getString("VOC_UP"), ResMsgCore.getString("ACTION_UP_TTIP")){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int idx = FTArgsPanel.this.getSelectedRow();
                    if (idx > 0 && idx < FTGateDlgEdit.this._ftArgsModel.getSize()) {
                        FTGateDlgEdit.this._ftArgsModel.up(idx);
                        FTArgsPanel.this._ctrlList.setSelectedIndex(idx - 1);
                    }
                }
            };
            this._ctrlDown = new CeciliaAction(ResIcoCore.getImageIcon("BUT_DOWN"), ResMsgVoc.getString("VOC_DOWN"), ResMsgCore.getString("ACTION_DOWN_TTIP")){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int idx = FTArgsPanel.this.getSelectedRow();
                    if (idx >= 0 && idx < FTGateDlgEdit.this._ftArgsModel.getSize() - 1) {
                        FTGateDlgEdit.this._ftArgsModel.down(idx);
                        FTArgsPanel.this._ctrlList.setSelectedIndex(idx + 1);
                    }
                }
            };
        }

        @Override
        protected JPopupMenu createMenuActions(JPopupMenu popupList) {
            popupList.add(this._ctrlDel);
            popupList.addSeparator();
            popupList.add(this._ctrlUp);
            popupList.add(this._ctrlDown);
            return popupList;
        }

        @Override
        protected void createToolBarActions(Container aPanel) {
            aPanel.add(this._ctrlNameArg);
            aPanel.add(Box.createRigidArea(CeciliaAction.RIGID_AREA));
            aPanel.add(this._ctrlAdd.createButton(CeciliaAction.BorderStyle.LIGHT));
            aPanel.add(Box.createRigidArea(new Dimension(10, 10)));
            aPanel.add(Box.createHorizontalGlue());
            aPanel.add(this._ctrlDel.createButton(CeciliaAction.BorderStyle.LIGHT));
            aPanel.add(Box.createRigidArea(CeciliaAction.RIGID_AREA));
            aPanel.add(this._ctrlUp.createButton(CeciliaAction.BorderStyle.LIGHT));
            aPanel.add(Box.createRigidArea(CeciliaAction.RIGID_AREA));
            aPanel.add(this._ctrlDown.createButton(CeciliaAction.BorderStyle.LIGHT));
        }

        @Override
        protected void refreshCtrl() {
            if (!this.isEnabled() || !FTGateDlgEdit.this.isEditable()) {
                this._ctrlAdd.setEnabled(false);
                this._ctrlDel.setEnabled(false);
                this._ctrlUp.setEnabled(false);
                this._ctrlDown.setEnabled(false);
                if (this._ctrlNameArg != null) {
                    this._ctrlNameArg.setEditable(false);
                }
            } else {
                int nbrSelect = this.getSelectedRowCount();
                boolean canDelete = false;
                boolean canUp = false;
                boolean canDown = false;
                if (nbrSelect > 0) {
                    canDown = true;
                    canUp = true;
                    canDelete = true;
                    int[] viewRows = this.getSelectedRows();
                    for (int i = 0; i < nbrSelect; ++i) {
                        int modelRow = viewRows[i];
                        if (modelRow == 0) {
                            canUp = false;
                        }
                        if (modelRow != FTGateDlgEdit.this._ftArgsModel.getSize() - 1) continue;
                        canDown = false;
                    }
                }
                this._ctrlDel.setEnabled(canDelete);
                this._ctrlUp.setEnabled(canUp);
                this._ctrlDown.setEnabled(canDown);
                this._ctrlAdd.setEnabled(this._ctrlNameArg != null && !this._ctrlNameArg.getText().isEmpty());
            }
        }

        @Override
        protected void addData(int idx) {
            String item = this._ctrlNameArg.getText();
            if (item == null) {
                return;
            }
            if (DBFactory.verifyName(item) != 0) {
                JOptionPane.showMessageDialog(JOptionCecilia.getTopContainerOf(this._ctrlNameArg), ResMsgArbor.msgFormat("MSG_ERR_VAR_BADNAME", item), FTGateDlgEdit.this.getTitle(), 0);
                return;
            }
            if (FTGateDlgEdit.this._ftArgsModel.getList().contains(item)) {
                return;
            }
            FTGateDlgEdit.this._ftArgsModel.insertAt(idx, item);
            idx = idx == -1 ? FTGateDlgEdit.this._ftArgsModel.getSize() - 1 : ++idx;
            this._ctrlList.setSelectedIndex(idx);
        }

        @Override
        protected void delData(int[] idx) {
            if (idx.length == 0) {
                return;
            }
            for (int i = idx.length - 1; i >= 0; --i) {
                FTGateDlgEdit.this._ftArgsModel.removeAt(idx[i]);
            }
        }

        protected void clear() {
            this._ctrlNameArg.setText("");
            FTGateDlgEdit.this._ftArgsModel.clear();
        }
    }
}

