/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.dbobj.faulttree.obj.io;

import com.dassault.cecilia.core.cecilia.ResMsgCore;
import com.dassault.cecilia.db.DBFolder;
import com.dassault.cecilia.dbobj.CECFactory;
import com.dassault.cecilia.dbobj.ResMsgObj;
import com.dassault.cecilia.dbobj.faulttree.ccf.CCF;
import com.dassault.cecilia.dbobj.faulttree.ft.io.FTXmlConstant;
import com.dassault.cecilia.dbobj.faulttree.obj.FTEvent;
import com.dassault.cecilia.dbobj.general.event.Event;
import com.dassault.cecilia.dbobj.general.event.io.EventHandlerXml;
import com.dassault.cecilia.dbobj.general.log.DBLogs;
import com.dassault.cecilia.dbobj.wrap.DBWrap;
import java.util.HashMap;
import java.util.Map;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class FTEventHandlerXml
extends EventHandlerXml
implements FTXmlConstant {
    FTEvent _ftEvent = null;
    FTEvent.State _ftState = FTEvent.State.DEFAULT;
    FTEvent.Style _ftStyle = FTEvent.Style.BASIC;
    CCF _dbCcf = null;
    Map<FTEvent.IF, Double> _mapImpFactors = new HashMap<FTEvent.IF, Double>();

    public FTEventHandlerXml(DBLogs.DBLogsManager manager, Locator locator, CECFactory daoFactory) {
        super(manager, locator, daoFactory);
    }

    public FTEvent getEvent() {
        return this._ftEvent;
    }

    public String getLabel() {
        return this._label;
    }

    @Override
    protected FTEvent createEvent() {
        this._ftEvent = new FTEvent();
        return this._ftEvent;
    }

    @Override
    protected void configureEvent(Event evt) {
        super.configureEvent(evt);
        if (!(evt instanceof FTEvent)) {
            return;
        }
        FTEvent ftEvt = (FTEvent)evt;
        ftEvt.setState(this._ftState);
        ftEvt.setStyle(this._ftStyle);
        if (this._dbCcf != null) {
            ftEvt.setCCF(this._dbCcf);
        }
        for (Map.Entry<FTEvent.IF, Double> entry : this._mapImpFactors.entrySet()) {
            ftEvt.addIF(entry.getKey(), entry.getValue());
        }
    }

    @Override
    protected boolean startInternalAction(String key, Map<String, String> attrs) throws SAXException {
        if ("ft.state".equals(key)) {
            FTEvent.State state = null;
            String attr = this.readAttr(key, "value", attrs);
            if (attr != null && (state = (FTEvent.State)FTEventHandlerXml.valueOfEnum(FTEvent.State.class, (String)attr.toUpperCase())) == null) {
                this.warning(new SAXParseException(ResMsgCore.msgFormat("MSG_ERR_DBMOD_XML_ATTR_FORMAT", key, "value", attr), this.getLocator()));
            }
            if (state != null) {
                this._ftState = state;
            }
        } else if ("ft.style".equals(key)) {
            FTEvent.Style style = null;
            String attr = this.readAttr(key, "value", attrs);
            if (attr != null && (style = (FTEvent.Style)FTEventHandlerXml.valueOfEnum(FTEvent.Style.class, (String)attr.toUpperCase())) == null) {
                this.warning(new SAXParseException(ResMsgCore.msgFormat("MSG_ERR_DBMOD_XML_ATTR_FORMAT", key, "value", attr), this.getLocator()));
            }
            if (style != null) {
                this._ftStyle = style;
            }
        } else if ("ft.impfactor".equals(key)) {
            FTEvent.IF type = null;
            String attr = this.readAttr(key, "type", attrs);
            if (attr != null && (type = (FTEvent.IF)FTEventHandlerXml.valueOfEnum(FTEvent.IF.class, (String)("cpr".equals(attr) ? "CPr" : attr.toUpperCase()))) == null) {
                this.warning(new SAXParseException(ResMsgCore.msgFormat("MSG_ERR_DBMOD_XML_ATTR_FORMAT", key, "type", attr), this.getLocator()));
            }
            double value = this.readDouble(key, "value", attrs, false, Double.NaN);
            if (type != null) {
                this._mapImpFactors.put(type, value);
            }
        } else if ("ft.ccf".equals(key)) {
            DBFolder dbFolder = this.readDBFolder(key, attrs, this._daoFactory.createFolderDAO(), DBFolder.Family.CCF_MODEL.getRootName(), false);
            if (dbFolder != null && dbFolder.getFamily() != DBFolder.Family.CCF_MODEL) {
                this.warning(new SAXParseException(ResMsgCore.msgFormat("MSG_ERR_DBMOD_XML_FOLDER_FAMILY", new Object[]{dbFolder.getRefPath(), DBFolder.Family.CCF_MODEL}), this.getLocator()));
                dbFolder = null;
            }
            if (dbFolder != null) {
                DBWrap dbWrap = this._daoFactory.findOrCreateWrap(dbFolder);
                if (dbWrap == null) {
                    this.warning(new SAXParseException(ResMsgObj.msgFormat("MSG_XML_MODEL_EVENT_READ", dbFolder.getRefPath()), this.getLocator()));
                } else {
                    this._dbCcf = (CCF)dbWrap;
                }
            }
        } else {
            return super.startInternalAction(key, attrs);
        }
        return true;
    }
}

