/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.dbobj.fmea;

import com.dassault.cecilia.core.cecilia.ResMsgCore;
import com.dassault.cecilia.db.DBFactory;
import com.dassault.cecilia.db.DBFolder;
import com.dassault.cecilia.db.DBObjModel;
import com.dassault.cecilia.db.DBObjProperty;
import com.dassault.cecilia.db.DBRelation;
import com.dassault.cecilia.db.DBUser;
import com.dassault.cecilia.db.dao.DAOFactory;
import com.dassault.cecilia.dbobj.CECFactory;
import com.dassault.cecilia.dbobj.fmea.DBAbstractFMEA;
import com.dassault.cecilia.dbobj.fmea.ihm.Head;
import com.dassault.cecilia.dbobj.fmea.ihm.ReadHeadFileException;
import com.dassault.cecilia.dbobj.fmea.model.DBIdentifier;
import com.dassault.cecilia.dbobj.fmea.model.ExternalFmeaReference;
import com.dassault.cecilia.dbobj.fmea.model.Fmea;
import com.dassault.cecilia.dbobj.fmea.model.FmeaDescriptor;
import com.dassault.cecilia.dbobj.general.log.DBLogs;
import com.dassault.cecilia.dbobj.wrap.DBWrap;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.HashSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;

public class DBTableFMEA
extends DBAbstractFMEA {
    private static final Logger _LOG = Logger.getLogger(DBTableFMEA.class.getPackage().getName());
    FmeaDescriptor _desc;
    Head _head;
    DBFolder _dbFolderModel;

    @Override
    protected Logger getJavaLog() {
        return _LOG;
    }

    public DBTableFMEA(DBFolder folder) {
        super(folder);
        this._desc = new FmeaDescriptor(new DBIdentifier(folder.getID(), folder.getParent().getName()));
        this._desc.setDescription(folder.getDescription());
        this._fmea = new Fmea();
    }

    @Override
    public DBFolder.Family getFamily() {
        return DBFolder.Family.PROJECT;
    }

    @Override
    public short getFamilyFlag() {
        return 4;
    }

    @Override
    protected String getNature() {
        return "fmea";
    }

    @Override
    public DBTableFMEA getCopy() {
        throw new RuntimeException();
    }

    public DBTableFMEA getCopy(CECFactory cecFactory) {
        DBTableFMEA dest = new DBTableFMEA(this.getDBFolder());
        dest.copy(this, cecFactory);
        return dest;
    }

    @Override
    protected void copy(DBWrap src, CECFactory cecFactory) {
        super.copy(src, cecFactory);
        if (src instanceof DBTableFMEA) {
            ByteArrayInputStream input;
            Head head;
            ByteArrayOutputStream output;
            DBTableFMEA srcFMEA = (DBTableFMEA)src;
            this._dbFolderModel = srcFMEA._dbFolderModel;
            if (srcFMEA._head != null && srcFMEA._head.write(output = new ByteArrayOutputStream(2048)) && (head = new Head()).read(input = new ByteArrayInputStream(output.toByteArray()))) {
                this._head = head;
            }
        }
    }

    public FmeaDescriptor getTableFMEADescription() {
        return this._desc;
    }

    public DBTableFMEA setModelFolder(DBFolder dbFolder) {
        this._dbFolderModel = dbFolder;
        DBObjProperty oprop = new DBObjProperty().setName("fmea.model.id").setType("Long").setValue(Long.toString(dbFolder.getID()));
        this.getDBFolder().getObject().addProperty(oprop);
        return this;
    }

    @Override
    protected void toXML(Appendable out, String indent) throws IOException {
        out.append(indent).append("<FMEA_TABLE>\n");
        this._fmea.toXML(out, indent + "  ");
        out.append(indent).append("</FMEA_TABLE>\n");
    }

    @Override
    protected void toXML(Appendable out) throws IOException {
        out.append("<FMEA>\n");
        this._fmea.getModel().addInternalAttribute("ID", this._desc.getIdent().getName());
        this._fmea.getModel().addInternalAttribute("COMMENT", this._desc.getDescription());
        this._fmea.getModel().toXML(out, "  ");
        out.append("\n");
        out.append("  <FMEA_TABLE>\n");
        this._fmea.toXML(out, "    ");
        out.append("  </FMEA_TABLE>\n");
        out.append("</FMEA>\n");
    }

    @Override
    public Collection<DBRelation> getUseRelations() {
        HashSet<DBRelation> relations = new HashSet<DBRelation>();
        if (this._dbFolderModel != null) {
            relations.add(new DBRelation(this._dbFolder, "FMEA", this._dbFolderModel, "FMEA_MODEL"));
        }
        for (ExternalFmeaReference external : this._fmea.getExternalLinks()) {
            if (external.getDBFolder().getID() <= 0L) continue;
            relations.add(new DBRelation(this._dbFolder, "FMEA_V", external.getDBFolder(), "FMEA_V"));
        }
        return relations;
    }

    public Collection<DBRelation> getWorkingRelations() {
        HashSet<DBRelation> relations = new HashSet<DBRelation>();
        for (ExternalFmeaReference external : this._fmea.getExternalLinks()) {
            if (external.getDBFolder().getID() <= 0L) continue;
            relations.add(new DBRelation(this._dbFolder, "WORKING", external.getDBFolder(), "FMEA_V"));
        }
        return relations;
    }

    protected boolean writeHeadToDAO(DBObjModel model) {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        if (!this._head.write(bos)) {
            _LOG.log(Level.SEVERE, "Soucis lors de la sauvegarde de 'fmea.head' ...");
            return false;
        }
        if (model == null) {
            model = new DBObjModel();
            model.setNature("fmea.head");
        }
        model.setFormat("JOS");
        model.setEncoding("");
        model.setSize(bos.size());
        model.setStreamToSave(new ByteArrayInputStream(bos.toByteArray()));
        this._dbFolder.getObject().addModel(model);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean writeToDAO(DAOFactory cecFactory, DBUser dbModifyUser) {
        if (this._head == null) {
            return super.writeToDAO(cecFactory, dbModifyUser);
        }
        DBObjModel headModel = this._dbFolder.getObject().getModel("fmea.head");
        if (!this.writeHeadToDAO(headModel)) {
            return false;
        }
        boolean result = false;
        try {
            result = super.writeToDAO(cecFactory, dbModifyUser);
        }
        finally {
            if (result || headModel == null) {
                // empty if block
            }
        }
        return result;
    }

    private DBFolder getModelFolder(CECFactory cecFactory, DBLogs.DBLogsManager logMng) {
        DBFolder dbFolder = null;
        long idModel = -1L;
        DBObjProperty dbObjProp = this.getDBFolder().getObject().getProperty("fmea.model.id");
        if (dbObjProp != null) {
            idModel = DBFactory.parseID(dbObjProp.getValue());
        }
        if (idModel == -1L) {
            logMng.addLog(DBLogs.DBLevel.ERROR, "Pas de modele d'AMDEC pour la table d'AMDEC");
            return null;
        }
        dbFolder = (DBFolder)cecFactory.createFolderDAO().find(idModel);
        if (dbFolder == null) {
            logMng.addLog(DBLogs.DBLevel.ERROR, "Le modele d'AMDEC n'existe pas (ID=" + idModel + ") ou n'est pas lisible");
            return null;
        }
        if (dbFolder.getFamily() != DBFolder.Family.FMEA_MODEL) {
            _LOG.info("Le modele d'AMDEC n'est pas de la bonne famille: " + dbFolder.getRefPath());
            return null;
        }
        if (!dbFolder.isVersion()) {
            _LOG.info("Le modele d'AMDEC n'est pas une version: " + dbFolder.getRefPath());
            return null;
        }
        if (dbFolder.getObject() == null) {
            _LOG.info("Le modele d'AMDEC n'a pas d'objet (et donc pas de flux): " + dbFolder.getRefPath());
            return null;
        }
        return dbFolder;
    }

    private InputStream getBinaryModelFMEA(CECFactory cecFactory, DBLogs.DBLogsManager logMng) {
        DBObjModel dbObjModelFMEA;
        if (this._dbFolderModel == null) {
            this._dbFolderModel = this.getModelFolder(cecFactory, logMng);
        }
        if (this._dbFolderModel != null && (dbObjModelFMEA = this._dbFolderModel.getObject().getModel("fmea.model")) != null) {
            String format = dbObjModelFMEA.getFormat();
            if ("XML".equals(format) || "ZML".equals(format)) {
                InputStream istream = cecFactory.createObjModelDAO().getBinaryStream(dbObjModelFMEA);
                if ("ZML".equals(format) || Boolean.getBoolean("cecilia.migration.db51to60.FMEAXmlIsCompressed")) {
                    istream = new InflaterInputStream(istream, new Inflater());
                }
                return istream;
            }
            logMng.addLog(DBLogs.DBLevel.ERROR, "Un probl\u00e8me est survenu lors de la lecture du modele d'AMDEC: " + this._dbFolderModel.getRefPath());
        }
        return null;
    }

    @Override
    protected boolean readFromDBObjModel(DBObjModel model, CECFactory cecFactory, DBLogs.DBLogsManager logMng) {
        String format = model.getFormat();
        if ("XML".equals(format) || "ZML".equals(format)) {
            InputStream imodel;
            InputStream itable = cecFactory.createObjModelDAO().getBinaryStream(model);
            if (itable == null) {
                logMng.addLog(DBLogs.DBLevel.ERROR, ResMsgCore.getString("MSG_ERR_DBMOD_READ"));
                return false;
            }
            if ("ZML".equals(format) || Boolean.getBoolean("cecilia.migration.db51to60.FMEAXmlIsCompressed")) {
                itable = new InflaterInputStream(itable, new Inflater());
            }
            if ((imodel = this.getBinaryModelFMEA(cecFactory, logMng)) == null) {
                return false;
            }
            if (!this.readXml(cecFactory, imodel, itable)) {
                return false;
            }
            for (ExternalFmeaReference external : this._fmea.getExternalLinks()) {
                DBTableFMEA fmeaTable;
                Double updateValue;
                DBWrap dbWrap;
                double refValue = Double.NaN;
                if (external.getDBFolder() != null && (dbWrap = cecFactory.findOrCreateWrap(external.getDBFolder())) != null && (updateValue = (fmeaTable = (DBTableFMEA)dbWrap).getFMEA().getValueOf(external.getFmeaEntId(), external.getFmeaEntName(), external.getFmeaEntValue(), external.getFmeaAttId(), external.getFmeaAttName())) != null) {
                    refValue = updateValue;
                }
                if (Double.isNaN(refValue)) {
                    logMng.addLog(DBLogs.DBLevel.WARNING, "Le lien FMEA n'est plus valide.");
                    external.setFmeaAttValue(0.0);
                    continue;
                }
                external.setFmeaAttValue(refValue);
            }
            return true;
        }
        logMng.addLog(DBLogs.DBLevel.ERROR, ResMsgCore.msgFormat("MSG_ERR_DBMOD_FORMAT", this.getNature(), format));
        return false;
    }

    public Head readHead(CECFactory cecFactory) {
        if (this._head != null) {
            return this._head;
        }
        DBObjModel dbObjModel = this.getDBFolder().getObject().getModel("fmea.head");
        if (dbObjModel != null) {
            if (!"JOS".equals(dbObjModel.getFormat())) {
                _LOG.severe("Le flux de nature 'fmea.head' n'a pas un format compatible (" + dbObjModel.getFormat() + "): " + this.getRefPath());
            } else {
                InputStream ihead = cecFactory.createObjModelDAO().getBinaryStream(dbObjModel);
                if (ihead == null) {
                    _LOG.severe("Probleme de lecture du flux 'fmea.head' : " + this.getRefPath());
                } else {
                    try {
                        this._head = new Head(ihead);
                    }
                    catch (ReadHeadFileException e) {
                        _LOG.log(Level.SEVERE, "Probleme de lecture du flux 'fmea.head' : " + this.getRefPath(), e);
                    }
                }
            }
        }
        if (this._head == null) {
            this._head = new Head();
        }
        return this._head;
    }

    public boolean update(CECFactory daoFactory, DBLogs.DBLogsManager logMng) {
        boolean change = this.getFMEA().update(daoFactory, logMng);
        if (change) {
            // empty if block
        }
        return change;
    }
}

