/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.dbobj.fmea.gui;

import com.dassault.cecilia.core.cecilia.pref.GeneralTextPreferencies;
import com.dassault.cecilia.core.cecilia.pref.PrefFieldsCategory;
import com.dassault.cecilia.core.cecilia.pref.Preferencies;
import com.dassault.cecilia.core.plugin.PluginWithOptions;
import com.dassault.cecilia.dbobj.fmea.gui.DBTableFMEAPrintPreferencies;
import com.dassault.cecilia.dbobj.fmea.io.FmeaOutputOptions;
import com.dassault.cecilia.lib.util.format.DoubleFormat;
import com.dassault.cecilia.lib.util.format.DoubleFormatJava;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;

public class DBTableFMEAOutputOptions
implements FmeaOutputOptions {
    DateFormat _dateFormat = SimpleDateFormat.getInstance();
    boolean _withAnalysis = true;
    boolean _withAttribute = false;
    DoubleFormat _doubleFormat = new DoubleFormatJava();

    public DBTableFMEAOutputOptions(Preferencies prefs) {
        if (prefs == null) {
            return;
        }
        PluginWithOptions pref = prefs.getOptions(DBTableFMEAPrintPreferencies.PREF_KEY);
        if (pref != null && pref instanceof PrefFieldsCategory) {
            this._withAnalysis = ((PrefFieldsCategory)pref).getPref("Content.Analysis").isSelected();
            this._withAttribute = ((PrefFieldsCategory)pref).getPref("Content.Attribute").isSelected();
        }
        if ((pref = prefs.getOptions(GeneralTextPreferencies.PREF_KEY)) != null && pref instanceof GeneralTextPreferencies) {
            this._dateFormat = ((GeneralTextPreferencies)pref).getDateFormat();
            this._doubleFormat = ((GeneralTextPreferencies)pref).getDoubleFormat();
        }
    }

    @Override
    public boolean getAnalysisOption() {
        return this._withAnalysis;
    }

    @Override
    public boolean getAttributeOption() {
        return this._withAttribute;
    }

    @Override
    public String formatDate(Date date) {
        return this._dateFormat.format(date);
    }

    @Override
    public String formatDouble(double value) {
        return this._doubleFormat.format(value);
    }
}

