/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.dbobj.fmea.ihm;

import com.dassault.cecilia.core.cecilia.dependencies.DependsListener;
import com.dassault.cecilia.core.cecilia.error.DlgDisplayMsg;
import com.dassault.cecilia.core.cecilia.error.Msg;
import com.dassault.cecilia.core.swing.JOptionCecilia;
import com.dassault.cecilia.db.DBFolder;
import com.dassault.cecilia.dbobj.fmea.Messages;
import com.dassault.cecilia.dbobj.fmea.ihm.FmeaTableUI;
import com.dassault.cecilia.dbobj.fmea.model.Dictionnary;
import com.dassault.cecilia.dbobj.fmea.model.DictionnaryManager;
import com.dassault.cecilia.dbobj.fmea.model.Fmea;
import com.dassault.cecilia.dbobj.fmea.model.FmeaAttributeDefinition;
import com.dassault.cecilia.dbobj.fmea.model.FmeaColumnDefinition;
import com.dassault.cecilia.dbobj.fmea.model.FmeaEntity;
import com.dassault.cecilia.dbobj.fmea.model.FmeaGraphicPropertyCollection;
import com.dassault.cecilia.dbobj.fmea.model.FmeaTableDefinition;
import com.dassault.cecilia.dbobj.fmea.model.FmeaTableModel;
import com.dassault.cecilia.dbobj.fmea.model.SortData;
import com.dassault.cecilia.dbobj.fmea.util.SorterTable2;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.AbstractCellEditor;
import javax.swing.Action;
import javax.swing.DefaultCellEditor;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.TableModelEvent;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.text.BadLocationException;

public class FmeaTable
extends SorterTable2 {
    protected static Border noFocusBorder = new EmptyBorder(1, 1, 1, 1);
    protected static Color lightGrayColor = new Color(240, 240, 240);
    protected DictionnaryManager _dicoMgr;
    private MouseListener _columnPopupMenuMouseListener;
    protected ColumnPopupMenu _columnPopupMenu;
    protected Vector<Vector> _fusionedCells = new Vector();
    protected boolean _showLinesByGroup = false;
    public boolean _isPrinting = false;
    private boolean _editable = true;
    protected boolean _toApply = false;
    protected boolean _groupCells = false;
    DBFolder _dbFolder;
    Action onArrowKeysAction = null;
    List<DependsListener> _listeners = new ArrayList<DependsListener>();

    public FmeaTable(DictionnaryManager dicoMgr) {
        this._dicoMgr = dicoMgr;
        this.init();
    }

    public FmeaTable(Fmea fmea, DictionnaryManager dicoMgr) {
        this._dicoMgr = dicoMgr;
        this.init();
        this.setFmea(fmea);
    }

    @Override
    public void updateUI() {
        super.updateUI();
        this.setUI(new FmeaTableUI());
        this.resizeAndRepaint();
    }

    public void setSource(DBFolder dbWrap) {
        this._dbFolder = dbWrap;
    }

    public void setFmea(Fmea fmea) {
        FmeaTableModel m = new FmeaTableModel(this._dicoMgr);
        m.setFmea(fmea);
        this.setDataModel(m);
        for (int i = 0; i < this.getModel().getColumnCount(); ++i) {
            FmeaGraphicPropertyCollection properties = this.getFmeaTableModel().getColumnDefinition(i).getGraphicProperties();
            if (properties.getString(FmeaGraphicPropertyCollection.dictionnary) == null) continue;
            this.getColumnModel().getColumn(i).setCellRenderer(new FmeaStringRenderer());
        }
        this.initColumnWidths();
        SortData sortData = this.getFmeaTableModel().getFmea().getModel().getSortData();
        this._groupCells = sortData == null ? false : sortData.getGroupCells();
        this.update();
        this.initRowHeights();
    }

    public void update() {
        this.initFusionedCellTable();
        this.setShowLinesByGroup(false);
        SortData sortData = this.getFmeaTableModel().getFmea().getModel().getSortData();
        if (sortData != null && this.getToApply()) {
            this.sort(sortData);
        }
    }

    public boolean isSortDataColumnResult(int col) {
        if (!this.getToApply()) {
            return false;
        }
        boolean b = this.getFmeaTableModel().isSortDataColumnResult(this.convertColumnIndexToModel(col));
        return b;
    }

    protected void init() {
        this.setDoubleBuffered(true);
        this.setAutoResizeMode(0);
        this.setDefaultRenderer(FmeaAttributeDefinition.String.class, new FmeaStringRenderer());
        this.setDefaultRenderer(FmeaAttributeDefinition.Integer.class, new FmeaNumberRenderer());
        this.setDefaultRenderer(FmeaAttributeDefinition.Double.class, new FmeaDoubleRenderer());
        this.setDefaultEditor(FmeaAttributeDefinition.String.class, new FmeaStringEditor());
        this.setDefaultEditor(FmeaAttributeDefinition.Reference.class, new FmeaStringEditor());
        this.setDefaultEditor(FmeaAttributeDefinition.Integer.class, new FmeaIntegerEditor());
        this.setDefaultEditor(FmeaAttributeDefinition.Double.class, new FmeaDoubleEditor());
        this.setRowSelectionAllowed(false);
        this.setShowLinesByGroup(true);
        this.setGridColor(Color.black);
        this.setBorder(new EmptyBorder(0, 0, 0, 0));
        this.installListeners();
    }

    protected void installListeners() {
        this._columnPopupMenuMouseListener = new ColumnPopupMenuMouseAdapter();
        this.getTableHeader().addMouseListener(this._columnPopupMenuMouseListener);
    }

    protected void uninstallListeners() {
        this.getTableHeader().removeMouseListener(this._columnPopupMenuMouseListener);
    }

    protected void initColumnWidths() {
        for (int i = 0; i < this.getColumnModel().getColumnCount(); ++i) {
            int modelIndex = this.convertColumnIndexToModel(i);
            TableColumn column = this.getColumnModel().getColumn(i);
            column.addPropertyChangeListener(this.getFmeaTableModel().getColumnDefinition(modelIndex));
        }
        for (int col = 0; col < this.getColumnModel().getColumnCount(); ++col) {
            FmeaTableModel model = this.getFmeaTableModel();
            Integer width = model.getColumnWidth(col);
            if (width == null) continue;
            this.getColumnModel().getColumn(col).setPreferredWidth(width);
        }
    }

    protected void initRowHeights() {
        JTextArea ta = new JTextArea();
        ta.setLineWrap(true);
        ta.setWrapStyleWord(true);
        JPanel pnl = new JPanel(new GridBagLayout());
        ta.setPreferredSize(new Dimension(30, 10));
        pnl.add((Component)ta, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        pnl.add((Component)new JPanel(), new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        JFrame frame = new JFrame();
        frame.getContentPane().add(pnl);
        for (int row = 0; row < this.getRowCount(); ++row) {
            int maxHeight = 0;
            for (int col = 0; col < this.getColumnCount(); ++col) {
                int modelIndex = this.convertColumnIndexToModel(col);
                FmeaColumnDefinition colDef = this.getFmeaTableModel().getColumnDefinition(modelIndex);
                FmeaGraphicPropertyCollection columnProp = colDef.getGraphicProperties();
                Font f = columnProp.getFont(FmeaGraphicPropertyCollection.font);
                if (f != null) {
                    ta.setFont(f);
                } else {
                    ta.setFont(this.getFont());
                }
                Object value = this.getValueAt(row, col);
                if (value == null || !(value instanceof String)) continue;
                String txt = value.toString();
                ta.setText(txt);
                int width = this.getColumnModel().getColumn(col).getPreferredWidth();
                Dimension d = new Dimension(width, 1);
                ta.setPreferredSize(d);
                frame.pack();
                Rectangle r = null;
                try {
                    int pos = ta.getText().length();
                    r = ta.modelToView(pos);
                }
                catch (BadLocationException e) {
                    e.printStackTrace();
                }
                maxHeight = Math.max(maxHeight, r.y + r.height);
            }
            this.setRowHeight(row, maxHeight + 3);
        }
    }

    protected void configureColumnPopupMenu(int viewColumn) {
        int modelColumnIndex = this.convertColumnIndexToModel(viewColumn);
        FmeaAttributeDefinition.Type columnType = this.getFmeaTableModel().getColumnDefinition(modelColumnIndex).getColumnType();
        this._columnPopupMenu = new ColumnPopupMenu(viewColumn);
        if (columnType instanceof FmeaAttributeDefinition.Number) {
            this._columnPopupMenu.add(this.createLinkToDictionnaryMenu(viewColumn));
            this._columnPopupMenu.add(this.createUnlinkFromDictionnaryMenuItem(viewColumn));
        }
        AbstractAction sortAscending = new AbstractAction(Messages.getString("FmeaTable.0")){

            @Override
            public void actionPerformed(ActionEvent e) {
                FmeaTable.this.sort(FmeaTable.this._columnPopupMenu.getColumn(), true);
            }
        };
        this._columnPopupMenu.add(new JMenuItem(sortAscending));
        AbstractAction sortDescending = new AbstractAction(Messages.getString("FmeaTable.1")){

            @Override
            public void actionPerformed(ActionEvent e) {
                FmeaTable.this.sort(FmeaTable.this._columnPopupMenu.getColumn(), false);
            }
        };
        this._columnPopupMenu.add(new JMenuItem(sortDescending));
    }

    protected JMenu createLinkToDictionnaryMenu(int viewColumn) {
        int modelIndex = this.convertColumnIndexToModel(this._columnPopupMenu.getColumn());
        FmeaGraphicPropertyCollection properties = this.getFmeaTableModel().getColumnDefinition(modelIndex).getGraphicProperties();
        String dico = properties.getString(FmeaGraphicPropertyCollection.dictionnary);
        JMenu linkToDictionnaryMenu = new JMenu(Messages.getString("FmeaTable.2"));
        Collection<Dictionnary> dicos = this._dicoMgr.getDictionnaries();
        if (dicos.isEmpty()) {
            linkToDictionnaryMenu.add(Messages.getString("FmeaTable.3"));
        } else {
            Iterator<Dictionnary> i = dicos.iterator();
            while (i.hasNext()) {
                String name = i.next().getName();
                AbstractAction linkToDictionnaryAction = new AbstractAction(name){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        FmeaTable.this.linkToDictionnary(FmeaTable.this._columnPopupMenu.getColumn(), this.getValue("Name").toString());
                    }
                };
                if (dico != null && dico.equals(name)) {
                    linkToDictionnaryAction.setEnabled(false);
                }
                linkToDictionnaryMenu.add(new JMenuItem(linkToDictionnaryAction));
            }
        }
        return linkToDictionnaryMenu;
    }

    protected JMenuItem createUnlinkFromDictionnaryMenuItem(int viewColumn) {
        int modelIndex = this.convertColumnIndexToModel(this._columnPopupMenu.getColumn());
        FmeaGraphicPropertyCollection properties = this.getFmeaTableModel().getColumnDefinition(modelIndex).getGraphicProperties();
        String dico = properties.getString(FmeaGraphicPropertyCollection.dictionnary);
        AbstractAction unlinkFromDictionnaryAction = new AbstractAction(Messages.getString("FmeaTable.4")){

            @Override
            public void actionPerformed(ActionEvent e) {
                FmeaTable.this.unlinkFromDictionnary(FmeaTable.this._columnPopupMenu.getColumn());
            }
        };
        if (dico == null) {
            unlinkFromDictionnaryAction.setEnabled(false);
        }
        JMenuItem unlinkFromDictionnary = new JMenuItem(unlinkFromDictionnaryAction);
        return unlinkFromDictionnary;
    }

    protected void linkToDictionnary(int column, String dicoName) {
        int modelIndex = this.convertColumnIndexToModel(column);
        FmeaGraphicPropertyCollection properties = this.getFmeaTableModel().getColumnDefinition(modelIndex).getGraphicProperties();
        properties.putString(FmeaGraphicPropertyCollection.dictionnary, dicoName);
        this.getColumnModel().getColumn(modelIndex).setCellRenderer(new FmeaStringRenderer());
        this.repaint();
    }

    protected void unlinkFromDictionnary(int column) {
        int modelIndex = this.convertColumnIndexToModel(column);
        FmeaGraphicPropertyCollection properties = this.getFmeaTableModel().getColumnDefinition(modelIndex).getGraphicProperties();
        properties.putString(FmeaGraphicPropertyCollection.dictionnary, null);
        this.getColumnModel().getColumn(modelIndex).setCellRenderer(null);
        this.repaint();
    }

    public FmeaTableModel getFmeaTableModel() {
        return (FmeaTableModel)this.getDataModel();
    }

    @Override
    public Rectangle getCellRect(int row, int column, boolean includeSpacing) {
        Rectangle rect = super.getCellRect(row, column, includeSpacing);
        return rect;
    }

    public int convertRowIndexToFmeaModel(int row) {
        return this.getSorterTableModel().convertRowIndexToModel(row);
    }

    @Override
    public int convertRowIndexToView(int row) {
        return this.getSorterTableModel().convertRowIndexToView(row);
    }

    public boolean isDataExist(int row, int column) {
        return this.getFmeaTableModel().isDataExist(this.convertRowIndexToFmeaModel(row), this.convertColumnIndexToModel(column));
    }

    public FmeaEntity createEntity(int row, int column) {
        FmeaEntity entity = this.getFmeaTableModel().createEntity(this.convertRowIndexToFmeaModel(row), this.convertColumnIndexToModel(column));
        this.update();
        return entity;
    }

    public void removeEntity(int row, int column) {
        this.getFmeaTableModel().removeEntity(this.convertRowIndexToFmeaModel(row), this.convertColumnIndexToModel(column));
        this.update();
    }

    public void createRelation(int row, int column) {
        this.getFmeaTableModel().createRelation(this.convertRowIndexToFmeaModel(row), this.convertColumnIndexToModel(column));
        this.update();
    }

    public void createAllRelations(int row, int column) {
        this.getFmeaTableModel().createAllRelations(this.convertRowIndexToFmeaModel(row), this.convertColumnIndexToModel(column));
        this.update();
    }

    public void removeRelation(int row, int column) {
        this.getFmeaTableModel().removeRelation(this.convertRowIndexToFmeaModel(row), this.convertColumnIndexToModel(column));
        this.update();
    }

    @Override
    public Component prepareRenderer(TableCellRenderer renderer, int row, int column) {
        FusionedCell cell = this.getFusionedCell(row, column);
        if (cell != null) {
            boolean isSelected = this.isCellSelected(row, column);
            int leadRow = this.selectionModel.getLeadSelectionIndex();
            int leadColumn = this.columnModel.getSelectionModel().getLeadSelectionIndex();
            boolean rowIsLead = leadRow >= cell._rStart && leadRow <= cell._rEnd;
            boolean colIsLead = leadColumn == cell._col;
            boolean hasFocus = rowIsLead && colIsLead && this.isFocusOwner();
            Object value = this.getValueAt(cell._rStart, cell._col);
            return renderer.getTableCellRendererComponent(this, value, isSelected, hasFocus, row, column);
        }
        return super.prepareRenderer(renderer, row, column);
    }

    @Override
    public Component prepareEditor(TableCellEditor editor, int row, int column) {
        FusionedCell cell = this.getFusionedCell(row, column);
        if (cell != null) {
            JComponent jComp;
            boolean isSelected;
            Object value = this.getValueAt(cell._rStart, cell._col);
            Component comp = editor.getTableCellEditorComponent(this, value, isSelected = this.isCellSelected(row, column), row, column);
            if (comp instanceof JComponent && (jComp = (JComponent)comp).getNextFocusableComponent() == null) {
                jComp.setNextFocusableComponent(this);
            }
            return comp;
        }
        return super.prepareEditor(editor, row, column);
    }

    @Override
    public void tableChanged(TableModelEvent e) {
        super.tableChanged(e);
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        super.valueChanged(e);
    }

    @Override
    public void editingStopped(ChangeEvent e) {
        TableCellEditor editor = this.getCellEditor(this.editingRow, this.editingColumn);
        if (editor != null) {
            Object value = editor.getCellEditorValue();
            Object oldValue = this.getValueAt(this.editingRow, this.editingColumn);
            if (value == null || value != null && !value.equals(oldValue)) {
                this.setValueAt(value, this.editingRow, this.editingColumn);
            }
            this.removeEditor();
        }
        this.update();
    }

    public boolean isEditingReferenceColumn() {
        return this.editorComp != null;
    }

    public void setToApply(boolean toApply) {
        this._toApply = toApply;
    }

    public boolean getToApply() {
        return this._toApply;
    }

    public boolean isGroupCells() {
        return this._groupCells;
    }

    public void setGroupCells(boolean groupCells) {
        this._groupCells = groupCells;
    }

    public void initFusionedCellTable() {
        this._fusionedCells = new Vector();
        for (int r = 0; r < this.getRowCount(); ++r) {
            Vector<Object> groupByRow = new Vector<Object>();
            this._fusionedCells.add(groupByRow);
            for (int col = 0; col < this.getColumnCount(); ++col) {
                groupByRow.add(null);
            }
        }
    }

    public void fusionCells(int rStart, int rEnd, int col, boolean formula, int operation, int source) {
        block12: {
            Class sourceClass;
            Class colClass;
            block10: {
                int value;
                block11: {
                    FusionedCell cell = new FusionedCell(rStart, rEnd, col);
                    for (int r = rStart; r <= rEnd; ++r) {
                        Vector groupByRow = this._fusionedCells.get(r);
                        groupByRow.set(col, cell);
                    }
                    if (!formula) {
                        return;
                    }
                    colClass = this.getFmeaTableModel().getColumnClass(col);
                    sourceClass = this.getFmeaTableModel().getColumnClass(source);
                    if (sourceClass != FmeaAttributeDefinition.Integer.class) break block10;
                    value = this.integerResolver(rStart, rEnd, operation, source);
                    if (colClass != FmeaAttributeDefinition.Integer.class) break block11;
                    for (int r2 = rStart; r2 <= rEnd; ++r2) {
                        this.setValueAt(value, r2, col);
                    }
                    break block12;
                }
                if (colClass != FmeaAttributeDefinition.Double.class) break block12;
                for (int r2 = rStart; r2 <= rEnd; ++r2) {
                    this.setValueAt(value, r2, col);
                }
                break block12;
            }
            if (sourceClass == FmeaAttributeDefinition.Double.class) {
                double value = this.doubleResolver(rStart, rEnd, operation, source);
                if (colClass == FmeaAttributeDefinition.Integer.class) {
                    for (int r2 = rStart; r2 <= rEnd; ++r2) {
                        this.setValueAt((int)value, r2, col);
                    }
                } else if (colClass == FmeaAttributeDefinition.Double.class) {
                    for (int r2 = rStart; r2 <= rEnd; ++r2) {
                        this.setValueAt(value, r2, col);
                    }
                }
            }
        }
    }

    public int integerResolver(int rStart, int rEnd, int operation, int source) {
        int total = 0;
        switch (operation) {
            case 0: {
                for (int r = rStart; r <= rEnd; ++r) {
                    if (this.getValueAt(r, source) == null) continue;
                    total += ((Integer)this.getValueAt(r, source)).intValue();
                }
                break;
            }
            case 1: {
                for (int r = rStart; r <= rEnd; ++r) {
                    if (this.getValueAt(r, source) == null) continue;
                    total *= ((Integer)this.getValueAt(r, source)).intValue();
                }
                break;
            }
        }
        return total;
    }

    public double doubleResolver(int rStart, int rEnd, int operation, int source) {
        double total = operation == 0 ? 0.0 : 1.0;
        switch (operation) {
            case 0: {
                for (int r = rStart; r <= rEnd; ++r) {
                    if (this.getValueAt(r, source) == null) continue;
                    total += ((Double)this.getValueAt(r, source)).doubleValue();
                }
                break;
            }
            case 1: {
                for (int r = rStart; r <= rEnd; ++r) {
                    if (this.getValueAt(r, source) == null) continue;
                    total *= ((Double)this.getValueAt(r, source)).doubleValue();
                }
                break;
            }
        }
        return total;
    }

    public void unFusionCells(int rStart, int rEnd, int col) {
        for (int r = rStart; r <= rEnd; ++r) {
            Vector row = this._fusionedCells.get(r);
            row.set(col, null);
        }
    }

    public boolean isCellFusioned(int row, int column) {
        return this._fusionedCells.get(row).get(column) != null;
    }

    public FusionedCell getFusionedCell(int row, int column) {
        return (FusionedCell)this._fusionedCells.get(row).get(column);
    }

    public Rectangle getFusionedCellRect(int row, int column, boolean withSpacing) {
        FusionedCell cell = this.getFusionedCell(row, column);
        return cell == null ? null : cell.getCellRect(withSpacing);
    }

    public void setShowLinesByGroup(boolean showLinesByGroup) {
        this._showLinesByGroup = showLinesByGroup;
        this.repaint();
    }

    public boolean getShowLinesByGroup() {
        return this._showLinesByGroup;
    }

    @Override
    public void sort(int column, boolean ascending) {
        this.setShowLinesByGroup(false);
        this.initFusionedCellTable();
        super.sort(column, ascending);
        this.setToApply(false);
    }

    public void sort(SortData sortData) {
        if (sortData == null) {
            return;
        }
        this.setToApply(true);
        this.setShowLinesByGroup(false);
        this.initFusionedCellTable();
        Vector<Integer> columns = new Vector<Integer>();
        Vector<String> orders = new Vector<String>();
        for (int i = 0; i < sortData.getColumnCount(); ++i) {
            FmeaColumnDefinition colDef = sortData.getColumnDefinition(i);
            FmeaTableDefinition tblDef = this.getFmeaTableModel().getFmea().getModel().getTableDefinition();
            int col = this.convertColumnIndexToView(tblDef.getColumnPosition(colDef));
            columns.add(col);
            orders.add(sortData.getColumnSortOrder(i));
        }
        super.sort(columns, orders);
        if (!this._groupCells) {
            return;
        }
        this.doFusionCells(sortData);
        this.setShowLinesByGroup(true);
    }

    private void doFusionCells(SortData sortData) {
        int colPrec = -1;
        for (int i = 0; i < sortData.getColumnCount(); ++i) {
            FmeaColumnDefinition colDef = sortData.getColumnDefinition(i);
            FmeaTableDefinition tblDef = this.getFmeaTableModel().getFmea().getModel().getTableDefinition();
            int mdlCol = tblDef.getColumnPosition(colDef);
            int col = this.convertColumnIndexToView(mdlCol);
            for (int row = 0; row < this.getRowCount(); ++row) {
                int rEnd;
                int rStart = row;
                if (!sortData.formulaApplied(colDef)) {
                    int r;
                    Object refValue = this.getValueAt(row, col);
                    if (i == 0) {
                        rEnd = this.getRowCount() - 1;
                    } else {
                        FusionedCell cell = this.getFusionedCell(row, colPrec);
                        rEnd = cell._rEnd;
                    }
                    for (r = rStart; r <= rEnd; ++r) {
                        Object value = this.getValueAt(r, col);
                        if (!(refValue == null && value == null || refValue != null && refValue.equals(value))) break;
                    }
                    rEnd = r - 1;
                } else {
                    FusionedCell cell = this.getFusionedCell(row, colPrec);
                    rEnd = cell._rEnd;
                }
                if (!sortData.formulaApplied(colDef)) {
                    this.fusionCells(rStart, rEnd, col, false, -1, 0);
                } else {
                    FmeaColumnDefinition srcColDef = sortData.getFormulaSourceColumn(colDef);
                    int sourceCol = this.convertColumnIndexToView(tblDef.getColumnPosition(srcColDef));
                    int operation = sortData.getFormulaOperation(colDef);
                    this.fusionCells(rStart, rEnd, col, true, operation, sourceCol);
                }
                row = rEnd;
            }
            colPrec = col;
        }
    }

    private void doFusionCells2(SortData sortData) {
        for (int i = 0; i < sortData.getColumnCount(); ++i) {
            FmeaColumnDefinition colDef = sortData.getColumnDefinition(i);
            FmeaTableDefinition tblDef = this.getFmeaTableModel().getFmea().getModel().getTableDefinition();
            int mdlCol = tblDef.getColumnPosition(colDef);
            int col = this.convertColumnIndexToView(mdlCol);
            for (int row = 0; row < this.getRowCount(); ++row) {
                int rStart;
                int r;
                int mdlRow = this.convertRowIndexToFmeaModel(row);
                FmeaEntity entityRef = this.getFmeaTableModel().getEntityAt(mdlRow, colDef);
                if (entityRef == null) continue;
                for (r = rStart = row; r < this.getRowCount(); ++r) {
                    mdlRow = this.convertRowIndexToFmeaModel(r);
                    FmeaEntity entity = this.getFmeaTableModel().getEntityAt(mdlRow, colDef);
                    if (entity != null && entity.getName() != entityRef.getName()) break;
                }
                int rEnd = r - 1;
                if (!sortData.formulaApplied(colDef)) {
                    this.fusionCells(rStart, rEnd, col, false, -1, 0);
                } else {
                    FmeaColumnDefinition srcColDef = sortData.getFormulaSourceColumn(colDef);
                    int sourceCol = this.convertColumnIndexToView(tblDef.getColumnPosition(srcColDef));
                    int operation = sortData.getFormulaOperation(colDef);
                    this.fusionCells(rStart, rEnd, col, true, operation, sourceCol);
                }
                row = rEnd;
            }
        }
    }

    @Override
    public void setValueAt(Object aValue, int row, int column) {
        super.setValueAt(aValue, row, column);
    }

    public void ungroupByColumns() {
        this.initFusionedCellTable();
        this.setShowLinesByGroup(false);
        this.setToApply(false);
        this.repaint();
    }

    public boolean checkValue(Object value, int row, int col) {
        Fmea.errorMgr.clear();
        int r = this.convertRowIndexToFmeaModel(row);
        int c = this.convertColumnIndexToModel(col);
        if (!this.getFmeaTableModel().checkValue(value, r, c)) {
            if (Fmea.errorMgr.size() == 1) {
                Msg msg = Fmea.errorMgr.get(0);
                JOptionPane.showMessageDialog(JOptionCecilia.getTopContainerOf(this), msg.getMsg(), Messages.getString("ErrorManager.2"), msg.getType().getCode());
            } else if (Fmea.errorMgr.size() > 1) {
                DlgDisplayMsg dlg = new DlgDisplayMsg(SwingUtilities.getWindowAncestor(this));
                dlg.setMsgs(Fmea.errorMgr);
                dlg.setModal(true);
                dlg.setLocationRelativeTo(JOptionCecilia.getTopContainerOf(this));
                dlg.setVisible(true);
                dlg.dispose();
            }
            return false;
        }
        return true;
    }

    @Override
    public boolean isCellEditable(int row, int column) {
        if (!this.isDataExist(row, column)) {
            return false;
        }
        if (this.isSortDataColumnResult(column)) {
            return false;
        }
        boolean b = super.isCellEditable(row, column);
        if (!b) {
            return false;
        }
        return this._editable;
    }

    public void setEditable(boolean b) {
        this._editable = b;
    }

    public void setPrinting(boolean printing) {
        this._isPrinting = printing;
    }

    public boolean isPrinting() {
        return this._isPrinting;
    }

    public void setOnArrowKeysAction(Action a) {
        this.onArrowKeysAction = a;
    }

    @Override
    protected boolean processKeyBinding(KeyStroke ks, KeyEvent e, int condition, boolean pressed) {
        boolean b = super.processKeyBinding(ks, e, condition, pressed);
        if (this.onArrowKeysAction != null && (ks == KeyStroke.getKeyStroke("LEFT") || ks == KeyStroke.getKeyStroke("RIGHT") || ks == KeyStroke.getKeyStroke("UP") || ks == KeyStroke.getKeyStroke("DOWN"))) {
            this.onArrowKeysAction.actionPerformed(null);
        }
        return b;
    }

    public void addDependsListener(DependsListener l) {
        if (!this._listeners.contains(l)) {
            this._listeners.add(l);
        }
    }

    public void removeDependsListener(DependsListener l) {
        this._listeners.remove(l);
    }

    protected void fireChangeDepends() {
        for (int i = this._listeners.size() - 1; i >= 0; --i) {
            this._listeners.get(i).changeDepends();
        }
    }

    private class FmeaStringRenderer
    extends JTextArea
    implements TableCellRenderer {
        public FmeaStringRenderer() {
            this.setLineWrap(true);
            this.setWrapStyleWord(true);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            int modelIndex = table.convertColumnIndexToModel(column);
            FmeaColumnDefinition colDef = ((FmeaTable)table).getFmeaTableModel().getColumnDefinition(modelIndex);
            FmeaGraphicPropertyCollection columnProp = colDef.getGraphicProperties();
            if (((FmeaTable)table).isPrinting()) {
                this.setForeground(Color.black);
                this.setBackground(Color.white);
            } else if (isSelected) {
                this.setForeground(table.getSelectionForeground());
                this.setBackground(table.getSelectionBackground());
            } else if (!((FmeaTable)table).isDataExist(row, column) || ((FmeaTable)table).isSortDataColumnResult(column)) {
                this.setForeground(table.getForeground());
                this.setBackground(lightGrayColor);
            } else {
                Color fg = columnProp.getColor(FmeaGraphicPropertyCollection.foreground);
                if (fg != null) {
                    this.setForeground(fg);
                } else {
                    this.setForeground(table.getForeground());
                }
                Color bg = columnProp.getColor(FmeaGraphicPropertyCollection.background);
                if (bg != null) {
                    this.setBackground(bg);
                } else {
                    this.setBackground(table.getBackground());
                }
            }
            if (hasFocus) {
                this.setBorder(UIManager.getBorder("Table.focusCellHighlightBorder"));
            } else {
                this.setBorder(noFocusBorder);
            }
            Font f = columnProp.getFont(FmeaGraphicPropertyCollection.font);
            if (f != null) {
                this.setFont(f);
            } else {
                this.setFont(table.getFont());
            }
            this.setValue(value);
            return this;
        }

        protected void setValue(Object value) {
            this.setText(value == null ? "" : value.toString());
        }
    }

    private class FmeaNumberRenderer
    extends FmeaDefaultRenderer {
        public FmeaNumberRenderer() {
            this.setHorizontalAlignment(4);
        }
    }

    private class FmeaDoubleRenderer
    extends FmeaNumberRenderer {
        final DecimalFormat formatter = new DecimalFormat("0.000E00", new DecimalFormatSymbols(Locale.ENGLISH));

        @Override
        public void setValue(Object value) {
            this.setText(value == null ? "" : this.formatter.format(value));
        }
    }

    private class FmeaStringEditor
    extends DefaultCellEditor
    implements KeyListener {
        public FmeaStringEditor() {
            super(new JTextField());
            this.editorComponent = new JTextArea();
            this.getTextArea().setLineWrap(true);
            this.getTextArea().setWrapStyleWord(true);
            this.editorComponent.addKeyListener(this);
            this.editorComponent.setFont(FmeaTable.this.getFont());
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            ((JComponent)this.getComponent()).setBorder(new LineBorder(Color.black));
            this.getTextArea().setText(value == null ? "" : value.toString());
            return this.editorComponent;
        }

        @Override
        public Component getComponent() {
            return this.editorComponent;
        }

        @Override
        public Object getCellEditorValue() {
            return this.getTextArea().getText().length() == 0 ? null : this.getTextArea().getText();
        }

        public JTextArea getTextArea() {
            return (JTextArea)this.editorComponent;
        }

        @Override
        public void keyPressed(KeyEvent e) {
            if (e.getKeyCode() == 10) {
                if (e.isControlDown()) {
                    this.getTextArea().insert("\n", this.getTextArea().getCaretPosition());
                } else {
                    this.stopCellEditing();
                    e.consume();
                }
            }
        }

        @Override
        public void keyReleased(KeyEvent e) {
        }

        @Override
        public void keyTyped(KeyEvent e) {
        }

        @Override
        public boolean stopCellEditing() {
            FmeaTable table = FmeaTable.this;
            return table.checkValue(this.getCellEditorValue(), table.getEditingRow(), table.getEditingColumn()) && super.stopCellEditing();
        }
    }

    private class FmeaIntegerEditor
    extends FmeaDefaultEditor {
        private FmeaIntegerEditor() {
        }

        @Override
        public Object getCellEditorValue() {
            return this.getTextField().getText().length() == 0 ? null : Integer.valueOf(this.getTextField().getText());
        }
    }

    private class FmeaDoubleEditor
    extends FmeaDefaultEditor {
        private FmeaDoubleEditor() {
        }

        @Override
        public Object getCellEditorValue() {
            return this.getTextField().getText().length() == 0 ? null : Double.valueOf(this.getTextField().getText());
        }
    }

    private class ColumnPopupMenuMouseAdapter
    extends MouseAdapter {
        private ColumnPopupMenuMouseAdapter() {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (e.getClickCount() != 1 || e.getModifiersEx() != 4096) {
                return;
            }
            int col = FmeaTable.this.getColumnModel().getColumnIndexAtX(e.getX());
            if (col == -1) {
                return;
            }
            FmeaTable.this.configureColumnPopupMenu(col);
            if (FmeaTable.this._columnPopupMenu.getComponentCount() == 0) {
                return;
            }
            FmeaTable.this._columnPopupMenu.show(FmeaTable.this.getTableHeader(), e.getX(), e.getY());
        }
    }

    private class ColumnPopupMenu
    extends JPopupMenu {
        int column = -1;

        ColumnPopupMenu(int viewColumn) {
            this.column = viewColumn;
        }

        int getColumn() {
            return this.column;
        }
    }

    public class FusionedCell {
        public int _col = 0;
        public int _rStart = 0;
        public int _rEnd = 0;

        public FusionedCell(int rStart, int rEnd, int col) {
            this._rStart = rStart;
            this._rEnd = rEnd;
            this._col = col;
        }

        public Rectangle getCellRect(boolean withSpacing) {
            Rectangle start = FmeaTable.this.getCellRect(this._rStart, this._col, withSpacing);
            Rectangle end = FmeaTable.this.getCellRect(this._rEnd, this._col, withSpacing);
            start.add(end);
            return start;
        }
    }

    private class FmeaComboCellEditor
    extends AbstractCellEditor
    implements TableCellEditor,
    ActionListener,
    FocusListener {
        private JComboBox component = new JComboBox();
        private int clickCountToStart = 2;

        public FmeaComboCellEditor() {
            this.component.addActionListener(this);
            this.component.addFocusListener(this);
            this.component.setEditable(true);
        }

        @Override
        public Object getCellEditorValue() {
            return this.component.getSelectedItem() == null ? null : this.component.getSelectedItem().toString();
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            this.component.removeAllItems();
            Iterator itr = ((FmeaTable)table).getFmeaTableModel().getEntities(table.convertColumnIndexToModel(column));
            while (itr.hasNext()) {
                this.component.addItem(((FmeaEntity)itr.next()).getName());
            }
            this.component.setBorder(new LineBorder(Color.black));
            this.component.setSelectedItem(value == null ? null : value.toString());
            return this.component;
        }

        @Override
        public boolean isCellEditable(EventObject anEvent) {
            if (anEvent instanceof MouseEvent) {
                return ((MouseEvent)anEvent).getClickCount() >= this.clickCountToStart;
            }
            return true;
        }

        public JComboBox getComponent() {
            return this.component;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!this.stopCellEditing()) {
                this.cancelCellEditing();
            }
        }

        @Override
        public void focusGained(FocusEvent e) {
        }

        @Override
        public void focusLost(FocusEvent e) {
        }

        @Override
        public boolean stopCellEditing() {
            Object value = this.getCellEditorValue();
            return value != null && value.toString().length() != 0 && super.stopCellEditing();
        }

        @Override
        public void cancelCellEditing() {
            super.cancelCellEditing();
        }
    }

    private class FmeaDefaultEditor
    extends DefaultCellEditor {
        public FmeaDefaultEditor() {
            super(new JTextField());
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            ((JComponent)this.getComponent()).setBorder(new LineBorder(Color.black));
            this.getTextField().setText(value == null ? "" : value.toString());
            return this.editorComponent;
        }

        @Override
        public Object getCellEditorValue() {
            return this.getTextField().getText().length() == 0 ? null : this.getTextField().getText();
        }

        public JTextField getTextField() {
            return (JTextField)this.editorComponent;
        }

        @Override
        public boolean stopCellEditing() {
            FmeaTable table = FmeaTable.this;
            boolean value = table.checkValue(this.getTextField().getText(), table.getEditingRow(), table.getEditingColumn()) && super.stopCellEditing();
            return value;
        }
    }

    private class FmeaDefaultRenderer
    extends JTextField
    implements TableCellRenderer {
        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            int modelIndex = table.convertColumnIndexToModel(column);
            FmeaColumnDefinition colDef = ((FmeaTable)table).getFmeaTableModel().getColumnDefinition(modelIndex);
            FmeaGraphicPropertyCollection columnProp = colDef.getGraphicProperties();
            if (((FmeaTable)table).isPrinting()) {
                super.setForeground(Color.black);
                super.setBackground(Color.white);
            } else if (isSelected) {
                super.setForeground(table.getSelectionForeground());
                super.setBackground(table.getSelectionBackground());
            } else if (!((FmeaTable)table).isDataExist(row, column) || ((FmeaTable)table).isSortDataColumnResult(column)) {
                super.setForeground(table.getForeground());
                super.setBackground(lightGrayColor);
            } else {
                Color fg = columnProp.getColor(FmeaGraphicPropertyCollection.foreground);
                if (fg != null) {
                    this.setForeground(fg);
                } else {
                    this.setForeground(table.getForeground());
                }
                Color bg = columnProp.getColor(FmeaGraphicPropertyCollection.background);
                if (bg != null) {
                    this.setBackground(bg);
                } else {
                    this.setBackground(table.getBackground());
                }
            }
            if (hasFocus) {
                this.setBorder(UIManager.getBorder("Table.focusCellHighlightBorder"));
            } else {
                this.setBorder(noFocusBorder);
            }
            Font f = columnProp.getFont(FmeaGraphicPropertyCollection.font);
            if (f != null) {
                this.setFont(f);
            } else {
                this.setFont(table.getFont());
            }
            Integer align = columnProp.getHorizontalAlignment();
            if (align != null) {
                this.setHorizontalAlignment(align);
            }
            this.setValue(value);
            return this;
        }

        protected void setValue(Object value) {
            this.setText(value == null ? "" : value.toString());
        }
    }

    private class FmeaStringRenderer2
    extends JPanel
    implements TableCellRenderer {
        private JTextArea textArea;

        public FmeaStringRenderer2() {
            super(new GridBagLayout());
            this.textArea = new JTextArea();
            this.textArea.setLineWrap(true);
            this.textArea.setWrapStyleWord(true);
            this.add((Component)this.textArea, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (((FmeaTable)table).isPrinting()) {
                super.setForeground(Color.black);
                super.setBackground(Color.white);
            } else if (isSelected) {
                super.setForeground(table.getSelectionForeground());
                super.setBackground(table.getSelectionBackground());
            } else if (!((FmeaTable)table).isDataExist(row, column) || ((FmeaTable)table).isSortDataColumnResult(column)) {
                super.setForeground(table.getForeground());
                super.setBackground(lightGrayColor);
            } else if (hasFocus && table.isCellEditable(row, column)) {
                super.setForeground(UIManager.getColor("Table.focusCellForeground"));
                super.setBackground(UIManager.getColor("Table.focusCellBackground"));
            } else {
                super.setForeground(table.getForeground());
                super.setBackground(table.getBackground());
            }
            if (hasFocus) {
                this.setBorder(UIManager.getBorder("Table.focusCellHighlightBorder"));
            } else {
                this.setBorder(noFocusBorder);
            }
            this.textArea.setFont(table.getFont());
            this.setValue(value);
            return this;
        }

        protected void setValue(Object value) {
            this.textArea.setText(value == null ? "" : value.toString());
        }

        @Override
        public void setForeground(Color color) {
            super.setForeground(color);
            if (this.textArea != null) {
                this.textArea.setForeground(color);
            }
        }

        @Override
        public void setBackground(Color color) {
            super.setBackground(color);
            if (this.textArea != null) {
                this.textArea.setBackground(Color.yellow);
            }
        }
    }
}

