/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.dbobj.fmea.ihm;

import com.dassault.cecilia.core.cecilia.dependencies.DependsListener;
import com.dassault.cecilia.core.cecilia.error.DlgDisplayMsg;
import com.dassault.cecilia.core.cecilia.error.Msg;
import com.dassault.cecilia.core.swing.JOptionCecilia;
import com.dassault.cecilia.dbobj.fmea.DBTableFMEA;
import com.dassault.cecilia.dbobj.fmea.Messages;
import com.dassault.cecilia.dbobj.fmea.ihm.FmeaDBTable;
import com.dassault.cecilia.dbobj.fmea.ihm.FmeaTable;
import com.dassault.cecilia.dbobj.fmea.ihm.FmeaTableView;
import com.dassault.cecilia.dbobj.fmea.ihm.Head;
import com.dassault.cecilia.dbobj.fmea.ihm.dialog.DictionnaryManagerPanel;
import com.dassault.cecilia.dbobj.fmea.ihm.dialog.TabbedTextFileImportDlg;
import com.dassault.cecilia.dbobj.fmea.model.ChangeListener;
import com.dassault.cecilia.dbobj.fmea.model.DictionnaryManager;
import com.dassault.cecilia.dbobj.fmea.model.DictionnaryStore;
import com.dassault.cecilia.dbobj.fmea.model.Fmea;
import com.dassault.cecilia.dbobj.fmea.model.FmeaAttributeDefinition;
import com.dassault.cecilia.dbobj.fmea.model.FmeaColumnDefinition;
import com.dassault.cecilia.dbobj.fmea.model.FmeaEntity;
import com.dassault.cecilia.dbobj.fmea.model.FmeaTableDefinition;
import com.dassault.cecilia.dbobj.fmea.model.SortData;
import com.dassault.cecilia.dbobj.fmea.util.Util;
import com.dassault.cecilia.main.cecilia.CeciliaAppl;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileFilter;

public class FmeaTablePanel
extends JPanel
implements ChangeListener {
    private static final String PROP_FMEA_RESOURCE_DEF = "com.dassault.cecilia.dbobj.fmea.ihm.FmeaPanel";
    public static final String PROP_FMEA_RESOURCE = "cecilia.fmea.bundle.baseFile";
    public static final String PROP_FMEA_LOG_PATH = "cecilia.fmea.log.path";
    public static final String PROP_FMEA_DB_PATH = "cecilia.fmea.db.path";
    private static ResourceBundle resources;
    public static final String typeSuffix = "Type";
    public static final String classSuffix = "Class";
    public static final String imageSuffix = "Image";
    public static final String labelSuffix = "Label";
    public static final String actionSuffix = "Action";
    public static final String tipSuffix = "Tooltip";
    public static final String textFileImportAction = "textFileImport";
    public static final String newEntityAction = "newEntity";
    public static final String newRelationAction = "newRelation";
    public static final String newRelationsAction = "newRelations";
    public static final String removeEntityAction = "removeEntity";
    public static final String removeRelationAction = "removeRelation";
    public static final String mergeAction = "merge";
    public static final String openDictionnaryManagerAction = "openDictionnaryManager";
    public static final String GLOBAL_ERROR = "GLOBAL_ERROR";
    public static final String LAUNCH_INI_NOT_FOUND = "LAUNCH_INI_NOT_FOUND";
    public static final String defaultTitle;
    private JMenuBar _menubar;
    protected JToolBar _toolbar;
    private Map<String, JMenuItem> _menubarItems = new HashMap<String, JMenuItem>();
    private Map<String, AbstractButton> _toolbarItems = new HashMap<String, AbstractButton>();
    protected JToolBar _toolbarPrintPreview;
    private JComponent _status;
    private Fmea _fmea;
    private Head _head;
    private FmeaTable _table;
    private DictionnaryManagerPanel _dicoMgrDlg;
    private CeciliaAppl _appli;
    private ActionManager actionMgr = new ActionManager();
    protected FmeaTableView tableView;
    private boolean listenChanges = false;
    DBTableFMEA _dbTableFMEA;
    private Action[] defaultActions = new Action[]{new TextFileImportAction(), new NewEntityAction(), new NewRelationAction(), new NewRelationsAction(), new RemoveEntityAction(), new RemoveRelationAction(), new MergeAction(), new OpenDictionnaryManagerAction()};

    public FmeaTablePanel(CeciliaAppl appli) {
        this._appli = appli;
        this.init();
    }

    public void init() {
        this.actionMgr.initializeActions();
        this.initializeAttributes();
        this.build();
    }

    public void initializeAttributes() {
        this._table = new FmeaDBTable(this._appli, (DictionnaryManager)new DictionnaryStore());
        this._dicoMgrDlg = new DictionnaryManagerPanel((Window)this._appli.getTopWindow(), Messages.getString("FmeaPanel.38"));
        this._toolbar = (JToolBar)this.createToolbar();
        this._toolbarPrintPreview = (JToolBar)this.createToolbarPrintPreview();
        this._status = this.createStatusbar();
        this._toolbarPrintPreview.setVisible(false);
        this._status.setPreferredSize(new Dimension(0, 20));
        this.tableView = new FmeaTableView();
    }

    public Fmea getFmea() {
        return this._fmea;
    }

    public FmeaTable getFmeaTable() {
        return this._table;
    }

    public URL getResourceURL(String name) {
        return this.getResource(name);
    }

    public InputStream getResourceStream(String name) {
        try {
            URL url = this.getResource(name);
            return url.openStream();
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public URL getResource(String key) {
        String name = FmeaTablePanel.getResourceString(key);
        if (name != null) {
            return this.getClass().getResource(name);
        }
        String msg = Util.FormatString(Messages.getString("FmeaPanel.34"), key);
        JOptionPane.showMessageDialog(JOptionCecilia.getTopContainerOf(this), msg, Messages.getString("ErrorManager.2"), 0);
        return null;
    }

    public boolean open(DBTableFMEA dbTableFMEA) {
        JToggleButton b;
        this._dbTableFMEA = dbTableFMEA;
        this._fmea = dbTableFMEA.getFMEA();
        if (this._fmea == null) {
            return false;
        }
        this._table.setSource(this._dbTableFMEA.getDBFolder());
        this._table.setFmea(this._fmea);
        this._table.addDependsListener(new DependsListener(){

            @Override
            public void changeDepends() {
                FmeaTablePanel.this._dbTableFMEA.updateDependTimeUpdt(FmeaTablePanel.this._appli.getDAOFactory(), FmeaTablePanel.this._dbTableFMEA.getWorkingRelations());
            }
        });
        SortData sortData = this._fmea.getModel().getSortData();
        this._table.sort(sortData);
        this.actionMgr.getAction(mergeAction).setEnabled(sortData != null && sortData.getGroupCells());
        JCheckBoxMenuItem mi = (JCheckBoxMenuItem)this._menubarItems.get(mergeAction);
        if (mi != null) {
            mi.setSelected(sortData == null ? false : sortData.getGroupCells());
        }
        if ((b = (JToggleButton)this._toolbarItems.get(mergeAction)) != null) {
            b.setSelected(sortData == null ? false : sortData.getGroupCells());
        }
        this._head = this._dbTableFMEA.readHead(this._appli.getDAOFactory());
        this.tableView.setData(this._table, this._head);
        this._fmea.getChangeNotifier().setChanged(false);
        if (this._fmea.getOpenMode() == Fmea.READ_WRITE) {
            this.listenChanges = true;
            this._fmea.getChangeNotifier().addChangeListener(this);
        } else {
            this.listenChanges = false;
        }
        this.updateTitle();
        return true;
    }

    public Container getToolbar() {
        return this._toolbar;
    }

    protected Container getPrintPreviewToolbar() {
        return this._toolbarPrintPreview;
    }

    protected JMenuBar getMenubar() {
        return this._menubar;
    }

    protected void initActionStates() {
        this.actionMgr.getAction(textFileImportAction).setEnabled(true);
        this.actionMgr.getAction(newEntityAction).setEnabled(true);
        this.actionMgr.getAction(newRelationAction).setEnabled(true);
        this.actionMgr.getAction(newRelationsAction).setEnabled(true);
        this.actionMgr.getAction(removeEntityAction).setEnabled(true);
        this.actionMgr.getAction(removeRelationAction).setEnabled(true);
        this.actionMgr.getAction(mergeAction).setEnabled(false);
        this.actionMgr.getAction(openDictionnaryManagerAction).setEnabled(true);
    }

    protected void build() {
        this.setLayout(new GridBagLayout());
        this.add((Component)this._toolbar, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this._toolbarPrintPreview, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.tableView, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this._status, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
    }

    protected JComponent createStatusbar() {
        return new StatusBar();
    }

    public ActionManager getActionManager() {
        return this.actionMgr;
    }

    public static String getResourceString(String nm) {
        String str;
        try {
            str = resources.getString(nm);
        }
        catch (MissingResourceException mre) {
            str = null;
        }
        return str;
    }

    protected InputStream getResourceAsStream(String key) {
        String name = FmeaTablePanel.getResourceString(key);
        if (name != null) {
            InputStream in = this.getClass().getResourceAsStream(name);
            return in;
        }
        return null;
    }

    protected Component createToolbar() {
        JToolBar toolbar = new JToolBar();
        String[] toolKeys = this.tokenize(FmeaTablePanel.getResourceString("toolbar"));
        for (int i = 0; i < toolKeys.length; ++i) {
            if (toolKeys[i].equals("-")) {
                toolbar.add(Box.createHorizontalStrut(5));
                toolbar.add(new JToolBar.Separator());
                toolbar.add(Box.createHorizontalStrut(5));
                continue;
            }
            toolbar.add(this.createTool(toolKeys[i]));
        }
        toolbar.setFloatable(false);
        toolbar.setMargin(new Insets(0, 0, 0, 0));
        return toolbar;
    }

    protected Component createToolbarPrintPreview() {
        JToolBar toolbar = new JToolBar();
        String[] toolKeys = this.tokenize(FmeaTablePanel.getResourceString("toolbarPrintPreview"));
        for (int i = 0; i < toolKeys.length; ++i) {
            if (toolKeys[i].equals("-")) {
                toolbar.add(Box.createHorizontalStrut(5));
                toolbar.add(new JToolBar.Separator());
                toolbar.add(Box.createHorizontalStrut(5));
                continue;
            }
            toolbar.add(this.createTool(toolKeys[i]));
        }
        toolbar.setFloatable(false);
        toolbar.setMargin(new Insets(0, 0, 0, 0));
        return toolbar;
    }

    protected Component createTool(String key) {
        return this.createToolbarButton(key);
    }

    protected AbstractButton createToolbarButton(String key) {
        AbstractButton b = null;
        String classB = FmeaTablePanel.getResourceString(key + classSuffix);
        if (classB != null && classB.equals("JToggleButton")) {
            b = new LocalJToggleButton();
            ((LocalJToggleButton)b).setKey(key);
        } else {
            b = new LocalJButton();
            ((LocalJButton)b).setKey(key);
        }
        final AbstractButton button = b;
        FmeaAction a = this.actionMgr.getAction(key);
        if (a != null) {
            b.setAction(a);
            this.actionMgr.addActionChangedListener(new ActionChangedListener(){

                @Override
                public void actionChanged(String actionKey, FmeaAction oldAction, FmeaAction newAction) {
                    if (actionKey != ((FmeaAction)button.getAction()).getKey()) {
                        return;
                    }
                    if (newAction == oldAction) {
                        return;
                    }
                    newAction.putValue("SmallIcon", oldAction.getValue("SmallIcon"));
                    newAction.putValue("ShortDescription", oldAction.getValue("ShortDescription"));
                    button.setAction(newAction);
                }
            });
        }
        b.setName(key);
        this._toolbarItems.put(key, b);
        return b;
    }

    public JMenuBar createMenubar() {
        JMenuBar mb = new JMenuBar();
        String[] menuKeys = this.tokenize(FmeaTablePanel.getResourceString("menubar"));
        for (int i = 0; i < menuKeys.length; ++i) {
            JMenu m = this.createMenu(menuKeys[i]);
            if (m == null) continue;
            mb.add(m);
        }
        this._menubar = mb;
        return mb;
    }

    protected JMenu createMenu(String key) {
        String[] itemKeys = this.tokenize(FmeaTablePanel.getResourceString(key));
        JMenu menu = new JMenu(FmeaTablePanel.getResourceString(key + labelSuffix));
        URL url = this.getResource(key + imageSuffix);
        if (url != null) {
            menu.setIcon(new ImageIcon(url));
        }
        for (int i = 0; i < itemKeys.length; ++i) {
            if (itemKeys[i].equals("-")) {
                menu.addSeparator();
                continue;
            }
            String menuDesc = FmeaTablePanel.getResourceString(itemKeys[i]);
            if (menuDesc != null) {
                JMenu submenu = this.createMenu(itemKeys[i]);
                menu.add(submenu);
                continue;
            }
            JMenuItem mi = this.createMenuItem(itemKeys[i]);
            menu.add(mi);
        }
        return menu;
    }

    protected JMenuItem createMenuItem(String cmd) {
        JMenuItem menuItem = null;
        String classMi = FmeaTablePanel.getResourceString(cmd + classSuffix);
        menuItem = classMi != null && classMi.equals("JToggleButton") ? new JCheckBoxMenuItem() : new JMenuItem();
        final JMenuItem mi = menuItem;
        mi.setHorizontalTextPosition(4);
        FmeaAction a = this.actionMgr.getAction(cmd);
        if (a != null) {
            mi.setAction(a);
            this.actionMgr.addActionChangedListener(new ActionChangedListener(){

                @Override
                public void actionChanged(String actionKey, FmeaAction oldAction, FmeaAction newAction) {
                    if (actionKey != ((FmeaAction)mi.getAction()).getKey()) {
                        return;
                    }
                    if (newAction == oldAction) {
                        return;
                    }
                    newAction.putValue("SmallIcon", oldAction.getValue("SmallIcon"));
                    newAction.putValue("ShortDescription", oldAction.getValue("ShortDescription"));
                    mi.setAction(newAction);
                }
            });
        } else {
            mi.setEnabled(false);
        }
        mi.setName(cmd);
        this._menubarItems.put(cmd, mi);
        return mi;
    }

    protected String[] tokenize(String input) {
        Vector<String> v = new Vector<String>();
        StringTokenizer t = new StringTokenizer(input);
        while (t.hasMoreTokens()) {
            v.addElement(t.nextToken());
        }
        String[] cmd = new String[v.size()];
        for (int i = 0; i < cmd.length; ++i) {
            cmd[i] = (String)v.elementAt(i);
        }
        return cmd;
    }

    public void updateTitle() {
    }

    @Override
    public void changed(Object changedObject) {
        if (!this.listenChanges) {
            return;
        }
        this.updateTitle();
    }

    static {
        String bundleBaseFile = null;
        try {
            bundleBaseFile = System.getProperty(PROP_FMEA_RESOURCE, PROP_FMEA_RESOURCE_DEF);
            resources = ResourceBundle.getBundle(bundleBaseFile, Locale.getDefault());
        }
        catch (MissingResourceException mre) {
            String file = bundleBaseFile.replace('.', '/') + ".properties";
            System.err.println("Ressource \"" + file + "\" not found");
            System.exit(1);
        }
        defaultTitle = Messages.getString("FmeaPanel.33");
    }

    public class ActionManager {
        private HashMap<String, FmeaAction> commands = new HashMap();
        private Collection<ActionChangedListener> listeners = new ArrayList<ActionChangedListener>();

        protected void initializeActions() {
            this.commands = new HashMap();
            Action[] actions = FmeaTablePanel.this.defaultActions;
            for (int i = 0; i < actions.length; ++i) {
                FmeaAction a = (FmeaAction)actions[i];
                String actionKey = (String)a.getValue("Name");
                this.initializeAction(a);
                this.commands.put(actionKey, a);
            }
            FmeaTablePanel.this.initActionStates();
        }

        protected void initializeAction(Action a) {
            String tip;
            URL url;
            String actionKey = (String)a.getValue("Name");
            String name = FmeaTablePanel.getResourceString(actionKey + FmeaTablePanel.labelSuffix);
            if (name != null) {
                a.putValue("Name", name);
            }
            if ((url = FmeaTablePanel.this.getResource(actionKey + FmeaTablePanel.imageSuffix)) != null) {
                a.putValue("SmallIcon", new ImageIcon(url));
            }
            if ((tip = FmeaTablePanel.getResourceString(actionKey + FmeaTablePanel.tipSuffix)) != null) {
                a.putValue("ShortDescription", tip);
            }
        }

        public FmeaAction getAction(String cmd) {
            return this.commands.get(cmd);
        }

        public void setAction(String cmd, FmeaAction action) {
            FmeaAction oldAction = this.commands.get(cmd);
            this.commands.put(cmd, action);
            this.notifyActionChangedListeners(cmd, oldAction, action);
        }

        public void addActionChangedListener(ActionChangedListener l) {
            this.listeners.add(l);
        }

        public void removeActionChangedListener(ActionChangedListener l) {
            this.listeners.remove(l);
        }

        private void notifyActionChangedListeners(String actionKey, FmeaAction oldAction, FmeaAction newAction) {
            Iterator<ActionChangedListener> i = this.listeners.iterator();
            while (i.hasNext()) {
                i.next().actionChanged(actionKey, oldAction, newAction);
            }
        }
    }

    class TextFileImportAction
    extends FmeaAction {
        TextFileImportAction() {
            super(FmeaTablePanel.textFileImportAction);
        }

        @Override
        public boolean doIt(ActionEvent e) {
            JFileChooser chooser = new JFileChooser();
            chooser.setFileFilter(new FileFilter(){

                @Override
                public boolean accept(File file) {
                    if (file.isDirectory()) {
                        return true;
                    }
                    if (file.isHidden()) {
                        return false;
                    }
                    String path = file.getAbsolutePath();
                    String ext = path.substring(path.lastIndexOf(".") + 1);
                    return ext.equalsIgnoreCase("txt") || ext.equalsIgnoreCase("csv");
                }

                @Override
                public String getDescription() {
                    return Messages.getString("FmeaPanel.64");
                }
            });
            String dbPath = System.getProperty(FmeaTablePanel.PROP_FMEA_DB_PATH);
            File f = dbPath == null ? new File(".") : new File(dbPath);
            chooser.setCurrentDirectory(f);
            int returnVal = chooser.showOpenDialog(SwingUtilities.getWindowAncestor((Component)e.getSource()));
            if (returnVal == 1) {
                return false;
            }
            ArrayList<Msg> msgMng = new ArrayList<Msg>();
            try {
                Vector<String> referenceColumns = new Vector<String>();
                Vector<String> columns = new Vector<String>();
                FmeaTableDefinition tableDef = FmeaTablePanel.this._fmea.getModel().getTableDefinition();
                for (int i = 0; i < tableDef.getColumnCount(); ++i) {
                    FmeaColumnDefinition colDef = tableDef.getColumnDefinition(i);
                    if (colDef.isLinkedToAttribute()) {
                        columns.add(colDef.getName());
                    }
                    if (!(colDef.getColumnType() instanceof FmeaAttributeDefinition.Reference)) continue;
                    referenceColumns.add(colDef.getName());
                }
                File file = chooser.getSelectedFile();
                TabbedTextFileImportDlg dialog = new TabbedTextFileImportDlg((Frame)FmeaTablePanel.this._appli.getTopWindow(), FmeaTablePanel.this._appli.getPlugable(), true);
                boolean b = FmeaTablePanel.this._fmea.getModel().getEntityDefinitions().length == 1;
                dialog.setData(file, columns, referenceColumns, b);
                dialog.setVisible(true);
                if (dialog.canceled()) {
                    return false;
                }
                FmeaTablePanel.this._fmea.importData(dialog.getLines(), dialog.getColumnMatch(), msgMng, dialog.getImportEachLineAsSingleEntity());
                FmeaTablePanel.this._table.getFmeaTableModel().loadFmea();
                FmeaTablePanel.this._table.update();
            }
            catch (OutOfMemoryError ex) {
                ex.printStackTrace();
            }
            if (msgMng.size() > 0) {
                // empty if block
            }
            if (msgMng.size() != 0) {
                Window win = SwingUtilities.getWindowAncestor(FmeaTablePanel.this);
                DlgDisplayMsg dlgError = new DlgDisplayMsg(win);
                dlgError.setMsgs(msgMng);
                dlgError.setModal(true);
                dlgError.setLocationRelativeTo(JOptionCecilia.getTopContainerOf(FmeaTablePanel.this));
                dlgError.setVisible(true);
                dlgError.dispose();
            }
            return true;
        }
    }

    class NewEntityAction
    extends FmeaAction {
        NewEntityAction() {
            super(FmeaTablePanel.newEntityAction);
        }

        @Override
        public boolean doIt(ActionEvent e) {
            int row = -1;
            int col = -1;
            FmeaEntity entity = null;
            if (FmeaTablePanel.this._table.getRowCount() == 0) {
                if (FmeaTablePanel.this._fmea.getModel().getEntityPathLength() != 0) {
                    String entityDefKey = FmeaTablePanel.this._fmea.getModel().getEntityDefinitionFromPath(0).getKey();
                    FmeaColumnDefinition colDef = FmeaTablePanel.this._fmea.getModel().getTableDefinition().getColumnDefinition(entityDefKey, entityDefKey);
                    if (colDef == null) {
                        return false;
                    }
                    col = FmeaTablePanel.this._table.getColumnModel().getColumnIndex(colDef.getName());
                    entity = FmeaTablePanel.this._table.getFmeaTableModel().createEntity(-1, FmeaTablePanel.this._table.convertColumnIndexToModel(col));
                }
                row = 0;
            } else {
                row = FmeaTablePanel.this._table.getSelectedRow();
                col = FmeaTablePanel.this._table.getSelectedColumn();
                if (col < 0 || col >= FmeaTablePanel.this._table.getColumnCount()) {
                    return false;
                }
                entity = FmeaTablePanel.this._table.createEntity(row, col);
            }
            FmeaTablePanel.this._table.update();
            if (entity != null) {
                int modelCol = FmeaTablePanel.this._table.convertColumnIndexToModel(col);
                int mdlRow = FmeaTablePanel.this._table.getFmeaTableModel().getRowForEntity(modelCol, entity.getName());
                row = FmeaTablePanel.this._table.getSorterTableModel().convertRowIndexToView(mdlRow);
                System.out.println(mdlRow + " " + row);
                FmeaTablePanel.this._table.createAllRelations(row, col);
            }
            FmeaTablePanel.this._table.update();
            return true;
        }
    }

    class NewRelationAction
    extends FmeaAction {
        NewRelationAction() {
            super(FmeaTablePanel.newRelationAction);
        }

        @Override
        public boolean doIt(ActionEvent e) {
            int row = FmeaTablePanel.this._table.getSelectedRow();
            int column = FmeaTablePanel.this._table.getSelectedColumn();
            if (column < 0 || column >= FmeaTablePanel.this._table.getColumnCount()) {
                return false;
            }
            FmeaTablePanel.this._table.createRelation(row, column);
            return true;
        }
    }

    class NewRelationsAction
    extends FmeaAction {
        NewRelationsAction() {
            super(FmeaTablePanel.newRelationsAction);
        }

        @Override
        public boolean doIt(ActionEvent e) {
            int row = FmeaTablePanel.this._table.getSelectedRow();
            int column = FmeaTablePanel.this._table.getSelectedColumn();
            if (column < 0 || column >= FmeaTablePanel.this._table.getColumnCount()) {
                return false;
            }
            FmeaTablePanel.this._table.createAllRelations(row, column);
            return true;
        }
    }

    class RemoveEntityAction
    extends FmeaAction {
        RemoveEntityAction() {
            super(FmeaTablePanel.removeEntityAction);
        }

        @Override
        public boolean doIt(ActionEvent e) {
            int row = FmeaTablePanel.this._table.getSelectedRow();
            int column = FmeaTablePanel.this._table.getSelectedColumn();
            if (column < 0 || column >= FmeaTablePanel.this._table.getColumnCount()) {
                return false;
            }
            FmeaTablePanel.this._table.removeEntity(row, column);
            return true;
        }
    }

    class RemoveRelationAction
    extends FmeaAction {
        RemoveRelationAction() {
            super(FmeaTablePanel.removeRelationAction);
        }

        @Override
        public boolean doIt(ActionEvent e) {
            int row = FmeaTablePanel.this._table.getSelectedRow();
            int column = FmeaTablePanel.this._table.getSelectedColumn();
            if (column < 0 || column >= FmeaTablePanel.this._table.getColumnCount()) {
                return false;
            }
            FmeaTablePanel.this._table.removeRelation(row, column);
            return true;
        }
    }

    class MergeAction
    extends FmeaAction {
        MergeAction() {
            super(FmeaTablePanel.mergeAction);
        }

        @Override
        public boolean doIt(ActionEvent e) {
            boolean toggle = FmeaTablePanel.this._table.isGroupCells();
            if (toggle) {
                FmeaTablePanel.this._table.ungroupByColumns();
                FmeaTablePanel.this._table.setGroupCells(!toggle);
            } else {
                FmeaTablePanel.this._table.setGroupCells(!toggle);
                FmeaTablePanel.this._table.sort(FmeaTablePanel.this._fmea.getModel().getSortData());
            }
            this.updateItemStates(!toggle);
            return true;
        }

        private void updateItemStates(boolean state) {
            JToggleButton b;
            JCheckBoxMenuItem mi = (JCheckBoxMenuItem)FmeaTablePanel.this._menubarItems.get(FmeaTablePanel.mergeAction);
            if (mi != null) {
                mi.setSelected(state);
            }
            if ((b = (JToggleButton)FmeaTablePanel.this._toolbarItems.get(FmeaTablePanel.mergeAction)) != null) {
                b.setSelected(state);
            }
        }
    }

    class OpenDictionnaryManagerAction
    extends FmeaAction {
        OpenDictionnaryManagerAction() {
            super(FmeaTablePanel.openDictionnaryManagerAction);
        }

        @Override
        public boolean doIt(ActionEvent e) {
            DictionnaryManager dicoMgr = FmeaTablePanel.this._fmea.getModel().getDicoMgr();
            FmeaTablePanel.this._dicoMgrDlg.setDictionnaries(dicoMgr.getDictionnaries());
            FmeaTablePanel.this._dicoMgrDlg.setWriteAccess(false);
            FmeaTablePanel.this._dicoMgrDlg.setVisible(true);
            return true;
        }
    }

    public abstract class FmeaAction
    extends AbstractAction {
        private String _key;

        public FmeaAction(String key) {
            super(key);
            this._key = key;
        }

        public String getKey() {
            return this._key;
        }

        public void updateActionStates() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                boolean isEnabled = this.doIt(e);
                if (isEnabled) {
                    this.updateActionStates();
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }

        public boolean doIt(ActionEvent e) {
            return false;
        }
    }

    class StatusBar
    extends JComponent {
        public StatusBar() {
            this.setLayout(new BoxLayout(this, 0));
        }

        @Override
        public void paint(Graphics g) {
            super.paint(g);
        }
    }

    class LocalJToggleButton
    extends JToggleButton {
        private String _key;

        LocalJToggleButton() {
        }

        public String getKey() {
            return this._key;
        }

        public void setKey(String key) {
            this._key = key;
        }

        @Override
        public String getText() {
            String type = FmeaTablePanel.getResourceString(this._key + FmeaTablePanel.typeSuffix);
            if (type != null && type.equals("BUTTON_LABEL")) {
                this.setIconTextGap(0);
                this.setMargin(new Insets(0, 0, 0, 2));
                return super.getText();
            }
            this.setMargin(new Insets(0, 0, 0, 0));
            return null;
        }

        @Override
        public Icon getIcon() {
            ImageIcon emptyBarIcon;
            String type = FmeaTablePanel.getResourceString(this._key + FmeaTablePanel.typeSuffix);
            URL url = FmeaTablePanel.this.getResource("empty_barImage");
            ImageIcon imageIcon = emptyBarIcon = url == null ? null : new ImageIcon(url);
            if (type != null && type.equals("BUTTON_LABEL") && emptyBarIcon != null) {
                return emptyBarIcon;
            }
            return super.getIcon();
        }
    }

    class LocalJButton
    extends JButton {
        private String _key;

        LocalJButton() {
        }

        public String getKey() {
            return this._key;
        }

        public void setKey(String key) {
            this._key = key;
        }

        @Override
        public String getText() {
            String type = FmeaTablePanel.getResourceString(this._key + FmeaTablePanel.typeSuffix);
            if (type != null && type.equals("BUTTON_LABEL")) {
                this.setIconTextGap(0);
                this.setMargin(new Insets(0, 0, 0, 2));
                return super.getText();
            }
            this.setMargin(new Insets(0, 0, 0, 0));
            return null;
        }

        @Override
        public Icon getIcon() {
            ImageIcon emptyBarIcon;
            String type = FmeaTablePanel.getResourceString(this._key + FmeaTablePanel.typeSuffix);
            URL url = FmeaTablePanel.this.getResource("empty_barImage");
            ImageIcon imageIcon = emptyBarIcon = url == null ? null : new ImageIcon(url);
            if (type != null && type.equals("BUTTON_LABEL") && emptyBarIcon != null) {
                return emptyBarIcon;
            }
            return super.getIcon();
        }
    }

    private static interface ActionChangedListener {
        public void actionChanged(String var1, FmeaAction var2, FmeaAction var3);
    }
}

