/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.dbobj.fmea.ihm;

import com.dassault.cecilia.dbobj.fmea.ihm.FmeaTable;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;
import javax.swing.CellRendererPane;
import javax.swing.JTable;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class FmeaTableRenderer {
    private JTable _table;
    private int _firstRow = -1;
    private int _lastRow = -1;
    protected CellRendererPane rendererPane;

    FmeaTableRenderer(JTable table, int firstRow, int lastRow) {
        this._table = table;
        this._firstRow = firstRow;
        this._lastRow = lastRow;
        this.rendererPane = new CellRendererPane();
        table.add(this.rendererPane);
    }

    public void paint(Graphics g) {
        this.paintTableHeader(g);
        g.translate(0, this._table.getTableHeader().getHeight());
        this.paintTable(g);
        g.translate(0, -this._table.getTableHeader().getHeight());
    }

    private void paintTableHeader(Graphics g) {
        JTableHeader header = this._table.getTableHeader();
        header.paint(g);
        int h = header.getHeight();
        g.drawLine(0, 0, 0, h);
    }

    private void paintTable(Graphics g) {
        if (this._table.getRowCount() <= 0 || this._table.getColumnCount() <= 0) {
            return;
        }
        int rMin = this._firstRow;
        int rMax = this._lastRow;
        boolean ltr = this._table.getComponentOrientation().isLeftToRight();
        int cMin = ltr ? 0 : this._table.getColumnCount() - 1;
        int cMax = ltr ? this._table.getColumnCount() - 1 : 0;
        Rectangle cell = this._table.getCellRect(rMin, cMin, true);
        g.translate(0, -cell.y);
        this.paintGrid(g, rMin, rMax, cMin, cMax);
        this.paintCells(g, rMin, rMax, cMin, cMax);
        g.translate(0, cell.y);
    }

    private void paintGrid(Graphics g, int rMin, int rMax, int cMin, int cMax) {
        g.setColor(this._table.getGridColor());
        Rectangle minCell = this._table.getCellRect(rMin, cMin, true);
        Rectangle maxCell = this._table.getCellRect(rMax, cMax, true);
        Rectangle area = minCell.union(maxCell);
        if (this._table.getShowHorizontalLines()) {
            int tableWidth = area.x + area.width;
            int y = area.y;
            if (this._table instanceof FmeaTable && ((FmeaTable)this._table).getShowLinesByGroup()) {
                for (row = rMin; row <= rMax; ++row) {
                    y += this._table.getRowHeight(row);
                    for (int col = cMin; col <= cMax; ++col) {
                        Rectangle cell;
                        if (((FmeaTable)this._table).isCellFusioned(row, col)) {
                            cell = ((FmeaTable)this._table).getFusionedCellRect(row, col, true);
                            g.drawLine(cell.x, y - 1, cell.x + cell.width - 1, y - 1);
                            continue;
                        }
                        cell = this._table.getCellRect(row, col, true);
                        g.drawLine(cell.x, y - 1, cell.x + cell.width - 1, y - 1);
                    }
                }
            } else {
                for (row = rMin; row <= rMax; ++row) {
                    g.drawLine(area.x, (y += this._table.getRowHeight(row)) - 1, tableWidth - 1, y - 1);
                }
            }
        }
        if (this._table.getShowVerticalLines()) {
            TableColumnModel cm = this._table.getColumnModel();
            int tableHeight = area.y + area.height;
            if (this._table.getComponentOrientation().isLeftToRight()) {
                x = area.x;
                g.drawLine(x, area.y, x, tableHeight - 1);
                for (column = cMin; column <= cMax; ++column) {
                    int w = cm.getColumn(column).getWidth();
                    g.drawLine((x += w) - 1, area.y, x - 1, tableHeight - 1);
                }
            } else {
                x = area.x + area.width;
                g.drawLine(x, area.y, x, tableHeight - 1);
                for (column = cMin; column < cMax; ++column) {
                    int w = cm.getColumn(column).getWidth();
                    g.drawLine((x -= w) - 1, area.y, x - 1, tableHeight - 1);
                }
                g.drawLine(x -= cm.getColumn(cMax).getWidth(), area.y, x, tableHeight - 1);
            }
        }
    }

    private void paintCells(Graphics g, int rMin, int rMax, int cMin, int cMax) {
        TableColumnModel cm = this._table.getColumnModel();
        int columnMargin = cm.getColumnMargin();
        if (this._table.getComponentOrientation().isLeftToRight()) {
            for (int row = rMin; row <= rMax; ++row) {
                Rectangle cellRect = this._table.getCellRect(row, cMin, false);
                for (int column = cMin; column <= cMax; ++column) {
                    TableColumn aColumn = cm.getColumn(column);
                    int columnWidth = aColumn.getWidth();
                    cellRect.width = columnWidth - columnMargin;
                    this.paintCell(g, cellRect, row, column);
                    cellRect.x += columnWidth;
                }
            }
        } else {
            for (int row = rMin; row <= rMax; ++row) {
                Rectangle cellRect = this._table.getCellRect(row, cMin, false);
                TableColumn aColumn = cm.getColumn(cMin);
                int columnWidth = aColumn.getWidth();
                cellRect.width = columnWidth - columnMargin;
                this.paintCell(g, cellRect, row, cMin);
                for (int column = cMin + 1; column <= cMax; ++column) {
                    aColumn = cm.getColumn(column);
                    columnWidth = aColumn.getWidth();
                    cellRect.width = columnWidth - columnMargin;
                    cellRect.x -= columnWidth;
                }
            }
        }
        this.rendererPane.removeAll();
    }

    private void paintCell(Graphics g, Rectangle cellRect, int row, int column) {
        Rectangle fusionedRect;
        TableCellRenderer renderer = this._table.getCellRenderer(row, column);
        Component component = this._table.prepareRenderer(renderer, row, column);
        if (this._table instanceof FmeaTable && (fusionedRect = ((FmeaTable)this._table).getFusionedCellRect(row, column, false)) != null) {
            cellRect = fusionedRect;
        }
        this.rendererPane.paintComponent(g, component, this._table, cellRect.x, cellRect.y, cellRect.width, cellRect.height, true);
    }
}

