/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.dbobj.fmea.ihm;

import com.dassault.cecilia.dbobj.fmea.Messages;
import com.dassault.cecilia.dbobj.fmea.ihm.FmeaTable;
import com.dassault.cecilia.dbobj.fmea.ihm.Head;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.print.PageFormat;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.border.BevelBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;

public class PrintPreviewPage
extends JPanel {
    private boolean _initDone = false;
    private Head _head;
    private FmeaTable _table;
    private JScrollPane _scpane;
    private PageFormat _pf;
    private Map<Integer, Integer> _pageInfos = new TreeMap<Integer, Integer>();
    int _page = 1;
    private int svTableAutoResizeMode;
    private boolean svTableReorderingAllowed;
    private boolean svTableResizingAllowed;
    private TableCellRenderer svHeaderCellRenderer;
    private int[] svTableRowHeight;
    private int svTableHeaderHeight;
    private int svTableRowMargin;
    private int svTableColumnMargin;
    private Font svTableFont;
    private Color svTableBackground;
    private Color svTableForeground;

    public PrintPreviewPage(Head head, FmeaTable table, PageFormat pf, boolean initDone) {
        super(new GridBagLayout(), true);
        this._head = head;
        this._table = table;
        this._pf = pf;
        this._initDone = initDone;
        BevelBorder b = new BevelBorder(0);
        this.setBorder(b);
        this.setBackground(Color.white);
        this.add((Component)this._head, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this._scpane = new JScrollPane();
        this._scpane.setPreferredSize(new Dimension(0, 0));
        this._scpane.setHorizontalScrollBarPolicy(31);
        this._scpane.setVerticalScrollBarPolicy(21);
        this._scpane.setBorder(new EmptyBorder(0, 0, 0, 0));
        this._scpane.setBackground(Color.white);
        this._scpane.getViewport().setBackground(Color.white);
        this._scpane.setViewportView(table);
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        constraints.fill = 1;
        this.add((Component)this._scpane, constraints);
        this.addComponentListener(new ComponentListener(){

            @Override
            public void componentResized(ComponentEvent e) {
                PrintPreviewPage.this.adjustBottomMargin();
            }

            @Override
            public void componentMoved(ComponentEvent e) {
            }

            @Override
            public void componentShown(ComponentEvent e) {
            }

            @Override
            public void componentHidden(ComponentEvent e) {
            }
        });
    }

    @Override
    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this._initDone = true;
            this._scpane.setViewportView(this._table);
            this.storeProperties();
            this.setFormat(this._pf);
            this._head.refresh();
            this._head.setEnabled(false);
            this._table.setEnabled(false);
            this._table.getTableHeader().setEnabled(false);
            this._scpane.setEnabled(false);
        } else {
            if (this._initDone) {
                this.restoreProperties();
            }
            this._table.setEnabled(true);
        }
        this.repaint();
    }

    public void setFormat(PageFormat pf) {
        this._pf = pf;
        if (this.isVisible()) {
            Dimension d = new Dimension((int)pf.getWidth(), (int)pf.getHeight());
            this.setPreferredSize(d);
            Insets margins = new Insets(0, 0, 0, 0);
            margins.top = (int)pf.getImageableY();
            margins.left = (int)pf.getImageableX();
            margins.bottom = 0;
            margins.right = (int)pf.getWidth() - (int)pf.getImageableWidth() - (int)pf.getImageableX();
            GridBagConstraints constraints = ((GridBagLayout)this.getLayout()).getConstraints(this._head);
            constraints.insets = margins;
            ((GridBagLayout)this.getLayout()).setConstraints(this._head, constraints);
            margins.top = 0;
            margins.left = (int)pf.getImageableX() + 1;
            margins.bottom = (int)pf.getHeight() - (int)pf.getImageableHeight() - (int)pf.getImageableY();
            margins.right = (int)pf.getWidth() - (int)pf.getImageableWidth() - (int)pf.getImageableX();
            constraints = ((GridBagLayout)this.getLayout()).getConstraints(this._scpane);
            constraints.insets = margins;
            ((GridBagLayout)this.getLayout()).setConstraints(this._scpane, constraints);
            this.restoreProperties();
            this.storeProperties();
            this.doLayout();
            this.validate();
            this.invalidate();
            this.repaint();
            this.resizeComponents();
            this.doLayout();
            this.validate();
            this.invalidate();
        }
    }

    public int getPage() {
        return this._page;
    }

    public void setPage(int page) {
        this._page = page;
        int height = 0;
        int rowMax = this._pageInfos.size() == 0 ? 0 : this._pageInfos.get(this._page);
        for (int row = 0; row < rowMax; ++row) {
            height += this._table.getRowHeight(row);
        }
        this._scpane.getViewport().setViewPosition(new Point(0, height));
        this.computePageInfos();
        this.adjustBottomMargin();
        this.repaint();
    }

    public int getPageCount() {
        return this._pageInfos.size();
    }

    public void computePageInfos() {
        this._pageInfos.clear();
        int offset = (int)(this._head.getPreferredSize().getHeight() + this._table.getTableHeader().getPreferredSize().getHeight());
        int availableHeight = (int)this._pf.getImageableHeight() - offset;
        int pgCount = 0;
        int row = 0;
        while (row < this._table.getRowCount()) {
            int height;
            this._pageInfos.put(++pgCount, row);
            if (height > availableHeight) {
                throw new RuntimeException(Messages.getString("PrintPreviewPage.0") + " PrintPreviewPage.computePageInfos()");
            }
            for (height = this._table.getRowHeight(row); row < this._table.getRowCount() && height < availableHeight; height += this._table.getRowHeight(++row)) {
            }
        }
    }

    public int getTableHeightOnPage() {
        if (this._pageInfos == null || this._pageInfos.size() == 0) {
            return 0;
        }
        int firstRow = this._pageInfos.get(this._page);
        int lastRow = this._page == this._pageInfos.size() ? this._table.getRowCount() : this._pageInfos.get(this._page + 1).intValue();
        int height = 0;
        for (int row = firstRow; row < lastRow; ++row) {
            height += this._table.getRowHeight(row);
        }
        return height;
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        Rectangle rect = this._scpane.getBounds();
        int tableHeight = this.getTableHeightOnPage();
        int y = rect.y + (int)this._table.getTableHeader().getPreferredSize().getHeight() + tableHeight - 1;
        g.drawLine(rect.x - 1, rect.y, rect.x - 1, y);
    }

    protected void storeProperties() {
        this.svTableAutoResizeMode = this._table.getAutoResizeMode();
        this._table.setAutoResizeMode(4);
        this.svTableReorderingAllowed = this._table.getTableHeader().getReorderingAllowed();
        this._table.getTableHeader().setReorderingAllowed(false);
        this.svTableResizingAllowed = this._table.getTableHeader().getResizingAllowed();
        this._table.getTableHeader().setResizingAllowed(false);
        this.svTableBackground = this._table.getBackground();
        this.svTableForeground = this._table.getForeground();
        this._table.setBackground(Color.white);
        this._table.setForeground(Color.black);
        MyTableHeaderRenderer renderer = new MyTableHeaderRenderer();
        JTableHeader tableHeader = this._table.getTableHeader();
        TableColumnModel cm = tableHeader.getColumnModel();
        if (cm.getColumnCount() > 0) {
            this.svHeaderCellRenderer = cm.getColumn(0).getHeaderRenderer();
        }
        for (int col = 0; col < cm.getColumnCount(); ++col) {
            cm.getColumn(col).setHeaderRenderer(renderer);
        }
        this._table.uninstallListeners();
        this._table.setSortEnabled(false);
        this.svTableFont = this._table.getFont();
        this.svTableRowHeight = new int[this._table.getRowCount()];
        for (int row = 0; row < this._table.getRowCount(); ++row) {
            this.svTableRowHeight[row] = this._table.getRowHeight(row);
        }
        this.svTableHeaderHeight = tableHeader.getPreferredSize().height;
        this.svTableRowMargin = this._table.getRowMargin();
        this._table.setRowMargin(3);
        this.svTableColumnMargin = this._table.getColumnModel().getColumnMargin();
        this._table.getColumnModel().setColumnMargin(3);
        this._head.storeProperties();
    }

    protected void restoreProperties() {
        this._table.setAutoResizeMode(this.svTableAutoResizeMode);
        this._table.getTableHeader().setReorderingAllowed(this.svTableReorderingAllowed);
        this._table.getTableHeader().setResizingAllowed(this.svTableResizingAllowed);
        this._table.setBackground(this.svTableBackground);
        this._table.setForeground(this.svTableForeground);
        TableColumnModel cm = this._table.getColumnModel();
        for (int col = 0; col < cm.getColumnCount(); ++col) {
            cm.getColumn(col).setHeaderRenderer(this.svHeaderCellRenderer);
        }
        this._table.installListeners();
        this._table.setSortEnabled(true);
        this._table.setFont(this.svTableFont);
        for (int row = 0; row < this.svTableRowHeight.length; ++row) {
            this._table.setRowHeight(row, this.svTableRowHeight[row]);
        }
        JTableHeader tHeader = this._table.getTableHeader();
        Dimension d = tHeader.getPreferredSize();
        tHeader.setPreferredSize(new Dimension(d.width, this.svTableHeaderHeight));
        this._table.setRowMargin(this.svTableRowMargin);
        this._table.getColumnModel().setColumnMargin(this.svTableColumnMargin);
        this._head.restoreProperties();
    }

    protected void resizeComponents() {
        this._table.validate();
        this._table.initRowHeights();
        this.computePageInfos();
        this.adjustBottomMargin();
    }

    protected void adjustBottomMargin() {
        int tableHeight = this.getTableHeightOnPage();
        this.doLayout();
        Rectangle rect = this._scpane.getBounds();
        int height = (int)((double)rect.y + this._table.getTableHeader().getPreferredSize().getHeight() + (double)tableHeight);
        GridBagConstraints constraints = ((GridBagLayout)this.getLayout()).getConstraints(this._scpane);
        constraints.insets.bottom = (int)(this._pf.getHeight() - (double)height - 2.0);
        ((GridBagLayout)this.getLayout()).setConstraints(this._scpane, constraints);
        this.validate();
    }

    public class MyTableHeaderRenderer
    extends DefaultTableCellRenderer {
        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            JComponent component = (JComponent)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            component.setBorder(new LineBorder(Color.black){

                @Override
                public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
                    Color oldColor = g.getColor();
                    g.setColor(this.lineColor);
                    for (int i = 0; i < this.thickness; ++i) {
                        g.drawLine(x + i, y + i, x + width - i - 1, y + i);
                        g.drawLine(x + i, y + height - i - 1, x + width - i - 1, y + height - i - 1);
                        g.drawLine(x + width - i - 1, y + i, x + width - i - 1, y + height - i - 1);
                    }
                    g.setColor(oldColor);
                }
            });
            return component;
        }
    }
}

