/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.dbobj.fmea.ihm.dialog;

import com.dassault.cecilia.core.swing.JOptionCecilia;
import com.dassault.cecilia.db.DBFolder;
import com.dassault.cecilia.dbobj.fmea.DBTableFMEA;
import com.dassault.cecilia.dbobj.fmea.Messages;
import com.dassault.cecilia.dbobj.fmea.ihm.dialog.ExternalFmeaReferenceUtility;
import com.dassault.cecilia.dbobj.fmea.model.ExternalFmeaReference;
import com.dassault.cecilia.dbobj.fmea.model.ExternalFmeaReferenceTableModel;
import com.dassault.cecilia.main.cecilia.CeciliaAppl;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.HeadlessException;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableColumn;

public class ExternalFmeaReferencePanel
extends JDialog {
    private boolean _canceled = true;
    private ExternalFmeaReferenceTableModel _dataModel = new ExternalFmeaReferenceTableModel();
    private JTable _table = new JTable(this._dataModel);
    private JScrollPane _scrollpane = new JScrollPane(this._table);
    private JButton _bAdd = new JButton(Messages.getString("ExternalFmeaReferencePanel.3"));
    private JButton _bEdit = new JButton(Messages.getString("ExternalFmeaReferencePanel.4"));
    private JButton _bRemove = new JButton(Messages.getString("ExternalFmeaReferencePanel.5"));
    private JButton _bOk = new JButton(Messages.getString("ExternalFmeaReferencePanel.6"));
    private JButton _bCancel = new JButton(Messages.getString("ExternalFmeaReferencePanel.7"));
    DBFolder _dbFolder;
    CeciliaAppl _application;

    public ExternalFmeaReferencePanel(Frame owner, String title) throws HeadlessException {
        super(owner, title, true);
        this.setModal(true);
        this.updateComponentStates();
        JPanel tPanel = new JPanel();
        tPanel.setLayout(new GridBagLayout());
        tPanel.add((Component)this._scrollpane, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        JPanel bPanel = new JPanel(new GridBagLayout());
        bPanel.add((Component)this._bAdd, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        bPanel.add((Component)this._bEdit, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        bPanel.add((Component)this._bRemove, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        bPanel.add((Component)this._bOk, new GridBagConstraints(0, 5, 1, 1, 0.0, 0.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        bPanel.add((Component)this._bCancel, new GridBagConstraints(0, 6, 1, 1, 0.0, 0.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        JPanel panel = new JPanel();
        panel.setLayout(new GridBagLayout());
        panel.add((Component)tPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        panel.add((Component)bPanel, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this._table.getTableHeader().setReorderingAllowed(false);
        this._table.setPreferredScrollableViewportSize(new Dimension(500, 200));
        this._table.setAutoResizeMode(0);
        this.getContentPane().add(panel);
        this.defineListeners();
        this.pack();
        this.setLocationRelativeTo(JOptionCecilia.getTopContainerOf(owner));
    }

    public void setSource(DBFolder dbFolder) {
        this._dbFolder = dbFolder;
    }

    public void setApplication(CeciliaAppl appl) {
        this._application = appl;
    }

    public void setReferences(Collection<ExternalFmeaReference> references) {
        ArrayList<ExternalFmeaReference> lst = new ArrayList<ExternalFmeaReference>(references);
        this._dataModel.setReferences(lst);
        this.updateComponentStates();
        this.resizeTableToContent(this._table);
    }

    public Collection<ExternalFmeaReference> getReferences() {
        return new ArrayList<ExternalFmeaReference>(this._dataModel.getReferences());
    }

    public boolean canceled() {
        return this._canceled;
    }

    public void updateComponentStates() {
        int count = this._table.getSelectedRowCount();
        this._bAdd.setEnabled(true);
        this._bEdit.setEnabled(count != 0);
        this._bRemove.setEnabled(count != 0);
        this._bOk.setEnabled(this._table.getRowCount() != 0);
    }

    protected void defineListeners() {
        this._bAdd.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ExternalFmeaReferencePanel.this.doAddExternalFmeaReference();
            }
        });
        this._bEdit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ExternalFmeaReferencePanel.this.doEditExternalFmeaReference();
            }
        });
        this._bRemove.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ExternalFmeaReferencePanel.this.doRemoveExternalFmeaReferences();
            }
        });
        this._bOk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ExternalFmeaReferencePanel.this._canceled = false;
                ExternalFmeaReferencePanel.this.setVisible(false);
                ExternalFmeaReferencePanel.this.dispose();
            }
        });
        this._bCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ExternalFmeaReferencePanel.this._canceled = true;
                ExternalFmeaReferencePanel.this.setVisible(false);
                ExternalFmeaReferencePanel.this.dispose();
            }
        });
        this._table.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                ExternalFmeaReferencePanel.this.updateComponentStates();
            }
        });
        this._table.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (SwingUtilities.isLeftMouseButton(e) && e.getClickCount() == 2) {
                    ExternalFmeaReferencePanel.this.doEditExternalFmeaReference();
                }
            }
        });
    }

    void doAddExternalFmeaReference() {
        DBTableFMEA dbFMEA;
        ExternalFmeaReference ref = null;
        if (this._table.getRowCount() != 0) {
            ref = this._table.getSelectedRowCount() == 1 ? this._dataModel.getReference(this._table.getSelectedRow()) : this._dataModel.getReference(0);
        }
        ExternalFmeaReferenceUtility util = new ExternalFmeaReferenceUtility();
        util.setApplication(this._application).setFolderExclude(this._dbFolder);
        if (ref != null) {
            util.setFolderSelect(ref.getDBFolder());
        }
        if ((dbFMEA = util.selectFMEA(this)) == null) {
            return;
        }
        List<ExternalFmeaReference> selecteds = util.selectReferencies(false, dbFMEA, new ExternalFmeaReference[0]);
        if (selecteds == null) {
            return;
        }
        this._dataModel.addReferences(selecteds);
        this.updateComponentStates();
        this.resizeTableToContent(this._table);
    }

    void doEditExternalFmeaReference() {
        if (this._table.getSelectedRowCount() != 1) {
            return;
        }
        int row = this._table.getSelectedRow();
        ExternalFmeaReference ref = this._dataModel.getReference(row);
        if (ref.getDBFolder().getID() == -1L) {
            return;
        }
        ExternalFmeaReferenceUtility util = new ExternalFmeaReferenceUtility();
        util.setApplication(this._application).setFolderExclude(this._dbFolder);
        util.setFolderSelect(ref.getDBFolder());
        DBTableFMEA dbFMEA = util.selectFMEA(this);
        if (dbFMEA == null) {
            return;
        }
        List<ExternalFmeaReference> selecteds = util.selectReferencies(true, dbFMEA, ref);
        if (selecteds == null || selecteds.size() == 0) {
            return;
        }
        this._dataModel.modifyExternalFmeaReference(row, selecteds.get(0));
    }

    private void doRemoveExternalFmeaReferences() {
        if (this._table.getSelectedRowCount() == 0) {
            return;
        }
        this._dataModel.removeReferences(this._table.getSelectedRows());
        this.updateComponentStates();
        this.resizeTableToContent(this._table);
    }

    private void resizeTableToContent(JTable table) {
        FontMetrics fm = table.getFontMetrics(table.getFont());
        for (int col = 0; col < table.getColumnCount(); ++col) {
            TableColumn tableCol = table.getColumnModel().getColumn(col);
            int w = fm.stringWidth(tableCol.getHeaderValue().toString()) + 20;
            if (table.getRowCount() <= 0) continue;
            for (int row = 0; row < table.getRowCount(); ++row) {
                Object cell = table.getValueAt(row, col);
                w = Math.max(w, fm.stringWidth(cell.toString()) + 10);
            }
            tableCol.setPreferredWidth(w);
        }
    }
}

