/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.dbobj.fmea.ihm.dialog;

import com.dassault.cecilia.core.ResMsgVoc;
import com.dassault.cecilia.core.cecilia.dependencies.Generate;
import com.dassault.cecilia.core.cecilia.dependencies.GenerateDepFolders;
import com.dassault.cecilia.db.DBFolder;
import com.dassault.cecilia.dbobj.fmea.DBTableFMEA;
import com.dassault.cecilia.dbobj.fmea.ihm.FmeaTable;
import com.dassault.cecilia.dbobj.fmea.ihm.dialog.FmeaTableDataSelection;
import com.dassault.cecilia.dbobj.fmea.model.ExternalFmeaReference;
import com.dassault.cecilia.dbobj.fmea.model.Fmea;
import com.dassault.cecilia.dbobj.fmea.model.FmeaAttributeDefinition;
import com.dassault.cecilia.dbobj.fmea.model.FmeaColumnDefinition;
import com.dassault.cecilia.dbobj.fmea.model.FmeaEntity;
import com.dassault.cecilia.dbobj.fmea.model.FmeaEntityDefinition;
import com.dassault.cecilia.dbobj.fmea.model.FmeaTableModel;
import com.dassault.cecilia.dbobj.fmea.model.SortData;
import com.dassault.cecilia.dbobj.project.gui.DBObjectProjectDlgChooser;
import com.dassault.cecilia.dbobj.wrap.DBWrap;
import com.dassault.cecilia.main.cecilia.CeciliaAppl;
import java.awt.Window;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class ExternalFmeaReferenceUtility {
    DBFolder _dbFolderExclude;
    CeciliaAppl _application;
    DBFolder _dbFolderSelect;
    private DBObjectProjectDlgChooser _dbTableFMEAChooser = null;
    private Object _LockerDlgChooser = new Object();

    public ExternalFmeaReferenceUtility setFolderExclude(DBFolder dbFolder) {
        this._dbFolderExclude = dbFolder;
        return this;
    }

    public ExternalFmeaReferenceUtility setApplication(CeciliaAppl application) {
        this._application = application;
        return this;
    }

    public ExternalFmeaReferenceUtility setFolderSelect(DBFolder dbFolder) {
        this._dbFolderSelect = dbFolder;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    DBObjectProjectDlgChooser getDlgChooser(Window win, CeciliaAppl appl) {
        if (this._dbTableFMEAChooser == null) {
            DBObjectProjectDlgChooser dlg = null;
            Object object = this._LockerDlgChooser;
            synchronized (object) {
                if (this._dbTableFMEAChooser == null) {
                    dlg = new DBObjectProjectDlgChooser(win, appl, ResMsgVoc.getString("VOC_FMEA")){

                        @Override
                        protected short getDefaultFamilyFlag() {
                            return 4;
                        }
                    };
                    dlg.getCtrlSelect().resetCache();
                }
                if (this._dbTableFMEAChooser == null) {
                    this._dbTableFMEAChooser = dlg;
                }
            }
        }
        if (this._dbFolderSelect != null) {
            GenerateDepFolders depsFolder = new GenerateDepFolders(appl.getDAOFactory()){

                @Override
                protected boolean dontTreatThisFamily(DBFolder.Family family) {
                    return family != DBFolder.Family.PROJECT;
                }
            };
            depsFolder.setDirection(Generate.Direction.UP);
            depsFolder.prepare(this._dbFolderSelect, this._dbFolderSelect, null);
            Set<DBFolder> dependFolders = depsFolder.getDepends(false);
            HashSet<DBFolder> excludeFolders = new HashSet<DBFolder>();
            for (DBFolder dependFolder : dependFolders) {
                if (dependFolder.equals(this._dbFolderSelect)) continue;
                if (dependFolder.isVersion()) {
                    excludeFolders.add(dependFolder.getParent());
                    List<DBFolder> children = dependFolder.getParent().getChildren();
                    if (children == null) {
                        children = appl.getDAOFactory().createFolderDAO().findChildren(dependFolder.getParent());
                    }
                    for (DBFolder dbChild : children) {
                        excludeFolders.add(dbChild);
                    }
                    continue;
                }
                excludeFolders.add(dependFolder);
            }
            this._dbTableFMEAChooser.defineExcludeFolders(excludeFolders);
        }
        return this._dbTableFMEAChooser;
    }

    public DBTableFMEA selectFMEA(Window win) {
        DBObjectProjectDlgChooser dlg = this.getDlgChooser(win, this._application);
        if (this._dbFolderSelect != null) {
            dlg.setSelectFolder(this._dbFolderSelect);
        }
        dlg.setVisible(true);
        if (!dlg.getResult()) {
            return null;
        }
        DBFolder dbFolder = dlg.getSelectFolder();
        if (dbFolder == null) {
            return null;
        }
        DBWrap dbWrap = this._application.getDAOFactory().findOrCreateWrap(dbFolder);
        if (dbWrap == null) {
            return null;
        }
        return (DBTableFMEA)dbWrap;
    }

    public List<ExternalFmeaReference> selectReferencies(boolean forEdition, DBTableFMEA dbFMEA, ExternalFmeaReference ... refs) {
        ArrayList<ExternalFmeaReference> references = new ArrayList<ExternalFmeaReference>();
        for (int i = 0; i < refs.length; ++i) {
            if (refs[i] == null) continue;
            references.add(refs[i]);
        }
        return this.selectReferencies(forEdition, dbFMEA, references);
    }

    public List<ExternalFmeaReference> selectReferencies(boolean forEdition, DBTableFMEA dbFMEA, List<ExternalFmeaReference> references) {
        ExternalFmeaReference ref = references.size() == 0 ? null : references.get(0);
        FmeaTableDataSelection sel = new FmeaTableDataSelection(ref);
        sel.setForEdition(forEdition);
        FmeaTable itable = sel.open(dbFMEA, this._application);
        ArrayList<ExternalFmeaReference> selecteds = new ArrayList<ExternalFmeaReference>();
        if (itable != null) {
            FmeaTable rtable = itable;
            int col = rtable.getSelectedColumn();
            for (int i = 0; i < rtable.getSelectedRowCount(); ++i) {
                int row = rtable.getSelectedRows()[i];
                int modelRow = rtable.convertRowIndexToFmeaModel(row);
                int modelCol = rtable.convertColumnIndexToModel(col);
                FmeaTableModel model = rtable.getFmeaTableModel();
                FmeaColumnDefinition colDef = model.getColumnDefinition(modelCol);
                FmeaEntityDefinition entDef = colDef.getEntityDefinition();
                FmeaAttributeDefinition attDef = colDef.getAttributeDefinition();
                FmeaEntity entity = model.getEntityAt(modelRow, colDef);
                ExternalFmeaReference reference = new ExternalFmeaReference(dbFMEA.getDBFolder(), entDef.getKey(), entDef.getName(), entity.getName(), attDef.getKey(), attDef.getName(), model.getValueAt(modelRow, modelCol));
                selecteds.add(reference);
                Fmea fmea = rtable.getFmeaTableModel().getFmea();
                SortData sortData = fmea.getModel().getSortData();
                if (sortData == null) continue;
                for (int colInd = 0; colInd < sortData.getColumnCount(); ++colInd) {
                    FmeaColumnDefinition column = sortData.getColumnDefinition(colInd);
                    String key = column.getKey();
                    String name = column.getName();
                    int pos = fmea.getModel().getTableDefinition().getColumnPosition(column);
                    Object value = "";
                    if (pos != -1) {
                        value = model.getValueAt(modelRow, pos);
                        Object object = value = value == null ? "" : value;
                    }
                    if (key.equals(entDef.getKey()) || key.equals(attDef.getKey())) continue;
                    reference.addColumn(key, name, value.toString());
                }
            }
        }
        return selecteds;
    }
}

