/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.dbobj.fmea.ihm.modeldefinition;

import com.dassault.cecilia.core.swing.JOptionCecilia;
import com.dassault.cecilia.dbobj.fmea.ihm.modeldefinition.EditDialog;
import com.dassault.cecilia.dbobj.fmea.ihm.modeldefinition.FmeaModelDefinitionPanel;
import com.dassault.cecilia.dbobj.fmea.ihm.modeldefinition.Messages;
import com.dassault.cecilia.dbobj.fmea.model.FmeaAttributeDefinition;
import com.dassault.cecilia.dbobj.fmea.model.FmeaEntityDefinition;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;

class EntityDefinitionPanel
extends JPanel {
    private final FmeaModelDefinitionPanel _definitionPanel;
    private EntityTableModel _tEntityModel;
    private JTable _table;
    private JScrollPane _scpane;
    private JButton _bAdd = new JButton(Messages.getString("EntityDefinitionPanel.1"));
    private JButton _bModify = new JButton(Messages.getString("EntityDefinitionPanel.2"));
    private JButton _bRemove = new JButton(Messages.getString("EntityDefinitionPanel.3"));
    private boolean _enabled = true;

    EntityDefinitionPanel(FmeaModelDefinitionPanel panel) {
        super(new GridBagLayout());
        this._definitionPanel = panel;
        this._tEntityModel = new EntityTableModel();
        this._table = new JTable(this._tEntityModel){

            @Override
            public boolean isCellEditable(int row, int col) {
                return EntityDefinitionPanel.this._enabled && super.isCellEditable(row, col);
            }
        };
        this._scpane = new JScrollPane(this._table);
        this._table.setPreferredScrollableViewportSize(new Dimension(150, 150));
        this._table.getTableHeader().setReorderingAllowed(false);
        JPanel bPanel = new JPanel(new GridBagLayout());
        bPanel.add((Component)this._bAdd, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 2, new Insets(5, 5, 5, 5), 0, 0));
        bPanel.add((Component)this._bModify, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 13, 2, new Insets(5, 5, 5, 5), 0, 0));
        bPanel.add((Component)this._bRemove, new GridBagConstraints(0, 2, 1, 1, 0.0, 1.0, 11, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)this._scpane, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)bPanel, new GridBagConstraints(1, 0, 1, 1, 0.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        this._bAdd.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FmeaEntityDefinition entityDef = new FmeaEntityDefinition(null);
                boolean create = EntityDefinitionPanel.this.editEntityDefinition(Messages.getString("EntityDefinitionPanel.4"), entityDef);
                if (create) {
                    EntityDefinitionPanel.this._definitionPanel._fmea.addEntityDefinition(entityDef);
                    EntityDefinitionPanel.this._definitionPanel.getEntityPathPanel().addEntity(entityDef);
                    EntityDefinitionPanel.this._definitionPanel._entityData = EntityDefinitionPanel.this._definitionPanel._fmea.getModel().getEntityDefinitions();
                    EntityDefinitionPanel.this._tEntityModel.fireTableDataChanged();
                }
            }
        });
        this._bModify.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (EntityDefinitionPanel.this._table.getSelectedRow() == -1) {
                    return;
                }
                FmeaEntityDefinition entityDef = (FmeaEntityDefinition)EntityDefinitionPanel.this._definitionPanel._entityData[EntityDefinitionPanel.this._table.getSelectedRow()];
                FmeaEntityDefinition copy = entityDef.getCopy();
                boolean modified = EntityDefinitionPanel.this.editEntityDefinition(Messages.getString("EntityDefinitionPanel.5"), copy);
                if (modified) {
                    entityDef.copy(copy);
                    EntityDefinitionPanel.this._tEntityModel.fireTableDataChanged();
                }
            }
        });
        this._bRemove.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EntityDefinitionPanel.this._tEntityModel.removeRows(EntityDefinitionPanel.this._table.getSelectedRows());
            }
        });
        this._table.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                EntityDefinitionPanel.this.updateButtonStates();
            }
        });
        this._table.getModel().addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent e) {
                EntityDefinitionPanel.this._definitionPanel.getRelationPanel().updateButtonStates();
                EntityDefinitionPanel.this._definitionPanel.getFmeaTablePanel().updateButtonStates();
            }
        });
    }

    private void updateButtonStates() {
        this._bAdd.setEnabled(this._enabled);
        this._bModify.setEnabled(this._enabled && this._table.getSelectedRowCount() == 1);
        this._bRemove.setEnabled(this._enabled && this._table.getSelectedRowCount() != 0);
    }

    public void updateContent() {
        this._tEntityModel.fireTableDataChanged();
        this.updateButtonStates();
    }

    public void setPanelEnabled(boolean enabled) {
        this._enabled = enabled;
        this.updateButtonStates();
    }

    public boolean editEntityDefinition(String title, FmeaEntityDefinition entityDef) {
        final EditEntityPanel editPanel = new EditEntityPanel(entityDef);
        Window window = SwingUtilities.getWindowAncestor(this._definitionPanel);
        EditDialog dlg = null;
        dlg = window instanceof Frame ? new EditDialog((Frame)window, title, true, editPanel, 3){

            @Override
            protected boolean closeEnabled() {
                return editPanel.validateFields();
            }
        } : new EditDialog((Dialog)window, title, true, editPanel, 3){

            @Override
            protected boolean closeEnabled() {
                return editPanel.validateFields();
            }
        };
        dlg.setVisible(true);
        dlg.dispose();
        return !dlg.isCanceled();
    }

    private class EntityTableModel
    extends AbstractTableModel {
        private String[] columnNames = new String[]{Messages.getString("EntityDefinitionPanel.6")};

        private EntityTableModel() {
        }

        @Override
        public String getColumnName(int col) {
            return this.columnNames[col];
        }

        @Override
        public int getColumnCount() {
            return this.columnNames.length;
        }

        @Override
        public int getRowCount() {
            return EntityDefinitionPanel.this._definitionPanel._entityData.length;
        }

        public Class getColumnClass(int col) {
            switch (col) {
                case 0: {
                    return String.class;
                }
            }
            return null;
        }

        @Override
        public boolean isCellEditable(int r, int c) {
            return true;
        }

        @Override
        public Object getValueAt(int row, int col) {
            FmeaEntityDefinition def = (FmeaEntityDefinition)EntityDefinitionPanel.this._definitionPanel._entityData[row];
            switch (col) {
                case 0: {
                    return def.getName();
                }
            }
            return null;
        }

        @Override
        public void setValueAt(Object value, int row, int col) {
            FmeaEntityDefinition def = (FmeaEntityDefinition)EntityDefinitionPanel.this._definitionPanel._entityData[row];
            switch (col) {
                case 0: {
                    def.setName(value.toString());
                    super.fireTableDataChanged();
                    break;
                }
            }
        }

        public void removeRows(int[] rows) {
            for (int i = 0; i < rows.length; ++i) {
                String msg;
                FmeaEntityDefinition def = (FmeaEntityDefinition)EntityDefinitionPanel.this._definitionPanel._entityData[rows[i]];
                if (EntityDefinitionPanel.this._definitionPanel._fmea.getModel().existRelationDefinition(def)) {
                    msg = Messages.msgFormat("EntityDefinitionPanel.7", def.getName());
                    JOptionPane.showMessageDialog(JOptionCecilia.getTopContainerOf(EntityDefinitionPanel.this), msg, Messages.getString("ErrorManager.2"), 0);
                    continue;
                }
                if (EntityDefinitionPanel.this._definitionPanel._fmea.getModel().getTableDefinition().existColumnDefinition(def)) {
                    msg = Messages.msgFormat("EntityDefinitionPanel.10", def.getName());
                    JOptionPane.showMessageDialog(JOptionCecilia.getTopContainerOf(EntityDefinitionPanel.this), msg, Messages.getString("ErrorManager.2"), 0);
                    continue;
                }
                EntityDefinitionPanel.this._definitionPanel.getEntityPathPanel().removeEntity(def);
                EntityDefinitionPanel.this._definitionPanel._fmea.removeEntityDefinition(def);
            }
            EntityDefinitionPanel.this._definitionPanel._entityData = EntityDefinitionPanel.this._definitionPanel._fmea.getModel().getEntityDefinitions();
            super.fireTableDataChanged();
        }
    }

    class EditEntityPanel
    extends JPanel {
        private FmeaEntityDefinition entityDefinition;
        private Object[] attributeData;
        private AttributeTableModel tAttributeModel;
        JTable table;
        JScrollPane scpane;
        JPanel pAttributes;
        JLabel label;
        JTextField field;
        TitledBorder border;
        JButton bAdd;
        JButton bModify;
        JButton bRemove;

        public EditEntityPanel(FmeaEntityDefinition entityDef) {
            super(new GridBagLayout());
            this.entityDefinition = null;
            this.attributeData = new Object[0];
            this.tAttributeModel = new AttributeTableModel();
            this.table = new JTable(this.tAttributeModel);
            this.scpane = new JScrollPane(this.table);
            this.pAttributes = new JPanel(new GridBagLayout());
            this.label = new JLabel(Messages.getString("EntityDefinitionPanel.18"));
            this.field = new JTextField(20);
            this.border = new TitledBorder(Messages.getString("EntityDefinitionPanel.19"));
            this.bAdd = new JButton(Messages.getString("EntityDefinitionPanel.1"));
            this.bModify = new JButton(Messages.getString("EntityDefinitionPanel.2"));
            this.bRemove = new JButton(Messages.getString("EntityDefinitionPanel.3"));
            this.entityDefinition = entityDef;
            this.attributeData = this.getAttributeDefinitions();
            this.table.setPreferredScrollableViewportSize(new Dimension(200, 100));
            this.table.setDefaultRenderer(Object.class, new DefaultTableCellRenderer(){

                @Override
                public Component getTableCellRendererComponent(JTable tbl, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                    Component comp = super.getTableCellRendererComponent(tbl, value, isSelected, hasFocus, row, column);
                    if (row != 0) {
                        return this;
                    }
                    comp.setFont(new Font(comp.getFont().getFamily(), 1, comp.getFont().getSize()));
                    return comp;
                }
            });
            this.table.getColumnModel().getColumn(1).setMaxWidth(70);
            this.table.getColumnModel().getColumn(1).setResizable(false);
            this.pAttributes.setBorder(this.border);
            this.pAttributes.add((Component)this.scpane, new GridBagConstraints(0, 0, 3, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
            this.pAttributes.add((Component)this.bAdd, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
            this.pAttributes.add((Component)this.bModify, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
            this.pAttributes.add((Component)this.bRemove, new GridBagConstraints(2, 1, 1, 1, 1.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
            this.add((Component)this.label, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 10), 0, 0));
            this.add((Component)this.field, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
            this.add((Component)this.pAttributes, new GridBagConstraints(0, 1, 2, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
            this.field.setText(this.entityDefinition.getName());
            this.field.setEnabled(EntityDefinitionPanel.this._enabled);
            this.updateButtonStates();
            this.bAdd.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    FmeaAttributeDefinition attDef = EditEntityPanel.this.editAttributeDefinition(Messages.getString("EntityDefinitionPanel.23"), null);
                    if (attDef != null) {
                        EditEntityPanel.this.entityDefinition.addAttributeDefinition(attDef);
                        EditEntityPanel.this.attributeData = EditEntityPanel.this.getAttributeDefinitions();
                        EditEntityPanel.this.tAttributeModel.fireTableDataChanged();
                    }
                }
            });
            this.bModify.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (EditEntityPanel.this.table.getSelectedRow() == -1) {
                        return;
                    }
                    FmeaAttributeDefinition attDef = (FmeaAttributeDefinition)EditEntityPanel.this.attributeData[EditEntityPanel.this.table.getSelectedRow()];
                    attDef = EditEntityPanel.this.editAttributeDefinition(Messages.getString("EntityDefinitionPanel.24"), attDef.getCopy());
                    if (attDef == null) {
                        return;
                    }
                    EditEntityPanel.this.entityDefinition.addAttributeDefinition(attDef);
                    EditEntityPanel.this.attributeData = EditEntityPanel.this.getAttributeDefinitions();
                    EditEntityPanel.this.tAttributeModel.fireTableDataChanged();
                }
            });
            this.bRemove.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    EditEntityPanel.this.tAttributeModel.removeRows(EditEntityPanel.this.table.getSelectedRows());
                }
            });
            this.table.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent e) {
                    EditEntityPanel.this.updateButtonStates();
                }
            });
        }

        public void updateButtonStates() {
            FmeaAttributeDefinition attDef;
            if (!EntityDefinitionPanel.this._enabled) {
                this.bAdd.setEnabled(false);
                this.bModify.setEnabled(false);
                this.bRemove.setEnabled(false);
                return;
            }
            if (this.table.getSelectedRowCount() != 1) {
                this.bModify.setEnabled(false);
            } else {
                attDef = (FmeaAttributeDefinition)this.attributeData[this.table.getSelectedRow()];
                this.bModify.setEnabled(!(attDef.getType() instanceof FmeaAttributeDefinition.Reference));
            }
            if (this.table.getSelectedRowCount() == 0) {
                this.bRemove.setEnabled(false);
            } else {
                attDef = (FmeaAttributeDefinition)this.attributeData[this.table.getSelectedRow()];
                this.bRemove.setEnabled(this.table.getSelectedRowCount() != 1 || !(attDef.getType() instanceof FmeaAttributeDefinition.Reference));
            }
        }

        public FmeaEntityDefinition getEntityDefinition() {
            return this.entityDefinition;
        }

        private Object[] getAttributeDefinitions() {
            Object[] attr = this.entityDefinition.getAttributeDefinitions();
            ArrayList<FmeaAttributeDefinition> l = new ArrayList<FmeaAttributeDefinition>();
            for (int i = 0; i < attr.length; ++i) {
                FmeaAttributeDefinition att = (FmeaAttributeDefinition)attr[i];
                if (att.getType() instanceof FmeaAttributeDefinition.Reference) {
                    l.add(0, att);
                    continue;
                }
                l.add(att);
            }
            return l.toArray();
        }

        public boolean validateFields() {
            String name = this.field.getText();
            if (name.length() == 0) {
                JOptionPane.showMessageDialog(JOptionCecilia.getTopContainerOf(this), Messages.getString("EntityDefinitionPanel.25"), Messages.getString("ErrorManager.2"), 0);
                return false;
            }
            if (!this.entityDefinition.getName().equals(name)) {
                for (int i = 0; i < EntityDefinitionPanel.this._definitionPanel._entityData.length; ++i) {
                    FmeaEntityDefinition entityDef = (FmeaEntityDefinition)EntityDefinitionPanel.this._definitionPanel._entityData[i];
                    if (!name.equals(entityDef.getName())) continue;
                    JOptionPane.showMessageDialog(JOptionCecilia.getTopContainerOf(this), Messages.getString("EntityDefinitionPanel.26"), Messages.getString("ErrorManager.2"), 0);
                    return false;
                }
            }
            this.entityDefinition.setName(name);
            return true;
        }

        public FmeaAttributeDefinition editAttributeDefinition(String title, FmeaAttributeDefinition attDef) {
            final EditAttributePanel editPanel = new EditAttributePanel(attDef);
            Window window = SwingUtilities.getWindowAncestor(EntityDefinitionPanel.this._definitionPanel);
            EditDialog dlg = null;
            dlg = window instanceof Frame ? new EditDialog((Frame)window, title, true, editPanel, 3){

                @Override
                protected boolean closeEnabled() {
                    return editPanel.validateFields();
                }
            } : new EditDialog((Dialog)window, title, true, editPanel, 3){

                @Override
                protected boolean closeEnabled() {
                    return editPanel.validateFields();
                }
            };
            dlg.setVisible(true);
            dlg.dispose();
            if (dlg.isCanceled()) {
                return null;
            }
            return editPanel.getAttributeDefinition();
        }

        private class AttributeTableModel
        extends AbstractTableModel {
            private String[] columnNames = new String[]{Messages.getString("EntityDefinitionPanel.13"), Messages.getString("EntityDefinitionPanel.14")};

            private AttributeTableModel() {
            }

            @Override
            public String getColumnName(int col) {
                return this.columnNames[col];
            }

            @Override
            public int getColumnCount() {
                return this.columnNames.length;
            }

            @Override
            public int getRowCount() {
                return EditEntityPanel.this.entityDefinition == null ? 0 : EditEntityPanel.this.attributeData.length;
            }

            public Class getColumnClass(int col) {
                switch (col) {
                    case 0: {
                        return String.class;
                    }
                    case 1: {
                        return FmeaAttributeDefinition.Type.class;
                    }
                }
                return null;
            }

            @Override
            public Object getValueAt(int row, int col) {
                FmeaAttributeDefinition def = (FmeaAttributeDefinition)EditEntityPanel.this.attributeData[row];
                switch (col) {
                    case 0: {
                        return def.getName();
                    }
                    case 1: {
                        return def.getType();
                    }
                }
                return null;
            }

            public void removeRows(int[] rows) {
                for (int i = 0; i < rows.length; ++i) {
                    FmeaAttributeDefinition def = (FmeaAttributeDefinition)EditEntityPanel.this.attributeData[rows[i]];
                    if (EntityDefinitionPanel.this._definitionPanel._fmea.getModel().getTableDefinition().existColumnDefinition(EditEntityPanel.this.entityDefinition, def)) {
                        String msg = Messages.msgFormat("EntityDefinitionPanel.15", def.getName());
                        JOptionPane.showMessageDialog(JOptionCecilia.getTopContainerOf(EntityDefinitionPanel.this), msg, Messages.getString("ErrorManager.2"), 0);
                        continue;
                    }
                    if (def.getType() instanceof FmeaAttributeDefinition.Reference) continue;
                    EditEntityPanel.this.entityDefinition.removeAttributeDefinition(def);
                }
                EditEntityPanel.this.attributeData = EditEntityPanel.this.getAttributeDefinitions();
                super.fireTableDataChanged();
            }
        }

        class EditAttributePanel
        extends JPanel {
            private boolean create;
            private FmeaAttributeDefinition attributeDefinition;
            private JLabel label1;
            private JLabel label2;
            private JTextField _attrField;
            private Object[] items;
            private JComboBox combo;

            public EditAttributePanel(FmeaAttributeDefinition attributeDef) {
                super(new GridBagLayout());
                this.create = false;
                this.attributeDefinition = null;
                this.label1 = new JLabel(Messages.getString("EntityDefinitionPanel.27"));
                this.label2 = new JLabel(Messages.getString("EntityDefinitionPanel.28"));
                this._attrField = new JTextField(20);
                this.items = new Object[]{FmeaAttributeDefinition.String, FmeaAttributeDefinition.Integer, FmeaAttributeDefinition.Double, FmeaAttributeDefinition.Enumeration};
                this.combo = new JComboBox<Object>(this.items);
                this.create = attributeDef == null;
                this.attributeDefinition = this.create ? new FmeaAttributeDefinition(null) : attributeDef;
                this.add((Component)this.label1, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 10), 0, 0));
                this.add((Component)this.label2, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 10), 0, 0));
                this.add((Component)this._attrField, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 10), 0, 0));
                this.add((Component)this.combo, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 10), 0, 0));
                this._attrField.setText(this.attributeDefinition.getName());
                this.combo.setSelectedItem(this.attributeDefinition.getType());
                this._attrField.setEnabled(EntityDefinitionPanel.this._enabled);
                this.combo.setEnabled(EntityDefinitionPanel.this._enabled);
            }

            public boolean validateFields() {
                String name = this._attrField.getText();
                if (name.length() == 0) {
                    JOptionPane.showMessageDialog(JOptionCecilia.getTopContainerOf(this), Messages.getString("EntityDefinitionPanel.25"), Messages.getString("ErrorManager.2"), 0);
                    return false;
                }
                if (this.create || !this.attributeDefinition.getName().equals(name)) {
                    for (int i = 0; i < EditEntityPanel.this.attributeData.length; ++i) {
                        FmeaAttributeDefinition attDef = (FmeaAttributeDefinition)EditEntityPanel.this.attributeData[i];
                        if (!name.equals(attDef.getName())) continue;
                        JOptionPane.showMessageDialog(JOptionCecilia.getTopContainerOf(this), Messages.getString("EntityDefinitionPanel.30"), Messages.getString("ErrorManager.2"), 0);
                        return false;
                    }
                }
                FmeaAttributeDefinition.Type type = (FmeaAttributeDefinition.Type)this.combo.getSelectedItem();
                if (this.combo.getSelectedItem() == null) {
                    JOptionPane.showMessageDialog(JOptionCecilia.getTopContainerOf(this), Messages.getString("EntityDefinitionPanel.31"), Messages.getString("ErrorManager.2"), 0);
                    return false;
                }
                this.attributeDefinition.setName(name);
                this.attributeDefinition.setType(type);
                return true;
            }

            public FmeaAttributeDefinition getAttributeDefinition() {
                return this.attributeDefinition;
            }
        }
    }
}

