/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.dbobj.fmea.io;

import com.dassault.cecilia.dbobj.fmea.model.FmeaDescriptor;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Map;

public class FmeaDescriptorOutput {
    private BufferedWriter writer;

    public FmeaDescriptorOutput(String path) throws IOException {
        this.writer = new BufferedWriter(new FileWriter(path));
    }

    public boolean write(Map descriptors) {
        try {
            for (FmeaDescriptor descriptor : descriptors.values()) {
                this.writer.write("name=" + descriptor.getIdent().getName());
                this.writer.newLine();
                this.writer.write("model=" + descriptor.getModelIdent().getName());
                this.writer.newLine();
                if (descriptor.getDescription().length() == 0) continue;
                this.writer.write("desc=" + descriptor.getDescription());
                if (descriptor.getDescription().charAt(descriptor.getDescription().length() - 1) == File.separatorChar) continue;
                this.writer.newLine();
            }
            return true;
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    public void close() {
        try {
            this.writer.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] args) {
    }
}

