/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.dbobj.fmea.io;

import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;

public class SaveOutput
extends PrintStream {
    public static final String PROP_FMEA_DEBUG_LOGFILE = "cecilia.fmea.logfile.debug";
    private static OutputStream logfile;
    private static PrintStream oldStdout;
    private static PrintStream oldStderr;

    public SaveOutput(PrintStream ps) {
        super(ps);
    }

    public static void start(String file) throws IOException {
        if (logfile != null) {
            SaveOutput.stop();
        }
        oldStdout = System.out;
        oldStderr = System.err;
        logfile = new PrintStream(new BufferedOutputStream(new FileOutputStream(file, true)));
        System.setOut(new SaveOutput(System.out));
        System.setErr(new SaveOutput(System.err));
    }

    public static void stop() {
        if (logfile != null) {
            System.setOut(oldStdout);
            System.setErr(oldStderr);
            try {
                logfile.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                logfile = null;
            }
        }
    }

    public boolean isOutputRedirected() {
        return logfile != null;
    }

    @Override
    public void write(int b) {
        try {
            logfile.write(b);
            logfile.flush();
        }
        catch (Exception e) {
            e.printStackTrace();
            this.setError();
        }
        if (Boolean.getBoolean(PROP_FMEA_DEBUG_LOGFILE)) {
            super.write(b);
        }
    }

    @Override
    public void write(byte[] buf, int off, int len) {
        try {
            logfile.write(buf, off, len);
            logfile.flush();
        }
        catch (Exception e) {
            e.printStackTrace();
            this.setError();
        }
        if (Boolean.getBoolean(PROP_FMEA_DEBUG_LOGFILE)) {
            super.write(buf, off, len);
        }
    }
}

