/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.dbobj.fmea.model;

import com.dassault.cecilia.dbobj.fmea.io.FmeaBufferedWriter;
import com.dassault.cecilia.dbobj.fmea.model.Dictionnary;
import com.dassault.cecilia.dbobj.fmea.model.FmeaObject;
import com.dassault.cecilia.dbobj.fmea.model.FmeaSerializable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class DefaultDictionnary
extends FmeaObject
implements Dictionnary,
FmeaSerializable {
    private String _name;
    private String _description;
    private List<String> _data = new ArrayList<String>();
    private Map map = new HashMap();

    public DefaultDictionnary() {
    }

    public DefaultDictionnary(String name, String description) {
        this._name = name;
        this._description = description;
    }

    public DefaultDictionnary(String name, String description, Collection entries) {
        this._name = name;
        this._description = description;
        for (Map.Entry entry : entries) {
            this._data.add((String)entry.getKey());
            this.map.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public String getName() {
        return this._name;
    }

    @Override
    public String getDescriptionKey() {
        return this._description;
    }

    @Override
    public String getThreshold(Object value) {
        if (!(value instanceof Double)) {
            value = Double.valueOf(value.toString());
        }
        Comparator comparator = new Comparator(){

            public int compare(Object o1, Object o2) {
                return -((Comparable)o1).compareTo(o2);
            }
        };
        TreeSet values = new TreeSet(comparator);
        values.addAll(this.map.values());
        Iterator<Object> i = values.iterator();
        Object v = null;
        while (i.hasNext() && ((Comparable)value).compareTo(v = (Object)i.next()) < 0) {
        }
        for (Object key : this.map.keySet()) {
            if (this.map.get(key) != v) continue;
            return key.toString();
        }
        return null;
    }

    @Override
    public Iterator getKeys() {
        return this._data.iterator();
    }

    @Override
    public Set getEntries() {
        return new HashMap(this.map).entrySet();
    }

    @Override
    public Object getValue(Object key) {
        return this.map.get(key);
    }

    @Override
    public int getCount() {
        return this.map.size();
    }

    @Override
    public void clear() {
        this._data.clear();
        this.map.clear();
        this._changeNotifier.changed(this);
    }

    @Override
    public void put(Object key, Double value) {
        this._data.add((String)key);
        this.map.put(key, value);
        this._changeNotifier.changed(this);
    }

    @Override
    public void remove(Object key) {
        this._data.remove(key);
        this.map.remove(key);
        this._changeNotifier.changed(this);
    }

    @Override
    public void writeXML(FmeaBufferedWriter w) throws IOException {
        w.write("<DICTIONNARY");
        w.write(" NAME=\"" + this.getName() + "\"");
        w.write(" DESCRIPTION=\"" + this.getDescriptionKey() + "\"");
        w.write(">\n");
        Iterator i = this.getKeys();
        while (i.hasNext()) {
            Object key = i.next();
            w.write("<ENTRY");
            w.write(" KEY=\"" + key + "\"");
            w.write(" VALUE=\"" + this.getValue(key) + "\"");
            w.write("/>\n");
        }
        w.write("</DICTIONNARY>\n");
    }

    @Override
    public void toXML(Appendable out, String indent) throws IOException {
        out.append(indent).append("<DICTIONNARY");
        out.append(" NAME=\"" + this.getName() + "\"");
        out.append(" DESCRIPTION=\"" + this.getDescriptionKey() + "\"");
        out.append(">\n");
        Iterator i = this.getKeys();
        while (i.hasNext()) {
            Object key = i.next();
            out.append(indent).append("  <ENTRY");
            out.append(" KEY=\"" + key + "\"");
            out.append(" VALUE=\"" + this.getValue(key) + "\"");
            out.append("/>\n");
        }
        out.append(indent).append("</DICTIONNARY>\n");
    }

    @Override
    public Object readXML(Element node) {
        this._name = node.getAttribute("NAME");
        this._description = node.getAttribute("DESCRIPTION");
        NodeList childs = node.getElementsByTagName("ENTRY");
        for (int i = 0; i < childs.getLength(); ++i) {
            Element entry = (Element)childs.item(i);
            String key = entry.getAttribute("KEY");
            Double value = Double.valueOf(entry.getAttribute("VALUE"));
            this._data.add(key);
            this.map.put(key, value);
        }
        return null;
    }

    public static void main(String[] args) {
        File file1 = new File("E:\\cecilia_dev\\Cecilia4\\run\\fmea\\data\\dictionnary1.xml");
        File file2 = new File("E:\\cecilia_dev\\Cecilia4\\run\\fmea\\data\\dictionnary2.xml");
        DefaultDictionnary dico = new DefaultDictionnary("Criticity dictionnary", "Dictionnary intended to enumerates ranges of criticity");
        Document document = null;
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setValidating(false);
        factory.setIgnoringComments(true);
        factory.setIgnoringElementContentWhitespace(true);
        factory.setCoalescing(false);
        factory.setExpandEntityReferences(true);
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            document = builder.parse(file1);
            Element root = document.getDocumentElement();
            dico.readXML(root);
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        try {
            FmeaBufferedWriter writer = new FmeaBufferedWriter(new FileWriter(file2));
            writer.write("<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?>\n");
            dico.writeXML(writer);
            writer.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void writeXML(Writer outXML) throws IOException {
    }
}

