/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.dbobj.fmea.model;

import com.dassault.cecilia.core.cecilia.error.Msg;
import com.dassault.cecilia.dbobj.fmea.Messages;
import com.dassault.cecilia.dbobj.fmea.io.FmeaBufferedWriter;
import com.dassault.cecilia.dbobj.fmea.model.Fmea;
import com.dassault.cecilia.dbobj.fmea.model.FmeaObject;
import com.dassault.cecilia.dbobj.fmea.model.FmeaSerializable;
import com.dassault.cecilia.dbobj.fmea.model.FmeaTypePropertyCollection;
import java.io.IOException;
import org.w3c.dom.Element;

public class FmeaAttributeDefinition
extends FmeaObject
implements FmeaSerializable {
    public static final Number Number = new Number();
    public static final Integer Integer = new Integer();
    public static final Double Double = new Double();
    public static final String String = new String();
    public static final Reference Reference = new Reference();
    public static final Enumeration Enumeration = new Enumeration();
    public static final Unknown Unknown = new Unknown();
    private static int __count = 0;
    private static java.lang.String __prefix = "AttributeDefinition";
    private java.lang.String _key;
    private Type _type;
    protected FmeaTypePropertyCollection typeProperties = new FmeaTypePropertyCollection();

    public FmeaAttributeDefinition(java.lang.String key) {
        this._key = key;
        this.setName(this._key);
        this.init();
    }

    public FmeaAttributeDefinition(java.lang.String key, java.lang.String name) {
        this._key = key;
        this.setName(name);
        this.init();
    }

    private FmeaAttributeDefinition(FmeaAttributeDefinition attDef) {
        super(attDef);
        this._key = attDef._key;
        this._type = attDef._type;
    }

    public FmeaAttributeDefinition getCopy() {
        return new FmeaAttributeDefinition(this);
    }

    protected void init() {
        if (this._key == null || this._key.length() == 0) {
            this._key = __prefix + __count++;
        } else if (this._key.startsWith(__prefix)) {
            int id = java.lang.Integer.parseInt(this._key.substring(__prefix.length()));
            __count = Math.max(id, __count);
            ++__count;
        }
    }

    public java.lang.String getKey() {
        return this._key;
    }

    public void setName(java.lang.String name) {
        this._internalAttributes.put("NAME", name);
        this._changeNotifier.changed(this);
    }

    public Type getType() {
        return this._type;
    }

    public void setType(Type type) {
        this._type = type;
        java.lang.String xmlType = null;
        if (this._type.getClass() == String.class) {
            xmlType = "string";
        } else if (this._type.getClass() == Integer.class) {
            xmlType = "integer";
        } else if (this._type.getClass() == Double.class) {
            xmlType = "double";
        } else if (this._type.getClass() == Enumeration.class) {
            xmlType = "enumeration";
        } else if (this._type.getClass() == Reference.class) {
            xmlType = "string";
        }
        if (xmlType != null) {
            this._internalAttributes.put("TYPE", xmlType);
            this._changeNotifier.changed(this);
        }
    }

    @Override
    public void internalAttributeChanged(java.lang.String name, java.lang.String value) {
        if (name.equals("TYPE")) {
            this._type = value.equals("double") ? Double : (value.equals("enumeration") ? Enumeration : (value.equals("integer") ? Integer : (value.equals("string") ? String : Unknown)));
        }
    }

    public void addTypeProperty(java.lang.String name, java.lang.String value) {
        this.typeProperties.put(name, value);
        this._changeNotifier.changed(this);
    }

    public boolean equals(Object o) {
        return o == null ? false : this.getKey().equals(((FmeaAttributeDefinition)o).getKey());
    }

    public int hashCode() {
        return this._key.hashCode();
    }

    public java.lang.String toString() {
        return this.getName();
    }

    public boolean checkValue(Object value) {
        Type t = this.getType();
        if (t instanceof Reference) {
            return this.checkReferenceValue(value);
        }
        if (t instanceof String) {
            return this.checkStringValue(value);
        }
        if (t instanceof Double) {
            return this.checkDoubleValue(value);
        }
        if (t instanceof Integer) {
            return this.checkIntegerValue(value);
        }
        return true;
    }

    @Override
    public void writeXML(FmeaBufferedWriter w) throws IOException {
        w.incTabCount();
        w.write("<ATTRIBUTE_DEFINITION KEY=\"");
        w.write(this.getKey());
        w.write("\" NAME=\"");
        w.write(this.getName());
        w.write("\" TYPE=\"");
        w.write(this.getXMLAttribute("TYPE"));
        w.writeln("\">");
        this.typeProperties.writeXML(w);
        w.writeln("</ATTRIBUTE_DEFINITION>");
        w.decTabCount();
    }

    @Override
    public void toXML(Appendable out, java.lang.String indent) throws IOException {
        out.append(indent).append("<ATTRIBUTE_DEFINITION");
        out.append(" KEY=\"").append(this.getKey()).append("\"");
        out.append(" NAME=\"").append(this.getName()).append("\"");
        out.append(" TYPE=\"").append(this.getXMLAttribute("TYPE")).append("\"");
        if (this.typeProperties.isEmpty()) {
            out.append("/>\n");
        } else {
            this.typeProperties.toXML(out, indent + "  ");
            out.append(indent).append("</ATTRIBUTE_DEFINITION>\n");
        }
    }

    @Override
    public Object readXML(Element node) {
        return null;
    }

    protected boolean checkStringValue(Object value) {
        if (value == null || value.toString().length() == 0) {
            return true;
        }
        java.lang.Integer string_length = this.typeProperties.getStringLength();
        if (string_length == null) {
            return true;
        }
        if (value.toString().length() > string_length) {
            Fmea.errorMgr.add(new Msg(Messages.msgFormat("FmeaAttributeDefinition.19", value.toString(), java.lang.String.valueOf(string_length))));
            return false;
        }
        return true;
    }

    protected boolean checkReferenceValue(Object value) {
        if (value == null || value.toString().length() == 0) {
            Fmea.errorMgr.add(new Msg(Messages.getString("FmeaAttributeDefinition.16")));
            return false;
        }
        return this.checkStringValue(value);
    }

    protected boolean checkNumberValue(Object value) {
        return true;
    }

    protected boolean checkIntegerValue(Object value) {
        if (value == null || value.toString().length() == 0) {
            return true;
        }
        java.lang.Integer i = null;
        try {
            i = java.lang.Integer.valueOf(value.toString());
        }
        catch (NumberFormatException e) {
            Fmea.errorMgr.add(new Msg(Messages.msgFormat("FmeaAttributeDefinition.15", value.toString())));
            return false;
        }
        java.lang.Integer lt = this.typeProperties.getLessThanValue().intValue();
        if (lt != null && i.compareTo(lt) >= 0) {
            Fmea.errorMgr.add(new Msg(Messages.msgFormat("FmeaAttributeDefinition.21", value.toString())));
            return false;
        }
        java.lang.Integer lte = this.typeProperties.getLessOrEqualValue().intValue();
        if (lte != null && i.compareTo(lte) > 0) {
            Fmea.errorMgr.add(new Msg(Messages.msgFormat("FmeaAttributeDefinition.22", value.toString())));
            return false;
        }
        java.lang.Integer mt = this.typeProperties.getMoreThanValue().intValue();
        if (mt != null && i.compareTo(mt) <= 0) {
            Fmea.errorMgr.add(new Msg(Messages.msgFormat("FmeaAttributeDefinition.23", value.toString())));
            return false;
        }
        java.lang.Integer mte = this.typeProperties.getMoreOrEqualValue().intValue();
        if (mte != null && i.compareTo(mte) < 0) {
            Fmea.errorMgr.add(new Msg(Messages.msgFormat("FmeaAttributeDefinition.24", value.toString())));
            return false;
        }
        return true;
    }

    protected boolean checkDoubleValue(Object value) {
        if (value == null || value.toString().length() == 0) {
            return true;
        }
        java.lang.Double d = null;
        try {
            d = java.lang.Double.valueOf(value.toString());
        }
        catch (NumberFormatException e) {
            Fmea.errorMgr.add(new Msg(Messages.msgFormat("FmeaAttributeDefinition.20", value.toString())));
            return false;
        }
        java.lang.Double lt = this.typeProperties.getLessThanValue();
        if (lt != null && d.compareTo(lt) >= 0) {
            Fmea.errorMgr.add(new Msg(Messages.msgFormat("FmeaAttributeDefinition.21", value.toString())));
            return false;
        }
        java.lang.Double lte = this.typeProperties.getLessOrEqualValue();
        if (lte != null && d.compareTo(lte) > 0) {
            Fmea.errorMgr.add(new Msg(Messages.msgFormat("FmeaAttributeDefinition.22", value.toString())));
            return false;
        }
        java.lang.Double mt = this.typeProperties.getMoreThanValue();
        if (mt != null && d.compareTo(mt) <= 0) {
            Fmea.errorMgr.add(new Msg(Messages.msgFormat("FmeaAttributeDefinition.23", value.toString())));
            return false;
        }
        java.lang.Double mte = this.typeProperties.getMoreOrEqualValue();
        if (mte != null && d.compareTo(mte) < 0) {
            Fmea.errorMgr.add(new Msg(Messages.msgFormat("FmeaAttributeDefinition.24", value.toString())));
            return false;
        }
        return true;
    }

    public static Object convertObjectToType(java.lang.String obj, Type type) {
        if (type == String) {
            return obj;
        }
        if (type == Enumeration) {
            return obj;
        }
        if (type == Reference) {
            return obj;
        }
        if (type == Unknown) {
            return obj;
        }
        if (type == Integer) {
            return java.lang.Integer.valueOf(obj);
        }
        if (type == Double) {
            return java.lang.Double.valueOf(obj);
        }
        return null;
    }

    public static class Type {
        private Type() {
        }

        public java.lang.String toString() {
            return null;
        }

        public boolean equals(Object o) {
            return o == null ? false : this.toString().equals(((Type)o).toString());
        }

        public int hashCode() {
            return this.toString().hashCode();
        }
    }

    public static class String
    extends Type {
        private String() {
        }

        @Override
        public java.lang.String toString() {
            return "string";
        }
    }

    public static class Integer
    extends Number {
        private Integer() {
        }

        @Override
        public java.lang.String toString() {
            return "integer";
        }
    }

    public static class Double
    extends Number {
        private Double() {
        }

        @Override
        public java.lang.String toString() {
            return "double";
        }
    }

    public static class Enumeration
    extends Type {
        private Enumeration() {
        }

        @Override
        public java.lang.String toString() {
            return "enumeration";
        }
    }

    public static class Reference
    extends String {
        private Reference() {
        }

        @Override
        public java.lang.String toString() {
            return "identifiant";
        }
    }

    public static class Unknown
    extends Type {
        private Unknown() {
        }

        @Override
        public java.lang.String toString() {
            return "unknown";
        }
    }

    public static class Number
    extends Type {
        private Number() {
        }

        @Override
        public java.lang.String toString() {
            return "number";
        }
    }
}

