/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.dbobj.fmea.model;

import com.dassault.cecilia.dbobj.fmea.io.FmeaBufferedWriter;
import com.dassault.cecilia.dbobj.fmea.model.FmeaAttributeDefinition;
import com.dassault.cecilia.dbobj.fmea.model.FmeaEntityDefinition;
import com.dassault.cecilia.dbobj.fmea.model.FmeaGraphicPropertyCollection;
import com.dassault.cecilia.dbobj.fmea.model.FmeaObject;
import com.dassault.cecilia.dbobj.fmea.model.FmeaSerializable;
import com.dassault.cecilia.dbobj.fmea.model.Formula;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import org.w3c.dom.Element;

public class FmeaColumnDefinition
extends FmeaObject
implements FmeaSerializable,
PropertyChangeListener {
    private static final String PROP_FMEA_TABLE_COLUMN_STRING = "cecilia.fmea.TableColumnHorizontalAlignment.String";
    private static final String PROP_FMEA_TABLE_COLUMN_REFERENCE = "cecilia.fmea.TableColumnHorizontalAlignment.Reference";
    private static final String PROP_FMEA_TABLE_COLUMN_NUMBER = "cecilia.fmea.TableColumnHorizontalAlignment.Number";
    private static final String PROP_FMEA_TABLE_COLUMN_INTEGER = "cecilia.fmea.TableColumnHorizontalAlignment.Integer";
    private static final String PROP_FMEA_TABLE_COLUMN_DOUBLE = "cecilia.fmea.TableColumnHorizontalAlignment.Double";
    private static final String PROP_FMEA_TABLE_COLUMN_ENUMERATION = "cecilia.fmea.TableColumnHorizontalAlignment.Enumeration";
    private static int count = 0;
    private static String prefix = "ColumnDefinition";
    private String _key;
    private String _name;
    private FmeaEntityDefinition _entityDef;
    private FmeaAttributeDefinition _attributeDef;
    protected FmeaGraphicPropertyCollection _graphicProperties;
    protected Formula _formula;

    public FmeaColumnDefinition(String key, String name, FmeaEntityDefinition entityDef, FmeaAttributeDefinition attributeDef) {
        this._key = key;
        this._name = name;
        this._entityDef = entityDef;
        this._attributeDef = attributeDef;
        this.init();
    }

    protected void init() {
        if (this._key == null || this._key.length() == 0) {
            this._key = prefix + count++;
        } else {
            int id = Integer.parseInt(this._key.substring(prefix.length()));
            count = Math.max(id, count);
            ++count;
        }
        this._graphicProperties = new FmeaGraphicPropertyCollection();
        this.setLinkToAttribute(this._entityDef != null);
        FmeaAttributeDefinition.Type type = this.getColumnType();
        String align = null;
        if (type instanceof FmeaAttributeDefinition.String) {
            align = System.getProperty(PROP_FMEA_TABLE_COLUMN_STRING);
        } else if (type instanceof FmeaAttributeDefinition.Reference) {
            align = System.getProperty(PROP_FMEA_TABLE_COLUMN_REFERENCE);
        } else if (type instanceof FmeaAttributeDefinition.Number) {
            align = System.getProperty(PROP_FMEA_TABLE_COLUMN_NUMBER);
        } else if (type instanceof FmeaAttributeDefinition.Integer) {
            align = System.getProperty(PROP_FMEA_TABLE_COLUMN_INTEGER);
        } else if (type instanceof FmeaAttributeDefinition.Double) {
            align = System.getProperty(PROP_FMEA_TABLE_COLUMN_DOUBLE);
        } else if (type instanceof FmeaAttributeDefinition.Enumeration) {
            align = System.getProperty(PROP_FMEA_TABLE_COLUMN_ENUMERATION);
        }
        if (align != null) {
            this._graphicProperties.putProperty(FmeaGraphicPropertyCollection.horizontalAlignment, align);
        }
        this._graphicProperties.getChangeNotifier().addChangeListener(this._changeNotifier);
    }

    public String getKey() {
        return this._key;
    }

    @Override
    public String getName() {
        return this._name;
    }

    public FmeaEntityDefinition getEntityDefinition() {
        return this._entityDef;
    }

    public FmeaAttributeDefinition getAttributeDefinition() {
        return this._attributeDef;
    }

    public FmeaGraphicPropertyCollection getGraphicProperties() {
        return this._graphicProperties;
    }

    public FmeaAttributeDefinition.Type getColumnType() {
        return this._attributeDef == null ? FmeaAttributeDefinition.Double : this._attributeDef.getType();
    }

    public Class getColumnClass() {
        return this._attributeDef == null ? FmeaAttributeDefinition.Double.getClass() : this._attributeDef.getType().getClass();
    }

    public Integer getColumnWidth() {
        return this._graphicProperties.getInteger(FmeaGraphicPropertyCollection.width);
    }

    public void setName(String name) {
        this._name = name;
        this._changeNotifier.changed(this);
    }

    public void setEntityDefinition(FmeaEntityDefinition entityDef) {
        this._entityDef = entityDef;
        this._changeNotifier.changed(this);
    }

    public void setAttributeDefinition(FmeaAttributeDefinition attributeDef) {
        this._attributeDef = attributeDef;
        this._changeNotifier.changed(this);
    }

    public boolean checkValue(Object value) {
        return this.getAttributeDefinition().checkValue(value);
    }

    public boolean isLinkedToAttribute() {
        return this._graphicProperties.getBoolean(FmeaGraphicPropertyCollection.link);
    }

    public void setLinkToAttribute(boolean link) {
        this._graphicProperties.putBoolean(FmeaGraphicPropertyCollection.link, link);
    }

    public Formula getFormula() {
        return this._formula;
    }

    public void setFormula(Formula formula) {
        this._formula = formula;
        if (formula != null) {
            this._graphicProperties.putString(FmeaGraphicPropertyCollection.formula, formula.getText());
        }
    }

    @Override
    public void writeXML(FmeaBufferedWriter w) throws IOException {
        w.incTabCount();
        w.write("<COLUMN_DEFINITION");
        w.write(" KEY=\"");
        w.write(this.getKey() == null ? "" : this.getKey());
        w.write("\" NAME=\"");
        w.write(this.getName());
        if (this.getEntityDefinition() != null) {
            w.write("\" ENTITY=\"");
            w.write(this.getEntityDefinition().getKey());
        }
        if (this.getAttributeDefinition() != null) {
            w.write("\" ATTRIBUTE=\"");
            w.write(this.getAttributeDefinition().getKey());
        }
        w.writeln("\">");
        this._graphicProperties.writeXML(w);
        w.writeln("</COLUMN_DEFINITION>");
        w.decTabCount();
    }

    @Override
    public void toXML(Appendable out, String indent) throws IOException {
        out.append(indent).append("<COLUMN_DEFINITION");
        out.append(" KEY=\"").append(this.getKey() == null ? "" : this.getKey()).append("\"");
        out.append(" NAME=\"").append(this.getName()).append("\"");
        if (this.getEntityDefinition() != null) {
            out.append(" ENTITY=\"").append(this.getEntityDefinition().getKey()).append("\"");
        }
        if (this.getAttributeDefinition() != null) {
            out.append(" ATTRIBUTE=\"").append(this.getAttributeDefinition().getKey()).append("\"");
        }
        if (this._graphicProperties.isEmpty()) {
            out.append("/>\n");
        } else {
            out.append(">\n");
            this._graphicProperties.toXML(out, indent + "  ");
            out.append(indent).append("</COLUMN_DEFINITION>\n");
        }
    }

    @Override
    public Object readXML(Element node) {
        return null;
    }

    public String toString() {
        return this._name;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("preferredWidth") || evt.getPropertyName().equals("width")) {
            this._graphicProperties.put(FmeaGraphicPropertyCollection.width, evt.getNewValue());
        }
    }

    public FmeaColumnDefinition getCopy() {
        return (FmeaColumnDefinition)this.clone();
    }

    public Object clone() {
        FmeaColumnDefinition clone = new FmeaColumnDefinition(this._key, this._name, this._entityDef, this._attributeDef);
        clone._internalAttributes.putAll(this._internalAttributes);
        clone._graphicProperties.putAll(this._graphicProperties);
        clone._formula = this._formula;
        return clone;
    }

    public void copy(FmeaColumnDefinition colDef) {
        this._name = colDef._name;
        this._internalAttributes.clear();
        this._internalAttributes.putAll(colDef._internalAttributes);
        this._graphicProperties.clear();
        this._graphicProperties.putAll(colDef._graphicProperties);
        this._entityDef = colDef._entityDef;
        this._attributeDef = colDef._attributeDef;
        this._formula = colDef._formula;
    }
}

