/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.dbobj.fmea.model;

import com.dassault.cecilia.core.Util;
import com.dassault.cecilia.dbobj.CECFactory;
import com.dassault.cecilia.dbobj.fmea.DBTableFMEA;
import com.dassault.cecilia.dbobj.fmea.io.FmeaBufferedWriter;
import com.dassault.cecilia.dbobj.fmea.model.ExternalFmeaReference;
import com.dassault.cecilia.dbobj.fmea.model.FmeaAttribute;
import com.dassault.cecilia.dbobj.fmea.model.FmeaAttributeDefinition;
import com.dassault.cecilia.dbobj.fmea.model.FmeaEntityDefinition;
import com.dassault.cecilia.dbobj.fmea.model.FmeaExternalRefAttribute;
import com.dassault.cecilia.dbobj.fmea.model.FmeaObject;
import com.dassault.cecilia.dbobj.fmea.model.FmeaSerializable;
import com.dassault.cecilia.dbobj.fmea.model.FmeaValueAttribute;
import com.dassault.cecilia.dbobj.general.DBObjectXmlUtility;
import com.dassault.cecilia.dbobj.general.log.DBLogs;
import com.dassault.cecilia.dbobj.wrap.DBWrap;
import java.io.IOException;
import java.text.NumberFormat;
import java.text.ParsePosition;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import org.w3c.dom.Element;

public class FmeaEntity
extends FmeaObject
implements FmeaSerializable {
    private static final String PROP_FMEA_NUMBER_LOCALE_DEF = "fr";
    public static final String PROP_FMEA_NUMBER_LOCALE = "cecilia.fmea.ImportTextFormatNumberLocale";
    private Integer referenceID = null;
    private FmeaEntityDefinition definition;
    private Map<String, FmeaAttribute> attributes = new HashMap<String, FmeaAttribute>();
    private Map relations = new HashMap();
    private FmeaEntity relationOrigin = null;

    public FmeaEntity(FmeaEntityDefinition entityDef, String name) {
        this.referenceID = this.hashCode();
        this.definition = entityDef;
        if (name == null) {
            name = this.definition.getNewEntityName();
        } else {
            this.definition.reserveIDFromNameIfNeeded(name);
        }
        this.setName(name);
    }

    public boolean importAttributeValue(String key, String value) {
        boolean state = true;
        Locale locale = Locale.getDefault();
        String prop = System.getProperty(PROP_FMEA_NUMBER_LOCALE, PROP_FMEA_NUMBER_LOCALE_DEF);
        try {
            locale = new Locale(prop);
        }
        catch (Exception e) {
            state = false;
        }
        if (!state) {
            return false;
        }
        return this.setAttributeValue(key, value, locale);
    }

    public boolean setAttributeValue(String key, String value) {
        return this.setAttributeValue(key, value, Locale.getDefault());
    }

    public boolean setAttributeValue(String key, String value, Locale locale) {
        if (locale == null) {
            throw new IllegalArgumentException("The parameter 'locale' can not be null.");
        }
        FmeaAttributeDefinition attrDef = this.getDefinition().getAttributeDefinition(key);
        if (attrDef == null) {
            attrDef = this.getDefinition().getAttributeDefinitionWithName(key);
        }
        boolean state = true;
        Object object = null;
        try {
            if (attrDef.getType() instanceof FmeaAttributeDefinition.Reference) {
                object = value;
            } else if (attrDef.getType() instanceof FmeaAttributeDefinition.String) {
                object = value;
            } else if (attrDef.getType() instanceof FmeaAttributeDefinition.Double) {
                NumberFormat nf = NumberFormat.getInstance(locale);
                nf.setParseIntegerOnly(false);
                ParsePosition pos = new ParsePosition(0);
                object = nf.parse(value, pos);
                if (pos.getIndex() < value.length()) {
                    object = null;
                    state = false;
                } else if (object instanceof Long) {
                    object = Double.valueOf(object.toString());
                }
            } else if (attrDef.getType() instanceof FmeaAttributeDefinition.Integer) {
                object = Integer.valueOf(value);
            } else if (attrDef.getType() instanceof FmeaAttributeDefinition.Enumeration) {
                object = value;
            } else {
                state = false;
            }
        }
        catch (NumberFormatException e) {
            state = false;
        }
        this.setAttributeValue(attrDef.getKey(), object);
        return state;
    }

    public void print() {
        String entityName = this.getName();
        System.out.println(">> name: " + entityName);
        System.out.print(">> attributes: ");
        System.out.println(this.attributes);
        System.out.print(">> relationships: ");
        System.out.println(this.relations);
    }

    public void release() {
        this.definition.releaseIDFromNameIfNeeded(this.getName());
    }

    public static String FormatGlobalName(String definitionName, String entityName) {
        StringBuilder builder = new StringBuilder();
        builder.append(definitionName);
        builder.append('.');
        builder.append(entityName);
        return builder.toString();
    }

    public void setAttributeValue(String key, Object value) {
        this.setAttribute(key, new FmeaValueAttribute(value));
    }

    public void removeAttribute(String key) {
        this.attributes.remove(key);
        this._changeNotifier.changed(this);
    }

    public void addRelation(FmeaEntity entity) {
        TreeMap<Integer, FmeaEntity> entities = (TreeMap<Integer, FmeaEntity>)this.relations.get(entity.getDefinition().getKey());
        if (entities == null) {
            entities = new TreeMap<Integer, FmeaEntity>();
            this.relations.put(entity.getDefinition().getKey(), entities);
        }
        entities.put(entity.getReferenceID(), entity);
    }

    public void removeRelation(FmeaEntity entity) {
        Map entities = (Map)this.relations.get(entity.getDefinition().getKey());
        if (entities != null) {
            entities.remove(entity.getReferenceID());
            if (entities.isEmpty()) {
                this.relations.remove(entity.getDefinition().getKey());
            }
        }
    }

    public void removeRelations() {
        this.relations = new HashMap();
    }

    public void setRelationOrigin(FmeaEntity entity) {
        this.relationOrigin = entity;
    }

    public FmeaEntity getRelationOrigin() {
        return this.relationOrigin;
    }

    public FmeaEntityDefinition getDefinition() {
        return this.definition;
    }

    public FmeaAttribute getAttribute(String key) {
        return this.attributes.get(key);
    }

    public void setAttribute(String key, FmeaAttribute attribute) {
        FmeaAttribute oldAttribute = this.attributes.put(key, attribute);
        if (oldAttribute != null) {
            oldAttribute.getChangeNotifier().removeChangeListener(this._changeNotifier);
        }
        attribute.getChangeNotifier().addChangeListener(this._changeNotifier);
        this._changeNotifier.changed(this);
    }

    public Object getAttributeValue(String key) {
        FmeaAttribute att = this.getAttribute(key);
        return att == null ? null : att.getValue();
    }

    public Iterator<Map.Entry<String, FmeaAttribute>> getAttributeIterator() {
        return this.attributes.entrySet().iterator();
    }

    public Map getRelations() {
        return this.relations;
    }

    public void setName(String name) {
        this._internalAttributes.put("NAME", name);
        this.setAttributeValue(this.definition.getKey(), name);
    }

    public Integer getReferenceID() {
        return this.referenceID;
    }

    public String getGlobalName() {
        return FmeaEntity.FormatGlobalName(this.definition.getKey(), this.getName());
    }

    @Override
    public Object readXML(Element node) {
        return null;
    }

    @Override
    public void writeXML(FmeaBufferedWriter w) throws IOException {
        w.write("<ENTITY");
        w.write(" NAME=\"");
        w.write(Util.formatStringForXml(this.getName()));
        w.write("\" DEFINITION=\"");
        w.write(this.getDefinition().getKey());
        w.writeln("\">");
        w.incTabCount();
        for (String key : this.attributes.keySet()) {
            FmeaAttribute attribute = this.attributes.get(key);
            String value = attribute.getValue() == null ? "" : attribute.getValue().toString();
            w.write("<ATTRIBUTE_VALUE ");
            w.write("NAME=\"" + key + "\" ");
            w.writeln("VALUE=\"" + Util.formatStringForXml(value) + "\">");
            if (attribute instanceof FmeaExternalRefAttribute) {
                FmeaExternalRefAttribute att = (FmeaExternalRefAttribute)attribute;
                for (ExternalFmeaReference ref : att.getExternalReferences()) {
                    w.write("<EXTERNAL_REF ");
                    w.write("FMEA_ID=\"" + ref.getDBFolder().getID() + "\" ");
                    w.write("FMEA_PATH=\"" + Util.formatStringForXml(ref.getDBFolder().getRefPath()) + "\" ");
                    w.write("FMEA_ENTITY_ID=\"" + Util.formatStringForXml(ref.getFmeaEntId()) + "\" ");
                    w.write("FMEA_ENTITY_NAME=\"" + Util.formatStringForXml(ref.getFmeaEntName()) + "\" ");
                    w.write("FMEA_ENTITY_VALUE=\"" + Util.formatStringForXml(ref.getFmeaEntValue()) + "\" ");
                    w.write("FMEA_ATTRIBUTE_ID=\"" + Util.formatStringForXml(ref.getFmeaAttId()) + "\" ");
                    w.write("FMEA_ATTRIBUTE_NAME=\"" + Util.formatStringForXml(ref.getFmeaAttName()) + "\" ");
                    w.write("FMEA_ATTRIBUTE_VALUE=\"" + ref.getFmeaAttValue() + "\">");
                    w.writeln();
                    for (int i = 0; i < ref.getcolumnCount(); ++i) {
                        w.write("<EXT_REF_COLUMN ");
                        w.write("ID=\"" + Util.formatStringForXml(ref.getColumnKey(i)) + "\" ");
                        w.write("NAME=\"" + Util.formatStringForXml(ref.getColumnName(i)) + "\" ");
                        w.write("VALUE=\"" + Util.formatStringForXml(ref.getColumnValue(i)) + "\">");
                        w.write("</EXT_REF_COLUMN>");
                        w.writeln();
                    }
                    w.write("</EXTERNAL_REF>");
                    w.writeln();
                }
            }
            w.writeln("</ATTRIBUTE_VALUE>");
        }
        w.decTabCount();
        w.writeln("</ENTITY>");
    }

    @Override
    public void toXML(Appendable out, String indent) throws IOException {
        out.append(indent).append("<ENTITY");
        DBObjectXmlUtility.appendXML(out.append(" NAME=\""), this.getName()).append("\"");
        DBObjectXmlUtility.appendXML(out.append(" DEFINITION=\""), this.getDefinition().getKey()).append("\"");
        out.append(">\n");
        for (String key : this.attributes.keySet()) {
            FmeaAttribute attribute = this.attributes.get(key);
            String value = attribute.getValue() == null ? "" : attribute.getValue().toString();
            out.append(indent).append("  <ATTRIBUTE_VALUE");
            DBObjectXmlUtility.appendXML(out.append(" NAME=\""), key).append("\"");
            DBObjectXmlUtility.appendXML(out.append(" VALUE=\""), value).append("\"");
            if (attribute instanceof FmeaExternalRefAttribute) {
                out.append(">\n");
                FmeaExternalRefAttribute att = (FmeaExternalRefAttribute)attribute;
                for (ExternalFmeaReference ref : att.getExternalReferences()) {
                    out.append(indent).append("    <EXTERNAL_REF");
                    out.append(" FMEA_ID=\"" + ref.getDBFolder().getID() + "\"");
                    out.append(" FMEA_PATH=\"" + Util.formatStringForXml(ref.getDBFolder().getRefPath()) + "\"");
                    out.append(" FMEA_ENTITY_ID=\"" + Util.formatStringForXml(ref.getFmeaEntId()) + "\"");
                    out.append(" FMEA_ENTITY_NAME=\"" + Util.formatStringForXml(ref.getFmeaEntName()) + "\"");
                    out.append(" FMEA_ENTITY_VALUE=\"" + Util.formatStringForXml(ref.getFmeaEntValue()) + "\"");
                    out.append(" FMEA_ATTRIBUTE_ID=\"" + Util.formatStringForXml(ref.getFmeaAttId()) + "\"");
                    out.append(" FMEA_ATTRIBUTE_NAME=\"" + Util.formatStringForXml(ref.getFmeaAttName()) + "\"");
                    out.append(" FMEA_ATTRIBUTE_VALUE=\"" + ref.getFmeaAttValue() + "\"");
                    if (ref.getcolumnCount() > 0) {
                        out.append(">\n");
                        for (int i = 0; i < ref.getcolumnCount(); ++i) {
                            out.append(indent).append("      <EXT_REF_COLUMN");
                            out.append(" ID=\"" + Util.formatStringForXml(ref.getColumnKey(i)) + "\"");
                            out.append(" NAME=\"" + Util.formatStringForXml(ref.getColumnName(i)) + "\"");
                            out.append(" VALUE=\"" + Util.formatStringForXml(ref.getColumnValue(i)) + "\"/>\n");
                        }
                        out.append(indent).append("    </EXTERNAL_REF>\n");
                        continue;
                    }
                    out.append("/>\n");
                }
                out.append(indent).append("  </ATTRIBUTE_VALUE>\n");
                continue;
            }
            out.append("/>\n");
        }
        out.append(indent).append("</ENTITY>\n");
    }

    public boolean update(CECFactory daoFactory, DBLogs.DBLogsManager logMng) {
        boolean result = false;
        for (String key : this.attributes.keySet()) {
            FmeaAttribute attribute = this.attributes.get(key);
            if (!(attribute instanceof FmeaExternalRefAttribute)) continue;
            FmeaExternalRefAttribute att = (FmeaExternalRefAttribute)attribute;
            Collection<ExternalFmeaReference> xFmeaRefs = att.getExternalReferences();
            Iterator<ExternalFmeaReference> references = xFmeaRefs.iterator();
            boolean change = false;
            while (references.hasNext()) {
                DBTableFMEA fmeaTable;
                Double updateValue;
                DBWrap dbWrap;
                ExternalFmeaReference ref = references.next();
                Object curValue = ref.getFmeaAttValue();
                double refValue = Double.NaN;
                if (ref.getDBFolder() != null && (dbWrap = daoFactory.findOrCreateWrap(ref.getDBFolder())) != null && (updateValue = (fmeaTable = (DBTableFMEA)dbWrap).getFMEA().getValueOf(ref.getFmeaEntId(), ref.getFmeaEntName(), ref.getFmeaEntValue(), ref.getFmeaAttId(), ref.getFmeaAttName())) != null) {
                    refValue = updateValue;
                }
                if (Double.isNaN(refValue)) {
                    logMng.addLog(DBLogs.DBLevel.WARNING, "Le lien FMEA n'est plus valide.");
                    ref.setFmeaAttValue(0.0);
                    continue;
                }
                if (curValue == null || curValue.equals(refValue)) continue;
                change = true;
                ref.setFmeaAttValue(refValue);
            }
            if (!change) continue;
            att.setExternalReferences(xFmeaRefs);
            result = true;
        }
        return result;
    }
}

