/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.dbobj.fmea.model;

import com.dassault.cecilia.dbobj.fmea.io.FmeaBufferedWriter;
import com.dassault.cecilia.dbobj.fmea.model.FmeaAttributeDefinition;
import com.dassault.cecilia.dbobj.fmea.model.FmeaColumnDefinition;
import com.dassault.cecilia.dbobj.fmea.model.FmeaEntityDefinition;
import com.dassault.cecilia.dbobj.fmea.model.FmeaHead;
import com.dassault.cecilia.dbobj.fmea.model.FmeaObject;
import com.dassault.cecilia.dbobj.fmea.model.FmeaSerializable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Element;

public class FmeaTableDefinition
extends FmeaObject
implements FmeaSerializable {
    private FmeaHead _head = null;
    private List<FmeaColumnDefinition> _columnDefinitions = new ArrayList<FmeaColumnDefinition>();
    private Map<String, Map<String, FmeaColumnDefinition>> _columnDefByEntityAttributeDef = new HashMap<String, Map<String, FmeaColumnDefinition>>();

    public void setHead(FmeaHead head) {
        this._head = head;
        this._changeNotifier.changed(this);
    }

    public void addColumnDefinition(FmeaColumnDefinition columnDef) {
        this._columnDefinitions.add(columnDef);
        if (columnDef.getEntityDefinition() != null) {
            Map<String, FmeaColumnDefinition> attributes = this._columnDefByEntityAttributeDef.get(columnDef.getEntityDefinition().getKey());
            if (attributes == null) {
                attributes = new HashMap<String, FmeaColumnDefinition>();
                this._columnDefByEntityAttributeDef.put(columnDef.getEntityDefinition().getKey(), attributes);
            }
            attributes.put(columnDef.getAttributeDefinition().getKey(), columnDef);
        }
        columnDef.getChangeNotifier().addChangeListener(this._changeNotifier);
        this._changeNotifier.changed(this);
    }

    public void removeColumnDefinition(FmeaColumnDefinition columnDef) {
        Map<String, FmeaColumnDefinition> attributes;
        int pos = this.getColumnPosition(columnDef);
        this._columnDefinitions.remove(pos);
        if (columnDef.getEntityDefinition() != null && (attributes = this._columnDefByEntityAttributeDef.get(columnDef.getEntityDefinition().getKey())) != null) {
            attributes.remove(columnDef.getAttributeDefinition().getKey());
        }
        for (int i = 0; i < this._columnDefinitions.size(); ++i) {
            FmeaColumnDefinition colDef = this._columnDefinitions.get(i);
            if (colDef.getFormula() == null) continue;
            boolean ok = colDef.getFormula().positionRemoved(pos);
            if (!ok) {
                colDef.setFormula(null);
                colDef.setLinkToAttribute(true);
                continue;
            }
            colDef.setFormula(colDef.getFormula());
        }
        columnDef.getChangeNotifier().removeChangeListener(this._changeNotifier);
        this._changeNotifier.changed(this);
    }

    public void changeColumnPosition(int oldPosition, int newPosition) {
        if (oldPosition == newPosition) {
            return;
        }
        FmeaColumnDefinition columnDef = this._columnDefinitions.remove(oldPosition);
        this._columnDefinitions.add(newPosition, columnDef);
        for (int i = 0; i < this._columnDefinitions.size(); ++i) {
            FmeaColumnDefinition colDef = this._columnDefinitions.get(i);
            if (colDef.getFormula() == null) continue;
            colDef.getFormula().changePosition(oldPosition, newPosition);
            colDef.setFormula(colDef.getFormula());
        }
        this._changeNotifier.changed(this);
    }

    public FmeaColumnDefinition getColumnDefinition(int column) {
        return this._columnDefinitions.get(column);
    }

    public FmeaColumnDefinition getColumnDefinition(String key) {
        for (FmeaColumnDefinition columnDef : this._columnDefinitions) {
            if (!columnDef.getKey().equals(key)) continue;
            return columnDef;
        }
        return null;
    }

    public FmeaColumnDefinition getColumnDefinitionWithName(String name) {
        for (FmeaColumnDefinition columnDef : this._columnDefinitions) {
            if (!columnDef.getName().equals(name)) continue;
            return columnDef;
        }
        return null;
    }

    public int getColumnCount() {
        return this._columnDefinitions.size();
    }

    public FmeaColumnDefinition getColumnDefinition(String entity, String attribute) {
        Map<String, FmeaColumnDefinition> map = this._columnDefByEntityAttributeDef.get(entity);
        return map == null ? null : map.get(attribute);
    }

    public int getColumnPosition(FmeaColumnDefinition columnDef) {
        for (int i = 0; i < this._columnDefinitions.size(); ++i) {
            if (this._columnDefinitions.get(i) != columnDef) continue;
            return i;
        }
        return -1;
    }

    public Object[] getColumnDefinitions() {
        return this._columnDefinitions.toArray();
    }

    public boolean existColumnDefinition(FmeaEntityDefinition entityDef) {
        Iterator<FmeaColumnDefinition> columns = this._columnDefinitions.iterator();
        while (columns.hasNext()) {
            if (columns.next().getEntityDefinition() != entityDef) continue;
            return true;
        }
        return false;
    }

    public boolean existColumnDefinition(FmeaEntityDefinition entityDef, FmeaAttributeDefinition attributeDef) {
        for (FmeaColumnDefinition columnDef : this._columnDefinitions) {
            if (columnDef.getEntityDefinition() == null || columnDef.getEntityDefinition().getKey() != entityDef.getKey() || columnDef.getAttributeDefinition().getKey() != attributeDef.getKey()) continue;
            return true;
        }
        return false;
    }

    @Override
    public void writeXML(FmeaBufferedWriter w) throws IOException {
        w.incTabCount();
        w.write("<TABLE_DEFINITION");
        w.write(" NAME=\"");
        w.write(this.getName() == null ? "" : this.getName());
        w.write("\" COMMENT=\"");
        w.write(this.getComment() == null ? "" : this.getComment());
        w.writeln("\">");
        this._head.writeXML(w);
        Iterator<FmeaColumnDefinition> it = this._columnDefinitions.iterator();
        while (it.hasNext()) {
            it.next().writeXML(w);
        }
        w.writeln("</TABLE_DEFINITION>");
        w.decTabCount();
    }

    @Override
    public void toXML(Appendable out, String indent) throws IOException {
        out.append(indent).append("<TABLE_DEFINITION");
        out.append(" NAME=\"").append(this.getName() == null ? "" : this.getName()).append("\"");
        out.append(" COMMENT=\"").append(this.getComment() == null ? "" : this.getComment()).append("\"");
        out.append(">\n");
        String indent1 = indent + "  ";
        this._head.toXML(out, indent1);
        Iterator<FmeaColumnDefinition> it = this._columnDefinitions.iterator();
        while (it.hasNext()) {
            it.next().toXML(out, indent1);
        }
        out.append(indent).append("</TABLE_DEFINITION>\n");
    }

    @Override
    public Object readXML(Element node) {
        return null;
    }
}

