/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.dbobj.fmea.util;

import java.awt.Component;
import java.io.Serializable;
import javax.swing.ImageIcon;
import javax.swing.JTable;
import javax.swing.JToggleButton;
import javax.swing.UIManager;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;

public class ButtonTableCellRenderer
extends JToggleButton
implements TableCellRenderer,
Serializable {
    private static String __arrowDownPath = "arrowDown.gif";
    private static String __arrowUpPath = "arrowUp.gif";
    protected boolean[] _selectedColumns = null;
    protected boolean[] _sortedColumns = null;
    protected boolean _ascendingOrder = true;

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        if (table != null) {
            JTableHeader header = table.getTableHeader();
            if (header != null) {
                this.setForeground(header.getForeground());
                this.setBackground(header.getBackground());
                this.setFont(header.getFont());
            }
            this.setSelected(this._selectedColumns[table.convertColumnIndexToModel(column)]);
            if (this._sortedColumns[table.convertColumnIndexToModel(column)]) {
                String name = this._ascendingOrder ? __arrowUpPath : __arrowDownPath;
                ImageIcon icon = new ImageIcon(this.getClass().getResource(name));
                this.setIcon(icon);
            } else {
                this.setIcon(null);
            }
        }
        this.setBorder(UIManager.getBorder("TableHeader.cellBorder"));
        this.setText(value == null ? "" : value.toString());
        return this;
    }

    public void setColumnCount(int columnCount) {
        this._selectedColumns = new boolean[columnCount];
        this._sortedColumns = new boolean[columnCount];
        for (int col = 0; col < this._selectedColumns.length; ++col) {
            this._selectedColumns[col] = false;
            this._sortedColumns[col] = false;
        }
    }

    public void setColumnSelected(int column, boolean selected) {
        this._selectedColumns[column] = selected;
    }

    public void deselectAllColumns() {
        for (int col = 0; col < this._selectedColumns.length; ++col) {
            this._selectedColumns[col] = false;
        }
    }

    public void setColumnSorted(int column) {
        boolean sorted = this._sortedColumns[column];
        for (int col = 0; col < this._sortedColumns.length; ++col) {
            this._sortedColumns[col] = false;
        }
        this._sortedColumns[column] = true;
        this._ascendingOrder = !sorted || !this._ascendingOrder;
    }

    public void setColumnSorted(int column, boolean ascendingOrder) {
        for (int col = 0; col < this._sortedColumns.length; ++col) {
            this._sortedColumns[col] = false;
        }
        this._sortedColumns[column] = true;
        this._ascendingOrder = ascendingOrder;
    }

    public boolean getAscendingOrder() {
        return this._ascendingOrder;
    }

    public static class UIResource
    extends ButtonTableCellRenderer
    implements javax.swing.plaf.UIResource {
    }
}

