/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.dbobj.fmea.util;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.TreeMap;
import java.util.Vector;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableModel;

public class SorterTableModel2
extends AbstractTableModel
implements TableModelListener {
    protected TableModel _model;
    int[] _indexes;
    Vector _sortingColumns = new Vector();
    Vector _sortingOrders = new Vector();

    public SorterTableModel2() {
        this._indexes = new int[0];
    }

    public SorterTableModel2(TableModel model) {
        this.setModel(model);
    }

    public TableModel getModel() {
        return this._model;
    }

    public void setModel(TableModel model) {
        this._model = model;
        this.reallocateIndexes();
        model.addTableModelListener(this);
    }

    @Override
    public Object getValueAt(int aRow, int aColumn) {
        this.checkModel();
        return this._model.getValueAt(this._indexes[aRow], aColumn);
    }

    @Override
    public void setValueAt(Object aValue, int aRow, int aColumn) {
        this.checkModel();
        this._model.setValueAt(aValue, this._indexes[aRow], aColumn);
    }

    @Override
    public int getRowCount() {
        return this._model == null ? 0 : this._model.getRowCount();
    }

    @Override
    public int getColumnCount() {
        return this._model == null ? 0 : this._model.getColumnCount();
    }

    @Override
    public String getColumnName(int aColumn) {
        return this._model.getColumnName(aColumn);
    }

    public Class getColumnClass(int aColumn) {
        return this._model.getColumnClass(aColumn);
    }

    @Override
    public boolean isCellEditable(int aRow, int aColumn) {
        return this._model.isCellEditable(this._indexes[aRow], aColumn);
    }

    public int convertRowIndexToModel(int aRow) {
        return this._indexes[aRow];
    }

    public int convertRowIndexToView(int aRow) {
        for (int i = 0; i < this._indexes.length; ++i) {
            if (this._indexes[i] != aRow) continue;
            return i;
        }
        return -1;
    }

    @Override
    public void tableChanged(TableModelEvent e) {
        if (e != null && e.getLastRow() == Integer.MAX_VALUE) {
            this.reallocateIndexes();
            this.sort(this);
        }
        this.fireTableChanged(e);
    }

    public void reallocateIndexes() {
        int rowCount = this._model.getRowCount();
        this._indexes = new int[rowCount];
        for (int row = 0; row < rowCount; ++row) {
            this._indexes[row] = row;
        }
    }

    public void checkModel() {
        if (this._indexes.length != this._model.getRowCount()) {
            System.err.println("Sorter not informed of a change in model.");
        }
    }

    public void sort(Object sender) {
        this.checkModel();
        if (this._sortingColumns.isEmpty()) {
            return;
        }
        Comparator[] comparator = new Comparator[this._sortingColumns.size()];
        for (int c = 0; c < comparator.length; ++c) {
            String ascending = (String)this._sortingOrders.get(c);
            final int way = ascending.equals("ascending") ? 1 : -1;
            comparator[c] = new Comparator(){

                public int compare(Object o1, Object o2) {
                    return o1 == null ? (o2 == null ? 0 : -1 * way) : (o2 == null ? 1 * way : ((Comparable)o1).compareTo(o2) * way);
                }
            };
        }
        TreeMap sortedRowsByColumns = new TreeMap(comparator[0]);
        for (int row = 0; row < this._model.getRowCount(); ++row) {
            TreeMap<Object, Cloneable> currentMap = sortedRowsByColumns;
            for (int c = 0; c < this._sortingColumns.size() - 1; ++c) {
                Integer column = (Integer)this._sortingColumns.get(c);
                int col = column;
                Object value = this._model.getValueAt(row, col);
                TreeMap nextMap = (TreeMap)currentMap.get(value);
                if (nextMap == null) {
                    nextMap = new TreeMap(comparator[c]);
                    currentMap.put(value, nextMap);
                }
                currentMap = nextMap;
            }
            Integer column = (Integer)this._sortingColumns.get(this._sortingColumns.size() - 1);
            int col = column;
            Object value = this._model.getValueAt(row, col);
            ArrayList<Integer> sortedRows = (ArrayList<Integer>)currentMap.get(value);
            if (sortedRows == null) {
                sortedRows = new ArrayList<Integer>();
                currentMap.put(value, sortedRows);
            }
            sortedRows.add(row);
        }
        int count = 0;
        TreeMap currentMap = sortedRowsByColumns;
        Stack stack = new Stack();
        int currentColumn = 0;
        Iterator currentIterator = currentMap.values().iterator();
        block3: while (true) {
            if (currentIterator.hasNext()) {
                if (currentColumn == this._sortingColumns.size() - 1) {
                    List list = (List)currentIterator.next();
                    Iterator rows = list.iterator();
                    while (true) {
                        if (!rows.hasNext()) continue block3;
                        this._indexes[count++] = (Integer)rows.next();
                    }
                }
                stack.push(currentIterator);
                Map map = (Map)currentIterator.next();
                currentIterator = map.values().iterator();
                ++currentColumn;
                continue;
            }
            if (stack.isEmpty()) break;
            currentIterator = (Iterator)stack.pop();
            --currentColumn;
        }
    }

    public void sort(int column) {
        this.sort(column, true);
    }

    public void sort(int column, boolean ascending) {
        Vector<Integer> columns = new Vector<Integer>();
        columns.add(column);
        Vector<String> orders = new Vector<String>();
        orders.add(ascending ? "ascending" : "descending");
        this.sort(columns, orders);
    }

    public void sort(Vector columns, Vector orders) {
        if (columns != this._sortingColumns) {
            this._sortingColumns.clear();
            this._sortingColumns.addAll(columns);
            this._sortingOrders.clear();
            this._sortingOrders.addAll(orders);
        }
        this.sort(this);
        this.fireTableChanged(new TableModelEvent(this));
    }

    public Vector getSortingColumns() {
        return this._sortingColumns;
    }

    public String getAscendingOrder() {
        return (String)this._sortingOrders.get(0);
    }
}

